//go:build !ignore_autogenerated

/*
Copyright2019 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by helpgen. DO NOT EDIT.

package markers

import (
	"sigs.k8s.io/controller-tools/pkg/markers"
)

func (Default) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD validation",
		DetailedHelp: markers.DetailedHelp{
			Summary: "sets the default value for this field.",
			Details: "A default value will be accepted as any value valid for the\nfield. Formatting for common types include: boolean: `true`, string:\n`Cluster`, numerical: `1.24`, array: `{1,2}`, object: `{policy:\n\"delete\"}`). Defaults should be defined in pruned form, and only best-effort\nvalidation will be performed. Full validation of a default requires\nsubmission of the containing CRD to an apiserver.",
		},
		FieldHelp: map[string]markers.DetailedHelp{
			"Value": {
				Summary: "",
				Details: "",
			},
		},
	}
}

func (DeprecatedVersion) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD",
		DetailedHelp: markers.DetailedHelp{
			Summary: "marks this version as deprecated.",
			Details: "",
		},
		FieldHelp: map[string]markers.DetailedHelp{
			"Warning": {
				Summary: "message to be shown on the deprecated version",
				Details: "",
			},
		},
	}
}

func (Enum) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD validation",
		DetailedHelp: markers.DetailedHelp{
			Summary: "specifies that this (scalar) field is restricted to the *exact* values specified here.",
			Details: "",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}

func (Example) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD validation",
		DetailedHelp: markers.DetailedHelp{
			Summary: "sets the example value for this field.",
			Details: "An example value will be accepted as any value valid for the\nfield. Formatting for common types include: boolean: `true`, string:\n`Cluster`, numerical: `1.24`, array: `{1,2}`, object: `{policy:\n\"delete\"}`). Examples should be defined in pruned form, and only best-effort\nvalidation will be performed. Full validation of an example requires\nsubmission of the containing CRD to an apiserver.",
		},
		FieldHelp: map[string]markers.DetailedHelp{
			"Value": {
				Summary: "",
				Details: "",
			},
		},
	}
}

func (ExclusiveMaximum) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD validation",
		DetailedHelp: markers.DetailedHelp{
			Summary: "indicates that the maximum is \"up to\" but not including that value.",
			Details: "",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}

func (ExclusiveMinimum) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD validation",
		DetailedHelp: markers.DetailedHelp{
			Summary: "indicates that the minimum is \"up to\" but not including that value.",
			Details: "",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}

func (Format) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD validation",
		DetailedHelp: markers.DetailedHelp{
			Summary: "specifies additional \"complex\" formatting for this field.",
			Details: "For example, a date-time field would be marked as \"type: string\" and\n\"format: date-time\".",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}

func (KubernetesDefault) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD validation",
		DetailedHelp: markers.DetailedHelp{
			Summary: "Default sets the default value for this field.",
			Details: "A default value will be accepted as any value valid for the field.\nOnly JSON-formatted values are accepted. `ref(...)` values are ignored.\nFormatting for common types include: boolean: `true`, string:\n`\"Cluster\"`, numerical: `1.24`, array: `[1,2]`, object: `{\"policy\":\n\"delete\"}`). Defaults should be defined in pruned form, and only best-effort\nvalidation will be performed. Full validation of a default requires\nsubmission of the containing CRD to an apiserver.",
		},
		FieldHelp: map[string]markers.DetailedHelp{
			"Value": {
				Summary: "",
				Details: "",
			},
		},
	}
}

func (ListMapKey) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD processing",
		DetailedHelp: markers.DetailedHelp{
			Summary: "specifies the keys to map listTypes.",
			Details: "It indicates the index of a map list. They can be repeated if multiple keys\nmust be used. It can only be used when ListType is set to map, and the keys\nshould be scalar types.",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}

func (ListType) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD processing",
		DetailedHelp: markers.DetailedHelp{
			Summary: "specifies the type of data-structure that the list",
			Details: "represents (map, set, atomic).\n\nPossible data-structure types of a list are:\n\n  - \"map\": it needs to have a key field, which will be used to build an\n    associative list. A typical example is a the pod container list,\n    which is indexed by the container name.\n\n  - \"set\": Fields need to be \"scalar\", and there can be only one\n    occurrence of each.\n\n  - \"atomic\": All the fields in the list are treated as a single value,\n    are typically manipulated together by the same actor.",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}

func (MapType) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD processing",
		DetailedHelp: markers.DetailedHelp{
			Summary: "specifies the level of atomicity of the map;",
			Details: "i.e. whether each item in the map is independent of the others,\nor all fields are treated as a single unit.\n\nPossible values:\n\n  - \"granular\": items in the map are independent of each other,\n    and can be manipulated by different actors.\n    This is the default behavior.\n\n  - \"atomic\": all fields are treated as one unit.\n    Any changes have to replace the entire map.",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}

func (MaxItems) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD validation",
		DetailedHelp: markers.DetailedHelp{
			Summary: "specifies the maximum length for this list.",
			Details: "",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}

func (MaxLength) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD validation",
		DetailedHelp: markers.DetailedHelp{
			Summary: "specifies the maximum length for this string.",
			Details: "",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}

func (MaxProperties) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD validation",
		DetailedHelp: markers.DetailedHelp{
			Summary: "restricts the number of keys in an object",
			Details: "",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}

func (Maximum) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD validation",
		DetailedHelp: markers.DetailedHelp{
			Summary: "specifies the maximum numeric value that this field can have.",
			Details: "",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}

func (Metadata) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD",
		DetailedHelp: markers.DetailedHelp{
			Summary: "configures the additional annotations or labels for this CRD.",
			Details: "For example adding annotation \"api-approved.kubernetes.io\" for a CRD with Kubernetes groups,\nor annotation \"cert-manager.io/inject-ca-from-secret\" for a CRD that needs CA injection.",
		},
		FieldHelp: map[string]markers.DetailedHelp{
			"Annotations": {
				Summary: "will be added into the annotations of this CRD.",
				Details: "",
			},
			"Labels": {
				Summary: "will be added into the labels of this CRD.",
				Details: "",
			},
		},
	}
}

func (MinItems) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD validation",
		DetailedHelp: markers.DetailedHelp{
			Summary: "specifies the minimum length for this list.",
			Details: "",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}

func (MinLength) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD validation",
		DetailedHelp: markers.DetailedHelp{
			Summary: "specifies the minimum length for this string.",
			Details: "",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}

func (MinProperties) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD validation",
		DetailedHelp: markers.DetailedHelp{
			Summary: "restricts the number of keys in an object",
			Details: "",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}

func (Minimum) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD validation",
		DetailedHelp: markers.DetailedHelp{
			Summary: "specifies the minimum numeric value that this field can have. Negative numbers are supported.",
			Details: "",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}

func (MultipleOf) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD validation",
		DetailedHelp: markers.DetailedHelp{
			Summary: "specifies that this field must have a numeric value that's a multiple of this one.",
			Details: "",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}

func (Nullable) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD validation",
		DetailedHelp: markers.DetailedHelp{
			Summary: "marks this field as allowing the \"null\" value.",
			Details: "This is often not necessary, but may be helpful with custom serialization.",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}

func (Pattern) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD validation",
		DetailedHelp: markers.DetailedHelp{
			Summary: "specifies that this string must match the given regular expression.",
			Details: "",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}

func (PrintColumn) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD",
		DetailedHelp: markers.DetailedHelp{
			Summary: "adds a column to \"kubectl get\" output for this CRD.",
			Details: "",
		},
		FieldHelp: map[string]markers.DetailedHelp{
			"Name": {
				Summary: "specifies the name of the column.",
				Details: "",
			},
			"Type": {
				Summary: "indicates the type of the column.",
				Details: "It may be any OpenAPI data type listed at\nhttps://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types.",
			},
			"JSONPath": {
				Summary: "specifies the jsonpath expression used to extract the value of the column.",
				Details: "",
			},
			"Description": {
				Summary: "specifies the help/description for this column.",
				Details: "",
			},
			"Format": {
				Summary: "specifies the format of the column.",
				Details: "It may be any OpenAPI data format corresponding to the type, listed at\nhttps://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types.",
			},
			"Priority": {
				Summary: "indicates how important it is that this column be displayed.",
				Details: "Lower priority (*higher* numbered) columns will be hidden if the terminal\nwidth is too small.",
			},
		},
	}
}

func (Resource) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD",
		DetailedHelp: markers.DetailedHelp{
			Summary: "configures naming and scope for a CRD.",
			Details: "",
		},
		FieldHelp: map[string]markers.DetailedHelp{
			"Path": {
				Summary: "specifies the plural \"resource\" for this CRD.",
				Details: "It generally corresponds to a plural, lower-cased version of the Kind.\nSee https://book.kubebuilder.io/cronjob-tutorial/gvks.html.",
			},
			"ShortName": {
				Summary: "specifies aliases for this CRD.",
				Details: "Short names are often used when people have work with your resource\nover and over again.  For instance, \"rs\" for \"replicaset\" or\n\"crd\" for customresourcedefinition.",
			},
			"Categories": {
				Summary: "specifies which group aliases this resource is part of.",
				Details: "Group aliases are used to work with groups of resources at once.\nThe most common one is \"all\" which covers about a third of the base\nresources in Kubernetes, and is generally used for \"user-facing\" resources.",
			},
			"Singular": {
				Summary: "overrides the singular form of your resource.",
				Details: "The singular form is otherwise defaulted off the plural (path).",
			},
			"Scope": {
				Summary: "overrides the scope of the CRD (Cluster vs Namespaced).",
				Details: "Scope defaults to \"Namespaced\".  Cluster-scoped (\"Cluster\") resources\ndon't exist in namespaces.",
			},
		},
	}
}

func (Schemaless) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD validation",
		DetailedHelp: markers.DetailedHelp{
			Summary: "marks a field as being a schemaless object.",
			Details: "Schemaless objects are not introspected, so you must provide\nany type and validation information yourself. One use for this\ntag is for embedding fields that hold JSONSchema typed objects.\nBecause this field disables all type checking, it is recommended\nto be used only as a last resort.",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}

func (SelectableField) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD",
		DetailedHelp: markers.DetailedHelp{
			Summary: "adds a field that may be used with field selectors.",
			Details: "",
		},
		FieldHelp: map[string]markers.DetailedHelp{
			"JSONPath": {
				Summary: "specifies the jsonpath expression which is used to produce a field selector value.",
				Details: "",
			},
		},
	}
}

func (SkipVersion) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD",
		DetailedHelp: markers.DetailedHelp{
			Summary: "removes the particular version of the CRD from the CRDs spec.",
			Details: "This is useful if you need to skip generating and listing version entries\nfor 'internal' resource versions, which typically exist if using the\nKubernetes upstream conversion-gen tool.",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}

func (StorageVersion) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD",
		DetailedHelp: markers.DetailedHelp{
			Summary: "marks this version as the \"storage version\" for the CRD for conversion.",
			Details: "When conversion is enabled for a CRD (i.e. it's not a trivial-versions/single-version CRD),\none version is set as the \"storage version\" to be stored in etcd.  Attempting to store any\nother version will result in conversion to the storage version via a conversion webhook.",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}

func (StructType) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD processing",
		DetailedHelp: markers.DetailedHelp{
			Summary: "specifies the level of atomicity of the struct;",
			Details: "i.e. whether each field in the struct is independent of the others,\nor all fields are treated as a single unit.\n\nPossible values:\n\n  - \"granular\": fields in the struct are independent of each other,\n    and can be manipulated by different actors.\n    This is the default behavior.\n\n  - \"atomic\": all fields are treated as one unit.\n    Any changes have to replace the entire struct.",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}

func (SubresourceScale) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD",
		DetailedHelp: markers.DetailedHelp{
			Summary: "enables the \"/scale\" subresource on a CRD.",
			Details: "",
		},
		FieldHelp: map[string]markers.DetailedHelp{
			"SpecPath": {
				Summary: "specifies the jsonpath to the replicas field for the scale's spec.",
				Details: "",
			},
			"StatusPath": {
				Summary: "specifies the jsonpath to the replicas field for the scale's status.",
				Details: "",
			},
			"SelectorPath": {
				Summary: "specifies the jsonpath to the pod label selector field for the scale's status.",
				Details: "The selector field must be the *string* form (serialized form) of a selector.\nSetting a pod label selector is necessary for your type to work with the HorizontalPodAutoscaler.",
			},
		},
	}
}

func (SubresourceStatus) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD",
		DetailedHelp: markers.DetailedHelp{
			Summary: "enables the \"/status\" subresource on a CRD.",
			Details: "",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}

func (Title) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD validation",
		DetailedHelp: markers.DetailedHelp{
			Summary: "sets the title for this field.",
			Details: "The title is metadata that makes the OpenAPI documentation more user-friendly,\nmaking the schema more understandable when viewed in documentation tools.\nIt's a metadata field that doesn't affect validation but provides\nimportant context about what the schema represents.",
		},
		FieldHelp: map[string]markers.DetailedHelp{
			"Value": {
				Summary: "",
				Details: "",
			},
		},
	}
}

func (Type) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD validation",
		DetailedHelp: markers.DetailedHelp{
			Summary: "overrides the type for this field (which defaults to the equivalent of the Go type).",
			Details: "This generally must be paired with custom serialization.  For example, the\nmetav1.Time field would be marked as \"type: string\" and \"format: date-time\".",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}

func (UniqueItems) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD validation",
		DetailedHelp: markers.DetailedHelp{
			Summary: "specifies that all items in this list must be unique.",
			Details: "",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}

func (UnservedVersion) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD",
		DetailedHelp: markers.DetailedHelp{
			Summary: "does not serve this version.",
			Details: "This is useful if you need to drop support for a version in favor of a newer version.",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}

func (XEmbeddedResource) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD validation",
		DetailedHelp: markers.DetailedHelp{
			Summary: "EmbeddedResource marks a fields as an embedded resource with apiVersion, kind and metadata fields.",
			Details: "An embedded resource is a value that has apiVersion, kind and metadata fields.\nThey are validated implicitly according to the semantics of the currently\nrunning apiserver. It is not necessary to add any additional schema for these\nfield, yet it is possible. This can be combined with PreserveUnknownFields.",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}

func (XIntOrString) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD validation",
		DetailedHelp: markers.DetailedHelp{
			Summary: "IntOrString marks a fields as an IntOrString.",
			Details: "This is required when applying patterns or other validations to an IntOrString\nfield. Known information about the type is applied during the collapse phase\nand as such is not normally available during marker application.",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}

func (XPreserveUnknownFields) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD processing",
		DetailedHelp: markers.DetailedHelp{
			Summary: "PreserveUnknownFields stops the apiserver from pruning fields which are not specified.",
			Details: "By default the apiserver drops unknown fields from the request payload\nduring the decoding step. This marker stops the API server from doing so.\nIt affects fields recursively, but switches back to normal pruning behaviour\nif nested  properties or additionalProperties are specified in the schema.\nThis can either be true or undefined. False\nis forbidden.\n\nNB: The kubebuilder:validation:XPreserveUnknownFields variant is deprecated\nin favor of the kubebuilder:pruning:PreserveUnknownFields variant.  They function\nidentically.",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}

func (XValidation) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "CRD validation",
		DetailedHelp: markers.DetailedHelp{
			Summary: "marks a field as requiring a value for which a given",
			Details: "expression evaluates to true.\n\nThis marker may be repeated to specify multiple expressions, all of\nwhich must evaluate to true.",
		},
		FieldHelp: map[string]markers.DetailedHelp{
			"Rule": {
				Summary: "",
				Details: "",
			},
			"Message": {
				Summary: "",
				Details: "",
			},
			"MessageExpression": {
				Summary: "",
				Details: "",
			},
			"Reason": {
				Summary: "",
				Details: "",
			},
			"FieldPath": {
				Summary: "",
				Details: "",
			},
			"OptionalOldSelf": {
				Summary: "",
				Details: "",
			},
		},
	}
}
