/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#include "brightnessFrame.h"
#include <QHBoxLayout>

BrightnessFrame::BrightnessFrame(QWidget *parent) :
    QFrame(parent)
{
    this->setFixedHeight(50);
    this->setMinimumWidth(550);
    this->setFrameShape(QFrame::Shape::Box);
    QHBoxLayout *layout = new QHBoxLayout(this);
    layout->setSpacing(6);
    layout->setMargin(9);

    labelName = new QLabel(this);
    labelName->setFixedWidth(118);

    slider = new Uslider(Qt::Horizontal, this);
    slider->setRange(10, 100);

    labelValue = new QLabel(this);
    labelValue->setAlignment(Qt::AlignRight);

    layout->addWidget(labelName);
    layout->addWidget(slider);
    layout->addWidget(labelValue);

}

BrightnessFrame::~BrightnessFrame()
{

}

void BrightnessFrame::setTextLableName(QString text)
{
    this->labelName->setText(text);
}

void BrightnessFrame::setTextLableValue(QString text)
{
    this->labelValue->setText(text + "%");
}
