/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef AREA_H
#define AREA_H

#include "areaui.h"
#include "shell/interface.h"
#include "interface/mthread.h"
#include "settinggroup.h"
#include "comboxwidget.h"
#include <QWidget>
#include <QObject>
#include <QtPlugin>
#include <QDBusInterface>
#include <QDBusReply>
#ifdef KY_SDK_SYSTIME
#include <kysdk/kysdk-system/libkydate.h>
#endif
using namespace kdk;
#include "ukcccommon.h"
using namespace ukcc;

/* qt会将glib里的signals成员识别为宏，所以取消该宏
 * 后面如果用到signals时，使用Q_SIGNALS代替即可
 **/
#ifdef signals
#undef signals
#endif

typedef QPair <QString, QString> pairString;
typedef QList <QPair<QString, QString>> pairStringList;

typedef struct InteractiveInfo
{
    QString listKey;
    QString key;
    QString setkey;
    pairStringList list;
}InteractiveInfo;

class Area : public QObject, CommonInterface
{
    Q_OBJECT
    Q_PLUGIN_METADATA(IID "org.ukcc.CommonInterface")
    Q_INTERFACES(CommonInterface)

public:
    Area();
    ~Area();
    QString plugini18nName()   Q_DECL_OVERRIDE;
    int pluginTypes()       Q_DECL_OVERRIDE;
    QWidget * pluginUi()   Q_DECL_OVERRIDE;
    const QString name() const  Q_DECL_OVERRIDE;
    bool isShowOnHomePage() const Q_DECL_OVERRIDE;
    QIcon icon() const Q_DECL_OVERRIDE;
    bool isEnable() const Q_DECL_OVERRIDE;

public:
    InteractiveInfo initInteractiveInfo(int orderNum);
    void initComboBox(QComboBox *comboBox, InteractiveInfo info);
    void initContent();
    void initCountry();
    void initCalendar();
    void initFirstDay();
    void initDateFormat();
    void initTimeFormat(bool firstLoad = false);
    void initLanguage();
    void initAddLanguage();
    void initDateComboBox();
    void initConnect();
    void connectToServer();
    QString showLanguageName(QString languageCode);
    void showMessageBox(const int flag);

public Q_SLOTS:
    void dataChanged(QString key);

private slots:
    void cloudChangedSlot(const QString &key);
    void TimeChanged(QString time);
    void refreshLongDate(QString date);
    void refreshShortDate(QString date);

private:
    AreaUi          *areaWidget          = nullptr;
    QDBusConnection *areaInerfaceConnect = nullptr;
    QDBusInterface  *areaInterface       = nullptr;
    QString         changeKey            = "";
    bool            mFirstLoad           = true;
    QString         pluginName           = "";
    int             pluginType           = 0;
};

#endif // AREA_H
