// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SADDL_2D_TRACE_AARCH64_H_
#define VIXL_SIM_SADDL_2D_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_saddl_2D[] = {
  0x000000000000fc00, 0x000000000000fe00,
  0x000000000000fd00, 0x0000000000807c00,
  0x0000000000807b00, 0x0000000000007f00,
  0x0000000000007e00, 0x0000000000007f01,
  0x0000000000007e01, 0x0000000000007f02,
  0x0000000000007e02, 0x0000000000007f20,
  0x0000000000007e20, 0x0000000000007f7d,
  0x0000000000007e7d, 0x0000000000007f7e,
  0x0000000000007e7e, 0x0000000000007f7f,
  0x0000000000007e7f, 0x000000000000fefd,
  0x000000000000fdfd, 0x000000000000fefe,
  0x000000000000fdfe, 0x000000000000feff,
  0x000000000000fdff, 0x000000003333b233,
  0x000000003333b133, 0x000000005555d455,
  0x000000005555d355, 0x0000000080007efd,
  0x0000000080007dfd, 0x0000000080007efe,
  0x0000000080007dfe, 0x0000000080007eff,
  0x0000000080007dff, 0xffffffff80007f00,
  0xffffffff80007e00, 0xffffffff80007f01,
  0xffffffff80007e01, 0xffffffffaaab29aa,
  0xffffffffaaab28aa, 0xffffffffcccd4bcc,
  0xffffffffcccd4acc, 0xffffffffffffff00,
  0xfffffffffffffe00, 0xffffffffffffff01,
  0xfffffffffffffe01, 0xffffffffffffff02,
  0xfffffffffffffe02, 0xffffffffffffff03,
  0xfffffffffffffe03, 0x0000000000007e80,
  0x0000000000007d80, 0x0000000000007e81,
  0x0000000000007d81, 0x0000000000007e82,
  0x0000000000007d82, 0x0000000000007e83,
  0x0000000000007d83, 0x0000000000007ee0,
  0x0000000000007de0, 0x0000000000007efd,
  0x0000000000007efd, 0x00000000007ffcfe,
  0x0000000000007efe, 0x00000000007ffcff,
  0x0000000000007eff, 0x00000000007ffd00,
  0x0000000000007f00, 0x00000000007ffd01,
  0x0000000000007f01, 0x00000000007ffd02,
  0x0000000000007f02, 0x00000000007ffd20,
  0x0000000000007f20, 0x00000000007ffd7d,
  0x0000000000007f7d, 0x00000000007ffd7e,
  0x0000000000007f7e, 0x00000000007ffd7f,
  0x0000000000007f7f, 0x0000000000807cfd,
  0x000000000000fefd, 0x0000000000807cfe,
  0x000000000000fefe, 0x0000000000807cff,
  0x000000000000feff, 0x0000000033b33033,
  0x000000003333b233, 0x0000000055d55255,
  0x000000005555d455, 0x00000000807ffcfd,
  0x0000000080007efd, 0x00000000807ffcfe,
  0x0000000080007efe, 0x00000000807ffcff,
  0x0000000080007eff, 0xffffffff807ffd00,
  0xffffffff80007f00, 0xffffffff807ffd01,
  0xffffffff80007f01, 0xffffffffab2aa7aa,
  0xffffffffaaab29aa, 0xffffffffcd4cc9cc,
  0xffffffffcccd4bcc, 0x00000000007f7d00,
  0xffffffffffffff00, 0x00000000007f7d01,
  0xffffffffffffff01, 0x00000000007f7d02,
  0xffffffffffffff02, 0x00000000007f7d03,
  0xffffffffffffff03, 0x00000000007ffc80,
  0x0000000000007e80, 0x00000000007ffc81,
  0x0000000000007e81, 0x00000000007ffc82,
  0x0000000000007e82, 0x00000000007ffc83,
  0x0000000000007e83, 0x00000000007ffce0,
  0x0000000000007ee0, 0x00000000007ffcfd,
  0x00000000007ffcfd, 0xfffffffffffffffe,
  0x00000000007ffcfe, 0xffffffffffffffff,
  0x00000000007ffcff, 0x0000000000000000,
  0x00000000007ffd00, 0x0000000000000001,
  0x00000000007ffd01, 0x0000000000000002,
  0x00000000007ffd02, 0x0000000000000020,
  0x00000000007ffd20, 0x000000000000007d,
  0x00000000007ffd7d, 0x000000000000007e,
  0x00000000007ffd7e, 0x000000000000007f,
  0x00000000007ffd7f, 0x0000000000007ffd,
  0x0000000000807cfd, 0x0000000000007ffe,
  0x0000000000807cfe, 0x0000000000007fff,
  0x0000000000807cff, 0x0000000033333333,
  0x0000000033b33033, 0x0000000055555555,
  0x0000000055d55255, 0x000000007ffffffd,
  0x00000000807ffcfd, 0x000000007ffffffe,
  0x00000000807ffcfe, 0x000000007fffffff,
  0x00000000807ffcff, 0xffffffff80000000,
  0xffffffff807ffd00, 0xffffffff80000001,
  0xffffffff807ffd01, 0xffffffffaaaaaaaa,
  0xffffffffab2aa7aa, 0xffffffffcccccccc,
  0xffffffffcd4cc9cc, 0xffffffffffff8000,
  0x00000000007f7d00, 0xffffffffffff8001,
  0x00000000007f7d01, 0xffffffffffff8002,
  0x00000000007f7d02, 0xffffffffffff8003,
  0x00000000007f7d03, 0xffffffffffffff80,
  0x00000000007ffc80, 0xffffffffffffff81,
  0x00000000007ffc81, 0xffffffffffffff82,
  0x00000000007ffc82, 0xffffffffffffff83,
  0x00000000007ffc83, 0xffffffffffffffe0,
  0x00000000007ffce0, 0xfffffffffffffffd,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000003,
  0x0000000000000002, 0x0000000000000021,
  0x0000000000000020, 0x000000000000007e,
  0x000000000000007d, 0x000000000000007f,
  0x000000000000007e, 0x0000000000000080,
  0x000000000000007f, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000008000,
  0x0000000000007fff, 0x0000000033333334,
  0x0000000033333333, 0x0000000055555556,
  0x0000000055555555, 0x000000007ffffffe,
  0x000000007ffffffd, 0x000000007fffffff,
  0x000000007ffffffe, 0x0000000080000000,
  0x000000007fffffff, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff80000002,
  0xffffffff80000001, 0xffffffffaaaaaaab,
  0xffffffffaaaaaaaa, 0xffffffffcccccccd,
  0xffffffffcccccccc, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffffff8004,
  0xffffffffffff8003, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffffff84,
  0xffffffffffffff83, 0xffffffffffffffe1,
  0xffffffffffffffe0, 0xfffffffffffffffe,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000003,
  0x0000000000000002, 0x0000000000000004,
  0x0000000000000003, 0x0000000000000022,
  0x0000000000000021, 0x000000000000007f,
  0x000000000000007e, 0x0000000000000080,
  0x000000000000007f, 0x0000000000000081,
  0x0000000000000080, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000008000,
  0x0000000000007fff, 0x0000000000008001,
  0x0000000000008000, 0x0000000033333335,
  0x0000000033333334, 0x0000000055555557,
  0x0000000055555556, 0x000000007fffffff,
  0x000000007ffffffe, 0x0000000080000000,
  0x000000007fffffff, 0x0000000080000001,
  0x0000000080000000, 0xffffffff80000002,
  0xffffffff80000001, 0xffffffff80000003,
  0xffffffff80000002, 0xffffffffaaaaaaac,
  0xffffffffaaaaaaab, 0xffffffffccccccce,
  0xffffffffcccccccd, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffffff8004,
  0xffffffffffff8003, 0xffffffffffff8005,
  0xffffffffffff8004, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffffff84,
  0xffffffffffffff83, 0xffffffffffffff85,
  0xffffffffffffff84, 0xffffffffffffffe2,
  0xffffffffffffffe1, 0xffffffffffffffff,
  0xffffffffffffffff, 0x000000000000001e,
  0x0000000000000000, 0x000000000000001f,
  0x0000000000000001, 0x0000000000000020,
  0x0000000000000002, 0x0000000000000021,
  0x0000000000000003, 0x0000000000000022,
  0x0000000000000004, 0x0000000000000040,
  0x0000000000000022, 0x000000000000009d,
  0x000000000000007f, 0x000000000000009e,
  0x0000000000000080, 0x000000000000009f,
  0x0000000000000081, 0x000000000000801d,
  0x0000000000007fff, 0x000000000000801e,
  0x0000000000008000, 0x000000000000801f,
  0x0000000000008001, 0x0000000033333353,
  0x0000000033333335, 0x0000000055555575,
  0x0000000055555557, 0x000000008000001d,
  0x000000007fffffff, 0x000000008000001e,
  0x0000000080000000, 0x000000008000001f,
  0x0000000080000001, 0xffffffff80000020,
  0xffffffff80000002, 0xffffffff80000021,
  0xffffffff80000003, 0xffffffffaaaaaaca,
  0xffffffffaaaaaaac, 0xffffffffccccccec,
  0xffffffffccccccce, 0xffffffffffff8020,
  0xffffffffffff8002, 0xffffffffffff8021,
  0xffffffffffff8003, 0xffffffffffff8022,
  0xffffffffffff8004, 0xffffffffffff8023,
  0xffffffffffff8005, 0xffffffffffffffa0,
  0xffffffffffffff82, 0xffffffffffffffa1,
  0xffffffffffffff83, 0xffffffffffffffa2,
  0xffffffffffffff84, 0xffffffffffffffa3,
  0xffffffffffffff85, 0x0000000000000000,
  0xffffffffffffffe2, 0x000000000000001d,
  0x000000000000001d, 0x000000000000007b,
  0x000000000000001e, 0x000000000000007c,
  0x000000000000001f, 0x000000000000007d,
  0x0000000000000020, 0x000000000000007e,
  0x0000000000000021, 0x000000000000007f,
  0x0000000000000022, 0x000000000000009d,
  0x0000000000000040, 0x00000000000000fa,
  0x000000000000009d, 0x00000000000000fb,
  0x000000000000009e, 0x00000000000000fc,
  0x000000000000009f, 0x000000000000807a,
  0x000000000000801d, 0x000000000000807b,
  0x000000000000801e, 0x000000000000807c,
  0x000000000000801f, 0x00000000333333b0,
  0x0000000033333353, 0x00000000555555d2,
  0x0000000055555575, 0x000000008000007a,
  0x000000008000001d, 0x000000008000007b,
  0x000000008000001e, 0x000000008000007c,
  0x000000008000001f, 0xffffffff8000007d,
  0xffffffff80000020, 0xffffffff8000007e,
  0xffffffff80000021, 0xffffffffaaaaab27,
  0xffffffffaaaaaaca, 0xffffffffcccccd49,
  0xffffffffccccccec, 0xffffffffffff807d,
  0xffffffffffff8020, 0xffffffffffff807e,
  0xffffffffffff8021, 0xffffffffffff807f,
  0xffffffffffff8022, 0xffffffffffff8080,
  0xffffffffffff8023, 0xfffffffffffffffd,
  0xffffffffffffffa0, 0xfffffffffffffffe,
  0xffffffffffffffa1, 0xffffffffffffffff,
  0xffffffffffffffa2, 0x0000000000000000,
  0xffffffffffffffa3, 0x000000000000005d,
  0x0000000000000000, 0x000000000000007a,
  0x000000000000007a, 0x000000000000007c,
  0x000000000000007b, 0x000000000000007d,
  0x000000000000007c, 0x000000000000007e,
  0x000000000000007d, 0x000000000000007f,
  0x000000000000007e, 0x0000000000000080,
  0x000000000000007f, 0x000000000000009e,
  0x000000000000009d, 0x00000000000000fb,
  0x00000000000000fa, 0x00000000000000fc,
  0x00000000000000fb, 0x00000000000000fd,
  0x00000000000000fc, 0x000000000000807b,
  0x000000000000807a, 0x000000000000807c,
  0x000000000000807b, 0x000000000000807d,
  0x000000000000807c, 0x00000000333333b1,
  0x00000000333333b0, 0x00000000555555d3,
  0x00000000555555d2, 0x000000008000007b,
  0x000000008000007a, 0x000000008000007c,
  0x000000008000007b, 0x000000008000007d,
  0x000000008000007c, 0xffffffff8000007e,
  0xffffffff8000007d, 0xffffffff8000007f,
  0xffffffff8000007e, 0xffffffffaaaaab28,
  0xffffffffaaaaab27, 0xffffffffcccccd4a,
  0xffffffffcccccd49, 0xffffffffffff807e,
  0xffffffffffff807d, 0xffffffffffff807f,
  0xffffffffffff807e, 0xffffffffffff8080,
  0xffffffffffff807f, 0xffffffffffff8081,
  0xffffffffffff8080, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x000000000000005e,
  0x000000000000005d, 0x000000000000007b,
  0x000000000000007b, 0x000000000000007d,
  0x000000000000007c, 0x000000000000007e,
  0x000000000000007d, 0x000000000000007f,
  0x000000000000007e, 0x0000000000000080,
  0x000000000000007f, 0x0000000000000081,
  0x0000000000000080, 0x000000000000009f,
  0x000000000000009e, 0x00000000000000fc,
  0x00000000000000fb, 0x00000000000000fd,
  0x00000000000000fc, 0x00000000000000fe,
  0x00000000000000fd, 0x000000000000807c,
  0x000000000000807b, 0x000000000000807d,
  0x000000000000807c, 0x000000000000807e,
  0x000000000000807d, 0x00000000333333b2,
  0x00000000333333b1, 0x00000000555555d4,
  0x00000000555555d3, 0x000000008000007c,
  0x000000008000007b, 0x000000008000007d,
  0x000000008000007c, 0x000000008000007e,
  0x000000008000007d, 0xffffffff8000007f,
  0xffffffff8000007e, 0xffffffff80000080,
  0xffffffff8000007f, 0xffffffffaaaaab29,
  0xffffffffaaaaab28, 0xffffffffcccccd4b,
  0xffffffffcccccd4a, 0xffffffffffff807f,
  0xffffffffffff807e, 0xffffffffffff8080,
  0xffffffffffff807f, 0xffffffffffff8081,
  0xffffffffffff8080, 0xffffffffffff8082,
  0xffffffffffff8081, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x000000000000005f,
  0x000000000000005e, 0x000000000000007c,
  0x000000000000007c, 0x0000000000007ffb,
  0x000000000000007d, 0x0000000000007ffc,
  0x000000000000007e, 0x0000000000007ffd,
  0x000000000000007f, 0x0000000000007ffe,
  0x0000000000000080, 0x0000000000007fff,
  0x0000000000000081, 0x000000000000801d,
  0x000000000000009f, 0x000000000000807a,
  0x00000000000000fc, 0x000000000000807b,
  0x00000000000000fd, 0x000000000000807c,
  0x00000000000000fe, 0x000000000000fffa,
  0x000000000000807c, 0x000000000000fffb,
  0x000000000000807d, 0x000000000000fffc,
  0x000000000000807e, 0x000000003333b330,
  0x00000000333333b2, 0x000000005555d552,
  0x00000000555555d4, 0x0000000080007ffa,
  0x000000008000007c, 0x0000000080007ffb,
  0x000000008000007d, 0x0000000080007ffc,
  0x000000008000007e, 0xffffffff80007ffd,
  0xffffffff8000007f, 0xffffffff80007ffe,
  0xffffffff80000080, 0xffffffffaaab2aa7,
  0xffffffffaaaaab29, 0xffffffffcccd4cc9,
  0xffffffffcccccd4b, 0xfffffffffffffffd,
  0xffffffffffff807f, 0xfffffffffffffffe,
  0xffffffffffff8080, 0xffffffffffffffff,
  0xffffffffffff8081, 0x0000000000000000,
  0xffffffffffff8082, 0x0000000000007f7d,
  0xffffffffffffffff, 0x0000000000007f7e,
  0x0000000000000000, 0x0000000000007f7f,
  0x0000000000000001, 0x0000000000007f80,
  0x0000000000000002, 0x0000000000007fdd,
  0x000000000000005f, 0x0000000000007ffa,
  0x0000000000007ffa, 0x0000000000007ffc,
  0x0000000000007ffb, 0x0000000000007ffd,
  0x0000000000007ffc, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000008000,
  0x0000000000007fff, 0x000000000000801e,
  0x000000000000801d, 0x000000000000807b,
  0x000000000000807a, 0x000000000000807c,
  0x000000000000807b, 0x000000000000807d,
  0x000000000000807c, 0x000000000000fffb,
  0x000000000000fffa, 0x000000000000fffc,
  0x000000000000fffb, 0x000000000000fffd,
  0x000000000000fffc, 0x000000003333b331,
  0x000000003333b330, 0x000000005555d553,
  0x000000005555d552, 0x0000000080007ffb,
  0x0000000080007ffa, 0x0000000080007ffc,
  0x0000000080007ffb, 0x0000000080007ffd,
  0x0000000080007ffc, 0xffffffff80007ffe,
  0xffffffff80007ffd, 0xffffffff80007fff,
  0xffffffff80007ffe, 0xffffffffaaab2aa8,
  0xffffffffaaab2aa7, 0xffffffffcccd4cca,
  0xffffffffcccd4cc9, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000007f7e,
  0x0000000000007f7d, 0x0000000000007f7f,
  0x0000000000007f7e, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000007f81,
  0x0000000000007f80, 0x0000000000007fde,
  0x0000000000007fdd, 0x0000000000007ffb,
  0x0000000000007ffb, 0x0000000000007ffd,
  0x0000000000007ffc, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000008000,
  0x0000000000007fff, 0x0000000000008001,
  0x0000000000008000, 0x000000000000801f,
  0x000000000000801e, 0x000000000000807c,
  0x000000000000807b, 0x000000000000807d,
  0x000000000000807c, 0x000000000000807e,
  0x000000000000807d, 0x000000000000fffc,
  0x000000000000fffb, 0x000000000000fffd,
  0x000000000000fffc, 0x000000000000fffe,
  0x000000000000fffd, 0x000000003333b332,
  0x000000003333b331, 0x000000005555d554,
  0x000000005555d553, 0x0000000080007ffc,
  0x0000000080007ffb, 0x0000000080007ffd,
  0x0000000080007ffc, 0x0000000080007ffe,
  0x0000000080007ffd, 0xffffffff80007fff,
  0xffffffff80007ffe, 0xffffffff80008000,
  0xffffffff80007fff, 0xffffffffaaab2aa9,
  0xffffffffaaab2aa8, 0xffffffffcccd4ccb,
  0xffffffffcccd4cca, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x0000000000007f7f,
  0x0000000000007f7e, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000007f81,
  0x0000000000007f80, 0x0000000000007f82,
  0x0000000000007f81, 0x0000000000007fdf,
  0x0000000000007fde, 0x0000000000007ffc,
  0x0000000000007ffc, 0x0000000033333331,
  0x0000000000007ffd, 0x0000000033333332,
  0x0000000000007ffe, 0x0000000033333333,
  0x0000000000007fff, 0x0000000033333334,
  0x0000000000008000, 0x0000000033333335,
  0x0000000000008001, 0x0000000033333353,
  0x000000000000801f, 0x00000000333333b0,
  0x000000000000807c, 0x00000000333333b1,
  0x000000000000807d, 0x00000000333333b2,
  0x000000000000807e, 0x000000003333b330,
  0x000000000000fffc, 0x000000003333b331,
  0x000000000000fffd, 0x000000003333b332,
  0x000000000000fffe, 0x0000000066666666,
  0x000000003333b332, 0x0000000088888888,
  0x000000005555d554, 0x00000000b3333330,
  0x0000000080007ffc, 0x00000000b3333331,
  0x0000000080007ffd, 0x00000000b3333332,
  0x0000000080007ffe, 0xffffffffb3333333,
  0xffffffff80007fff, 0xffffffffb3333334,
  0xffffffff80008000, 0xffffffffdddddddd,
  0xffffffffaaab2aa9, 0xffffffffffffffff,
  0xffffffffcccd4ccb, 0x000000003332b333,
  0xffffffffffffffff, 0x000000003332b334,
  0x0000000000000000, 0x000000003332b335,
  0x0000000000000001, 0x000000003332b336,
  0x0000000000000002, 0x00000000333332b3,
  0x0000000000007f7f, 0x00000000333332b4,
  0x0000000000007f80, 0x00000000333332b5,
  0x0000000000007f81, 0x00000000333332b6,
  0x0000000000007f82, 0x0000000033333313,
  0x0000000000007fdf, 0x0000000033333330,
  0x0000000033333330, 0x0000000055555553,
  0x0000000033333331, 0x0000000055555554,
  0x0000000033333332, 0x0000000055555555,
  0x0000000033333333, 0x0000000055555556,
  0x0000000033333334, 0x0000000055555557,
  0x0000000033333335, 0x0000000055555575,
  0x0000000033333353, 0x00000000555555d2,
  0x00000000333333b0, 0x00000000555555d3,
  0x00000000333333b1, 0x00000000555555d4,
  0x00000000333333b2, 0x000000005555d552,
  0x000000003333b330, 0x000000005555d553,
  0x000000003333b331, 0x000000005555d554,
  0x000000003333b332, 0x0000000088888888,
  0x0000000066666666, 0x00000000aaaaaaaa,
  0x0000000088888888, 0x00000000d5555552,
  0x00000000b3333330, 0x00000000d5555553,
  0x00000000b3333331, 0x00000000d5555554,
  0x00000000b3333332, 0xffffffffd5555555,
  0xffffffffb3333333, 0xffffffffd5555556,
  0xffffffffb3333334, 0xffffffffffffffff,
  0xffffffffdddddddd, 0x0000000022222221,
  0xffffffffffffffff, 0x000000005554d555,
  0x000000003332b333, 0x000000005554d556,
  0x000000003332b334, 0x000000005554d557,
  0x000000003332b335, 0x000000005554d558,
  0x000000003332b336, 0x00000000555554d5,
  0x00000000333332b3, 0x00000000555554d6,
  0x00000000333332b4, 0x00000000555554d7,
  0x00000000333332b5, 0x00000000555554d8,
  0x00000000333332b6, 0x0000000055555535,
  0x0000000033333313, 0x0000000055555552,
  0x0000000055555552, 0x000000007ffffffb,
  0x0000000055555553, 0x000000007ffffffc,
  0x0000000055555554, 0x000000007ffffffd,
  0x0000000055555555, 0x000000007ffffffe,
  0x0000000055555556, 0x000000007fffffff,
  0x0000000055555557, 0x000000008000001d,
  0x0000000055555575, 0x000000008000007a,
  0x00000000555555d2, 0x000000008000007b,
  0x00000000555555d3, 0x000000008000007c,
  0x00000000555555d4, 0x0000000080007ffa,
  0x000000005555d552, 0x0000000080007ffb,
  0x000000005555d553, 0x0000000080007ffc,
  0x000000005555d554, 0x00000000b3333330,
  0x0000000088888888, 0x00000000d5555552,
  0x00000000aaaaaaaa, 0x00000000fffffffa,
  0x00000000d5555552, 0x00000000fffffffb,
  0x00000000d5555553, 0x00000000fffffffc,
  0x00000000d5555554, 0xfffffffffffffffd,
  0xffffffffd5555555, 0xfffffffffffffffe,
  0xffffffffd5555556, 0x000000002aaaaaa7,
  0xffffffffffffffff, 0x000000004cccccc9,
  0x0000000022222221, 0x000000007fff7ffd,
  0x000000005554d555, 0x000000007fff7ffe,
  0x000000005554d556, 0x000000007fff7fff,
  0x000000005554d557, 0x000000007fff8000,
  0x000000005554d558, 0x000000007fffff7d,
  0x00000000555554d5, 0x000000007fffff7e,
  0x00000000555554d6, 0x000000007fffff7f,
  0x00000000555554d7, 0x000000007fffff80,
  0x00000000555554d8, 0x000000007fffffdd,
  0x0000000055555535, 0x000000007ffffffa,
  0x000000007ffffffa, 0x000000007ffffffc,
  0x000000007ffffffb, 0x000000007ffffffd,
  0x000000007ffffffc, 0x000000007ffffffe,
  0x000000007ffffffd, 0x000000007fffffff,
  0x000000007ffffffe, 0x0000000080000000,
  0x000000007fffffff, 0x000000008000001e,
  0x000000008000001d, 0x000000008000007b,
  0x000000008000007a, 0x000000008000007c,
  0x000000008000007b, 0x000000008000007d,
  0x000000008000007c, 0x0000000080007ffb,
  0x0000000080007ffa, 0x0000000080007ffc,
  0x0000000080007ffb, 0x0000000080007ffd,
  0x0000000080007ffc, 0x00000000b3333331,
  0x00000000b3333330, 0x00000000d5555553,
  0x00000000d5555552, 0x00000000fffffffb,
  0x00000000fffffffa, 0x00000000fffffffc,
  0x00000000fffffffb, 0x00000000fffffffd,
  0x00000000fffffffc, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x000000002aaaaaa8,
  0x000000002aaaaaa7, 0x000000004cccccca,
  0x000000004cccccc9, 0x000000007fff7ffe,
  0x000000007fff7ffd, 0x000000007fff7fff,
  0x000000007fff7ffe, 0x000000007fff8000,
  0x000000007fff7fff, 0x000000007fff8001,
  0x000000007fff8000, 0x000000007fffff7e,
  0x000000007fffff7d, 0x000000007fffff7f,
  0x000000007fffff7e, 0x000000007fffff80,
  0x000000007fffff7f, 0x000000007fffff81,
  0x000000007fffff80, 0x000000007fffffde,
  0x000000007fffffdd, 0x000000007ffffffb,
  0x000000007ffffffb, 0x000000007ffffffd,
  0x000000007ffffffc, 0x000000007ffffffe,
  0x000000007ffffffd, 0x000000007fffffff,
  0x000000007ffffffe, 0x0000000080000000,
  0x000000007fffffff, 0x0000000080000001,
  0x0000000080000000, 0x000000008000001f,
  0x000000008000001e, 0x000000008000007c,
  0x000000008000007b, 0x000000008000007d,
  0x000000008000007c, 0x000000008000007e,
  0x000000008000007d, 0x0000000080007ffc,
  0x0000000080007ffb, 0x0000000080007ffd,
  0x0000000080007ffc, 0x0000000080007ffe,
  0x0000000080007ffd, 0x00000000b3333332,
  0x00000000b3333331, 0x00000000d5555554,
  0x00000000d5555553, 0x00000000fffffffc,
  0x00000000fffffffb, 0x00000000fffffffd,
  0x00000000fffffffc, 0x00000000fffffffe,
  0x00000000fffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x000000002aaaaaa9,
  0x000000002aaaaaa8, 0x000000004ccccccb,
  0x000000004cccccca, 0x000000007fff7fff,
  0x000000007fff7ffe, 0x000000007fff8000,
  0x000000007fff7fff, 0x000000007fff8001,
  0x000000007fff8000, 0x000000007fff8002,
  0x000000007fff8001, 0x000000007fffff7f,
  0x000000007fffff7e, 0x000000007fffff80,
  0x000000007fffff7f, 0x000000007fffff81,
  0x000000007fffff80, 0x000000007fffff82,
  0x000000007fffff81, 0x000000007fffffdf,
  0x000000007fffffde, 0x000000007ffffffc,
  0x000000007ffffffc, 0xffffffff7ffffffe,
  0x000000007ffffffd, 0xffffffff7fffffff,
  0x000000007ffffffe, 0xffffffff80000000,
  0x000000007fffffff, 0xffffffff80000001,
  0x0000000080000000, 0xffffffff80000002,
  0x0000000080000001, 0xffffffff80000020,
  0x000000008000001f, 0xffffffff8000007d,
  0x000000008000007c, 0xffffffff8000007e,
  0x000000008000007d, 0xffffffff8000007f,
  0x000000008000007e, 0xffffffff80007ffd,
  0x0000000080007ffc, 0xffffffff80007ffe,
  0x0000000080007ffd, 0xffffffff80007fff,
  0x0000000080007ffe, 0xffffffffb3333333,
  0x00000000b3333332, 0xffffffffd5555555,
  0x00000000d5555554, 0xfffffffffffffffd,
  0x00000000fffffffc, 0xfffffffffffffffe,
  0x00000000fffffffd, 0xffffffffffffffff,
  0x00000000fffffffe, 0xffffffff00000000,
  0xffffffffffffffff, 0xffffffff00000001,
  0x0000000000000000, 0xffffffff2aaaaaaa,
  0x000000002aaaaaa9, 0xffffffff4ccccccc,
  0x000000004ccccccb, 0xffffffff7fff8000,
  0x000000007fff7fff, 0xffffffff7fff8001,
  0x000000007fff8000, 0xffffffff7fff8002,
  0x000000007fff8001, 0xffffffff7fff8003,
  0x000000007fff8002, 0xffffffff7fffff80,
  0x000000007fffff7f, 0xffffffff7fffff81,
  0x000000007fffff80, 0xffffffff7fffff82,
  0x000000007fffff81, 0xffffffff7fffff83,
  0x000000007fffff82, 0xffffffff7fffffe0,
  0x000000007fffffdf, 0xffffffff7ffffffd,
  0xffffffff7ffffffd, 0xffffffff7fffffff,
  0xffffffff7ffffffe, 0xffffffff80000000,
  0xffffffff7fffffff, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff80000002,
  0xffffffff80000001, 0xffffffff80000003,
  0xffffffff80000002, 0xffffffff80000021,
  0xffffffff80000020, 0xffffffff8000007e,
  0xffffffff8000007d, 0xffffffff8000007f,
  0xffffffff8000007e, 0xffffffff80000080,
  0xffffffff8000007f, 0xffffffff80007ffe,
  0xffffffff80007ffd, 0xffffffff80007fff,
  0xffffffff80007ffe, 0xffffffff80008000,
  0xffffffff80007fff, 0xffffffffb3333334,
  0xffffffffb3333333, 0xffffffffd5555556,
  0xffffffffd5555555, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0xffffffff00000001,
  0xffffffff00000000, 0xffffffff00000002,
  0xffffffff00000001, 0xffffffff2aaaaaab,
  0xffffffff2aaaaaaa, 0xffffffff4ccccccd,
  0xffffffff4ccccccc, 0xffffffff7fff8001,
  0xffffffff7fff8000, 0xffffffff7fff8002,
  0xffffffff7fff8001, 0xffffffff7fff8003,
  0xffffffff7fff8002, 0xffffffff7fff8004,
  0xffffffff7fff8003, 0xffffffff7fffff81,
  0xffffffff7fffff80, 0xffffffff7fffff82,
  0xffffffff7fffff81, 0xffffffff7fffff83,
  0xffffffff7fffff82, 0xffffffff7fffff84,
  0xffffffff7fffff83, 0xffffffff7fffffe1,
  0xffffffff7fffffe0, 0xffffffff7ffffffe,
  0xffffffff7ffffffe, 0xffffffffaaaaaaa8,
  0xffffffff7fffffff, 0xffffffffaaaaaaa9,
  0xffffffff80000000, 0xffffffffaaaaaaaa,
  0xffffffff80000001, 0xffffffffaaaaaaab,
  0xffffffff80000002, 0xffffffffaaaaaaac,
  0xffffffff80000003, 0xffffffffaaaaaaca,
  0xffffffff80000021, 0xffffffffaaaaab27,
  0xffffffff8000007e, 0xffffffffaaaaab28,
  0xffffffff8000007f, 0xffffffffaaaaab29,
  0xffffffff80000080, 0xffffffffaaab2aa7,
  0xffffffff80007ffe, 0xffffffffaaab2aa8,
  0xffffffff80007fff, 0xffffffffaaab2aa9,
  0xffffffff80008000, 0xffffffffdddddddd,
  0xffffffffb3333334, 0xffffffffffffffff,
  0xffffffffd5555556, 0x000000002aaaaaa7,
  0xfffffffffffffffe, 0x000000002aaaaaa8,
  0xffffffffffffffff, 0x000000002aaaaaa9,
  0x0000000000000000, 0xffffffff2aaaaaaa,
  0xffffffff00000001, 0xffffffff2aaaaaab,
  0xffffffff00000002, 0xffffffff55555554,
  0xffffffff2aaaaaab, 0xffffffff77777776,
  0xffffffff4ccccccd, 0xffffffffaaaa2aaa,
  0xffffffff7fff8001, 0xffffffffaaaa2aab,
  0xffffffff7fff8002, 0xffffffffaaaa2aac,
  0xffffffff7fff8003, 0xffffffffaaaa2aad,
  0xffffffff7fff8004, 0xffffffffaaaaaa2a,
  0xffffffff7fffff81, 0xffffffffaaaaaa2b,
  0xffffffff7fffff82, 0xffffffffaaaaaa2c,
  0xffffffff7fffff83, 0xffffffffaaaaaa2d,
  0xffffffff7fffff84, 0xffffffffaaaaaa8a,
  0xffffffff7fffffe1, 0xffffffffaaaaaaa7,
  0xffffffffaaaaaaa7, 0xffffffffccccccca,
  0xffffffffaaaaaaa8, 0xffffffffcccccccb,
  0xffffffffaaaaaaa9, 0xffffffffcccccccc,
  0xffffffffaaaaaaaa, 0xffffffffcccccccd,
  0xffffffffaaaaaaab, 0xffffffffccccccce,
  0xffffffffaaaaaaac, 0xffffffffccccccec,
  0xffffffffaaaaaaca, 0xffffffffcccccd49,
  0xffffffffaaaaab27, 0xffffffffcccccd4a,
  0xffffffffaaaaab28, 0xffffffffcccccd4b,
  0xffffffffaaaaab29, 0xffffffffcccd4cc9,
  0xffffffffaaab2aa7, 0xffffffffcccd4cca,
  0xffffffffaaab2aa8, 0xffffffffcccd4ccb,
  0xffffffffaaab2aa9, 0xffffffffffffffff,
  0xffffffffdddddddd, 0x0000000022222221,
  0xffffffffffffffff, 0x000000004cccccc9,
  0x000000002aaaaaa7, 0x000000004cccccca,
  0x000000002aaaaaa8, 0x000000004ccccccb,
  0x000000002aaaaaa9, 0xffffffff4ccccccc,
  0xffffffff2aaaaaaa, 0xffffffff4ccccccd,
  0xffffffff2aaaaaab, 0xffffffff77777776,
  0xffffffff55555554, 0xffffffff99999998,
  0xffffffff77777776, 0xffffffffcccc4ccc,
  0xffffffffaaaa2aaa, 0xffffffffcccc4ccd,
  0xffffffffaaaa2aab, 0xffffffffcccc4cce,
  0xffffffffaaaa2aac, 0xffffffffcccc4ccf,
  0xffffffffaaaa2aad, 0xffffffffcccccc4c,
  0xffffffffaaaaaa2a, 0xffffffffcccccc4d,
  0xffffffffaaaaaa2b, 0xffffffffcccccc4e,
  0xffffffffaaaaaa2c, 0xffffffffcccccc4f,
  0xffffffffaaaaaa2d, 0xffffffffccccccac,
  0xffffffffaaaaaa8a, 0xffffffffccccccc9,
  0xffffffffccccccc9, 0xffffffffffff7ffe,
  0xffffffffccccccca, 0xffffffffffff7fff,
  0xffffffffcccccccb, 0xffffffffffff8000,
  0xffffffffcccccccc, 0xffffffffffff8001,
  0xffffffffcccccccd, 0xffffffffffff8002,
  0xffffffffccccccce, 0xffffffffffff8020,
  0xffffffffccccccec, 0xffffffffffff807d,
  0xffffffffcccccd49, 0xffffffffffff807e,
  0xffffffffcccccd4a, 0xffffffffffff807f,
  0xffffffffcccccd4b, 0xfffffffffffffffd,
  0xffffffffcccd4cc9, 0xfffffffffffffffe,
  0xffffffffcccd4cca, 0xffffffffffffffff,
  0xffffffffcccd4ccb, 0x000000003332b333,
  0xffffffffffffffff, 0x000000005554d555,
  0x0000000022222221, 0x000000007fff7ffd,
  0x000000004cccccc9, 0x000000007fff7ffe,
  0x000000004cccccca, 0x000000007fff7fff,
  0x000000004ccccccb, 0xffffffff7fff8000,
  0xffffffff4ccccccc, 0xffffffff7fff8001,
  0xffffffff4ccccccd, 0xffffffffaaaa2aaa,
  0xffffffff77777776, 0xffffffffcccc4ccc,
  0xffffffff99999998, 0xffffffffffff0000,
  0xffffffffcccc4ccc, 0xffffffffffff0001,
  0xffffffffcccc4ccd, 0xffffffffffff0002,
  0xffffffffcccc4cce, 0xffffffffffff0003,
  0xffffffffcccc4ccf, 0xffffffffffff7f80,
  0xffffffffcccccc4c, 0xffffffffffff7f81,
  0xffffffffcccccc4d, 0xffffffffffff7f82,
  0xffffffffcccccc4e, 0xffffffffffff7f83,
  0xffffffffcccccc4f, 0xffffffffffff7fe0,
  0xffffffffccccccac, 0xffffffffffff7ffd,
  0xffffffffffff7ffd, 0xffffffffffff7fff,
  0xffffffffffff7ffe, 0xffffffffffff8000,
  0xffffffffffff7fff, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffffff8021,
  0xffffffffffff8020, 0xffffffffffff807e,
  0xffffffffffff807d, 0xffffffffffff807f,
  0xffffffffffff807e, 0xffffffffffff8080,
  0xffffffffffff807f, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x000000003332b334,
  0x000000003332b333, 0x000000005554d556,
  0x000000005554d555, 0x000000007fff7ffe,
  0x000000007fff7ffd, 0x000000007fff7fff,
  0x000000007fff7ffe, 0x000000007fff8000,
  0x000000007fff7fff, 0xffffffff7fff8001,
  0xffffffff7fff8000, 0xffffffff7fff8002,
  0xffffffff7fff8001, 0xffffffffaaaa2aab,
  0xffffffffaaaa2aaa, 0xffffffffcccc4ccd,
  0xffffffffcccc4ccc, 0xffffffffffff0001,
  0xffffffffffff0000, 0xffffffffffff0002,
  0xffffffffffff0001, 0xffffffffffff0003,
  0xffffffffffff0002, 0xffffffffffff0004,
  0xffffffffffff0003, 0xffffffffffff7f81,
  0xffffffffffff7f80, 0xffffffffffff7f82,
  0xffffffffffff7f81, 0xffffffffffff7f83,
  0xffffffffffff7f82, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffffff7fe1,
  0xffffffffffff7fe0, 0xffffffffffff7ffe,
  0xffffffffffff7ffe, 0xffffffffffff8000,
  0xffffffffffff7fff, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffffff8004,
  0xffffffffffff8003, 0xffffffffffff8022,
  0xffffffffffff8021, 0xffffffffffff807f,
  0xffffffffffff807e, 0xffffffffffff8080,
  0xffffffffffff807f, 0xffffffffffff8081,
  0xffffffffffff8080, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x000000003332b335,
  0x000000003332b334, 0x000000005554d557,
  0x000000005554d556, 0x000000007fff7fff,
  0x000000007fff7ffe, 0x000000007fff8000,
  0x000000007fff7fff, 0x000000007fff8001,
  0x000000007fff8000, 0xffffffff7fff8002,
  0xffffffff7fff8001, 0xffffffff7fff8003,
  0xffffffff7fff8002, 0xffffffffaaaa2aac,
  0xffffffffaaaa2aab, 0xffffffffcccc4cce,
  0xffffffffcccc4ccd, 0xffffffffffff0002,
  0xffffffffffff0001, 0xffffffffffff0003,
  0xffffffffffff0002, 0xffffffffffff0004,
  0xffffffffffff0003, 0xffffffffffff0005,
  0xffffffffffff0004, 0xffffffffffff7f82,
  0xffffffffffff7f81, 0xffffffffffff7f83,
  0xffffffffffff7f82, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffffff7f85,
  0xffffffffffff7f84, 0xffffffffffff7fe2,
  0xffffffffffff7fe1, 0xffffffffffff7fff,
  0xffffffffffff7fff, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffffff8004,
  0xffffffffffff8003, 0xffffffffffff8005,
  0xffffffffffff8004, 0xffffffffffff8023,
  0xffffffffffff8022, 0xffffffffffff8080,
  0xffffffffffff807f, 0xffffffffffff8081,
  0xffffffffffff8080, 0xffffffffffff8082,
  0xffffffffffff8081, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x000000003332b336,
  0x000000003332b335, 0x000000005554d558,
  0x000000005554d557, 0x000000007fff8000,
  0x000000007fff7fff, 0x000000007fff8001,
  0x000000007fff8000, 0x000000007fff8002,
  0x000000007fff8001, 0xffffffff7fff8003,
  0xffffffff7fff8002, 0xffffffff7fff8004,
  0xffffffff7fff8003, 0xffffffffaaaa2aad,
  0xffffffffaaaa2aac, 0xffffffffcccc4ccf,
  0xffffffffcccc4cce, 0xffffffffffff0003,
  0xffffffffffff0002, 0xffffffffffff0004,
  0xffffffffffff0003, 0xffffffffffff0005,
  0xffffffffffff0004, 0xffffffffffff0006,
  0xffffffffffff0005, 0xffffffffffff7f83,
  0xffffffffffff7f82, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffffff7f85,
  0xffffffffffff7f84, 0xffffffffffff7f86,
  0xffffffffffff7f85, 0xffffffffffff7fe3,
  0xffffffffffff7fe2, 0xffffffffffff8000,
  0xffffffffffff8000, 0xffffffffffffff7e,
  0xffffffffffff8001, 0xffffffffffffff7f,
  0xffffffffffff8002, 0xffffffffffffff80,
  0xffffffffffff8003, 0xffffffffffffff81,
  0xffffffffffff8004, 0xffffffffffffff82,
  0xffffffffffff8005, 0xffffffffffffffa0,
  0xffffffffffff8023, 0xfffffffffffffffd,
  0xffffffffffff8080, 0xfffffffffffffffe,
  0xffffffffffff8081, 0xffffffffffffffff,
  0xffffffffffff8082, 0x0000000000007f7d,
  0x0000000000000000, 0x0000000000007f7e,
  0x0000000000000001, 0x0000000000007f7f,
  0x0000000000000002, 0x00000000333332b3,
  0x000000003332b336, 0x00000000555554d5,
  0x000000005554d558, 0x000000007fffff7d,
  0x000000007fff8000, 0x000000007fffff7e,
  0x000000007fff8001, 0x000000007fffff7f,
  0x000000007fff8002, 0xffffffff7fffff80,
  0xffffffff7fff8003, 0xffffffff7fffff81,
  0xffffffff7fff8004, 0xffffffffaaaaaa2a,
  0xffffffffaaaa2aad, 0xffffffffcccccc4c,
  0xffffffffcccc4ccf, 0xffffffffffff7f80,
  0xffffffffffff0003, 0xffffffffffff7f81,
  0xffffffffffff0004, 0xffffffffffff7f82,
  0xffffffffffff0005, 0xffffffffffff7f83,
  0xffffffffffff0006, 0xffffffffffffff00,
  0xffffffffffff7f83, 0xffffffffffffff01,
  0xffffffffffff7f84, 0xffffffffffffff02,
  0xffffffffffff7f85, 0xffffffffffffff03,
  0xffffffffffff7f86, 0xffffffffffffff60,
  0xffffffffffff7fe3, 0xffffffffffffff7d,
  0xffffffffffffff7d, 0xffffffffffffff7f,
  0xffffffffffffff7e, 0xffffffffffffff80,
  0xffffffffffffff7f, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffffffa1,
  0xffffffffffffffa0, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000007f7e,
  0x0000000000007f7d, 0x0000000000007f7f,
  0x0000000000007f7e, 0x0000000000007f80,
  0x0000000000007f7f, 0x00000000333332b4,
  0x00000000333332b3, 0x00000000555554d6,
  0x00000000555554d5, 0x000000007fffff7e,
  0x000000007fffff7d, 0x000000007fffff7f,
  0x000000007fffff7e, 0x000000007fffff80,
  0x000000007fffff7f, 0xffffffff7fffff81,
  0xffffffff7fffff80, 0xffffffff7fffff82,
  0xffffffff7fffff81, 0xffffffffaaaaaa2b,
  0xffffffffaaaaaa2a, 0xffffffffcccccc4d,
  0xffffffffcccccc4c, 0xffffffffffff7f81,
  0xffffffffffff7f80, 0xffffffffffff7f82,
  0xffffffffffff7f81, 0xffffffffffff7f83,
  0xffffffffffff7f82, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffffffff01,
  0xffffffffffffff00, 0xffffffffffffff02,
  0xffffffffffffff01, 0xffffffffffffff03,
  0xffffffffffffff02, 0xffffffffffffff04,
  0xffffffffffffff03, 0xffffffffffffff61,
  0xffffffffffffff60, 0xffffffffffffff7e,
  0xffffffffffffff7e, 0xffffffffffffff80,
  0xffffffffffffff7f, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffffff84,
  0xffffffffffffff83, 0xffffffffffffffa2,
  0xffffffffffffffa1, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000007f7f,
  0x0000000000007f7e, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000007f81,
  0x0000000000007f80, 0x00000000333332b5,
  0x00000000333332b4, 0x00000000555554d7,
  0x00000000555554d6, 0x000000007fffff7f,
  0x000000007fffff7e, 0x000000007fffff80,
  0x000000007fffff7f, 0x000000007fffff81,
  0x000000007fffff80, 0xffffffff7fffff82,
  0xffffffff7fffff81, 0xffffffff7fffff83,
  0xffffffff7fffff82, 0xffffffffaaaaaa2c,
  0xffffffffaaaaaa2b, 0xffffffffcccccc4e,
  0xffffffffcccccc4d, 0xffffffffffff7f82,
  0xffffffffffff7f81, 0xffffffffffff7f83,
  0xffffffffffff7f82, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffffff7f85,
  0xffffffffffff7f84, 0xffffffffffffff02,
  0xffffffffffffff01, 0xffffffffffffff03,
  0xffffffffffffff02, 0xffffffffffffff04,
  0xffffffffffffff03, 0xffffffffffffff05,
  0xffffffffffffff04, 0xffffffffffffff62,
  0xffffffffffffff61, 0xffffffffffffff7f,
  0xffffffffffffff7f, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffffff84,
  0xffffffffffffff83, 0xffffffffffffff85,
  0xffffffffffffff84, 0xffffffffffffffa3,
  0xffffffffffffffa2, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000007f81,
  0x0000000000007f80, 0x0000000000007f82,
  0x0000000000007f81, 0x00000000333332b6,
  0x00000000333332b5, 0x00000000555554d8,
  0x00000000555554d7, 0x000000007fffff80,
  0x000000007fffff7f, 0x000000007fffff81,
  0x000000007fffff80, 0x000000007fffff82,
  0x000000007fffff81, 0xffffffff7fffff83,
  0xffffffff7fffff82, 0xffffffff7fffff84,
  0xffffffff7fffff83, 0xffffffffaaaaaa2d,
  0xffffffffaaaaaa2c, 0xffffffffcccccc4f,
  0xffffffffcccccc4e, 0xffffffffffff7f83,
  0xffffffffffff7f82, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffffff7f85,
  0xffffffffffff7f84, 0xffffffffffff7f86,
  0xffffffffffff7f85, 0xffffffffffffff03,
  0xffffffffffffff02, 0xffffffffffffff04,
  0xffffffffffffff03, 0xffffffffffffff05,
  0xffffffffffffff04, 0xffffffffffffff06,
  0xffffffffffffff05, 0xffffffffffffff63,
  0xffffffffffffff62, 0xffffffffffffff80,
  0xffffffffffffff80, 0xffffffffffffffde,
  0xffffffffffffff81, 0xffffffffffffffdf,
  0xffffffffffffff82, 0xffffffffffffffe0,
  0xffffffffffffff83, 0xffffffffffffffe1,
  0xffffffffffffff84, 0xffffffffffffffe2,
  0xffffffffffffff85, 0x0000000000000000,
  0xffffffffffffffa3, 0x000000000000005d,
  0x0000000000000000, 0x000000000000005e,
  0x0000000000000001, 0x000000000000005f,
  0x0000000000000002, 0x0000000000007fdd,
  0x0000000000007f80, 0x0000000000007fde,
  0x0000000000007f81, 0x0000000000007fdf,
  0x0000000000007f82, 0x0000000033333313,
  0x00000000333332b6, 0x0000000055555535,
  0x00000000555554d8, 0x000000007fffffdd,
  0x000000007fffff80, 0x000000007fffffde,
  0x000000007fffff81, 0x000000007fffffdf,
  0x000000007fffff82, 0xffffffff7fffffe0,
  0xffffffff7fffff83, 0xffffffff7fffffe1,
  0xffffffff7fffff84, 0xffffffffaaaaaa8a,
  0xffffffffaaaaaa2d, 0xffffffffccccccac,
  0xffffffffcccccc4f, 0xffffffffffff7fe0,
  0xffffffffffff7f83, 0xffffffffffff7fe1,
  0xffffffffffff7f84, 0xffffffffffff7fe2,
  0xffffffffffff7f85, 0xffffffffffff7fe3,
  0xffffffffffff7f86, 0xffffffffffffff60,
  0xffffffffffffff03, 0xffffffffffffff61,
  0xffffffffffffff04, 0xffffffffffffff62,
  0xffffffffffffff05, 0xffffffffffffff63,
  0xffffffffffffff06, 0xffffffffffffffc0,
  0xffffffffffffff63, 0xffffffffffffffdd,
  0xffffffffffffffdd, 0xfffffffffffffffb,
  0xffffffffffffffde, 0xfffffffffffffffc,
  0xffffffffffffffdf, 0xfffffffffffffffd,
  0xffffffffffffffe0, 0xfffffffffffffffe,
  0xffffffffffffffe1, 0xffffffffffffffff,
  0xffffffffffffffe2, 0x000000000000001d,
  0x0000000000000000, 0x000000000000007a,
  0x000000000000005d, 0x000000000000007b,
  0x000000000000005e, 0x000000000000007c,
  0x000000000000005f, 0x0000000000007ffa,
  0x0000000000007fdd, 0x0000000000007ffb,
  0x0000000000007fde, 0x0000000000007ffc,
  0x0000000000007fdf, 0x0000000033333330,
  0x0000000033333313, 0x0000000055555552,
  0x0000000055555535, 0x000000007ffffffa,
  0x000000007fffffdd, 0x000000007ffffffb,
  0x000000007fffffde, 0x000000007ffffffc,
  0x000000007fffffdf, 0xffffffff7ffffffd,
  0xffffffff7fffffe0, 0xffffffff7ffffffe,
  0xffffffff7fffffe1, 0xffffffffaaaaaaa7,
  0xffffffffaaaaaa8a, 0xffffffffccccccc9,
  0xffffffffccccccac, 0xffffffffffff7ffd,
  0xffffffffffff7fe0, 0xffffffffffff7ffe,
  0xffffffffffff7fe1, 0xffffffffffff7fff,
  0xffffffffffff7fe2, 0xffffffffffff8000,
  0xffffffffffff7fe3, 0xffffffffffffff7d,
  0xffffffffffffff60, 0xffffffffffffff7e,
  0xffffffffffffff61, 0xffffffffffffff7f,
  0xffffffffffffff62, 0xffffffffffffff80,
  0xffffffffffffff63, 0xffffffffffffffdd,
  0xffffffffffffffc0, 0xfffffffffffffffa,
};
const unsigned kExpectedCount_NEON_saddl_2D = 961;

#endif  // VIXL_SIM_SADDL_2D_TRACE_AARCH64_H_
