# Class to store information about a known exploit.
# This code doesn't actually exploit anything.


# These have members
class exploit():
    def __init__(self):
        self.title = None
        self.description = None
        self.urls = []
        self.info = {}
        self.refnos = {}

    def set_title(self, title):
        self.title = title

    def get_title(self):
        return self.title

    def get_msno(self):
        if 'MS Bulletin' in self.refnos:
            return self.refnos['MS Bulletin']
        return None

    def get_description(self):
        return self.description

    def add_refno(self, reftype, ref):
        self.refnos[reftype] = ref

    def set_info(self, inftype, info):
        self.info[inftype] = info

    def get_info(self, inftype):
        if inftype in self.info.keys():
            return self.info[inftype]
        return None

    def add_url(self, url):
        # TODO uniq
        self.urls.append(url)

    def as_string(self):
        print "Title: %s" % self.title
        if self.description:
            print "Description: %s" % self.description
        if self.urls:
            print "URLs: %s" % "      \n".join(self.urls)
        for k in self.info.keys():
            print "%s: %s" % (k, self.info[k])
        for k in self.refnos.keys():
            print "%s: %s" % (k, self.refnos[k])
        print
