/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.anticsrf;

import net.sf.json.JSONObject;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.anticsrf.ExtensionAntiCSRF;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiOther;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiView;

public class AntiCsrfAPI
extends ApiImplementor {
    private static final String PREFIX = "acsrf";
    private static final String VIEW_TOKENS_NAMES = "optionTokensNames";
    private static final String OTHER_GENERATE_FORM = "genForm";
    private static final String OTHER_GENERATE_FORM_PARAM_HREFID = "hrefId";
    private static final String OTHER_GENERATE_FORM_ACTION_URL = "actionUrl";
    private static final String TOKEN_NAME = "tokenName";
    private ExtensionAntiCSRF extension = null;

    public AntiCsrfAPI(ExtensionAntiCSRF ext) {
        this.extension = ext;
        this.addApiView(new ApiView(VIEW_TOKENS_NAMES));
        this.addApiOthers(new ApiOther(OTHER_GENERATE_FORM, new String[]{OTHER_GENERATE_FORM_PARAM_HREFID}, new String[]{OTHER_GENERATE_FORM_ACTION_URL}));
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    public static String getAntiCsrfFormUrl(int hrefid) {
        return API.getInstance().getBaseURL(API.Format.OTHER, PREFIX, API.RequestType.other, OTHER_GENERATE_FORM, false) + "hrefId=" + hrefid;
    }

    @Override
    public ApiResponse handleApiView(String name, JSONObject params) throws ApiException {
        return switch (name) {
            case VIEW_TOKENS_NAMES -> {
                ApiResponseList resultList = new ApiResponseList(name);
                for (String tokenName : this.extension.getParam().getTokensNames()) {
                    resultList.addItem(new ApiResponseElement(TOKEN_NAME, tokenName));
                }
                yield resultList;
            }
            default -> throw new ApiException(ApiException.Type.BAD_VIEW);
        };
    }

    @Override
    public HttpMessage handleApiOther(HttpMessage msg, String name, JSONObject params) throws ApiException {
        if (OTHER_GENERATE_FORM.equals(name)) {
            int hrefId;
            String hrefIdStr = params.getString(OTHER_GENERATE_FORM_PARAM_HREFID);
            if (hrefIdStr == null || hrefIdStr.length() == 0) {
                throw new ApiException(ApiException.Type.MISSING_PARAMETER, OTHER_GENERATE_FORM_PARAM_HREFID);
            }
            try {
                hrefId = Integer.parseInt(hrefIdStr);
            }
            catch (NumberFormatException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, OTHER_GENERATE_FORM_PARAM_HREFID, e);
            }
            String actionUrl = params.optString(OTHER_GENERATE_FORM_ACTION_URL, "");
            try {
                HttpMessage originalMessage = new HistoryReference(hrefId, true).getHttpMessage();
                String response = this.extension.generateForm(originalMessage, actionUrl);
                Object charset = originalMessage.getResponseHeader().getCharset();
                charset = charset == null || ((String)charset).length() == 0 ? "" : " charset=" + (String)charset;
                msg.setResponseHeader(API.getDefaultResponseHeader("text/html; " + (String)charset));
                msg.setResponseBody(response);
                msg.getResponseHeader().setContentLength(msg.getResponseBody().length());
            }
            catch (HttpMalformedHeaderException e) {
                throw new ApiException(ApiException.Type.HREF_NOT_FOUND, hrefIdStr, e);
            }
            catch (Exception e) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)e);
            }
        }
        throw new ApiException(ApiException.Type.BAD_OTHER, name);
        return msg;
    }
}

