//
//  main.c  --  main function for Althea v0.3
//  -- created 4/12/00 updated 5/23/00
////////////////////////////////////////////

#include "main.h"

extern Althea gAlthea;

int main( int argc, char *argv[] ) {

    setlocale (LC_MESSAGES, "");
    bindtextdomain (PACKAGE, LOCALEDIR);
    textdomain (PACKAGE);
  

    
    GtkWidget *main_window;

    gtk_set_locale();
    gtk_init(&argc, &argv);

    gAlthea.set_Verbose(0);
    int counter = argc-1;
    while(counter > 0) {
      if (strstr("-v",argv[counter])!=NULL)
	gAlthea.set_Verbose(1);
      if (strstr("-V",argv[counter])!=NULL)
	gAlthea.set_Verbose(2);
      if (strstr("-h",argv[counter])!=NULL) {
	cout << "Althea command line options:" << endl;
	cout << "  -v     output some information to stdout" << endl;
	cout << "  -V     output communications to the IMAP server" << endl;
	cout << "  -h     print this help message" << endl;
	_exit(1);
      }
      counter--;
    }

    
    if (gAlthea.get_Verbose()){
      cout << "Althea version " << VERSION << endl; 
      cout << "Verbose:" << (int)gAlthea.get_Verbose() << endl;
    }


    add_pixmap_directory( PIXDIR );
    
    main_window = create_main_window();

    // pop all password promping boxes in front of the main window
    if (gAlthea.promptwindows.size()!=0) {
      for (list<GtkWidget *>::iterator it=gAlthea.promptwindows.begin();
	   it!=gAlthea.promptwindows.end();
	   it++) {
      gtk_grab_add(GTK_WIDGET(*it));
      gtk_window_set_transient_for(GTK_WINDOW(*it),GTK_WINDOW(main_window));
      }
    }
    // show the main window
    gtk_widget_show( main_window );



    //load_Althea();

    if (gAlthea.get_Verbose())
      gAlthea.display_filters();
    
    // check mail
    //    get_mail();

    gtk_main();

    return( 0 );
}





