//
//  save_config.cpp -- implementation of the functions to save the config file
//  -- created 1/18/01  updated 1/18/01
////////////////////////////////////////////////////////////

#include "save_config.h"


// The master function that starts the saving process



int save_Althea(Althea Althea_to_save)
{
  ofstream config_file;
  char* file_name;
  Configuration *config;
  
  //  Get the environment variable HOME, this is POSIX and Windows Compliant
  file_name=(char *)malloc (255);
  strcpy(file_name, getenv ("HOME"));
  strcat(file_name, "/"); 
  strcat(file_name,LOCAL_CONFIG_FILE);
  config_file.open(file_name);
  if (gAlthea.get_Verbose())
    cout << "Saveing to " << file_name << endl;

  list<Server>::iterator it;
  list<Server> server_list = Althea_to_save.get_Server_List();
  it = server_list.begin();
  while( it != server_list.end() )
  { 
    if (Althea_to_save.get_Verbose() == 2)
    	cout << "saving server" << endl;
    config_file << "<SERVER>" << endl;
    config_file << "\t<NAME>" << (*it).get_Server_Name() << "</NAME>" << endl;
    config_file << "\t<IMAPSERVER>" << (*it).get_IMAP_Server_Name() << "</IMAPSERVER>" << endl;
    config_file << "\t<IMAPPORT>" << (*it).get_Port_Number() << "</IMAPPORT>" << endl;
    config_file << "\t<SMTPSERVER>" << (*it).get_SMTP_Server_Name() << "</SMTPSERVER>" << endl;
    config_file << "\t<USERNAME>" << (*it).get_Username() << "</USERNAME>" << endl;
    if ((*it).get_Save_Password()) {

      // sanity check, apperently the encrypt func isn't perfect
      if (AltheaDecrypt(AltheaCrypt((*it).get_Password()))==(*it).get_Password())
	config_file << "\t<CRYPTPASSWORD>" << AltheaCrypt((*it).get_Password()) << "</CRYPTPASSWORD>" << endl;
      else {
	cout << AltheaDecrypt(AltheaCrypt((*it).get_Password())) << endl;
	cout << "could not crypt passwd" << endl;
	config_file << "\t<PASSWORD>" << (*it).get_Password() << "</PASSWORD>" << endl;
      }
    } else
      config_file << "\t<SAVEPASSWORD>0</SAVEPASSWORD>" << endl;
    if ((*it).get_Use_SSL()) 
      config_file << "\t<USESSL>1</USESSL>" << endl;

    config_file << "\t<MAILBOX>" << (*it).get_Folder_Root() << "</MAILBOX>" << endl;    
    config_file << "\t<FCCFOLDER>" << (*it).get_FCC_Folder() << "</FCCFOLDER>" << endl;
    config_file << "\t<EMAILADDRESS>" << (*it).get_EMail_Address() << "</EMAILADDRESS>" << endl;


    config_file << "</SERVER>" << endl;
    it++;

  }


  for (list<Filter>::iterator fit=Althea_to_save.filter_list.begin();
       fit != Althea_to_save.filter_list.end();
       fit++) {
   if (Althea_to_save.get_Verbose() == 2)
     cout << "saving filter " << (*fit).filter_string << endl;


    config_file << endl << "<FILTER>" << endl;
    config_file << "\t<FIELD>" << (*fit).field << "</FIELD>" << endl;
    config_file << "\t<FILTERFOLDER>" << (*fit).folder << "</FILTERFOLDER>" << endl;
    config_file << "\t<FILTERSTRING>" << (*fit).filter_string << "</FILTERSTRING>" << endl;
    config_file << "</FILTER>" << endl;
  }
  
  config = Althea_to_save.get_config();
  
  if ((config->get_key_accelerator(CHECK_MAIL)) != 0) {
  	config_file << endl << "<CHECK_MAIL_KEY>" << (char)config->get_key_accelerator(CHECK_MAIL) << "</CHECK_MAIL_KEY>" << endl;
  }
  
  if ((config->get_key_accelerator(DELETE_MESSAGE)) != 0) {
  	config_file << endl << "<DELETE_MESSAGE_KEY>" << (char)config->get_key_accelerator(DELETE_MESSAGE) << "</DELETE_MESSAGE_KEY>" << endl;
  }
  
  if ((config->get_key_accelerator(FORWARD_MESSAGE)) != 0) {
  	config_file << endl << "<FORWARD_MESSAGE_KEY>" << (char)config->get_key_accelerator(FORWARD_MESSAGE) << "</FORWARD_MESSAGE_KEY>" << endl;
  }
  
  if ((config->get_key_accelerator(COMPOSE_MESSAGE)) != 0) {
  	config_file << endl << "<COMPOSE_MESSAGE_KEY>" << (char)config->get_key_accelerator(COMPOSE_MESSAGE) << "</COMPOSE_MESSAGE_KEY>" << endl;
  }
  
  if ((config->get_key_accelerator(PRINT_MESSAGE)) != 0) {
  	config_file << endl << "<PRINT_MESSAGE_KEY>" << (char)config->get_key_accelerator(PRINT_MESSAGE) << "</PRINT_MESSAGE_KEY>" << endl;
  }
  
  if ((config->get_key_accelerator(QUIT_ALTHEA)) != 0) {
  	config_file << endl << "<QUIT_ALTHEA_KEY>" << (char)config->get_key_accelerator(QUIT_ALTHEA) << "</QUIT_ALTHEA_KEY>" << endl;
  }
  
  if ((config->get_key_accelerator(REPLY_MESSAGE)) != 0) {
  	config_file << endl << "<REPLY_MESSAGE_KEY>" << (char)config->get_key_accelerator(REPLY_MESSAGE) << "</REPLY_MESSAGE_KEY>" << endl;
  }
  
  if ((config->get_key_accelerator(SAVE_MESSAGE)) != 0) {
  	config_file << endl << "<SAVE_MESSAGE_KEY>" << (char)config->get_key_accelerator(SAVE_MESSAGE) << "</SAVE_MESSAGE_KEY>" << endl;
  }
  
  if ((config->get_key_accelerator(SEND_MESSAGE)) != 0) {
  	config_file << endl << "<SEND_MESSAGE_KEY>" << (char)config->get_key_accelerator(SEND_MESSAGE) << "</SEND_MESSAGE_KEY>" << endl;
  }
  
  if ((config->get_key_accelerator(ATTACH_FILE)) != 0) {
  	config_file << endl << "<ATTACH_FILE_KEY>" << (char)config->get_key_accelerator(ATTACH_FILE) << "</ATTACH_FILE_KEY>" << endl;
  }
  
  if ((config->get_key_accelerator(CLOSE_MESSAGE)) != 0) {
  	config_file << endl << "<CLOSE_MESSAGE_KEY>" << (char)config->get_key_accelerator(CLOSE_MESSAGE) << "</CLOSE_MESSAGE_KEY>" << endl;
  }
  	
  config_file.close();
  chmod(file_name, S_IRUSR | S_IWUSR);
  free(file_name);

  if (Althea_to_save.get_Verbose() == 2)
  	cout << "done saving" << endl;

  return SUCCESS;

}





