/***************************************************************************/
/* 		This code is part of WWW grabber called pavuk		   */
/*		Copyright (c) 1997 - 2001 Stefan Ondrejicka		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef _dllist_h_
#define _dllist_h_

typedef int		(*dlcomp_func)	(void *key1, void *key2);
typedef void		(*dlfree_func)	(void *key_data);

typedef  struct _dllist dllist;

struct _dllist {
	void 		*data;	
	dllist		*next;
	dllist		*prev;
};


extern dllist *dllist_new_entry(void *);
extern dllist *dllist_append(dllist *, void *);
extern dllist *dllist_prepend(dllist *, void *);
extern dllist *dllist_insert(dllist *, int, void *);
extern dllist *dllist_insert_after(dllist *, dllist *, void *);
extern dllist *dllist_insert_before(dllist *, dllist *, void *);
extern dllist *dllist_insert_list_after(dllist *, dllist *, dllist *);
extern dllist *dllist_first(dllist *);
extern dllist *dllist_last(dllist *);
extern dllist *dllist_nth(dllist *, int);
extern dllist *dllist_find(dllist *, void *);
extern dllist *dllist_find2(dllist *, void *, dlcomp_func);
extern unsigned int dllist_count(dllist *);
extern dllist *dllist_remove_entry(dllist *, dllist *);
extern dllist *dllist_remove_data(dllist *, void *);
extern void dllist_free_all(dllist *);
extern void dllist_free_all_custom(dllist *, dlfree_func);
extern dllist *dllist_concat(dllist *, dllist *);

#endif
