#!perl

use strict;
use warnings;

use Test::More tests => 12;
use Test::Exception;
use Test::MockObject;
use IO::String;

use Auth::Kokolores::Request;

my $server = Test::MockObject->new;
$server->set_isa('Auth::Kokolores', 'Net::Server');

my $r;
lives_ok {
  $r = Auth::Kokolores::Request->new(
    username => 'user',
    password => 'secret',
    service => 'auth',
    realm => 'example.com',
    server => $server,
  );
} 'create Auth::Kokolores::Request object';
isa_ok( $r, 'Auth::Kokolores::Request');

cmp_ok( $r->username, 'eq', 'user', '->user must be "user"');
cmp_ok( $r->password, 'eq', 'secret', '->password must be "secret"');
cmp_ok( $r->service, 'eq', 'auth', '->service must be "auth"');
cmp_ok( $r->realm, 'eq', 'example.com', '->realm must be "example.com"');

$r = undef;

my $sasl_request_string = pack 'n/a*n/a*n/a*n/a*xx', 'user', 'secret', 'auth', 'example.com';

my $conn = IO::String->new($sasl_request_string);

lives_ok {
  $r = Auth::Kokolores::Request->new_from_conn($conn, $server);
} 'create Auth::Kokolores::Request object';
isa_ok( $r, 'Auth::Kokolores::Request');

cmp_ok( $r->username, 'eq', 'user', '->user must be "user"');
cmp_ok( $r->password, 'eq', 'secret', '->password must be "secret"');
cmp_ok( $r->service, 'eq', 'auth', '->service must be "auth"');
cmp_ok( $r->realm, 'eq', 'example.com', '->realm must be "example.com"');


