use strict;
use Panda::Install;

write_makefile(
    NAME          => 'Panda::Lib',
    VERSION_FROM  => 'lib/Panda/Lib.pm',
    ABSTRACT_FROM => 'lib/Panda/Lib.pod',
    PREREQ_PM     => {'Panda::Export' => 0, 'Time::HiRes' => 0},
    TEST_REQUIRES => {'Test::Fatal' => 0, 'JSON::XS' => 0},
    CPLUS         => 11,
    DEFINE        => $ENV{TEST_FULL} ? '-DTEST_FULL' : '',
    SRC           => 'src',
    INC           => '-Isrc',
    LIBS          => ($^O eq 'MSWin32') ? '' : '-lpthread',
    BIN_DEPS      => 'Panda::XS',
    BIN_SHARE     => {
        CPLUS    => 11,
        INCLUDE  => {'src' => '/'},
        TYPEMAPS => {'typemap' => ''},
    },
    #OPTIMIZE  => '-g -O2',
    #CC => 'clang++',
);
