#!/usr/bin/perl -w

use File::Compare;
use File::Path;

my $shar = 'perl ../shar';
my $unshar = 'perl ../unshar';
my $dir = 'temp';

mkdir $dir, 0777 or die "Couldn't mkdir '$dir': $!";

system("$shar robert.frost mog.gif | $unshar -qcd $dir")
    == 0 or die "Couldn't run par/unpar: $!";

my $error = 0;
my %saw;
for (qw[
    robert.frost
    mog.gif
]) {
    $error++ unless compare($_, "$dir/$_") == 0;
}

print "1..1\n";
print $error ? "not ok 1\n" : "ok 1\n";

rmtree $dir;
