
use Test::More tests => 31;
BEGIN { use_ok('Compress::PPMd') };

my $in;
{ local $/; $in=<DATA> }

for my $maxorder (2..16) {
    my $encoder=Compress::PPMd::Encoder->new($maxorder);
    my $decoder=Compress::PPMd::Decoder->new($maxorder);

    my $encoded=$encoder->encode($in);
    my $decoded=$decoder->decode($encoded);
    is ($decoded, $in, "encoding/decoding maxorder=$maxorder");

    my $encoded2=$encoder->encode($in);
    my $decoded2=$decoder->decode($encoded2);
    is ($decoded2, $in, "encoding/decoding maxorder=$maxorder, solid mode");
}

__DATA__

Captulo primero. Que trata de la condicin y ejercicio del famoso hidalgo
don Quijote de la Mancha


En un lugar de la Mancha, de cuyo nombre no quiero acordarme, no ha mucho
tiempo que viva un hidalgo de los de lanza en astillero, adarga antigua,
rocn flaco y galgo corredor. Una olla de algo ms vaca que carnero,
salpicn las ms noches, duelos y quebrantos los sbados, lantejas los
viernes, algn palomino de aadidura los domingos, consuman las tres
partes de su hacienda. El resto della concluan sayo de velarte, calzas de
velludo para las fiestas, con sus pantuflos de lo mesmo, y los das de
entresemana se honraba con su vellor de lo ms fino. Tena en su casa una
ama que pasaba de los cuarenta, y una sobrina que no llegaba a los veinte,
y un mozo de campo y plaza, que as ensillaba el rocn como tomaba la
podadera. Frisaba la edad de nuestro hidalgo con los cincuenta aos; era de
complexin recia, seco de carnes, enjuto de rostro, gran madrugador y amigo
de la caza. Quieren decir que tena el sobrenombre de Quijada, o Quesada,
que en esto hay alguna diferencia en los autores que deste caso escriben;
aunque, por conjeturas verosmiles, se deja entender que se llamaba
Quejana. Pero esto importa poco a nuestro cuento; basta que en la narracin
dl no se salga un punto de la verdad.

Es, pues, de saber que este sobredicho hidalgo, los ratos que estaba
ocioso, que eran los ms del ao, se daba a leer libros de caballeras, con
tanta aficin y gusto, que olvid casi de todo punto el ejercicio de la
caza, y aun la administracin de su hacienda. Y lleg a tanto su curiosidad
y desatino en esto, que vendi muchas hanegas de tierra de sembradura para
comprar libros de caballeras en que leer, y as, llev a su casa todos
cuantos pudo haber dellos; y de todos, ningunos le parecan tan bien como
los que compuso el famoso Feliciano de Silva, porque la claridad de su
prosa y aquellas entricadas razones suyas le parecan de perlas, y ms
cuando llegaba a leer aquellos requiebros y cartas de desafos, donde en
muchas partes hallaba escrito: La razn de la sinrazn que a mi razn se
hace, de tal manera mi razn enflaquece, que con razn me quejo de la
vuestra fermosura. Y tambin cuando lea: ...los altos cielos que de
vuestra divinidad divinamente con las estrellas os fortifican, y os hacen
merecedora del merecimiento que merece la vuestra grandeza.

Con estas razones perda el pobre caballero el juicio, y desvelbase por
entenderlas y desentraarles el sentido, que no se lo sacara ni las
entendiera el mesmo Aristteles, si resucitara para slo ello. No estaba
muy bien con las heridas que don Belians daba y receba, porque se
imaginaba que, por grandes maestros que le hubiesen curado, no dejara de
tener el rostro y todo el cuerpo lleno de cicatrices y seales. Pero, con
todo, alababa en su autor aquel acabar su libro con la promesa de aquella
inacabable aventura, y muchas veces le vino deseo de tomar la pluma y dalle
fin al pie de la letra, como all se promete; y sin duda alguna lo hiciera,
y aun saliera con ello, si otros mayores y continuos pensamientos no se lo
estorbaran. Tuvo muchas veces competencia con el cura de su lugar -que era
hombre docto, graduado en Sigenza-, sobre cul haba sido mejor caballero:
Palmern de Ingalaterra o Amads de Gaula; mas maese Nicols, barbero del
mesmo pueblo, deca que ninguno llegaba al Caballero del Febo, y que si
alguno se le poda comparar, era don Galaor, hermano de Amads de Gaula,
porque tena muy acomodada condicin para todo; que no era caballero
melindroso, ni tan llorn como su hermano, y que en lo de la valenta no le
iba en zaga.

En resolucin, l se enfrasc tanto en su letura, que se le pasaban las
noches leyendo de claro en claro, y los das de turbio en turbio; y as,
del poco dormir y del mucho leer, se le sec el celebro, de manera que vino
a perder el juicio. Llensele la fantasa de todo aquello que lea en los
libros, as de encantamentos como de pendencias, batallas, desafos,
heridas, requiebros, amores, tormentas y disparates imposibles; y
asentsele de tal modo en la imaginacin que era verdad toda aquella
mquina de aquellas sonadas soadas invenciones que lea, que para l no
haba otra historia ms cierta en el mundo. Deca l que el Cid Ruy Daz
haba sido muy buen caballero, pero que no tena que ver con el Caballero
de la Ardiente Espada, que de slo un revs haba partido por medio dos
fieros y descomunales gigantes. Mejor estaba con Bernardo del Carpio,
porque en Roncesvalles haba muerto a Roldn el encantado, valindose de la
industria de Hrcules, cuando ahog a Anteo, el hijo de la Tierra, entre
los brazos. Deca mucho bien del gigante Morgante, porque, con ser de
aquella generacin gigantea, que todos son soberbios y descomedidos, l
solo era afable y bien criado. Pero, sobre todos, estaba bien con Reinaldos
de Montalbn, y ms cuando le vea salir de su castillo y robar cuantos
topaba, y cuando en allende rob aquel dolo de Mahoma que era todo de oro,
segn dice su historia. Diera l, por dar una mano de coces al traidor de
Galaln, al ama que tena, y aun a su sobrina de aadidura.

En efeto, rematado ya su juicio, vino a dar en el ms estrao pensamiento
que jams dio loco en el mundo; y fue que le pareci convenible y
necesario, as para el aumento de su honra como para el servicio de su
repblica, hacerse caballero andante, y irse por todo el mundo con sus
armas y caballo a buscar las aventuras y a ejercitarse en todo aquello que
l haba ledo que los caballeros andantes se ejercitaban, deshaciendo todo
gnero de agravio, y ponindose en ocasiones y peligros donde, acabndolos,
cobrase eterno nombre y fama. Imaginbase el pobre ya coronado por el valor
de su brazo, por lo menos, del imperio de Trapisonda; y as, con estos tan
agradables pensamientos, llevado del estrao gusto que en ellos senta, se
dio priesa a poner en efeto lo que deseaba.

Y lo primero que hizo fue limpiar unas armas que haban sido de sus
bisabuelos, que, tomadas de orn y llenas de moho, luengos siglos haba que
estaban puestas y olvidadas en un rincn. Limpilas y aderezlas lo mejor
que pudo, pero vio que tenan una gran falta, y era que no tenan celada de
encaje, sino morrin simple; mas a esto supli su industria, porque de
cartones hizo un modo de media celada, que, encajada con el morrin, hacan
una apariencia de celada entera. Es verdad que para probar si era fuerte y
poda estar al riesgo de una cuchillada, sac su espada y le dio dos
golpes, y con el primero y en un punto deshizo lo que haba hecho en una
semana; y no dej de parecerle mal la facilidad con que la haba hecho
pedazos, y, por asegurarse deste peligro, la torn a hacer de nuevo,
ponindole unas barras de hierro por de dentro, de tal manera que l qued
satisfecho de su fortaleza; y, sin querer hacer nueva experiencia della, la
diput y tuvo por celada finsima de encaje.

Fue luego a ver su rocn, y, aunque tena ms cuartos que un real y ms
tachas que el caballo de Gonela, que tantum pellis et ossa fuit, le pareci
que ni el Bucfalo de Alejandro ni Babieca el del Cid con l se igualaban.
Cuatro das se le pasaron en imaginar qu nombre le pondra; porque, segn
se deca l a s mesmo, no era razn que caballo de caballero tan famoso, y
tan bueno l por s, estuviese sin nombre conocido; y ans, procuraba
acomodrsele de manera que declarase quin haba sido, antes que fuese de
caballero andante, y lo que era entonces; pues estaba muy puesto en razn
que, mudando su seor estado, mudase l tambin el nombre, y le cobrase
famoso y de estruendo, como convena a la nueva orden y al nuevo ejercicio
que ya profesaba. Y as, despus de muchos nombres que form, borr y
quit, aadi, deshizo y torn a hacer en su memoria e imaginacin, al fin
le vino a llamar Rocinante: nombre, a su parecer, alto, sonoro y
significativo de lo que haba sido cuando fue rocn, antes de lo que ahora
era, que era antes y primero de todos los rocines del mundo.

Puesto nombre, y tan a su gusto, a su caballo, quiso ponrsele a s mismo,
y en este pensamiento dur otros ocho das, y al cabo se vino a llamar don
Quijote; de donde -como queda dicho- tomaron ocasin los autores desta tan
verdadera historia que, sin duda, se deba de llamar Quijada, y no Quesada,
como otros quisieron decir. Pero, acordndose que el valeroso Amads no
slo se haba contentado con llamarse Amads a secas, sino que aadi el
nombre de su reino y patria, por Hepila famosa, y se llam Amads de Gaula,
as quiso, como buen caballero, aadir al suyo el nombre de la suya y
llamarse don Quijote de la Mancha, con que, a su parecer, declaraba muy al
vivo su linaje y patria, y la honraba con tomar el sobrenombre della.

Limpias, pues, sus armas, hecho del morrin celada, puesto nombre a su
rocn y confirmndose a s mismo, se dio a entender que no le faltaba otra
cosa sino buscar una dama de quien enamorarse; porque el caballero andante
sin amores era rbol sin hojas y sin fruto y cuerpo sin alma. Decase l
a s:

-Si yo, por malos de mis pecados, o por mi buena suerte, me encuentro por
ah con algn gigante, como de ordinario les acontece a los caballeros
andantes, y le derribo de un encuentro, o le parto por mitad del cuerpo, o,
finalmente, le venzo y le rindo, no ser bien tener a quien enviarle
presentado y que entre y se hinque de rodillas ante mi dulce seora, y diga
con voz humilde y rendido: ''Yo, seora, soy el gigante Caraculiambro,
seor de la nsula Malindrania, a quien venci en singular batalla el
jams como se debe alabado caballero don Quijote de la Mancha, el cual me
mand que me presentase ante vuestra merced, para que la vuestra grandeza
disponga de m a su talante''?

Oh, cmo se holg nuestro buen caballero cuando hubo hecho este discurso,
y ms cuando hall a quien dar nombre de su dama! Y fue, a lo que se cree,
que en un lugar cerca del suyo haba una moza labradora de muy buen
parecer, de quien l un tiempo anduvo enamorado, aunque, segn se entiende,
ella jams lo supo, ni le dio cata dello. Llambase Aldonza Lorenzo, y a
sta le pareci ser bien darle ttulo de seora de sus pensamientos; y,
buscndole nombre que no desdijese mucho del suyo, y que tirase y se
encaminase al de princesa y gran seora, vino a llamarla Dulcinea del
Toboso, porque era natural del Toboso; nombre, a su parecer, msico y
peregrino y significativo, como todos los dems que a l y a sus cosas
haba puesto.

