#
# This file is part of Dist-Zilla-Plugin-MinimumPerl
#
# This software is copyright (c) 2014 by Apocalypse.
#
# This is free software; you can redistribute it and/or modify it under
# the same terms as the Perl 5 programming language system itself.
#
use strict; use warnings;
# This Makefile.PL for Dist-Zilla-Plugin-MinimumPerl was generated by
# Dist::Zilla::Plugin::MakeMaker::Fallback 0.014
# and Dist::Zilla::Plugin::MakeMaker::Awesome 0.31.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

BEGIN {
my %configure_requires = (
    'ExtUtils::MakeMaker' => '0',
    'Module::Build::Tiny' => '0.039',
);

my @missing = grep {
    ! eval "require $_; $_->VERSION($configure_requires{$_}); 1"
} keys %configure_requires;

if (not @missing)
{
    print "Congratulations, your toolchain understands 'configure_requires'!\n\n";
}
else
{
    $ENV{PERL_MM_FALLBACK_SILENCE_WARNING} or warn <<'EOW';
*** WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING ***

If you're seeing this warning, your toolchain is really, really old* and you'll
almost certainly have problems installing CPAN modules from this century. But
never fear, dear user, for we have the technology to fix this!

If you're using CPAN.pm to install things, then you can upgrade it using:

    cpan CPAN

If you're using CPANPLUS to install things, then you can upgrade it using:

    cpanp CPANPLUS

If you're using cpanminus, you shouldn't be seeing this message in the first
place, so please file an issue on github.

If you're installing manually, please retrain your fingers to run Build.PL
when present instead.

This public service announcement was brought to you by the Perl Toolchain
Gang, the irc.perl.org #toolchain IRC channel, and the number 42.

----

* Alternatively, you are doing something overly clever, in which case you
should consider setting the 'prefer_installer' config option in CPAN.pm, or
'prefer_makefile' in CPANPLUS, to 'mb" and '0' respectively.

You can also silence this warning for future installations by setting the
PERL_MM_FALLBACK_SILENCE_WARNING environment variable.

EOW

    sleep 10 if -t STDIN && (-t STDOUT || !(-f STDOUT || -c STDOUT));
}
}

use 5.006;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT" => "Detects the minimum version of Perl required for your dist",
  "AUTHOR" => "Apocalypse <APOCAL\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "Module::Build::Tiny" => "0.039"
  },
  "DISTNAME" => "Dist-Zilla-Plugin-MinimumPerl",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "MIN_PERL_VERSION" => "5.006",
  "NAME" => "Dist::Zilla::Plugin::MinimumPerl",
  "PREREQ_PM" => {
    "Dist::Zilla::Role::FileFinderUser" => "4.200006",
    "Dist::Zilla::Role::PrereqSource" => "5.006",
    "Moose" => "1.03",
    "Moose::Util::TypeConstraints" => "1.01",
    "MooseX::Types::Perl" => "0.101340",
    "Perl::MinimumVersion" => "1.26",
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "File::Spec" => 0,
    "File::Temp" => 0,
    "IO::Handle" => 0,
    "IPC::Open3" => 0,
    "Test::More" => "0.88"
  },
  "VERSION" => "1.006",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Dist::Zilla::Role::FileFinderUser" => "4.200006",
  "Dist::Zilla::Role::PrereqSource" => "5.006",
  "ExtUtils::MakeMaker" => 0,
  "File::Spec" => 0,
  "File::Temp" => 0,
  "IO::Handle" => 0,
  "IPC::Open3" => 0,
  "Module::Build::Tiny" => "0.039",
  "Moose" => "1.03",
  "Moose::Util::TypeConstraints" => "1.01",
  "MooseX::Types::Perl" => "0.101340",
  "Perl::MinimumVersion" => "1.26",
  "Test::More" => "0.88",
  "strict" => 0,
  "warnings" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
