use 5.018;
use Config;
use Panda::Install;

my $ivbits = $Config{ivsize}*8;

write_makefile(
    NAME          => 'Panda::XS',
    VERSION_FROM  => 'lib/Panda/XS.pm',
    ABSTRACT_FROM => 'lib/Panda/XS.pod',
    CPLUS         => 1,
    SRC           => ['src', $ENV{TEST_FULL} ? 't/src' : ()],
    INC           => '-Isrc',
    DEFINE        => $ENV{TEST_FULL} ? '-DTEST_FULL' : '',
    CCFLAGS       => $ENV{CPP11X} ? '-std=c++11' : '',
    TYPEMAPS      => ['typemap', "typemap$ivbits", 'testmap'],
    BIN_SHARE     => {
        CPLUS    => 1,
        INCLUDE  => {'src' => '/'},
        XSOPT    => '-hiertype',
        TYPEMAPS => {
            'typemap'        => '',
            "typemap$ivbits" => '',
        },
    },
    MIN_PERL_VERSION => '5.18.0', # required for GV_SUPER
    #OPTIMIZE => '-g -O0',
    #CC => 'clang++',
);
