package App::Yath::Command::init;
use strict;
use warnings;

use parent 'App::Yath::Command';

our $VERSION = '0.001063';

use Test2::Harness::Util qw/open_file/;
use App::Yath::Util qw/is_generated_test_pl/;

sub show_bench { 0 }

sub summary { "Create/update test.pl to run tests via Test2::Harness" }

sub description {
    return <<"    EOT";
This command will create or update the 'test.pl' file in the current directory.
This 'test.pl' file this creates will run all your tests via yath.

This command will fail if there is already a test.pl file that does not look
like it was generated by this command.
    EOT
}

sub run {
    die "'test.pl' already exists, and does not appear to be a yath runner.\n"
        if -f 'test.pl' && !is_generated_test_pl('test.pl');

    print "\nWriting test.pl...\n\n";

    my $fh = open_file('test.pl', '>');

    print $fh <<'    EOT';
#!/usr/bin/env perl
# HARNESS-NO-PRELOAD
# HARNESS-CAT-LONG
# THIS IS A GENERATED YATH RUNNER TEST
use strict;
use warnings;

use App::Yath::Util qw/find_yath/;

system($^X, '-Ilib', find_yath(), 'test', '--default-search' => './t', '--default-search' => './t2', @ARGV);
my $exit = $?;

# This makes sure it works with prove.
print "1..1\n";
print "not " if $exit;
print "ok 1 - Passed tests when run by yath\n";
print STDERR "yath exited with $exit" if $exit;

exit($exit ? 255 : 0);
    EOT

    return 0;
}

1;


__END__

=pod

=encoding UTF-8

=head1 NAME

=head1 DESCRIPTION

=head1 SYNOPSIS

=head1 COMMAND LINE USAGE


    $ yath init [options]

=head2 Help

=over 4

=item --show-opts

Exit after showing what yath thinks your options mean

=item -h

=item --help

Exit after showing this help message

=item -V

=item --version

Show version information

=back

=head2 Plugins

=over 4

=item -pPlugin

=item -p+My::Plugin

=item --plugin Plugin

Load a plugin

can be specified multiple times

=item --no-plugins

cancel any plugins listed until now

This can be used to negate plugins specified in .yath.rc or similar

=back

=head1 SOURCE

The source code repository for Test2-Harness can be found at
F<http://github.com/Test-More/Test2-Harness/>.

=head1 MAINTAINERS

=over 4

=item Chad Granum E<lt>exodist@cpan.orgE<gt>

=back

=head1 AUTHORS

=over 4

=item Chad Granum E<lt>exodist@cpan.orgE<gt>

=back

=head1 COPYRIGHT

Copyright 2017 Chad Granum E<lt>exodist7@gmail.comE<gt>.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

See F<http://dev.perl.org/licenses/>

=cut
