use warnings;
use strict;
use Test::More;
use Siebel::Srvrmgr::ListParser 0.27;
use Siebel::Srvrmgr::Daemon::ActionFactory 0.27;
use Siebel::Srvrmgr::Daemon::ActionStash 0.27;

my $class  = 'Siebel::Lbconfig::Daemon::Action::AOM';
my $parser = Siebel::Srvrmgr::ListParser->new(
    { clear_raw => 1, field_delimiter => '|' } );
$ENV{SIEBEL_TZ} = 'America/Sao_Paulo';
my $action = Siebel::Srvrmgr::Daemon::ActionFactory->create(
    $class,
    {
        parser => $parser,
    }
);

isa_ok( $action, $class );
$action->do( read_fixture() );
my $stash = Siebel::Srvrmgr::Daemon::ActionStash->instance();
my $comps = $stash->shift_stash();
is( ref($comps), 'HASH',
    "content returned from $class instance is a hash reference" );

SKIP: {
    skip 'invalid content from stash', 1 unless ( ref($comps) eq 'HASH' );
    my $expected = {
        EAIObjMgr_enu => [
            qw(sieb_serv045 sieb_serv052 sieb_serv057 sieb_serv049 sieb_serv053 sieb_serv048 sieb_serv058)
        ],
        EAIObjMgrXXXXX_enu => [
            qw(sieb_serv057 sieb_serv049 sieb_serv053 sieb_serv048 sieb_serv058)
        ],
        eMarketObjMgr_enu  => [qw(sieb_serv047 sieb_serv046)],
        eMarketObjMgr_esn  => [qw(sieb_serv047 sieb_serv046)],
        eMarketObjMgr_ptb  => [qw(sieb_serv047 sieb_serv046)],
        eServiceObjMgr_enu => [qw(sieb_serv053 sieb_serv048)],
        eServiceObjMgr_esn => [qw(sieb_serv053 sieb_serv048)],
        eServiceObjMgr_ptb => [qw(sieb_serv053 sieb_serv048)],
        loyalty2ObjMgr_enu => [qw(sieb_serv049 sieb_serv053 sieb_serv048)],
        loyaltyObjMgr_enu =>
          [qw(sieb_serv049 sieb_serv053 sieb_serv048 sieb_serv051)],
        loyaltyObjMgr_esn =>
          [qw(sieb_serv049 sieb_serv053 sieb_serv048 sieb_serv051)],
        loyaltyObjMgr_ptb =>
          [qw(sieb_serv049 sieb_serv053 sieb_serv048 sieb_serv051)],
        loyaltyscwObjMgr_enu => [qw(sieb_serv047 sieb_serv046)],
        loyaltyscwObjMgr_esn => [qw(sieb_serv047 sieb_serv046)],
        loyaltyscwObjMgr_ptb => [qw(sieb_serv047 sieb_serv046)],
        loyaltySMLObjMgr_enu => [qw(sieb_serv049 sieb_serv053 sieb_serv048)],
        loyaltySMLObjMgr_esn => [qw(sieb_serv049 sieb_serv053 sieb_serv048)],
        loyaltySMLObjMgr_ptb => [qw(sieb_serv049 sieb_serv053 sieb_serv048)],
        SCCObjMgr_enu        => [qw(sieb_serv053 sieb_serv048)],
        SCCObjMgr_esn        => [qw(sieb_serv053 sieb_serv048)],
        SCCObjMgr_ptb        => [qw(sieb_serv053 sieb_serv048)],
        SMObjMgr_enu         => [qw(sieb_serv056 sieb_serv050)],
        SMObjMgr_esn         => [qw(sieb_serv056 sieb_serv050)],
        SMObjMgr_ptb         => [qw(sieb_serv056 sieb_serv050)],
        SMSMLObjMgr_enu      => [qw(sieb_serv056 sieb_serv050)],
        SMSMLObjMgr_esn      => [qw(sieb_serv056 sieb_serv050)],
        SMSMLObjMgr_ptb      => [qw(sieb_serv056 sieb_serv050)],
        SServiceObjMgr_enu   => [qw(sieb_serv053 sieb_serv048)],
        SServiceObjMgr_esn   => [qw(sieb_serv053 sieb_serv048)],
        SServiceObjMgr_ptb   => [qw(sieb_serv053 sieb_serv048)],
    };
    is_deeply( $comps, $expected, 'all expected combinations of components and servers matches' );
}

done_testing;

sub read_fixture {
    my @data = <DATA>;
    close(DATA);
    return \@data;
}

__DATA__
srvrmgr> list comp

SV_NAME     |CC_ALIAS         |CC_NAME                                    |CT_ALIAS   |CG_ALIAS |CC_RUNMODE |CP_DISP_RUN_STATE|CP_STARTMODE|CP_NUM_RUN_TASKS|CP_MAX_TASKS|CP_ACTV_MTS_PROCS|CP_MAX_MTS_PROCS|CP_START_TIME      |CP_END_TIME        |CP_STATUS|CC_INCARN_NO|CC_DESC_TEXT|
------------  -----------------  -------------------------------------------  -----------  ---------  -----------  -----------------  ------------  ----------------  ------------  -----------------  ----------------  -------------------  -------------------  ---------  ------------  ------------  
sieb_serv056|FSMSrvr          |File System Manager                        |FSMSrvr    |SystemAux|Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:27|                   |Enabled  |            |            |
sieb_serv056|SMSMLObjMgr_enu  |Marketing Object Manager (ENU)             |AppObjMgr  |MktgOM   |Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:32|                   |Enabled  |            |            |
sieb_serv056|SMObjMgr_enu     |Marketing Object Manager (ENU)             |AppObjMgr  |MktgOM   |Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:32|                   |Enabled  |            |            |
sieb_serv056|SMObjMgr_esn     |Marketing Object Manager (ESN)             |AppObjMgr  |MktgOM   |Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:32|                   |Enabled  |            |            |
sieb_serv056|SMSMLObjMgr_esn  |Marketing Object Manager (ESN)             |AppObjMgr  |MktgOM   |Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:32|                   |Enabled  |            |            |
sieb_serv056|SMObjMgr_ptb     |Marketing Object Manager (PTB)             |AppObjMgr  |MktgOM   |Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:32|                   |Enabled  |            |            |
sieb_serv056|SMSMLObjMgr_ptb  |Marketing Object Manager (PTB)             |AppObjMgr  |MktgOM   |Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:32|                   |Enabled  |            |            |
sieb_serv056|ServerMgr        |Server Manager                             |ServerMgr  |System   |Interactive|Running          |Auto        |2               |20          |                 |                |2016-09-19 14:42:27|                   |Enabled  |            |            |
sieb_serv056|SRBroker         |Server Request Broker                      |ReqBroker  |System   |Interactive|Running          |Auto        |34              |100         |1                |1               |2016-09-19 14:42:27|                   |Enabled  |            |            |
sieb_serv056|SRProc           |Server Request Processor                   |SRProc     |SystemAux|Interactive|Running          |Auto        |2               |20          |1                |1               |2016-09-19 14:42:27|                   |Enabled  |            |            |
sieb_serv056|SvrTblCleanup    |Server Tables Cleanup                      |BusSvcMgr  |SystemAux|Background |Shutdown         |Manual      |0               |1           |                 |                |                   |2016-09-19 14:42:27|Enabled  |            |            |
sieb_serv056|SvrTaskPersist   |Server Task Persistance                    |BusSvcMgr  |SystemAux|Background |Running          |Auto        |1               |1           |                 |                |2016-09-19 14:42:27|                   |Enabled  |            |            |
sieb_serv056|AdminNotify      |Siebel Administrator Notification Component|AdminNotify|SystemAux|Batch      |Online           |Auto        |0               |10          |1                |1               |2016-09-19 14:42:27|                   |Enabled  |            |            |
sieb_serv056|SCBroker         |Siebel Connection Broker                   |SCBroker   |System   |Background |Running          |Auto        |2               |2           |                 |                |2016-09-19 14:42:27|                   |Enabled  |            |            |
sieb_serv056|eEventsObjMgr_enu|eEvents Object Manager (ENU)               |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:42:32|Enabled  |            |            |
sieb_serv056|eEventsObjMgr_esn|eEvents Object Manager (ESN)               |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:42:32|Enabled  |            |            |
sieb_serv056|eEventsObjMgr_ptb|eEvents Object Manager (PTB)               |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:42:32|Enabled  |            |            |
sieb_serv056|eMarketObjMgr_enu|eMarketing Object Manager (ENU)            |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |1000        |0                |10              |                   |2016-09-19 14:42:32|Enabled  |            |            |
sieb_serv056|eMarketObjMgr_esn|eMarketing Object Manager (ESN)            |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |1000        |0                |10              |                   |2016-09-19 14:42:32|Enabled  |            |            |
sieb_serv056|eMarketObjMgr_ptb|eMarketing Object Manager (PTB)            |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |1000        |0                |10              |                   |2016-09-19 14:42:32|Enabled  |            |            |
sieb_serv045|EAIObjMgrXXXXX_enu|EAI Object Manager (ENU)                   |EAIObjMgr  |EAI      |Interactive|Shutdown         |Manual      |0               |400         |0                |20              |                   |2016-09-19 14:42:30|Enabled  |            |            |
sieb_serv045|EAIObjMgr_enu    |EAI Object Manager (ENU)                   |EAIObjMgr  |EAI      |Interactive|Online           |Auto        |0               |400         |10               |20              |2016-09-19 14:42:30|                   |Enabled  |            |            |
sieb_serv045|InfraEAIOutbound |EAI Outbound Server                        |BusSvcMgr  |EAI      |Batch      |Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:42:30|Enabled  |            |            |
sieb_serv045|EIM              |Enterprise Integration Mgr                 |EIM        |EAI      |Batch      |Shutdown         |Manual      |0               |5           |                 |                |                   |2016-09-19 14:42:30|Enabled  |            |            |
sieb_serv045|FSMSrvr          |File System Manager                        |FSMSrvr    |SystemAux|Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:25|                   |Enabled  |            |            |
sieb_serv045|JMSReceiver      |JMS Receiver                               |EAIJMSRcvr |EAI      |Batch      |Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:42:30|Enabled  |            |            |
sieb_serv045|MqSeriesAMIRcvr  |MQSeries AMI Receiver                      |EAIRcvr    |EAI      |Background |Shutdown         |Manual      |0               |20          |                 |                |                   |2016-09-19 14:42:30|Enabled  |            |            |
sieb_serv045|MqSeriesSrvRcvr  |MQSeries Server Receiver                   |EAIRcvr    |EAI      |Background |Shutdown         |Manual      |0               |20          |                 |                |                   |2016-09-19 14:42:30|Enabled  |            |            |
sieb_serv045|MSMQRcvr         |MSMQ Receiver                              |EAIRcvr    |EAI      |Background |Shutdown         |Manual      |0               |20          |                 |                |                   |2016-09-19 14:42:30|Enabled  |            |            |
sieb_serv045|SMQReceiver      |SMQ Receiver                               |EAIRcvr    |EAI      |Background |Shutdown         |Manual      |0               |20          |                 |                |                   |2016-09-19 14:42:30|Enabled  |            |            |
sieb_serv045|ServerMgr        |Server Manager                             |ServerMgr  |System   |Interactive|Running          |Auto        |2               |20          |                 |                |2016-09-19 14:42:25|                   |Enabled  |            |            |
sieb_serv045|SRBroker         |Server Request Broker                      |ReqBroker  |System   |Interactive|Running          |Auto        |47              |100         |1                |1               |2016-09-19 14:42:25|                   |Enabled  |            |            |
sieb_serv045|SRProc           |Server Request Processor                   |SRProc     |SystemAux|Interactive|Running          |Auto        |2               |20          |1                |1               |2016-09-19 14:42:25|                   |Enabled  |            |            |
sieb_serv045|SvrTblCleanup    |Server Tables Cleanup                      |BusSvcMgr  |SystemAux|Background |Shutdown         |Manual      |0               |1           |                 |                |                   |2016-09-19 14:42:25|Enabled  |            |            |
sieb_serv045|SvrTaskPersist   |Server Task Persistance                    |BusSvcMgr  |SystemAux|Background |Running          |Auto        |1               |1           |                 |                |2016-09-19 14:42:25|                   |Enabled  |            |            |
sieb_serv045|AdminNotify      |Siebel Administrator Notification Component|AdminNotify|SystemAux|Batch      |Online           |Auto        |0               |10          |1                |1               |2016-09-19 14:42:25|                   |Enabled  |            |            |
sieb_serv045|SCBroker         |Siebel Connection Broker                   |SCBroker   |System   |Background |Running          |Auto        |2               |2           |                 |                |2016-09-19 14:42:25|                   |Enabled  |            |            |
sieb_serv045|LoyEngineBatch   |eLoyalty Processing Engine - Batch         |BusSvcMgr  |LoyaltyEngine|Batch      |Running          |Auto        |27              |60          |3                |3               |2016-09-20 13:07:34|                   |Enabled  |            |            |
sieb_serv045|LoyEngineInteractive|eLoyalty Processing Engine - Interactive   |BusSvcMgr  |LoyaltyEngine|Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:30|                   |Enabled  |            |            |
sieb_serv045|LoyEngineRealtime|eLoyalty Processing Engine - Realtime      |BusSvcMgr  |LoyaltyEngine|Batch      |Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:42:30|Enabled  |            |            |
sieb_serv045|LoyEngineRealtimeTier|eLoyalty Processing Engine - Realtime - Tier|BusSvcMgr  |LoyaltyEngine|Batch      |Online           |Auto        |0               |50          |1                |1               |2016-09-19 14:42:30|                   |Enabled  |            |            |
sieb_serv052|EAIObjMgrXXXXX_enu|EAI Object Manager (ENU)                   |EAIObjMgr  |EAI      |Interactive|Shutdown         |Manual      |0               |400         |0                |20              |                   |2016-09-19 14:42:43|Enabled  |            |            |
sieb_serv052|EAIObjMgr_enu    |EAI Object Manager (ENU)                   |EAIObjMgr  |EAI      |Interactive|Online           |Auto        |0               |400         |10               |20              |2016-09-19 14:42:43|                   |Enabled  |            |            |
sieb_serv052|InfraEAIOutbound |EAI Outbound Server                        |BusSvcMgr  |EAI      |Batch      |Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:42:43|Enabled  |            |            |
sieb_serv052|EIM              |Enterprise Integration Mgr                 |EIM        |EAI      |Batch      |Shutdown         |Manual      |0               |5           |                 |                |                   |2016-09-19 14:42:43|Enabled  |            |            |
sieb_serv052|FSMSrvr          |File System Manager                        |FSMSrvr    |SystemAux|Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:33|                   |Enabled  |            |            |
sieb_serv052|JMSReceiver      |JMS Receiver                               |EAIJMSRcvr |EAI      |Batch      |Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:42:43|Enabled  |            |            |
sieb_serv052|MqSeriesAMIRcvr  |MQSeries AMI Receiver                      |EAIRcvr    |EAI      |Background |Shutdown         |Manual      |0               |20          |                 |                |                   |2016-09-19 14:42:43|Enabled  |            |            |
sieb_serv052|MqSeriesSrvRcvr  |MQSeries Server Receiver                   |EAIRcvr    |EAI      |Background |Shutdown         |Manual      |0               |20          |                 |                |                   |2016-09-19 14:42:43|Enabled  |            |            |
sieb_serv052|MSMQRcvr         |MSMQ Receiver                              |EAIRcvr    |EAI      |Background |Shutdown         |Manual      |0               |20          |                 |                |                   |2016-09-19 14:42:43|Enabled  |            |            |
sieb_serv052|SMQReceiver      |SMQ Receiver                               |EAIRcvr    |EAI      |Background |Shutdown         |Manual      |0               |20          |                 |                |                   |2016-09-19 14:42:43|Enabled  |            |            |
sieb_serv052|ServerMgr        |Server Manager                             |ServerMgr  |System   |Interactive|Running          |Auto        |3               |20          |                 |                |2016-09-19 14:42:33|                   |Enabled  |            |            |
sieb_serv052|SRBroker         |Server Request Broker                      |ReqBroker  |System   |Interactive|Running          |Auto        |47              |100         |1                |1               |2016-09-19 14:42:33|                   |Enabled  |            |            |
sieb_serv052|SRProc           |Server Request Processor                   |SRProc     |SystemAux|Interactive|Running          |Auto        |2               |20          |1                |1               |2016-09-19 14:42:33|                   |Enabled  |            |            |
sieb_serv052|SvrTblCleanup    |Server Tables Cleanup                      |BusSvcMgr  |SystemAux|Background |Shutdown         |Manual      |0               |1           |                 |                |                   |2016-09-19 14:42:33|Enabled  |            |            |
sieb_serv052|SvrTaskPersist   |Server Task Persistance                    |BusSvcMgr  |SystemAux|Background |Running          |Auto        |1               |1           |                 |                |2016-09-19 14:42:33|                   |Enabled  |            |            |
sieb_serv052|AdminNotify      |Siebel Administrator Notification Component|AdminNotify|SystemAux|Batch      |Online           |Auto        |0               |10          |1                |1               |2016-09-19 14:42:33|                   |Enabled  |            |            |
sieb_serv052|SCBroker         |Siebel Connection Broker                   |SCBroker   |System   |Background |Running          |Auto        |2               |2           |                 |                |2016-09-19 14:42:33|                   |Enabled  |            |            |
sieb_serv052|LoyEngineBatch   |eLoyalty Processing Engine - Batch         |BusSvcMgr  |LoyaltyEngine|Batch      |Running          |Auto        |27              |60          |3                |3               |2016-09-20 13:07:36|                   |Enabled  |            |            |
sieb_serv052|LoyEngineInteractive|eLoyalty Processing Engine - Interactive   |BusSvcMgr  |LoyaltyEngine|Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:43|                   |Enabled  |            |            |
sieb_serv052|LoyEngineRealtime|eLoyalty Processing Engine - Realtime      |BusSvcMgr  |LoyaltyEngine|Batch      |Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:42:43|Enabled  |            |            |
sieb_serv052|LoyEngineRealtimeTier|eLoyalty Processing Engine - Realtime - Tier|BusSvcMgr  |LoyaltyEngine|Batch      |Online           |Auto        |0               |50          |1                |1               |2016-09-19 14:42:43|                   |Enabled  |            |            |
sieb_serv050|FSMSrvr          |File System Manager                        |FSMSrvr    |SystemAux|Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:34|                   |Enabled  |            |            |
sieb_serv050|SMSMLObjMgr_enu  |Marketing Object Manager (ENU)             |AppObjMgr  |MktgOM   |Interactive|Running          |Auto        |1               |20          |1                |1               |2016-09-19 14:42:40|                   |Enabled  |            |            |
sieb_serv050|SMObjMgr_enu     |Marketing Object Manager (ENU)             |AppObjMgr  |MktgOM   |Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:40|                   |Enabled  |            |            |
sieb_serv050|SMObjMgr_esn     |Marketing Object Manager (ESN)             |AppObjMgr  |MktgOM   |Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:40|                   |Enabled  |            |            |
sieb_serv050|SMSMLObjMgr_esn  |Marketing Object Manager (ESN)             |AppObjMgr  |MktgOM   |Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:40|                   |Enabled  |            |            |
sieb_serv050|SMObjMgr_ptb     |Marketing Object Manager (PTB)             |AppObjMgr  |MktgOM   |Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:40|                   |Enabled  |            |            |
sieb_serv050|SMSMLObjMgr_ptb  |Marketing Object Manager (PTB)             |AppObjMgr  |MktgOM   |Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:40|                   |Enabled  |            |            |
sieb_serv050|ServerMgr        |Server Manager                             |ServerMgr  |System   |Interactive|Running          |Auto        |3               |20          |                 |                |2016-09-19 14:42:29|                   |Enabled  |            |            |
sieb_serv050|SRBroker         |Server Request Broker                      |ReqBroker  |System   |Interactive|Running          |Auto        |35              |100         |1                |1               |2016-09-19 14:42:29|                   |Enabled  |            |            |
sieb_serv050|SRProc           |Server Request Processor                   |SRProc     |SystemAux|Interactive|Running          |Auto        |2               |20          |1                |1               |2016-09-19 14:42:34|                   |Enabled  |            |            |
sieb_serv050|SvrTblCleanup    |Server Tables Cleanup                      |BusSvcMgr  |SystemAux|Background |Shutdown         |Manual      |0               |1           |                 |                |                   |2016-09-19 14:42:34|Enabled  |            |            |
sieb_serv050|SvrTaskPersist   |Server Task Persistance                    |BusSvcMgr  |SystemAux|Background |Running          |Auto        |1               |1           |                 |                |2016-09-19 14:42:34|                   |Enabled  |            |            |
sieb_serv050|AdminNotify      |Siebel Administrator Notification Component|AdminNotify|SystemAux|Batch      |Online           |Auto        |0               |10          |1                |1               |2016-09-19 14:42:34|                   |Enabled  |            |            |
sieb_serv050|SCBroker         |Siebel Connection Broker                   |SCBroker   |System   |Background |Running          |Auto        |2               |2           |                 |                |2016-09-19 14:42:29|                   |Enabled  |            |            |
sieb_serv050|eEventsObjMgr_enu|eEvents Object Manager (ENU)               |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:42:40|Enabled  |            |            |
sieb_serv050|eEventsObjMgr_esn|eEvents Object Manager (ESN)               |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:42:40|Enabled  |            |            |
sieb_serv050|eEventsObjMgr_ptb|eEvents Object Manager (PTB)               |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:42:40|Enabled  |            |            |
sieb_serv050|eMarketObjMgr_enu|eMarketing Object Manager (ENU)            |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |1000        |0                |10              |                   |2016-09-19 14:42:40|Enabled  |            |            |
sieb_serv050|eMarketObjMgr_esn|eMarketing Object Manager (ESN)            |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |1000        |0                |10              |                   |2016-09-19 14:42:40|Enabled  |            |            |
sieb_serv050|eMarketObjMgr_ptb|eMarketing Object Manager (PTB)            |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |1000        |0                |10              |                   |2016-09-19 14:42:40|Enabled  |            |            |
sieb_serv057|AsgnSrvr         |Assignment Manager                         |AsgnSrvr   |AsgnMgmt |Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:37|                   |Enabled  |            |            |
sieb_serv057|AsgnBatch        |Batch Assignment                           |AsgnBatch  |AsgnMgmt |Batch      |Online           |Auto        |0               |20          |                 |                |2016-09-19 14:42:37|                   |Enabled  |            |            |
sieb_serv057|CommConfigMgr    |Communications Configuration Manager       |BusSvcMgr  |CommMgmt |Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:37|                   |Enabled  |            |            |
sieb_serv057|CommInboundProcessor|Communications Inbound Processor           |BusSvcMgr  |CommMgmt |Batch      |Online           |Auto        |0               |50          |1                |1               |2016-09-19 14:42:37|                   |Enabled  |            |            |
sieb_serv057|CommInboundRcvr  |Communications Inbound Receiver            |CommInboundRcvr|CommMgmt |Batch      |Online           |Auto        |0               |21          |1                |1               |2016-09-19 14:42:37|                   |Enabled  |            |            |
sieb_serv057|CommOutboundMgr  |Communications Outbound Manager            |BusSvcMgr  |CommMgmt |Batch      |Online           |Auto        |0               |150         |1                |3               |2016-09-19 14:42:37|                   |Enabled  |            |            |
sieb_serv057|CommSessionMgr   |Communications Session Manager             |CommSessionMgr|CommMgmt |Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:37|                   |Enabled  |            |            |
sieb_serv057|EAIObjMgr_enu    |EAI Object Manager (ENU)                   |EAIObjMgr  |EAI      |Interactive|Online           |Auto        |0               |240         |5                |6               |2016-09-19 14:42:37|                   |Enabled  |            |            |
sieb_serv057|EAIObjMgrXXXXX_enu|EAI Object Manager (ENU)                   |EAIObjMgr  |EAI      |Interactive|Online           |Auto        |0               |240         |5                |6               |2016-09-19 14:42:37|                   |Enabled  |            |            |
sieb_serv057|InfraEAIOutbound |EAI Outbound Server                        |BusSvcMgr  |EAI      |Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:37|                   |Enabled  |            |            |
sieb_serv057|MailMgr          |Email Manager                              |MailMgr    |CommMgmt |Background |Online           |Auto        |0               |20          |                 |                |2016-09-19 14:42:37|                   |Enabled  |            |            |
sieb_serv057|EIM              |Enterprise Integration Mgr                 |EIM        |EAI      |Batch      |Online           |Auto        |0               |5           |                 |                |2016-09-19 14:42:37|                   |Enabled  |            |            |
sieb_serv057|FSMSrvr          |File System Manager                        |FSMSrvr    |SystemAux|Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:32|                   |Enabled  |            |            |
sieb_serv057|JMSReceiver      |JMS Receiver                               |EAIJMSRcvr |EAI      |Batch      |Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:42:37|Enabled  |            |            |
sieb_serv057|MqSeriesAMIRcvr  |MQSeries AMI Receiver                      |EAIRcvr    |EAI      |Background |Shutdown         |Manual      |0               |20          |                 |                |                   |2016-09-19 14:42:37|Enabled  |            |            |
sieb_serv057|MqSeriesSrvRcvr  |MQSeries Server Receiver                   |EAIRcvr    |EAI      |Background |Shutdown         |Manual      |0               |20          |                 |                |                   |2016-09-19 14:42:37|Enabled  |            |            |
sieb_serv057|MSMQRcvr         |MSMQ Receiver                              |EAIRcvr    |EAI      |Background |Shutdown         |Manual      |0               |20          |                 |                |                   |2016-09-19 14:42:37|Enabled  |            |            |
sieb_serv057|PageMgr          |Page Manager                               |PageMgr    |CommMgmt |Background |Shutdown         |Manual      |0               |20          |                 |                |                   |2016-09-19 14:42:37|Enabled  |            |            |
sieb_serv057|SMQReceiver      |SMQ Receiver                               |EAIRcvr    |EAI      |Background |Shutdown         |Manual      |0               |20          |                 |                |                   |2016-09-19 14:42:37|Enabled  |            |            |
sieb_serv057|ServerMgr        |Server Manager                             |ServerMgr  |System   |Interactive|Running          |Auto        |4               |20          |                 |                |2016-09-19 14:42:27|                   |Enabled  |            |            |
sieb_serv057|SRBroker         |Server Request Broker                      |ReqBroker  |System   |Interactive|Running          |Auto        |49              |100         |1                |1               |2016-09-19 14:42:27|                   |Enabled  |            |            |
sieb_serv057|SRProc           |Server Request Processor                   |SRProc     |SystemAux|Interactive|Running          |Auto        |2               |20          |1                |1               |2016-09-19 14:42:32|                   |Enabled  |            |            |
sieb_serv057|SvrTblCleanup    |Server Tables Cleanup                      |BusSvcMgr  |SystemAux|Background |Shutdown         |Manual      |0               |1           |                 |                |                   |2016-09-19 14:42:32|Enabled  |            |            |
sieb_serv057|SvrTaskPersist   |Server Task Persistance                    |BusSvcMgr  |SystemAux|Background |Running          |Auto        |1               |1           |                 |                |2016-09-19 14:42:32|                   |Enabled  |            |            |
sieb_serv057|AdminNotify      |Siebel Administrator Notification Component|AdminNotify|SystemAux|Batch      |Online           |Auto        |0               |10          |1                |1               |2016-09-19 14:42:32|                   |Enabled  |            |            |
sieb_serv057|SCBroker         |Siebel Connection Broker                   |SCBroker   |System   |Background |Running          |Auto        |2               |2           |                 |                |2016-09-19 14:42:27|                   |Enabled  |            |            |
sieb_serv057|SmartAnswer      |Smart Answer Manager                       |BusSvcMgr  |CommMgmt |Batch      |Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:42:37|Enabled  |            |            |
sieb_serv057|LoyEngineBatch   |eLoyalty Processing Engine - Batch         |BusSvcMgr  |LoyaltyEngine|Batch      |Shutdown         |Manual      |0               |60          |0                |3               |                   |2016-09-19 14:42:37|Enabled  |            |            |
sieb_serv057|LoyEngineInteractive|eLoyalty Processing Engine - Interactive   |BusSvcMgr  |LoyaltyEngine|Batch      |Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:42:37|Enabled  |            |            |
sieb_serv057|LoyEngineRealtime|eLoyalty Processing Engine - Realtime      |BusSvcMgr  |LoyaltyEngine|Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:37|                   |Enabled  |            |            |
sieb_serv057|LoyEngineRealtimeTier|eLoyalty Processing Engine - Realtime - Tier|BusSvcMgr  |LoyaltyEngine|Batch      |Online           |Auto        |0               |50          |1                |1               |2016-09-19 14:42:37|                   |Enabled  |            |            |
sieb_serv049|EAIObjMgr_enu    |EAI Object Manager (ENU)                   |EAIObjMgr  |EAI      |Interactive|Online           |Auto        |0               |400         |10               |20              |2016-09-19 14:42:51|                   |Enabled  |            |            |
sieb_serv049|EAIObjMgrXXXXX_enu|EAI Object Manager (ENU)                   |EAIObjMgr  |EAI      |Interactive|Online           |Auto        |0               |400         |10               |20              |2016-09-19 14:42:51|                   |Enabled  |            |            |
sieb_serv049|InfraEAIOutbound |EAI Outbound Server                        |BusSvcMgr  |EAI      |Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:51|                   |Enabled  |            |            |
sieb_serv049|EIM              |Enterprise Integration Mgr                 |EIM        |EAI      |Batch      |Online           |Auto        |0               |5           |                 |                |2016-09-19 14:42:51|                   |Enabled  |            |            |
sieb_serv049|FSMSrvr          |File System Manager                        |FSMSrvr    |SystemAux|Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:41|                   |Enabled  |            |            |
sieb_serv049|JMSReceiver      |JMS Receiver                               |EAIJMSRcvr |EAI      |Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:51|                   |Enabled  |            |            |
sieb_serv049|loyaltyObjMgr_enu|Loyalty Object Manager (ENU)               |AppObjMgr  |Loyalty  |Interactive|Running          |Auto        |1               |50          |1                |1               |2016-09-19 14:42:51|                   |Enabled  |            |            |
sieb_serv049|loyaltySMLObjMgr_enu|Loyalty Object Manager (ENU)               |AppObjMgr  |Loyalty  |Interactive|Running          |Auto        |2               |50          |1                |1               |2016-09-19 14:42:51|                   |Enabled  |            |            |
sieb_serv049|loyaltySMLObjMgr_esn|Loyalty Object Manager (ESN)               |AppObjMgr  |Loyalty  |Interactive|Online           |Auto        |0               |50          |1                |1               |2016-09-19 14:42:51|                   |Enabled  |            |            |
sieb_serv049|loyaltyObjMgr_esn|Loyalty Object Manager (ESN)               |AppObjMgr  |Loyalty  |Interactive|Online           |Auto        |0               |50          |1                |1               |2016-09-19 14:42:51|                   |Enabled  |            |            |
sieb_serv049|loyaltyObjMgr_ptb|Loyalty Object Manager (PTB)               |AppObjMgr  |Loyalty  |Interactive|Online           |Auto        |0               |50          |1                |1               |2016-09-19 14:42:51|                   |Enabled  |            |            |
sieb_serv049|loyaltySMLObjMgr_ptb|Loyalty Object Manager (PTB)               |AppObjMgr  |Loyalty  |Interactive|Running          |Auto        |1               |50          |1                |1               |2016-09-19 14:42:51|                   |Enabled  |            |            |
sieb_serv049|loyalty2ObjMgr_enu|Loyalty Object Manager 2 (ENU)             |AppObjMgr  |Loyalty  |Interactive|Online           |Auto        |0               |50          |1                |1               |2016-09-19 14:42:51|                   |Enabled  |            |            |
sieb_serv049|loylalty2ObjMgr_enu|Loyalty Object Manager2 (ENU)              |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |1           |0                |1               |                   |2016-09-19 14:42:51|Enabled  |            |            |
sieb_serv049|loyaltyscwObjMgr_enu|Loyalty Partner Portal Object Manager (ENU)|AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |70          |0                |1               |                   |2016-09-19 14:42:51|Enabled  |            |            |
sieb_serv049|loyaltyscwObjMgr_esn|Loyalty Partner Portal Object Manager (ESN)|AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |70          |0                |1               |                   |2016-09-19 14:42:51|Enabled  |            |            |
sieb_serv049|loyaltyscwObjMgr_ptb|Loyalty Partner Portal Object Manager (PTB)|AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |70          |0                |1               |                   |2016-09-19 14:42:51|Enabled  |            |            |
sieb_serv049|eloyaltyObjMgr_enu|Loyalty eMember Object Manager (ENU)       |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:42:51|Enabled  |            |            |
sieb_serv049|eloyaltyObjMgr_esn|Loyalty eMember Object Manager (ESN)       |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:42:51|Enabled  |            |            |
sieb_serv049|eloyaltyObjMgr_ptb|Loyalty eMember Object Manager (PTB)       |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:42:51|Enabled  |            |            |
sieb_serv049|MqSeriesAMIRcvr  |MQSeries AMI Receiver                      |EAIRcvr    |EAI      |Background |Online           |Auto        |0               |20          |                 |                |2016-09-19 14:42:51|                   |Enabled  |            |            |
sieb_serv049|MqSeriesSrvRcvr  |MQSeries Server Receiver                   |EAIRcvr    |EAI      |Background |Online           |Auto        |0               |20          |                 |                |2016-09-19 14:42:51|                   |Enabled  |            |            |
sieb_serv049|MSMQRcvr         |MSMQ Receiver                              |EAIRcvr    |EAI      |Background |Online           |Auto        |0               |20          |                 |                |2016-09-19 14:42:51|                   |Enabled  |            |            |
sieb_serv049|SMQReceiver      |SMQ Receiver                               |EAIRcvr    |EAI      |Background |Online           |Auto        |0               |20          |                 |                |2016-09-19 14:42:51|                   |Enabled  |            |            |
sieb_serv049|ServerMgr        |Server Manager                             |ServerMgr  |System   |Interactive|Running          |Auto        |3               |20          |                 |                |2016-09-19 14:42:41|                   |Enabled  |            |            |
sieb_serv049|SRBroker         |Server Request Broker                      |ReqBroker  |System   |Interactive|Running          |Auto        |62              |100         |1                |1               |2016-09-19 14:42:41|                   |Enabled  |            |            |
sieb_serv049|SRProc           |Server Request Processor                   |SRProc     |SystemAux|Interactive|Running          |Auto        |2               |20          |1                |1               |2016-09-19 14:42:41|                   |Enabled  |            |            |
sieb_serv049|SvrTblCleanup    |Server Tables Cleanup                      |BusSvcMgr  |SystemAux|Background |Running          |Auto        |1               |1           |                 |                |2016-09-19 14:42:41|                   |Enabled  |            |            |
sieb_serv049|SvrTaskPersist   |Server Task Persistance                    |BusSvcMgr  |SystemAux|Background |Running          |Auto        |1               |1           |                 |                |2016-09-19 14:42:41|                   |Enabled  |            |            |
sieb_serv049|AdminNotify      |Siebel Administrator Notification Component|AdminNotify|SystemAux|Batch      |Online           |Auto        |0               |10          |1                |1               |2016-09-19 14:42:41|                   |Enabled  |            |            |
sieb_serv049|SCBroker         |Siebel Connection Broker                   |SCBroker   |System   |Background |Running          |Auto        |2               |2           |                 |                |2016-09-19 14:42:41|                   |Enabled  |            |            |
sieb_serv049|LoyEngineBatch   |eLoyalty Processing Engine - Batch         |BusSvcMgr  |LoyaltyEngine|Batch      |Shutdown         |Manual      |0               |60          |0                |3               |                   |2016-09-19 14:42:51|Enabled  |            |            |
sieb_serv049|LoyEngineInteractive|eLoyalty Processing Engine - Interactive   |BusSvcMgr  |LoyaltyEngine|Batch      |Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:42:51|Enabled  |            |            |
sieb_serv049|LoyEngineRealtime|eLoyalty Processing Engine - Realtime      |BusSvcMgr  |LoyaltyEngine|Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:51|                   |Enabled  |            |            |
sieb_serv049|LoyEngineRealtimeTier|eLoyalty Processing Engine - Realtime - Tier|BusSvcMgr  |LoyaltyEngine|Batch      |Online           |Auto        |0               |50          |1                |1               |2016-09-19 14:42:51|                   |Enabled  |            |            |
sieb_serv047|FSMSrvr          |File System Manager                        |FSMSrvr    |SystemAux|Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:52|                   |Enabled  |            |            |
sieb_serv047|loyaltySMLObjMgr_enu|Loyalty Object Manager (ENU)               |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv047|loyaltyObjMgr_enu|Loyalty Object Manager (ENU)               |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv047|loyaltySMLObjMgr_esn|Loyalty Object Manager (ESN)               |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv047|loyaltyObjMgr_esn|Loyalty Object Manager (ESN)               |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv047|loyaltyObjMgr_ptb|Loyalty Object Manager (PTB)               |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv047|loyaltySMLObjMgr_ptb|Loyalty Object Manager (PTB)               |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv047|loyalty2ObjMgr_enu|Loyalty Object Manager 2 (ENU)             |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv047|loylalty2ObjMgr_enu|Loyalty Object Manager2 (ENU)              |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |1           |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv047|loyaltyscwObjMgr_enu|Loyalty Partner Portal Object Manager (ENU)|AppObjMgr  |Loyalty  |Interactive|Online           |Auto        |0               |70          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv047|loyaltyscwObjMgr_esn|Loyalty Partner Portal Object Manager (ESN)|AppObjMgr  |Loyalty  |Interactive|Online           |Auto        |0               |70          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv047|loyaltyscwObjMgr_ptb|Loyalty Partner Portal Object Manager (PTB)|AppObjMgr  |Loyalty  |Interactive|Online           |Auto        |0               |70          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv047|eloyaltyObjMgr_enu|Loyalty eMember Object Manager (ENU)       |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv047|eloyaltyObjMgr_esn|Loyalty eMember Object Manager (ESN)       |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv047|eloyaltyObjMgr_ptb|Loyalty eMember Object Manager (PTB)       |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv047|SMSMLObjMgr_enu  |Marketing Object Manager (ENU)             |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv047|SMObjMgr_enu     |Marketing Object Manager (ENU)             |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv047|SMSMLObjMgr_esn  |Marketing Object Manager (ESN)             |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv047|SMObjMgr_esn     |Marketing Object Manager (ESN)             |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv047|SMSMLObjMgr_ptb  |Marketing Object Manager (PTB)             |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv047|SMObjMgr_ptb     |Marketing Object Manager (PTB)             |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv047|ServerMgr        |Server Manager                             |ServerMgr  |System   |Interactive|Running          |Auto        |3               |20          |                 |                |2016-09-19 14:42:52|                   |Enabled  |            |            |
sieb_serv047|SRBroker         |Server Request Broker                      |ReqBroker  |System   |Interactive|Running          |Auto        |58              |100         |1                |1               |2016-09-19 14:42:52|                   |Enabled  |            |            |
sieb_serv047|SRProc           |Server Request Processor                   |SRProc     |SystemAux|Interactive|Running          |Auto        |2               |20          |1                |1               |2016-09-19 14:42:52|                   |Enabled  |            |            |
sieb_serv047|SvrTblCleanup    |Server Tables Cleanup                      |BusSvcMgr  |SystemAux|Background |Shutdown         |Manual      |0               |1           |                 |                |                   |2016-09-19 14:42:52|Enabled  |            |            |
sieb_serv047|SvrTaskPersist   |Server Task Persistance                    |BusSvcMgr  |SystemAux|Background |Running          |Auto        |1               |1           |                 |                |2016-09-19 14:42:52|                   |Enabled  |            |            |
sieb_serv047|AdminNotify      |Siebel Administrator Notification Component|AdminNotify|SystemAux|Batch      |Online           |Auto        |0               |10          |1                |1               |2016-09-19 14:42:52|                   |Enabled  |            |            |
sieb_serv047|SCBroker         |Siebel Connection Broker                   |SCBroker   |System   |Background |Running          |Auto        |2               |2           |                 |                |2016-09-19 14:42:52|                   |Enabled  |            |            |
sieb_serv047|eEventsObjMgr_enu|eEvents Object Manager (ENU)               |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv047|eEventsObjMgr_esn|eEvents Object Manager (ESN)               |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv047|eEventsObjMgr_ptb|eEvents Object Manager (PTB)               |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv047|eMarketObjMgr_enu|eMarketing Object Manager (ENU)            |AppObjMgr  |MktgOM   |Interactive|Online           |Auto        |0               |1000        |9                |10              |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv047|eMarketObjMgr_esn|eMarketing Object Manager (ESN)            |AppObjMgr  |MktgOM   |Interactive|Online           |Auto        |0               |1000        |9                |10              |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv047|eMarketObjMgr_ptb|eMarketing Object Manager (PTB)            |AppObjMgr  |MktgOM   |Interactive|Online           |Auto        |0               |1000        |9                |10              |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv046|FSMSrvr          |File System Manager                        |FSMSrvr    |SystemAux|Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:52|                   |Enabled  |            |            |
sieb_serv046|loyaltySMLObjMgr_enu|Loyalty Object Manager (ENU)               |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv046|loyaltyObjMgr_enu|Loyalty Object Manager (ENU)               |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv046|loyaltySMLObjMgr_esn|Loyalty Object Manager (ESN)               |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv046|loyaltyObjMgr_esn|Loyalty Object Manager (ESN)               |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv046|loyaltyObjMgr_ptb|Loyalty Object Manager (PTB)               |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv046|loyaltySMLObjMgr_ptb|Loyalty Object Manager (PTB)               |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv046|loyalty2ObjMgr_enu|Loyalty Object Manager 2 (ENU)             |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv046|loylalty2ObjMgr_enu|Loyalty Object Manager2 (ENU)              |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |1           |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv046|loyaltyscwObjMgr_enu|Loyalty Partner Portal Object Manager (ENU)|AppObjMgr  |Loyalty  |Interactive|Online           |Auto        |0               |70          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv046|loyaltyscwObjMgr_esn|Loyalty Partner Portal Object Manager (ESN)|AppObjMgr  |Loyalty  |Interactive|Online           |Auto        |0               |70          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv046|loyaltyscwObjMgr_ptb|Loyalty Partner Portal Object Manager (PTB)|AppObjMgr  |Loyalty  |Interactive|Online           |Auto        |0               |70          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv046|eloyaltyObjMgr_enu|Loyalty eMember Object Manager (ENU)       |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv046|eloyaltyObjMgr_esn|Loyalty eMember Object Manager (ESN)       |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv046|eloyaltyObjMgr_ptb|Loyalty eMember Object Manager (PTB)       |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv046|SMSMLObjMgr_enu  |Marketing Object Manager (ENU)             |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv046|SMObjMgr_enu     |Marketing Object Manager (ENU)             |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv046|SMSMLObjMgr_esn  |Marketing Object Manager (ESN)             |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv046|SMObjMgr_esn     |Marketing Object Manager (ESN)             |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv046|SMSMLObjMgr_ptb  |Marketing Object Manager (PTB)             |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv046|SMObjMgr_ptb     |Marketing Object Manager (PTB)             |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv046|ServerMgr        |Server Manager                             |ServerMgr  |System   |Interactive|Running          |Auto        |2               |20          |                 |                |2016-09-19 14:42:52|                   |Enabled  |            |            |
sieb_serv046|SRBroker         |Server Request Broker                      |ReqBroker  |System   |Interactive|Running          |Auto        |58              |100         |1                |1               |2016-09-19 14:42:52|                   |Enabled  |            |            |
sieb_serv046|SRProc           |Server Request Processor                   |SRProc     |SystemAux|Interactive|Running          |Auto        |2               |20          |1                |1               |2016-09-19 14:42:52|                   |Enabled  |            |            |
sieb_serv046|SvrTblCleanup    |Server Tables Cleanup                      |BusSvcMgr  |SystemAux|Background |Shutdown         |Manual      |0               |1           |                 |                |                   |2016-09-19 14:42:52|Enabled  |            |            |
sieb_serv046|SvrTaskPersist   |Server Task Persistance                    |BusSvcMgr  |SystemAux|Background |Running          |Auto        |1               |1           |                 |                |2016-09-19 14:42:52|                   |Enabled  |            |            |
sieb_serv046|AdminNotify      |Siebel Administrator Notification Component|AdminNotify|SystemAux|Batch      |Online           |Auto        |0               |10          |1                |1               |2016-09-19 14:42:52|                   |Enabled  |            |            |
sieb_serv046|SCBroker         |Siebel Connection Broker                   |SCBroker   |System   |Background |Running          |Auto        |2               |2           |                 |                |2016-09-19 14:42:52|                   |Enabled  |            |            |
sieb_serv046|eEventsObjMgr_enu|eEvents Object Manager (ENU)               |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv046|eEventsObjMgr_esn|eEvents Object Manager (ESN)               |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv046|eEventsObjMgr_ptb|eEvents Object Manager (PTB)               |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv046|eMarketObjMgr_enu|eMarketing Object Manager (ENU)            |AppObjMgr  |MktgOM   |Interactive|Online           |Auto        |0               |1000        |9                |10              |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv046|eMarketObjMgr_esn|eMarketing Object Manager (ESN)            |AppObjMgr  |MktgOM   |Interactive|Online           |Auto        |0               |1000        |9                |10              |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv046|eMarketObjMgr_ptb|eMarketing Object Manager (PTB)            |AppObjMgr  |MktgOM   |Interactive|Online           |Auto        |0               |1000        |9                |10              |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv053|SCCObjMgr_enu    |Call Center Object Manager (ENU)           |AppObjMgr  |CallCenter|Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv053|SCCObjMgr_esn    |Call Center Object Manager (ESN)           |AppObjMgr  |CallCenter|Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv053|SCCObjMgr_ptb    |Call Center Object Manager (PTB)           |AppObjMgr  |CallCenter|Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv053|EAIObjMgr_enu    |EAI Object Manager (ENU)                   |EAIObjMgr  |EAI      |Interactive|Online           |Auto        |0               |400         |10               |20              |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv053|EAIObjMgrXXXXX_enu|EAI Object Manager (ENU)                   |EAIObjMgr  |EAI      |Interactive|Online           |Auto        |0               |400         |10               |20              |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv053|InfraEAIOutbound |EAI Outbound Server                        |BusSvcMgr  |EAI      |Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv053|EIM              |Enterprise Integration Mgr                 |EIM        |EAI      |Batch      |Online           |Auto        |0               |5           |                 |                |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv053|FSMSrvr          |File System Manager                        |FSMSrvr    |SystemAux|Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:52|                   |Enabled  |            |            |
sieb_serv053|JMSReceiver      |JMS Receiver                               |EAIJMSRcvr |EAI      |Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv053|loyaltySMLObjMgr_enu|Loyalty Object Manager (ENU)               |AppObjMgr  |Loyalty  |Interactive|Running          |Auto        |6               |50          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv053|loyaltyObjMgr_enu|Loyalty Object Manager (ENU)               |AppObjMgr  |Loyalty  |Interactive|Running          |Auto        |2               |50          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv053|loyaltyObjMgr_esn|Loyalty Object Manager (ESN)               |AppObjMgr  |Loyalty  |Interactive|Online           |Auto        |0               |50          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv053|loyaltySMLObjMgr_esn|Loyalty Object Manager (ESN)               |AppObjMgr  |Loyalty  |Interactive|Online           |Auto        |0               |50          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv053|loyaltyObjMgr_ptb|Loyalty Object Manager (PTB)               |AppObjMgr  |Loyalty  |Interactive|Running          |Auto        |1               |50          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv053|loyaltySMLObjMgr_ptb|Loyalty Object Manager (PTB)               |AppObjMgr  |Loyalty  |Interactive|Running          |Auto        |1               |50          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv053|loyalty2ObjMgr_enu|Loyalty Object Manager 2 (ENU)             |AppObjMgr  |Loyalty  |Interactive|Online           |Auto        |0               |50          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv053|loylalty2ObjMgr_enu|Loyalty Object Manager2 (ENU)              |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |1           |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv053|loyaltyscwObjMgr_enu|Loyalty Partner Portal Object Manager (ENU)|AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |70          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv053|loyaltyscwObjMgr_esn|Loyalty Partner Portal Object Manager (ESN)|AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |70          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv053|loyaltyscwObjMgr_ptb|Loyalty Partner Portal Object Manager (PTB)|AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |70          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv053|eloyaltyObjMgr_enu|Loyalty eMember Object Manager (ENU)       |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv053|eloyaltyObjMgr_esn|Loyalty eMember Object Manager (ESN)       |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv053|eloyaltyObjMgr_ptb|Loyalty eMember Object Manager (PTB)       |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv053|MqSeriesAMIRcvr  |MQSeries AMI Receiver                      |EAIRcvr    |EAI      |Background |Online           |Auto        |0               |20          |                 |                |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv053|MqSeriesSrvRcvr  |MQSeries Server Receiver                   |EAIRcvr    |EAI      |Background |Online           |Auto        |0               |20          |                 |                |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv053|MSMQRcvr         |MSMQ Receiver                              |EAIRcvr    |EAI      |Background |Online           |Auto        |0               |20          |                 |                |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv053|SMQReceiver      |SMQ Receiver                               |EAIRcvr    |EAI      |Background |Online           |Auto        |0               |20          |                 |                |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv053|SServiceObjMgr_enu|Self Service Object Manager (ENU)          |AppObjMgr  |CallCenter|Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv053|SServiceObjMgr_esn|Self Service Object Manager (ESN)          |AppObjMgr  |CallCenter|Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv053|SServiceObjMgr_ptb|Self Service Object Manager (PTB)          |AppObjMgr  |CallCenter|Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv053|ServerMgr        |Server Manager                             |ServerMgr  |System   |Interactive|Running          |Auto        |2               |20          |                 |                |2016-09-19 14:42:52|                   |Enabled  |            |            |
sieb_serv053|SRBroker         |Server Request Broker                      |ReqBroker  |System   |Interactive|Running          |Auto        |67              |100         |1                |1               |2016-09-19 14:42:52|                   |Enabled  |            |            |
sieb_serv053|SRProc           |Server Request Processor                   |SRProc     |SystemAux|Interactive|Running          |Auto        |2               |20          |1                |1               |2016-09-19 14:42:52|                   |Enabled  |            |            |
sieb_serv053|SvrTblCleanup    |Server Tables Cleanup                      |BusSvcMgr  |SystemAux|Background |Shutdown         |Manual      |0               |1           |                 |                |                   |2016-09-19 14:42:52|Enabled  |            |            |
sieb_serv053|SvrTaskPersist   |Server Task Persistance                    |BusSvcMgr  |SystemAux|Background |Running          |Auto        |1               |1           |                 |                |2016-09-19 14:42:52|                   |Enabled  |            |            |
sieb_serv053|AdminNotify      |Siebel Administrator Notification Component|AdminNotify|SystemAux|Batch      |Online           |Auto        |0               |10          |1                |1               |2016-09-19 14:42:52|                   |Enabled  |            |            |
sieb_serv053|SCBroker         |Siebel Connection Broker                   |SCBroker   |System   |Background |Running          |Auto        |2               |2           |                 |                |2016-09-19 14:42:52|                   |Enabled  |            |            |
sieb_serv053|eServiceObjMgr_enu|eService Object Manager (ENU)              |AppObjMgr  |CallCenter|Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv053|eServiceObjMgr_esn|eService Object Manager (ESN)              |AppObjMgr  |CallCenter|Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv053|eServiceObjMgr_ptb|eService Object Manager (PTB)              |AppObjMgr  |CallCenter|Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv048|SCCObjMgr_enu    |Call Center Object Manager (ENU)           |AppObjMgr  |CallCenter|Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:43:06|                   |Enabled  |            |            |
sieb_serv048|SCCObjMgr_esn    |Call Center Object Manager (ESN)           |AppObjMgr  |CallCenter|Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:43:06|                   |Enabled  |            |            |
sieb_serv048|SCCObjMgr_ptb    |Call Center Object Manager (PTB)           |AppObjMgr  |CallCenter|Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:43:06|                   |Enabled  |            |            |
sieb_serv048|EAIObjMgr_enu    |EAI Object Manager (ENU)                   |EAIObjMgr  |EAI      |Interactive|Online           |Auto        |0               |400         |10               |20              |2016-09-19 14:43:06|                   |Enabled  |            |            |
sieb_serv048|EAIObjMgrXXXXX_enu|EAI Object Manager (ENU)                   |EAIObjMgr  |EAI      |Interactive|Online           |Auto        |0               |400         |10               |20              |2016-09-19 14:43:06|                   |Enabled  |            |            |
sieb_serv048|InfraEAIOutbound |EAI Outbound Server                        |BusSvcMgr  |EAI      |Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:43:06|                   |Enabled  |            |            |
sieb_serv048|EIM              |Enterprise Integration Mgr                 |EIM        |EAI      |Batch      |Online           |Auto        |0               |5           |                 |                |2016-09-19 14:43:06|                   |Enabled  |            |            |
sieb_serv048|FSMSrvr          |File System Manager                        |FSMSrvr    |SystemAux|Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:51|                   |Enabled  |            |            |
sieb_serv048|JMSReceiver      |JMS Receiver                               |EAIJMSRcvr |EAI      |Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:43:06|                   |Enabled  |            |            |
sieb_serv048|loyaltySMLObjMgr_enu|Loyalty Object Manager (ENU)               |AppObjMgr  |Loyalty  |Interactive|Running          |Auto        |6               |50          |1                |1               |2016-09-19 14:43:06|                   |Enabled  |            |            |
sieb_serv048|loyaltyObjMgr_enu|Loyalty Object Manager (ENU)               |AppObjMgr  |Loyalty  |Interactive|Online           |Auto        |0               |50          |1                |1               |2016-09-19 14:43:06|                   |Enabled  |            |            |
sieb_serv048|loyaltyObjMgr_esn|Loyalty Object Manager (ESN)               |AppObjMgr  |Loyalty  |Interactive|Online           |Auto        |0               |50          |1                |1               |2016-09-19 14:43:06|                   |Enabled  |            |            |
sieb_serv048|loyaltySMLObjMgr_esn|Loyalty Object Manager (ESN)               |AppObjMgr  |Loyalty  |Interactive|Online           |Auto        |0               |50          |1                |1               |2016-09-19 14:43:06|                   |Enabled  |            |            |
sieb_serv048|loyaltyObjMgr_ptb|Loyalty Object Manager (PTB)               |AppObjMgr  |Loyalty  |Interactive|Online           |Auto        |0               |50          |1                |1               |2016-09-19 14:43:06|                   |Enabled  |            |            |
sieb_serv048|loyaltySMLObjMgr_ptb|Loyalty Object Manager (PTB)               |AppObjMgr  |Loyalty  |Interactive|Running          |Auto        |2               |50          |1                |1               |2016-09-19 14:43:06|                   |Enabled  |            |            |
sieb_serv048|loyalty2ObjMgr_enu|Loyalty Object Manager 2 (ENU)             |AppObjMgr  |Loyalty  |Interactive|Online           |Auto        |0               |50          |1                |1               |2016-09-19 14:43:06|                   |Enabled  |            |            |
sieb_serv048|loylalty2ObjMgr_enu|Loyalty Object Manager2 (ENU)              |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |1           |0                |1               |                   |2016-09-19 14:43:06|Enabled  |            |            |
sieb_serv048|loyaltyscwObjMgr_enu|Loyalty Partner Portal Object Manager (ENU)|AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |70          |0                |1               |                   |2016-09-19 14:43:06|Enabled  |            |            |
sieb_serv048|loyaltyscwObjMgr_esn|Loyalty Partner Portal Object Manager (ESN)|AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |70          |0                |1               |                   |2016-09-19 14:43:06|Enabled  |            |            |
sieb_serv048|loyaltyscwObjMgr_ptb|Loyalty Partner Portal Object Manager (PTB)|AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |70          |0                |1               |                   |2016-09-19 14:43:06|Enabled  |            |            |
sieb_serv048|eloyaltyObjMgr_enu|Loyalty eMember Object Manager (ENU)       |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:06|Enabled  |            |            |
sieb_serv048|eloyaltyObjMgr_esn|Loyalty eMember Object Manager (ESN)       |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:06|Enabled  |            |            |
sieb_serv048|eloyaltyObjMgr_ptb|Loyalty eMember Object Manager (PTB)       |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:06|Enabled  |            |            |
sieb_serv048|MqSeriesAMIRcvr  |MQSeries AMI Receiver                      |EAIRcvr    |EAI      |Background |Online           |Auto        |0               |20          |                 |                |2016-09-19 14:43:06|                   |Enabled  |            |            |
sieb_serv048|MqSeriesSrvRcvr  |MQSeries Server Receiver                   |EAIRcvr    |EAI      |Background |Online           |Auto        |0               |20          |                 |                |2016-09-19 14:43:06|                   |Enabled  |            |            |
sieb_serv048|MSMQRcvr         |MSMQ Receiver                              |EAIRcvr    |EAI      |Background |Online           |Auto        |0               |20          |                 |                |2016-09-19 14:43:06|                   |Enabled  |            |            |
sieb_serv048|SMQReceiver      |SMQ Receiver                               |EAIRcvr    |EAI      |Background |Online           |Auto        |0               |20          |                 |                |2016-09-19 14:43:06|                   |Enabled  |            |            |
sieb_serv048|SServiceObjMgr_enu|Self Service Object Manager (ENU)          |AppObjMgr  |CallCenter|Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:43:06|                   |Enabled  |            |            |
sieb_serv048|SServiceObjMgr_esn|Self Service Object Manager (ESN)          |AppObjMgr  |CallCenter|Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:43:06|                   |Enabled  |            |            |
sieb_serv048|SServiceObjMgr_ptb|Self Service Object Manager (PTB)          |AppObjMgr  |CallCenter|Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:43:06|                   |Enabled  |            |            |
sieb_serv048|ServerMgr        |Server Manager                             |ServerMgr  |System   |Interactive|Running          |Auto        |3               |20          |                 |                |2016-09-19 14:42:51|                   |Enabled  |            |            |
sieb_serv048|SRBroker         |Server Request Broker                      |ReqBroker  |System   |Interactive|Running          |Auto        |67              |100         |1                |1               |2016-09-19 14:42:51|                   |Enabled  |            |            |
sieb_serv048|SRProc           |Server Request Processor                   |SRProc     |SystemAux|Interactive|Running          |Auto        |2               |20          |1                |1               |2016-09-19 14:42:51|                   |Enabled  |            |            |
sieb_serv048|SvrTblCleanup    |Server Tables Cleanup                      |BusSvcMgr  |SystemAux|Background |Shutdown         |Manual      |0               |1           |                 |                |                   |2016-09-19 14:42:51|Enabled  |            |            |
sieb_serv048|SvrTaskPersist   |Server Task Persistance                    |BusSvcMgr  |SystemAux|Background |Running          |Auto        |1               |1           |                 |                |2016-09-19 14:42:51|                   |Enabled  |            |            |
sieb_serv048|AdminNotify      |Siebel Administrator Notification Component|AdminNotify|SystemAux|Batch      |Online           |Auto        |0               |10          |1                |1               |2016-09-19 14:42:51|                   |Enabled  |            |            |
sieb_serv048|SCBroker         |Siebel Connection Broker                   |SCBroker   |System   |Background |Running          |Auto        |2               |2           |                 |                |2016-09-19 14:42:51|                   |Enabled  |            |            |
sieb_serv048|eServiceObjMgr_enu|eService Object Manager (ENU)              |AppObjMgr  |CallCenter|Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:43:06|                   |Enabled  |            |            |
sieb_serv048|eServiceObjMgr_esn|eService Object Manager (ESN)              |AppObjMgr  |CallCenter|Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:43:06|                   |Enabled  |            |            |
sieb_serv048|eServiceObjMgr_ptb|eService Object Manager (PTB)              |AppObjMgr  |CallCenter|Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:43:06|                   |Enabled  |            |            |
sieb_serv051|FSMSrvr          |File System Manager                        |FSMSrvr    |SystemAux|Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:43:02|                   |Enabled  |            |            |
sieb_serv051|ListImportSvcMgr |List Import Service Manager                |BusSvcMgr  |MktgSrv  |Batch      |Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv051|loyaltySMLObjMgr_enu|Loyalty Object Manager (ENU)               |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv051|loyaltyObjMgr_enu|Loyalty Object Manager (ENU)               |AppObjMgr  |Loyalty  |Interactive|Online           |Auto        |0               |50          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv051|loyaltySMLObjMgr_esn|Loyalty Object Manager (ESN)               |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv051|loyaltyObjMgr_esn|Loyalty Object Manager (ESN)               |AppObjMgr  |Loyalty  |Interactive|Online           |Auto        |0               |50          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv051|loyaltyObjMgr_ptb|Loyalty Object Manager (PTB)               |AppObjMgr  |Loyalty  |Interactive|Online           |Auto        |0               |50          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv051|loyaltySMLObjMgr_ptb|Loyalty Object Manager (PTB)               |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv051|loyalty2ObjMgr_enu|Loyalty Object Manager 2 (ENU)             |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv051|loylalty2ObjMgr_enu|Loyalty Object Manager2 (ENU)              |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |1           |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv051|loyaltyscwObjMgr_enu|Loyalty Partner Portal Object Manager (ENU)|AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |70          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv051|loyaltyscwObjMgr_esn|Loyalty Partner Portal Object Manager (ESN)|AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |70          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv051|loyaltyscwObjMgr_ptb|Loyalty Partner Portal Object Manager (PTB)|AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |70          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv051|eloyaltyObjMgr_enu|Loyalty eMember Object Manager (ENU)       |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv051|eloyaltyObjMgr_esn|Loyalty eMember Object Manager (ESN)       |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv051|eloyaltyObjMgr_ptb|Loyalty eMember Object Manager (PTB)       |AppObjMgr  |Loyalty  |Interactive|Shutdown         |Manual      |0               |50          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv051|SMSMLObjMgr_enu  |Marketing Object Manager (ENU)             |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv051|SMObjMgr_enu     |Marketing Object Manager (ENU)             |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv051|SMObjMgr_esn     |Marketing Object Manager (ESN)             |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv051|SMSMLObjMgr_esn  |Marketing Object Manager (ESN)             |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv051|SMSMLObjMgr_ptb  |Marketing Object Manager (PTB)             |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv051|SMObjMgr_ptb     |Marketing Object Manager (PTB)             |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv051|ServerMgr        |Server Manager                             |ServerMgr  |System   |Interactive|Running          |Auto        |2               |20          |                 |                |2016-09-19 14:42:57|                   |Enabled  |            |            |
sieb_serv051|SRBroker         |Server Request Broker                      |ReqBroker  |System   |Interactive|Running          |Auto        |34              |100         |1                |1               |2016-09-19 14:42:57|                   |Enabled  |            |            |
sieb_serv051|SRProc           |Server Request Processor                   |SRProc     |SystemAux|Interactive|Running          |Auto        |2               |20          |1                |1               |2016-09-19 14:43:02|                   |Enabled  |            |            |
sieb_serv051|SvrTblCleanup    |Server Tables Cleanup                      |BusSvcMgr  |SystemAux|Background |Shutdown         |Manual      |0               |1           |                 |                |                   |2016-09-19 14:43:02|Enabled  |            |            |
sieb_serv051|SvrTaskPersist   |Server Task Persistance                    |BusSvcMgr  |SystemAux|Background |Running          |Auto        |1               |1           |                 |                |2016-09-19 14:43:02|                   |Enabled  |            |            |
sieb_serv051|AdminNotify      |Siebel Administrator Notification Component|AdminNotify|SystemAux|Batch      |Online           |Auto        |0               |10          |1                |1               |2016-09-19 14:43:02|                   |Enabled  |            |            |
sieb_serv051|SCBroker         |Siebel Connection Broker                   |SCBroker   |System   |Background |Running          |Auto        |2               |2           |                 |                |2016-09-19 14:42:57|                   |Enabled  |            |            |
sieb_serv051|eEventsObjMgr_enu|eEvents Object Manager (ENU)               |AppObjMgr  |MktgOM   |Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv051|eEventsObjMgr_esn|eEvents Object Manager (ESN)               |AppObjMgr  |MktgOM   |Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv051|eEventsObjMgr_ptb|eEvents Object Manager (PTB)               |AppObjMgr  |MktgOM   |Interactive|Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:43:12|                   |Enabled  |            |            |
sieb_serv051|eMarketObjMgr_enu|eMarketing Object Manager (ENU)            |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |1000        |0                |10              |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv051|eMarketObjMgr_esn|eMarketing Object Manager (ESN)            |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |1000        |0                |10              |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv051|eMarketObjMgr_ptb|eMarketing Object Manager (PTB)            |AppObjMgr  |MktgOM   |Interactive|Shutdown         |Manual      |0               |1000        |0                |10              |                   |2016-09-19 14:43:12|Enabled  |            |            |
sieb_serv058|AsgnSrvr         |Assignment Manager                         |AsgnSrvr   |AsgnMgmt |Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:49|                   |Enabled  |            |            |
sieb_serv058|AsgnBatch        |Batch Assignment                           |AsgnBatch  |AsgnMgmt |Batch      |Online           |Auto        |0               |20          |                 |                |2016-09-19 14:42:49|                   |Enabled  |            |            |
sieb_serv058|EAIObjMgr_enu    |EAI Object Manager (ENU)                   |EAIObjMgr  |EAI      |Interactive|Online           |Auto        |0               |240         |5                |6               |2016-09-19 14:42:49|                   |Enabled  |            |            |
sieb_serv058|EAIObjMgrXXXXX_enu|EAI Object Manager (ENU)                   |EAIObjMgr  |EAI      |Interactive|Online           |Auto        |0               |240         |5                |6               |2016-09-19 14:42:49|                   |Enabled  |            |            |
sieb_serv058|InfraEAIOutbound |EAI Outbound Server                        |BusSvcMgr  |EAI      |Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:49|                   |Enabled  |            |            |
sieb_serv058|EIM              |Enterprise Integration Mgr                 |EIM        |EAI      |Batch      |Online           |Auto        |0               |5           |                 |                |2016-09-19 14:42:49|                   |Enabled  |            |            |
sieb_serv058|FSMSrvr          |File System Manager                        |FSMSrvr    |SystemAux|Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:44|                   |Enabled  |            |            |
sieb_serv058|YOLRedemptionSongBobMarly|YOL Redemption Without Minus               |WorkMon    |Workflow |Background |Running          |Auto        |1               |1           |                 |                |2016-09-19 14:42:49|                   |Enabled  |            |            |
sieb_serv058|WorkMonEpidemicShroud|YOL WorkMon Send Epidemic Emails           |WorkMon    |Workflow |Background |Running          |Auto        |1               |1           |                 |                |2016-09-19 14:42:49|                   |Enabled  |            |            |
sieb_serv058|WorkMonNeinFuckserhla|YOL WorkMon Tier Send Emails               |WorkMon    |Workflow |Background |Running          |Auto        |1               |1           |                 |                |2016-09-19 14:42:49|                   |Enabled  |            |            |
sieb_serv058|GenTrig          |Generate Triggers                          |GenTrig    |Workflow |Batch      |Online           |Auto        |0               |1           |                 |                |2016-09-19 14:42:49|                   |Enabled  |            |            |
sieb_serv058|JMSReceiver      |JMS Receiver                               |EAIJMSRcvr |EAI      |Batch      |Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:42:49|Enabled  |            |            |
sieb_serv058|MqSeriesAMIRcvr  |MQSeries AMI Receiver                      |EAIRcvr    |EAI      |Background |Shutdown         |Manual      |0               |20          |                 |                |                   |2016-09-19 14:42:49|Enabled  |            |            |
sieb_serv058|MqSeriesSrvRcvr  |MQSeries Server Receiver                   |EAIRcvr    |EAI      |Background |Shutdown         |Manual      |0               |20          |                 |                |                   |2016-09-19 14:42:49|Enabled  |            |            |
sieb_serv058|MSMQRcvr         |MSMQ Receiver                              |EAIRcvr    |EAI      |Background |Shutdown         |Manual      |0               |20          |                 |                |                   |2016-09-19 14:42:49|Enabled  |            |            |
sieb_serv058|SMQReceiver      |SMQ Receiver                               |EAIRcvr    |EAI      |Background |Shutdown         |Manual      |0               |20          |                 |                |                   |2016-09-19 14:42:49|Enabled  |            |            |
sieb_serv058|ServerMgr        |Server Manager                             |ServerMgr  |System   |Interactive|Running          |Auto        |5               |20          |                 |                |2016-09-19 14:42:39|                   |Enabled  |            |            |
sieb_serv058|SRBroker         |Server Request Broker                      |ReqBroker  |System   |Interactive|Running          |Auto        |55              |100         |1                |1               |2016-09-19 14:42:39|                   |Enabled  |            |            |
sieb_serv058|SRProc           |Server Request Processor                   |SRProc     |SystemAux|Interactive|Running          |Auto        |2               |20          |1                |1               |2016-09-19 14:42:44|                   |Enabled  |            |            |
sieb_serv058|SvrTblCleanup    |Server Tables Cleanup                      |BusSvcMgr  |SystemAux|Background |Shutdown         |Manual      |0               |1           |                 |                |                   |2016-09-19 14:42:44|Enabled  |            |            |
sieb_serv058|SvrTaskPersist   |Server Task Persistance                    |BusSvcMgr  |SystemAux|Background |Running          |Auto        |1               |1           |                 |                |2016-09-19 14:42:44|                   |Enabled  |            |            |
sieb_serv058|AdminNotify      |Siebel Administrator Notification Component|AdminNotify|SystemAux|Batch      |Online           |Auto        |0               |10          |1                |1               |2016-09-19 14:42:44|                   |Enabled  |            |            |
sieb_serv058|SCBroker         |Siebel Connection Broker                   |SCBroker   |System   |Background |Running          |Auto        |2               |2           |                 |                |2016-09-19 14:42:39|                   |Enabled  |            |            |
sieb_serv058|WorkActn         |Workflow Action Agent                      |WorkActn   |Workflow |Background |Online           |Auto        |0               |5           |                 |                |2016-09-19 14:42:49|                   |Enabled  |            |            |
sieb_serv058|WorkMon          |Workflow Monitor Agent                     |WorkMon    |Workflow |Background |Online           |Auto        |0               |5           |                 |                |2016-09-19 14:42:49|                   |Enabled  |            |            |
sieb_serv058|WorkMonAcrl      |Workflow Monitor Agent ACRL Itm            |WorkMon    |Workflow |Background |Running          |Auto        |1               |1           |                 |                |2016-09-19 14:42:49|                   |Enabled  |            |            |
sieb_serv058|WorkMonMkt       |Workflow Monitor Agent Bounce Mkt          |WorkMon    |Workflow |Background |Running          |Auto        |1               |1           |                 |                |2016-09-19 14:42:49|                   |Enabled  |            |            |
sieb_serv058|WorkMonXXXXXYYYY |Workflow Monitor Agent XXXXX YYYY          |WorkMon    |Workflow |Background |Running          |Auto        |1               |1           |                 |                |2016-09-19 14:42:49|                   |Enabled  |            |            |
sieb_serv058|WorkMonXXXXXZZ   |Workflow Monitor Agent XXXXX ZZ            |WorkMon    |Workflow |Background |Running          |Auto        |1               |1           |                 |                |2016-09-19 14:42:49|                   |Enabled  |            |            |
sieb_serv058|WorkMonMoob      |Workflow Monitor Agent Club Foobar         |WorkMon    |Workflow |Background |Running          |Auto        |1               |1           |                 |                |2016-09-19 14:42:49|                   |Enabled  |            |            |
sieb_serv058|WorkMonABCDEFGHIJLMNO|Workflow Monitor Agent Portal Anywhere     |WorkMon    |Workflow |Background |Running          |Auto        |1               |1           |                 |                |2016-09-19 14:42:49|                   |Enabled  |            |            |
sieb_serv058|WorkMonRdm       |Workflow Monitor Agent RDM Itm             |WorkMon    |Workflow |Background |Running          |Auto        |1               |1           |                 |                |2016-09-19 14:42:49|                   |Enabled  |            |            |
sieb_serv058|WorkMonSR        |Workflow Monitor Agent SR                  |WorkMon    |Workflow |Background |Running          |Auto        |1               |1           |                 |                |2016-09-19 14:42:49|                   |Enabled  |            |            |
sieb_serv058|WorkMonTXNCancelled|Workflow Monitor Agent SendMail Cancelled TXN|WorkMon    |Workflow |Background |Not Online       |Auto        |0               |1           |                 |                |2016-09-19 14:42:49|                   |Enabled  |            |            |
sieb_serv058|WorkMonSMSFricazzoids|Workflow Monitor Agent Foobar Map Send Mail|WorkMon    |Workflow |Background |Running          |Auto        |1               |1           |                 |                |2016-09-19 14:42:49|                   |Enabled  |            |            |
sieb_serv058|WorkMonTXN       |Workflow Monitor Agent TXN                 |WorkMon    |Workflow |Background |Running          |Auto        |1               |1           |                 |                |2016-09-19 14:42:49|                   |Enabled  |            |            |
sieb_serv058|WorkMonTXNRetro  |Workflow Monitor Agent TXN Retro           |WorkMon    |Workflow |Background |Running          |Auto        |1               |1           |                 |                |2016-09-19 14:42:49|                   |Enabled  |            |            |
sieb_serv058|WorkMonVoucher   |Workflow Monitor Agent Voucher             |WorkMon    |Workflow |Background |Running          |Auto        |1               |1           |                 |                |2016-09-19 14:42:49|                   |Enabled  |            |            |
sieb_serv058|WfProcBatchMgr   |Workflow Process Batch Manager             |BusSvcMgr  |Workflow |Batch      |Running          |Auto        |1               |20          |1                |1               |2016-09-19 14:42:49|                   |Enabled  |            |            |
sieb_serv058|WfProcMgr        |Workflow Process Manager                   |BusSvcMgr  |Workflow |Batch      |Running          |Auto        |2               |20          |1                |1               |2016-09-19 14:42:49|                   |Enabled  |            |            |
sieb_serv058|WfRecvMgr        |Workflow Recovery Manager                  |BusSvcMgr  |Workflow |Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:49|                   |Enabled  |            |            |
sieb_serv058|LoyEngineBatch   |eLoyalty Processing Engine - Batch         |BusSvcMgr  |LoyaltyEngine|Batch      |Shutdown         |Manual      |0               |60          |0                |3               |                   |2016-09-19 14:42:49|Enabled  |            |            |
sieb_serv058|LoyEngineInteractive|eLoyalty Processing Engine - Interactive   |BusSvcMgr  |LoyaltyEngine|Batch      |Shutdown         |Manual      |0               |20          |0                |1               |                   |2016-09-19 14:42:49|Enabled  |            |            |
sieb_serv058|LoyEngineRealtime|eLoyalty Processing Engine - Realtime      |BusSvcMgr  |LoyaltyEngine|Batch      |Online           |Auto        |0               |20          |1                |1               |2016-09-19 14:42:49|                   |Enabled  |            |            |
sieb_serv058|LoyEngineRealtimeTier|eLoyalty Processing Engine - Realtime - Tier|BusSvcMgr  |LoyaltyEngine|Batch      |Online           |Auto        |0               |50          |1                |1               |2016-09-19 14:42:49|                   |Enabled  |            |            |

376 rows returned.

