
package Paws::KinesisAnalytics::UpdateApplication;
  use Moose;
  has ApplicationName => (is => 'ro', isa => 'Str', required => 1);
  has ApplicationUpdate => (is => 'ro', isa => 'Paws::KinesisAnalytics::ApplicationUpdate', required => 1);
  has CurrentApplicationVersionId => (is => 'ro', isa => 'Int', required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'UpdateApplication');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::KinesisAnalytics::UpdateApplicationResponse');
  class_has _result_key => (isa => 'Str', is => 'ro');
1;

### main pod documentation begin ###

=head1 NAME

Paws::KinesisAnalytics::UpdateApplication - Arguments for method UpdateApplication on Paws::KinesisAnalytics

=head1 DESCRIPTION

This class represents the parameters used for calling the method UpdateApplication on the 
Amazon Kinesis Analytics service. Use the attributes of this class
as arguments to method UpdateApplication.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to UpdateApplication.

As an example:

  $service_obj->UpdateApplication(Att1 => $value1, Att2 => $value2, ...);

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ApplicationName => Str

Name of the Kinesis Analytics application to update.



=head2 B<REQUIRED> ApplicationUpdate => L<Paws::KinesisAnalytics::ApplicationUpdate>

Describes application updates.



=head2 B<REQUIRED> CurrentApplicationVersionId => Int

The current application version ID. You can use the DescribeApplication
operation to get this value.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method UpdateApplication in L<Paws::KinesisAnalytics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: https://github.com/pplu/aws-sdk-perl

Please report bugs to: https://github.com/pplu/aws-sdk-perl/issues

=cut

