use 5.006;
use strict;
use warnings;
use Module::Build;

my $builder = Module::Build->new(
    module_name         => 'Passwd::Keyring::PWSafe3',
    license             => 'perl',
    dynamic_config      => 1,

    build_requires => {
        'Module::Build' => '0.36',
        'Test::More' => 0,
        'Test::Pod::Coverage' => '1.0',
        'Pod::Readme' => 0,
    },
    configure_requires => {
        'Module::Build' => '0.36',
    },
    requires => {
        'perl' => 5.006,
        'Crypt::PWSafe3' => '1.05', # 1.05 fixes windows problems and taint
    },

    create_makefile_pl => 'traditional',
    add_to_cleanup      => [ 'Passwd-Keyring-PWSafe3-*' ],

    create_readme       => 1,
    dist_author         => q{Marcin Kasperski <Marcin.Kasperski@mekk.waw.pl>},
    dist_version_from   => 'lib/Passwd/Keyring/PWSafe3.pm',
    meta_merge => {
        keywords => [ qw/ passwords security secure-storage keyring KDE PWSafe3 / ],
        resources => {
            license     => 'http://dev.perl.org/licenses/',
            homepage    => 'http://bitbucket.org/Mekk/perl-keyring-pwsafe3',
            repository => 'http://bitbucket.org/Mekk/perl-keyring-pwsafe3',
            bugtracker => 'https://bitbucket.org/Mekk/perl-keyring-pwsafe3/issues',
        },
    },
);

$builder->create_build_script();
