# Automatically generated by perl-Test-AutoBuild.spec.PL

%define with_selinux 0

%define appname Test-AutoBuild

# This macro is used for the continuous automated builds. It just
# allows an extra fragment based on the timestamp to be appended
# to the release. This distinguishes automated builds, from formal
# Fedora RPM builds
%define _extra_release %{?dist:%{dist}}%{?extra_release:%{extra_release}}

Summary: Framework for performing continuous, unattended, automated software builds
Name: perl-%{appname}
Version: 1.2.2
Release: 1%{_extra_release}
License: GPLv2+
Group: Development/Tools
Url: http://autobuild.org/
Source: http://www.cpan.org/authors/id/D/DA/DANBERR/%{appname}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArchitectures: noarch

Requires: perl(:MODULE_COMPAT_%(eval "`%{__perl} -V:version`"; echo $version))

BuildRequires: perl(BSD::Resource) >= 1.15
BuildRequires: perl(Config::Record) >= 1.1.0
BuildRequires: perl(Log::Log4perl)
BuildRequires: perl(Template)
BuildRequires: perl(IO::Scalar)
BuildRequires: perl(Date::Manip)
BuildRequires: perl(Class::MethodMaker)
BuildRequires: perl(XML::Simple)
BuildRequires: perl(Test::More)
BuildRequires: perl(Test::Pod)
BuildRequires: perl(Test::Pod::Coverage)
BuildRequires: cvs >= 1.11
BuildRequires: subversion >= 1.0.0
BuildRequires: tla >= 1.1.0
BuildRequires: mercurial >= 0.7
BuildRequires: perl-SVK >= 1.0
BuildRequires: git >= 1.5.0.0
BuildRequires: darcs >= 1.0.0
BuildRequires: bzr >= 0.91
BuildRequires: monotone >= 0.37
%if %{with_selinux}
BuildRequires: selinux-policy-devel
%endif

# For Test::AutoBuild::Stage::ISOBuilder
Requires: /usr/bin/mkisofs
# For Test::AutoBuild::Stage::Yum
Requires: /usr/bin/yum-arch
# For Test::AutoBuild::Stage::CreateRepo
Requires: /usr/bin/createrepo
# For Test::AutoBuild::Stage::Apt
Requires: /usr/bin/genbasedir
# For Test::AutoBuild::Publisher::XSLTransform
Requires: /usr/bin/xsltproc

%if %{with_selinux}
Requires(post): policycoreutils
Requires(postun): policycoreutils
%endif

%package account
Summary: User account and directory structure for running builder
Group: Development/Tools
Url: http://autobuild.org/
Requires: perl-%{appname} = %{version}-%{release}
%if %{with_selinux}
Requires(post): policycoreutils
%endif

%package cvs
Summary: CVS source repository integration for autobuild engine
Group: Development/Tools
Url: http://autobuild.org/
Requires: perl-%{appname} = %{version}-%{release}
Requires: cvs >= 1.11

%package mercurial
Summary: Mercurial source repository integration for autobuild engine
Group: Development/Tools
Url: http://autobuild.org/
Requires: perl-%{appname} = %{version}-%{release}
Requires: mercurial >= 0.7

%package git
Summary: Git source repository integration for autobuild engine
Group: Development/Tools
Url: http://autobuild.org/
Requires: perl-%{appname} = %{version}-%{release}
Requires: git >= 1.5.0.0

%package darcs
Summary: Darcs source repository integration for autobuild engine
Group: Development/Tools
Url: http://autobuild.org/
Requires: perl-%{appname} = %{version}-%{release}
Requires: darcs >= 1.0.0

%package bzr
Summary: Bazaar source repository integration for autobuild engine
Group: Development/Tools
Url: http://autobuild.org/
Requires: perl-%{appname} = %{version}-%{release}
Requires: bzr >= 0.91

%package monotone
Summary: Monotone source repository integration for autobuild engine
Group: Development/Tools
Url: http://autobuild.org/
Requires: perl-%{appname} = %{version}-%{release}
Requires: monotone >= 0.37

%package subversion
Summary: Subversion source repository integration for autobuild engine
Group: Development/Tools
Url: http://autobuild.org/
Requires: perl-%{appname} = %{version}-%{release}
Requires: subversion >= 1.0.0

%package tla
Summary: GNU Arch source repository integration for autobuild engine
Group: Development/Tools
Url: http://autobuild.org/
Requires: perl-%{appname} = %{version}-%{release}
Requires: tla >= 1.1.0

%package svk
Summary: SVK source repository integration for autobuild engine
Group: Development/Tools
Url: http://autobuild.org/
Requires: perl-%{appname} = %{version}-%{release}
Requires: perl-SVK >= 1.0

%package perforce
Summary: Perforce source repository integration for autobuild engine
Group: Development/Tools
Url: http://autobuild.org/
Requires: perl-%{appname} = %{version}-%{release}
# No RPMs of Perforce so we can't add a formal dep :-(
# User will just have to download p4 binary direct from perforce.com
#Requires: perforce


%description
Test-AutoBuild is a Perl framework for performing continuous, unattended,
automated software builds

%description account
Test-AutoBuild is a Perl framework for performing continuous, unattended,
automated software builds.

This sub-package creates a 'builder' user account and the directory structure
in /var/lib/builder necessary for running a builder instance using the default
example configuration file.

%description cvs
Test-AutoBuild is a Perl framework for performing continuous, unattended,
automated software builds.

This sub-package provides the module for integrating with the CVS version
control system

%description mercurial
Test-AutoBuild is a Perl framework for performing continuous, unattended,
automated software builds.

This sub-package provides the module for integrating with the Mercurial
version control system

%description git
Test-AutoBuild is a Perl framework for performing continuous, unattended,
automated software builds.

This sub-package provides the module for integrating with the Git
version control system

%description darcs
Test-AutoBuild is a Perl framework for performing continuous, unattended,
automated software builds.

This sub-package provides the module for integrating with the Darcs
version control system

%description bzr
Test-AutoBuild is a Perl framework for performing continuous, unattended,
automated software builds.

This sub-package provides the module for integrating with the Bazaar
version control system

%description monotone
Test-AutoBuild is a Perl framework for performing continuous, unattended,
automated software builds.

This sub-package provides the module for integrating with the Monotone
version control system

%description subversion
Test-AutoBuild is a Perl framework for performing continuous, unattended,
automated software builds.

This sub-package provides the module for integrating with the Subversion
version control system

%description tla
Test-AutoBuild is a Perl framework for performing continuous, unattended,
automated software builds.

This sub-package provides the module for integrating with the GNU Arch
version control system

%description perforce
Test-AutoBuild is a Perl framework for performing continuous, unattended,
automated software builds.

This sub-package provides the module for integrating with the Perforce
version control system.

NB. this package requires that the 'p4' binary is provided in $PATH.

%description svk
Test-AutoBuild is a Perl framework for performing continuous, unattended,
automated software builds.

This sub-package provides the module for integrating with the SVK version
control system



%prep
%setup -q -n %{appname}-%{version}

%build
%{__perl} Makefile.PL INSTALLDIRS=vendor
%__make \
  WITH_SELINUX=%{with_selinux}

%install
%__rm -rf $RPM_BUILD_ROOT

%__make install \
  WITH_SELINUX=%{with_selinux} \
  PERL_INSTALL_ROOT=$RPM_BUILD_ROOT \
  sysconfdir=$RPM_BUILD_ROOT%{_sysconfdir} \
  bindir=$RPM_BUILD_ROOT%{_bindir} \
  selinuxdir=$RPM_BUILD_ROOT%{_datadir}/selinux \
  INSTALLVENDORMAN5DIR=$RPM_BUILD_ROOT%{_mandir}/man5
find $RPM_BUILD_ROOT -name perllocal.pod -exec rm -f {} \;
find $RPM_BUILD_ROOT -name .packlist -exec rm -f {} \;
%__cp $RPM_BUILD_ROOT%{_sysconfdir}/auto-build.d/auto-build.conf \
  $RPM_BUILD_ROOT%{_sysconfdir}/auto-build.d/auto-build.conf-example

# Create various bits wanted for the -account subRPM
$RPM_BUILD_ROOT%{_bindir}/auto-build-make-root \
  $RPM_BUILD_ROOT%{_localstatedir}/lib/builder

echo "/1 :pserver:anonymous@cvs.gna.org:2401/cvs/testautobuild A" \
  >> $RPM_BUILD_ROOT%{_localstatedir}/lib/builder/.cvspass
%__chmod 0600 $RPM_BUILD_ROOT%{_localstatedir}/lib/builder/.cvspass

echo "%%_topdir %{_localstatedir}/lib/builder/package-root/rpm" \
  >> $RPM_BUILD_ROOT%{_localstatedir}/lib/builder/.rpmmacros

%check
make test

%clean
%__rm -rf $RPM_BUILD_ROOT

%pre account
%__id builder > /dev/null 2>&1 || useradd -s /bin/snologin -d /var/lib/builder builder
# In case of upgrade from old version, relocate the home dir
usermod -d /var/lib/builder -s /sbin/nologin builder

%if %{with_selinux}
%post
# Always run, even on upgrade so we reload it
/usr/sbin/semodule -i %{_datadir}/selinux/packages/auto-build/auto-build.pp >/dev/null
fixfiles -R %{name} restore
%endif

%if %{with_selinux}
%post account
fixfiles -R %{name}-account restore
%endif

%if %{with_selinux}
%postun
# Unload if last module
if [ $1 -eq 0 ]; then
  /usr/sbin/semodule -r autobuild >/dev/null
fi
%endif

%files
%defattr(-,root,root)
%doc AUTHORS README LICENSE CHANGES UPGRADING
%doc doc/*
%doc examples

# Man pages
%{_mandir}/man1/*
%{_mandir}/man3/*
%{_mandir}/man5/*

# Config
%dir %{_sysconfdir}/auto-build.d
%config(noreplace) %{_sysconfdir}/auto-build.d/auto-build.conf-example
%dir %{_sysconfdir}/auto-build.d/engine
%config(noreplace) %{_sysconfdir}/auto-build.d/engine/*.conf
%dir %{_sysconfdir}/auto-build.d/cron
%config(noreplace) %{_sysconfdir}/auto-build.d/cron/*.conf
%dir %{_sysconfdir}/auto-build.d/httpd
%config(noreplace) %{_sysconfdir}/auto-build.d/httpd/*.conf
%dir %{_sysconfdir}/auto-build.d/templates
%config(noreplace) %{_sysconfdir}/auto-build.d/templates/*

# Scripts & modules
%attr(0755,root,root) %{_bindir}/auto-build
%if %{with_selinux}
%attr(0755,root,root) %{_bindir}/auto-build-secure
%endif
%attr(0755,root,root) %{_bindir}/auto-build-make-root
%attr(0755,root,root) %{_bindir}/auto-build-clean-root
%dir %{perl_vendorlib}/Test
%{perl_vendorlib}/Test/AutoBuild.pm
%dir %{perl_vendorlib}/Test/AutoBuild
%{perl_vendorlib}/Test/AutoBuild/*.pm
%dir %{perl_vendorlib}/Test/AutoBuild/Repository
%{perl_vendorlib}/Test/AutoBuild/Repository/Disk.pm
%dir %{perl_vendorlib}/Test/AutoBuild/Stage
%{perl_vendorlib}/Test/AutoBuild/Stage/*.pm
%dir %{perl_vendorlib}/Test/AutoBuild/Archive
%{perl_vendorlib}/Test/AutoBuild/Archive/*.pm
%dir %{perl_vendorlib}/Test/AutoBuild/ArchiveManager
%{perl_vendorlib}/Test/AutoBuild/ArchiveManager/*.pm
%dir %{perl_vendorlib}/Test/AutoBuild/Counter
%{perl_vendorlib}/Test/AutoBuild/Counter/*.pm
%dir %{perl_vendorlib}/Test/AutoBuild/Monitor
%{perl_vendorlib}/Test/AutoBuild/Monitor/*.pm
%dir %{perl_vendorlib}/Test/AutoBuild/Publisher
%{perl_vendorlib}/Test/AutoBuild/Publisher/*.pm
%dir %{perl_vendorlib}/Test/AutoBuild/Command
%{perl_vendorlib}/Test/AutoBuild/Command/*.pm

%if %{with_selinux}
# SELinux policy
%{_datadir}/selinux/packages/auto-build/auto-build.pp
%endif

%files cvs
%defattr(-,root,root)
%doc README
%{perl_vendorlib}/Test/AutoBuild/Repository/CVS.pm

%files mercurial
%defattr(-,root,root)
%doc README
%{perl_vendorlib}/Test/AutoBuild/Repository/Mercurial.pm

%files git
%defattr(-,root,root)
%doc README
%{perl_vendorlib}/Test/AutoBuild/Repository/Git.pm

%files darcs
%defattr(-,root,root)
%doc README
%{perl_vendorlib}/Test/AutoBuild/Repository/Darcs.pm

%files bzr
%defattr(-,root,root)
%doc README
%{perl_vendorlib}/Test/AutoBuild/Repository/Bazaar.pm

%files monotone
%defattr(-,root,root)
%doc README
%{perl_vendorlib}/Test/AutoBuild/Repository/Monotone.pm

%files subversion
%defattr(-,root,root)
%doc README
%{perl_vendorlib}/Test/AutoBuild/Repository/Subversion.pm

%files tla
%defattr(-,root,root)
%doc README
%{perl_vendorlib}/Test/AutoBuild/Repository/GNUArch.pm

%files svk
%defattr(-,root,root)
%doc README
%{perl_vendorlib}/Test/AutoBuild/Repository/SVK.pm

%files perforce
%defattr(-,root,root)
%doc README
%{perl_vendorlib}/Test/AutoBuild/Repository/Perforce.pm

%files account
%defattr(-,root,root)
%doc README
# Builder home
%config(noreplace) %{_sysconfdir}/auto-build.d/auto-build.conf
%dir %attr(-,builder,builder) %{_localstatedir}/lib/builder
%attr(-,builder,builder) %{_localstatedir}/lib/builder/*
%config(noreplace) %attr(-,builder,builder) %{_localstatedir}/lib/builder/.rpmmacros
%config(noreplace) %attr(-,builder,builder) %{_localstatedir}/lib/builder/.cvspass

%changelog
* Sun Dec 16 2007 Daniel Berrange <dan@berrange.com> - 1.2.2-1
- Added support for GIT, Monotone, Darcs and Bazaar repositories

* Sat Jun 30 2007 Daniel Berrange <dan@berrange.com> - 1.2.1-1
- Added in SELinux policy

* Thu Sep 14 2006 Daniel berrange <dan@berrange.com> - 1.2.0-3
- Added <perlvendorlib>/Test directory to list of owned dirs

* Sun Sep 10 2006 Daniel Berrange <dan@berrange.com> - 1.2.0-2
- Use macros for all path prefixes
- Added buildrequires on Test::Pod and Test::Pod::Coverage
- Added docs/ dir to documentation files
- Use macros for all programs used in build/install where available
- Fixed buildroot to comply with Fedora standards
- Make use of fedora-usermgmt package for creating builder account
- Ensure main package owns all directories it creates in /etc/ & perl lib dir

* Sat Sep  2 2006 Daniel Berrange <dan@berrange.com> - 1.2.0-1
- Misc fixes to bring closer in line with Fedora Extras guidelines

* Thu Feb  2 2006 Daniel Berrange <dan@berrange.com> - 1.1.4-1
- Relocate from /var/builder to /var/lib/builder for FHS compliance

* Wed Dec 28 2005 Daniel Berrange <dan@berrange.com> - 1.1.3-1
- Modular RPM packaging for source repository plugins

