package ETL::Yertl::Format::yaml;
our $VERSION = '0.038';
# ABSTRACT: YAML read/write support for Yertl

#pod =head1 SYNOPSIS
#pod
#pod =head1 DESCRIPTION
#pod
#pod =head1 SEE ALSO
#pod
#pod L<ETL::Yertl::FormatStream>
#pod
#pod =cut

use ETL::Yertl;
use base 'ETL::Yertl::Format';

sub new {
    my ( $class, @args ) = @_;
    my $self = $class->SUPER::new( @args );
    no strict 'refs';
    $self->{_load} = \&{ $self->{formatter_class} . '::Load' };
    $self->{_dump} = \&{ $self->{formatter_class} . '::Dump' };
    return $self;
}

sub _formatter_classes {
    return (
        [ 'YAML::XS' => 0 ],
        [ 'YAML::Syck' => 0 ],
        # [ 'YAML' => 0 ], # Disabled: YAML::Old changes have broke something here...
        [ 'YAML::Tiny' => 0 ],
    );
}

sub read_buffer {
    my ( $self, $buffref, $eof ) = @_;
    if ( $$buffref =~ s/(.+(?:\n---[^\n]*\n|\Z))//s ) {
        my @docs = $self->{_load}->( $1 );
        return @docs;
    }
}

sub format {
    my ( $self, $doc ) = @_;
    return $self->{_dump}->( $doc );
}

1;

__END__

=pod

=head1 NAME

ETL::Yertl::Format::yaml - YAML read/write support for Yertl

=head1 VERSION

version 0.038

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 SEE ALSO

L<ETL::Yertl::FormatStream>

=head1 AUTHOR

Doug Bell <preaction@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Doug Bell.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
