# -*- perl -*-

use strict;
use warnings;
use Data::Dumper qw{Dumper};
use Test::More tests => 16;

{
  package #hide from CPAN
    SMS::Send::My::ClassWithOverrides;
  use base qw{SMS::Send::Driver::WebService};
  sub _username_default {"user_class"};
  sub _password_default {"pass_class"};
  sub _host_default {"host_class"};
  sub _protocol_default {"protocol_class"};
  sub _port_default {"port_class"};
  sub _script_name_default {"script_name_class"};
}

my $service = SMS::Send::My::ClassWithOverrides->new;

isa_ok ($service, 'SMS::Send::My::ClassWithOverrides');
isa_ok ($service, 'SMS::Send::Driver::WebService');
isa_ok ($service, 'SMS::Send::Driver');
isa_ok ($service->cfg, 'Config::IniFiles');
is($service->cfg_section, "My::ClassWithOverrides", "cfg_section");
is($service->cfg_file, "./SMS-Send.ini", "cfg_file");
isa_ok($service->cfg_path, "ARRAY");
is($service->cfg_path->[0], ".", "cfg_path[0]");
is($service->cfg_path->[1], "/etc", "cfg_path[1]");

is($service->username,    'user_class_cfg',        'username');
is($service->password,    'pass_class_cfg',        'password');
is($service->host,        'host_class_cfg',        'host');
is($service->protocol,    'protocol_class_cfg',    'protocol');
is($service->port,        'port_class_cfg',        'port');
is($service->script_name, 'script_name_class_cfg', 'script_name');
is($service->script_name, 'script_name_class_cfg', 'script_name');
