package Chart::Plotly::Trace::Ohlc;
use Moose;

our $VERSION = '0.003';    # VERSION

=encoding utf-8

=head1 NAME 

Chart::Plotly::Trace::Ohlc

=head1 SYNOPSIS

	use HTML::Show;
	use Chart::Plotly;
	use Chart::Plotly::Trace::Ohlc;
	my $ohlc = Chart::Plotly::Trace::Ohlc->new(x => [1 .. 5], y => [1 .. 5]);
	
	HTML::Show::show(Chart::Plotly::render_full_html(data => [$ohlc]));


=head1 DESCRIPTION

This file has been autogenerated from the official plotly.js source.

If you like Plotly, please support them: L<https://plot.ly/> 
Open source announcement: L<https://plot.ly/javascript/open-source-announcement/>

Full reference: L<https://plot.ly/javascript/reference/#ohlc>

=head1 DISCLAIMER

This is an unofficial Plotly Perl module. Currently I'm not affiliated in any way with Plotly. 
But I think plotly.js is a great library and I want to use it with perl.

=head1 METHODS

=cut

=head2 TO_JSON

Serialize the trace to JSON. This method should be called only by L<JSON> serializer.

=cut

sub TO_JSON {
    my $self = shift;
    my %hash = %$self;
    $hash{type} = $self->type();
    return \%hash;
}

=head2 type

Trace type.

=cut

sub type {
    my @components = split( /::/, __PACKAGE__ );
    return lc( $components[-1] );
}

=head1 ATTRIBUTES

=over

=cut

=item * increasing


=cut

has increasing => ( is => 'rw', );

=item * tickwidth

Sets the width of the open/close tick marks relative to the *x* minimal interval.

=cut

has tickwidth => ( is            => 'rw',
                   documentation => "Sets the width of the open/close tick marks relative to the *x* minimal interval.",
);

=item * close

Sets the close values.

=cut

has close => ( is            => 'rw',
               documentation => "Sets the close values.", );

=item * text

Sets hover text elements associated with each sample point. If a single string, the same string appears over all the data points. If an array of string, the items are mapped in order to this trace's sample points.

=cut

has text => (
    is => 'rw',
    documentation =>
      "Sets hover text elements associated with each sample point. If a single string, the same string appears over all the data points. If an array of string, the items are mapped in order to this trace's sample points.",
);

=item * high

Sets the high values.

=cut

has high => ( is            => 'rw',
              documentation => "Sets the high values.", );

=item * decreasing


=cut

has decreasing => ( is => 'rw', );

=item * x

Sets the x coordinates. If absent, linear coordinate will be generated.

=cut

has x => ( is            => 'rw',
           documentation => "Sets the x coordinates. If absent, linear coordinate will be generated.", );

=item * line


=cut

has line => ( is => 'rw', );

=item * open

Sets the open values.

=cut

has open => ( is            => 'rw',
              documentation => "Sets the open values.", );

=item * low

Sets the low values.

=cut

has low => ( is            => 'rw',
             documentation => "Sets the low values.", );

=pod

=back

=cut

__PACKAGE__->meta->make_immutable();
1;
