use strict;
use warnings;
use utf8;

use Test::More tests => 5;

use String::Copyright;

is copyright("#define foo(c) 1999 Foo"), '', 'bogus sign';

is copyright("(c) 1999 Foo\n#define foo(c) 1999 Bar"),
	'© 1999 Foo',
	'sign, then bogus sign';

is copyright("#define foo(c) 1999 Foo\n(c) 1999 Bar"),
	'© 1999 Bar',
	'bogus sign, then sign';

TODO: {
	local $TODO = 'not yet handled';
	is copyright("(c) 1999 Foo #define foo(c) 1999 Bar"),
		'© 1999 Foo',
		'sign, then bogus sign on same line';

	is copyright("#define foo(c) 1999 Foo (c) 1999 Bar"),
		'© 1999 Bar',
		'bogus sign, then sign on same line';
}
