use strict;
use warnings;
use utf8;

use Test::More tests => 9;

use String::Copyright;

is_deeply copyright("© 1999 12345 Steps")->blocks,
	['1999 12345 Steps'],
	'year-like owner';

is_deeply copyright("© 1999 1234 Steps")->blocks,
	['1999, 1234 Steps'],
	'too-year-like owner';

is copyright("© Foo"), '© Foo', 'year-less owner';

is copyright("© , Foo"), '© Foo', 'messy owner starting with comma';

is copyright("© . Foo"), '', 'bogus owner starting with dot';

is copyright("© -Foo"), '© -Foo', 'owner starting with dash';

is copyright('© Foo (Bar) Baz'), '© Foo (Bar) Baz',
	'owner with non-first word in parenthesis';

is copyright('© Foo (Bar Baz)'), '© Foo (Bar Baz)',
	'owner with non-first words in parenthesis';

is copyright('© (Foo) Bar Baz'), '',
	'bogus owner with first word in parenthesis';
