package main;

use 5.006002;

use strict;
use warnings;

use Date::Tolkien::Shire;
use Test::More 0.47;	# The best we can do with 5.6.2.
use Time::Local;

plan tests => 26298;

print <<'EOT';
# Created Wed Feb  8 03:32:50 2017 UT
# using Date::Tolkien::Shire 1.13_01
EOT

my ( $dts, $epoch );

$epoch = timelocal( 0, 0, 0, 1, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-01-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-01-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-01-01 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 1999-01-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 9 Afteryule 7463', 'as_string() on 1999-01-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-01 Gregorian' );
Monday 9 Afteryule 7463
EOT

$epoch = timelocal( 0, 0, 0, 2, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-01-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-01-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-01-02 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 1999-01-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 10 Afteryule 7463', 'as_string() on 1999-01-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-02 Gregorian' );
Trewsday 10 Afteryule 7463
EOT

$epoch = timelocal( 0, 0, 0, 3, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-01-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-01-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-01-03 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 1999-01-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 11 Afteryule 7463', 'as_string() on 1999-01-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-03 Gregorian' );
Hevensday 11 Afteryule 7463
EOT

$epoch = timelocal( 0, 0, 0, 4, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-01-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-01-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-01-04 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 1999-01-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 12 Afteryule 7463', 'as_string() on 1999-01-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-04 Gregorian' );
Mersday 12 Afteryule 7463
EOT

$epoch = timelocal( 0, 0, 0, 5, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-01-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-01-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-01-05 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 1999-01-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 13 Afteryule 7463', 'as_string() on 1999-01-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-05 Gregorian' );
Highday 13 Afteryule 7463

The Company of the Ring reaches the West-gate of Moria at nightfall, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 6, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-01-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-01-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-01-06 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 1999-01-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 14 Afteryule 7463', 'as_string() on 1999-01-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-06 Gregorian' );
Sterday 14 Afteryule 7463

The Company of the Ring spends the night in Moria hall 21, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 7, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-01-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-01-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-01-07 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 1999-01-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 15 Afteryule 7463', 'as_string() on 1999-01-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-07 Gregorian' );
Sunday 15 Afteryule 7463

The Bridge of Khazad-dum, and the fall of Gandalf, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 8, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-01-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-01-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-01-08 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 1999-01-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 16 Afteryule 7463', 'as_string() on 1999-01-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-08 Gregorian' );
Monday 16 Afteryule 7463
EOT

$epoch = timelocal( 0, 0, 0, 9, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-01-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-01-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-01-09 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 1999-01-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 17 Afteryule 7463', 'as_string() on 1999-01-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-09 Gregorian' );
Trewsday 17 Afteryule 7463

The Company of the Ring comes to Caras Galadhon at evening, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 10, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-01-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-01-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-01-10 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 1999-01-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 18 Afteryule 7463', 'as_string() on 1999-01-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-10 Gregorian' );
Hevensday 18 Afteryule 7463
EOT

$epoch = timelocal( 0, 0, 0, 11, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-01-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-01-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-01-11 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 1999-01-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 19 Afteryule 7463', 'as_string() on 1999-01-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-11 Gregorian' );
Mersday 19 Afteryule 7463
EOT

$epoch = timelocal( 0, 0, 0, 12, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-01-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-01-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-01-12 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 1999-01-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 20 Afteryule 7463', 'as_string() on 1999-01-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-12 Gregorian' );
Highday 20 Afteryule 7463
EOT

$epoch = timelocal( 0, 0, 0, 13, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-01-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-01-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-01-13 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 1999-01-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 21 Afteryule 7463', 'as_string() on 1999-01-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-13 Gregorian' );
Sterday 21 Afteryule 7463
EOT

$epoch = timelocal( 0, 0, 0, 14, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-01-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-01-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-01-14 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 1999-01-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 22 Afteryule 7463', 'as_string() on 1999-01-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-14 Gregorian' );
Sunday 22 Afteryule 7463
EOT

$epoch = timelocal( 0, 0, 0, 15, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-01-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-01-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-01-15 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 1999-01-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 23 Afteryule 7463', 'as_string() on 1999-01-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-15 Gregorian' );
Monday 23 Afteryule 7463

Gandalf pursues the Balrog to the peak of Zirakzigil, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 16, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-01-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-01-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-01-16 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 1999-01-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 24 Afteryule 7463', 'as_string() on 1999-01-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-16 Gregorian' );
Trewsday 24 Afteryule 7463
EOT

$epoch = timelocal( 0, 0, 0, 17, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-01-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-01-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-01-17 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 1999-01-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 25 Afteryule 7463', 'as_string() on 1999-01-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-17 Gregorian' );
Hevensday 25 Afteryule 7463

Gandalf casts down the Balrog, and passes away.
His body lies on the peak of Zirakzigil, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 18, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-01-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-01-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-01-18 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 1999-01-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 26 Afteryule 7463', 'as_string() on 1999-01-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-18 Gregorian' );
Mersday 26 Afteryule 7463
EOT

$epoch = timelocal( 0, 0, 0, 19, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-01-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-01-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-01-19 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 1999-01-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 27 Afteryule 7463', 'as_string() on 1999-01-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-19 Gregorian' );
Highday 27 Afteryule 7463
EOT

$epoch = timelocal( 0, 0, 0, 20, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-01-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-01-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-01-20 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 1999-01-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 28 Afteryule 7463', 'as_string() on 1999-01-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-20 Gregorian' );
Sterday 28 Afteryule 7463
EOT

$epoch = timelocal( 0, 0, 0, 21, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-01-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-01-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-01-21 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 1999-01-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 29 Afteryule 7463', 'as_string() on 1999-01-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-21 Gregorian' );
Sunday 29 Afteryule 7463
EOT

$epoch = timelocal( 0, 0, 0, 22, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-01-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-01-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-01-22 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 1999-01-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 30 Afteryule 7463', 'as_string() on 1999-01-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-22 Gregorian' );
Monday 30 Afteryule 7463
EOT

$epoch = timelocal( 0, 0, 0, 23, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-01-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-01-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-01-23 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 1999-01-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 1 Solmath 7463', 'as_string() on 1999-01-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-23 Gregorian' );
Trewsday 1 Solmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 24, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-01-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-01-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-01-24 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 1999-01-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 2 Solmath 7463', 'as_string() on 1999-01-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-24 Gregorian' );
Hevensday 2 Solmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 25, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-01-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-01-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-01-25 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 1999-01-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 3 Solmath 7463', 'as_string() on 1999-01-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-25 Gregorian' );
Mersday 3 Solmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 26, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-01-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-01-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-01-26 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 1999-01-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 4 Solmath 7463', 'as_string() on 1999-01-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-26 Gregorian' );
Highday 4 Solmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 27, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-01-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-01-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-01-27 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 1999-01-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 5 Solmath 7463', 'as_string() on 1999-01-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-27 Gregorian' );
Sterday 5 Solmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 28, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-01-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-01-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-01-28 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 1999-01-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 6 Solmath 7463', 'as_string() on 1999-01-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-28 Gregorian' );
Sunday 6 Solmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 29, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-01-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-01-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-01-29 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 1999-01-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 7 Solmath 7463', 'as_string() on 1999-01-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-29 Gregorian' );
Monday 7 Solmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 30, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-01-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-01-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-01-30 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 1999-01-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 8 Solmath 7463', 'as_string() on 1999-01-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-30 Gregorian' );
Trewsday 8 Solmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 31, 0, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-01-31 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-01-31 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-01-31 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-01-31 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 1999-01-31 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-01-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-01-31 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 9 Solmath 7463', 'as_string() on 1999-01-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-01-31 Gregorian' );
Hevensday 9 Solmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 1, 1, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-02-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-02-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-02-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-02-01 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 1999-02-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-02-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 10 Solmath 7463', 'as_string() on 1999-02-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-01 Gregorian' );
Mersday 10 Solmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 2, 1, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-02-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-02-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-02-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-02-02 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 1999-02-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-02-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 11 Solmath 7463', 'as_string() on 1999-02-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-02 Gregorian' );
Highday 11 Solmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 3, 1, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-02-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-02-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-02-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-02-03 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 1999-02-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-02-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 12 Solmath 7463', 'as_string() on 1999-02-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-03 Gregorian' );
Sterday 12 Solmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 4, 1, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-02-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-02-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-02-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-02-04 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 1999-02-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-02-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 13 Solmath 7463', 'as_string() on 1999-02-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-04 Gregorian' );
Sunday 13 Solmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 5, 1, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-02-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-02-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-02-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-02-05 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 1999-02-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-02-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 14 Solmath 7463', 'as_string() on 1999-02-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-05 Gregorian' );
Monday 14 Solmath 7463

Frodo and Sam look in the Mirror of Galadriel, 1419.
Gandalf returns to life, and lies in a trance, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 6, 1, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-02-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-02-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-02-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-02-06 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 1999-02-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-02-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 15 Solmath 7463', 'as_string() on 1999-02-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-06 Gregorian' );
Trewsday 15 Solmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 7, 1, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-02-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-02-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-02-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-02-07 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 1999-02-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-02-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 16 Solmath 7463', 'as_string() on 1999-02-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-07 Gregorian' );
Hevensday 16 Solmath 7463

Company of the Ring says farewell to Lorien --
Gollum observes departure, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 8, 1, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-02-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-02-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-02-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-02-08 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 1999-02-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-02-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 17 Solmath 7463', 'as_string() on 1999-02-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-08 Gregorian' );
Mersday 17 Solmath 7463

Gwaihir the eagle bears Gandalf to Lorien, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 9, 1, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-02-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-02-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-02-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-02-09 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 1999-02-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-02-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 18 Solmath 7463', 'as_string() on 1999-02-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-09 Gregorian' );
Highday 18 Solmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 10, 1, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-02-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-02-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-02-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-02-10 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 1999-02-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-02-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 19 Solmath 7463', 'as_string() on 1999-02-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-10 Gregorian' );
Sterday 19 Solmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 11, 1, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-02-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-02-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-02-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-02-11 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 1999-02-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-02-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 20 Solmath 7463', 'as_string() on 1999-02-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-11 Gregorian' );
Sunday 20 Solmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 12, 1, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-02-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-02-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-02-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-02-12 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 1999-02-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-02-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 21 Solmath 7463', 'as_string() on 1999-02-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-12 Gregorian' );
Monday 21 Solmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 13, 1, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-02-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-02-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-02-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-02-13 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 1999-02-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-02-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 22 Solmath 7463', 'as_string() on 1999-02-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-13 Gregorian' );
Trewsday 22 Solmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 14, 1, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-02-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-02-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-02-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-02-14 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 1999-02-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-02-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 23 Solmath 7463', 'as_string() on 1999-02-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-14 Gregorian' );
Hevensday 23 Solmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 15, 1, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-02-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-02-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-02-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-02-15 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 1999-02-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-02-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 24 Solmath 7463', 'as_string() on 1999-02-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-15 Gregorian' );
Mersday 24 Solmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 16, 1, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-02-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-02-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-02-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-02-16 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 1999-02-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-02-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 25 Solmath 7463', 'as_string() on 1999-02-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-16 Gregorian' );
Highday 25 Solmath 7463

The Company of the Ring pass the Argonath and camp at Parth Galen, 1419.
First battle of the Fords of Isen -- Theodred son of Theoden slain, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 17, 1, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-02-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-02-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-02-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-02-17 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 1999-02-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-02-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 26 Solmath 7463', 'as_string() on 1999-02-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-17 Gregorian' );
Sterday 26 Solmath 7463

Breaking of the Fellowship, 1419.
Death of Boromir; his horn is heard in Minas Tirith, 1419.
Meriadoc and Peregrin captured by Orcs -- Aragorn pursues, 1419.
Eomer hears of the descent of the Orc-band from Emyn Muil, 1419.
Frodo and Samwise enter the eastern Emyn Muil, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 18, 1, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-02-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-02-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-02-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-02-18 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 1999-02-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-02-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 27 Solmath 7463', 'as_string() on 1999-02-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-18 Gregorian' );
Sunday 27 Solmath 7463

Aragorn reaches the west-cliff at sunrise, 1419.
Eomer sets out from Eastfold against Theoden's orders to pursue the Orcs, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 19, 1, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-02-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-02-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-02-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-02-19 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 1999-02-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-02-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 28 Solmath 7463', 'as_string() on 1999-02-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-19 Gregorian' );
Monday 28 Solmath 7463

Eomer overtakes the Orcs just outside of Fangorn Forest, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 20, 1, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-02-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-02-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-02-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-02-20 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 1999-02-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-02-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 29 Solmath 7463', 'as_string() on 1999-02-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-20 Gregorian' );
Trewsday 29 Solmath 7463

Meriodoc and Pippin escape and meet Treebeard, 1419.
The Rohirrim attack at sunrise and destroy the Orcs, 1419.
Frodo descends from the Emyn Muil and meets Gollum, 1419.
Faramir sees the funeral boat of Boromir, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 21, 1, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-02-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-02-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-02-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 1999-02-21 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 1999-02-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-02-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 30 Solmath 7463', 'as_string() on 1999-02-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-21 Gregorian' );
Hevensday 30 Solmath 7463

Entmoot begins, 1419.
Eomer, returning to Edoras, meets Aragorn, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 22, 1, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-02-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-02-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-02-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-02-22 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 1999-02-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-02-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 1 Rethe 7463', 'as_string() on 1999-02-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-22 Gregorian' );
Mersday 1 Rethe 7463

Aragorn meets Gandalf the White, and they set out for Edoras, 1419.
Faramir leaves Minas Tirith on an errand to Ithilien, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 23, 1, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-02-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-02-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-02-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-02-23 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 1999-02-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-02-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 2 Rethe 7463', 'as_string() on 1999-02-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-23 Gregorian' );
Highday 2 Rethe 7463

The Rohirrim ride west against Saruman, 1419.
Second battle at the Fords of Isen; Erkenbrand defeated, 1419.
Entmoot ends.  Ents march on Isengard and reach it at night, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 24, 1, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-02-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-02-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-02-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-02-24 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 1999-02-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-02-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 3 Rethe 7463', 'as_string() on 1999-02-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-24 Gregorian' );
Sterday 3 Rethe 7463

Theoden retreats to Helm's Deep; battle of the Hornburg begins, 1419.
Ents complete the destruction of Isengard.
EOT

$epoch = timelocal( 0, 0, 0, 25, 1, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-02-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-02-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-02-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-02-25 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 1999-02-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-02-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 4 Rethe 7463', 'as_string() on 1999-02-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-25 Gregorian' );
Sunday 4 Rethe 7463

Theoden and Gandalf set out from Helm's Deep for Isengard, 1419.
Frodo reaches the slag mound on the edge of the of the Morannon, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 26, 1, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-02-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-02-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-02-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-02-26 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 1999-02-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-02-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 5 Rethe 7463', 'as_string() on 1999-02-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-26 Gregorian' );
Monday 5 Rethe 7463

Theoden reaches Isengard at noon; parley with Saruman in Orthanc, 1419.
Gandalf sets out with Peregrin for Minas Tirith, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 27, 1, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-02-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-02-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-02-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-02-27 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 1999-02-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-02-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 6 Rethe 7463', 'as_string() on 1999-02-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-27 Gregorian' );
Trewsday 6 Rethe 7463

Aragorn overtaken by the Dunedain in the early hours, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 28, 1, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-02-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-02-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-02-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-02-28 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 1999-02-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-02-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-02-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 7 Rethe 7463', 'as_string() on 1999-02-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-02-28 Gregorian' );
Hevensday 7 Rethe 7463

Frodo taken by Faramir to Henneth Annun, 1419.
Aragorn comes to Dunharrow at nightfall, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 1, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-03-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-03-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-03-01 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 1999-03-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 8 Rethe 7463', 'as_string() on 1999-03-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-01 Gregorian' );
Mersday 8 Rethe 7463

Aragorn takes the "Paths of the Dead", and reaches Erech at midnight, 1419.
Frodo leaves Henneth Annun, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 2, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-03-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-03-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-03-02 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 1999-03-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 9 Rethe 7463', 'as_string() on 1999-03-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-02 Gregorian' );
Highday 9 Rethe 7463

Gandalf reaches Minas Tirith, 1419.
Darkness begins to flow out of Mordor, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 3, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-03-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-03-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-03-03 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 1999-03-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 10 Rethe 7463', 'as_string() on 1999-03-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-03 Gregorian' );
Sterday 10 Rethe 7463

The Dawnless Day, 1419.
The Rohirrim are mustered and ride from Harrowdale, 1419.
Faramir rescued by Gandalf at the gates of Minas Tirith, 1419.
An army from the Morannon takes Cair Andros and passes into Anorien, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 4, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-03-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-03-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-03-04 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 1999-03-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 11 Rethe 7463', 'as_string() on 1999-03-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-04 Gregorian' );
Sunday 11 Rethe 7463

Gollum visits Shelob, 1419.
Denethor sends Faramir to Osgiliath, 1419.
Eastern Rohan is invaded and Lorien assaulted, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 5, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-03-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-03-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-03-05 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 1999-03-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 12 Rethe 7463', 'as_string() on 1999-03-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-05 Gregorian' );
Monday 12 Rethe 7463

Gollum leads Frodo into Shelob's lair, 1419.
Ents defeat the invaders of Rohan, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 6, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-03-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-03-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-03-06 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 1999-03-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 13 Rethe 7463', 'as_string() on 1999-03-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-06 Gregorian' );
Trewsday 13 Rethe 7463

Frodo captured by the Orcs of Cirith Ungol, 1419.
The Pelennor is overrun and Faramir is wounded, 1419.
Aragorn reaches Pelargir and captures the fleet of Umbar, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 7, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-03-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-03-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-03-07 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 1999-03-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 14 Rethe 7463', 'as_string() on 1999-03-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-07 Gregorian' );
Hevensday 14 Rethe 7463

Samwise finds Frodo in the tower of Cirith Ungol, 1419.
Minas Tirith besieged, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 8, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-03-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-03-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-03-08 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 1999-03-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 15 Rethe 7463', 'as_string() on 1999-03-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-08 Gregorian' );
Mersday 15 Rethe 7463

Witch King breaks the gates of Minas Tirith, 1419.
Denethor, Steward of Gondor, burns himself on a pyre, 1419.
The battle of the Pelennor occurs as Theoden and Aragorn arrive, 1419.
Thranduil repels the forces of Dol Guldur in Mirkwood, 1419.
Lorien assaulted for second time, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 9, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-03-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-03-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-03-09 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 1999-03-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 16 Rethe 7463', 'as_string() on 1999-03-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-09 Gregorian' );
Highday 16 Rethe 7463
EOT

$epoch = timelocal( 0, 0, 0, 10, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-03-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-03-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-03-10 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 1999-03-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 17 Rethe 7463', 'as_string() on 1999-03-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-10 Gregorian' );
Sterday 17 Rethe 7463

Battle of Dale, where King Brand and King Dain Ironfoot fall, 1419.
Shagrat brings Frodo's cloak, mail-shirt, and sword to Barad-dur, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 11, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-03-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-03-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-03-11 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 1999-03-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 18 Rethe 7463', 'as_string() on 1999-03-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-11 Gregorian' );
Sunday 18 Rethe 7463

Host of the west leaves Minas Tirith, 1419.
Frodo and Sam overtaken by Orcs on the road from Durthang to Udun, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 12, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-03-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-03-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-03-12 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 1999-03-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 19 Rethe 7463', 'as_string() on 1999-03-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-12 Gregorian' );
Monday 19 Rethe 7463

Frodo and Sam escape the Orcs and start on the road toward Mount Doom, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 13, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-03-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-03-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-03-13 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 1999-03-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 20 Rethe 7463', 'as_string() on 1999-03-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-13 Gregorian' );
Trewsday 20 Rethe 7463
EOT

$epoch = timelocal( 0, 0, 0, 14, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-03-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-03-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-03-14 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 1999-03-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 21 Rethe 7463', 'as_string() on 1999-03-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-14 Gregorian' );
Hevensday 21 Rethe 7463
EOT

$epoch = timelocal( 0, 0, 0, 15, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-03-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-03-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-03-15 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 1999-03-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 22 Rethe 7463', 'as_string() on 1999-03-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-15 Gregorian' );
Mersday 22 Rethe 7463

Lorien assaulted for the third time, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 16, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-03-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-03-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-03-16 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 1999-03-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 23 Rethe 7463', 'as_string() on 1999-03-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-16 Gregorian' );
Highday 23 Rethe 7463
EOT

$epoch = timelocal( 0, 0, 0, 17, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-03-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-03-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-03-17 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 1999-03-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 24 Rethe 7463', 'as_string() on 1999-03-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-17 Gregorian' );
Sterday 24 Rethe 7463

Frodo and Sam reach the base of Mount Doom, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 18, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-03-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-03-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-03-18 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 1999-03-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 25 Rethe 7463', 'as_string() on 1999-03-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-18 Gregorian' );
Sunday 25 Rethe 7463

Battle of the Host of the West on the slag hill of the Morannon, 1419.
Gollum siezes the Ring of Power and falls into the Cracks of Doom, 1419.
Downfall of Barad-dur and the passing of Sauron!, 1419.
Birth of Elanor the Fair, daughter of Samwise, 1421.
Fourth age begins in the reckoning of Gondor, 1421.
EOT

$epoch = timelocal( 0, 0, 0, 19, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-03-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-03-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-03-19 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 1999-03-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 26 Rethe 7463', 'as_string() on 1999-03-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-19 Gregorian' );
Monday 26 Rethe 7463
EOT

$epoch = timelocal( 0, 0, 0, 20, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-03-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-03-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-03-20 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 1999-03-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 27 Rethe 7463', 'as_string() on 1999-03-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-20 Gregorian' );
Trewsday 27 Rethe 7463

Bard II and Thorin III Stonehelm drive the enemy from Dale, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 21, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-03-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-03-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-03-21 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 1999-03-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 28 Rethe 7463', 'as_string() on 1999-03-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-21 Gregorian' );
Hevensday 28 Rethe 7463

Celeborn crosses the Anduin and begins destruction of Dol Guldur, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 22, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-03-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-03-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-03-22 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 1999-03-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 29 Rethe 7463', 'as_string() on 1999-03-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-22 Gregorian' );
Mersday 29 Rethe 7463
EOT

$epoch = timelocal( 0, 0, 0, 23, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-03-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-03-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 1999-03-23 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 1999-03-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 30 Rethe 7463', 'as_string() on 1999-03-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-23 Gregorian' );
Highday 30 Rethe 7463
EOT

$epoch = timelocal( 0, 0, 0, 24, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-03-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-03-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-03-24 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 1999-03-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 1 Astron 7463', 'as_string() on 1999-03-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-24 Gregorian' );
Sterday 1 Astron 7463
EOT

$epoch = timelocal( 0, 0, 0, 25, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-03-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-03-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-03-25 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 1999-03-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 2 Astron 7463', 'as_string() on 1999-03-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-25 Gregorian' );
Sunday 2 Astron 7463
EOT

$epoch = timelocal( 0, 0, 0, 26, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-03-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-03-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-03-26 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 1999-03-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 3 Astron 7463', 'as_string() on 1999-03-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-26 Gregorian' );
Monday 3 Astron 7463
EOT

$epoch = timelocal( 0, 0, 0, 27, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-03-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-03-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-03-27 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 1999-03-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 4 Astron 7463', 'as_string() on 1999-03-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-27 Gregorian' );
Trewsday 4 Astron 7463
EOT

$epoch = timelocal( 0, 0, 0, 28, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-03-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-03-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-03-28 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 1999-03-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 5 Astron 7463', 'as_string() on 1999-03-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-28 Gregorian' );
Hevensday 5 Astron 7463
EOT

$epoch = timelocal( 0, 0, 0, 29, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-03-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-03-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-03-29 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 1999-03-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 6 Astron 7463', 'as_string() on 1999-03-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-29 Gregorian' );
Mersday 6 Astron 7463

The mallorn tree flowers in the party field, 1420.
EOT

$epoch = timelocal( 0, 0, 0, 30, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-03-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-03-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-03-30 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 1999-03-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 7 Astron 7463', 'as_string() on 1999-03-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-30 Gregorian' );
Highday 7 Astron 7463
EOT

$epoch = timelocal( 0, 0, 0, 31, 2, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-03-31 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-03-31 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-03-31 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-03-31 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 1999-03-31 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-03-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-03-31 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 8 Astron 7463', 'as_string() on 1999-03-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-03-31 Gregorian' );
Sterday 8 Astron 7463

Ring bearers are honored on the fields of Cormallen, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 1, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-04-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-04-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-04-01 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 1999-04-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 9 Astron 7463', 'as_string() on 1999-04-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-01 Gregorian' );
Sunday 9 Astron 7463
EOT

$epoch = timelocal( 0, 0, 0, 2, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-04-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-04-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-04-02 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 1999-04-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 10 Astron 7463', 'as_string() on 1999-04-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-02 Gregorian' );
Monday 10 Astron 7463
EOT

$epoch = timelocal( 0, 0, 0, 3, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-04-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-04-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-04-03 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 1999-04-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 11 Astron 7463', 'as_string() on 1999-04-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-03 Gregorian' );
Trewsday 11 Astron 7463
EOT

$epoch = timelocal( 0, 0, 0, 4, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-04-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-04-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-04-04 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 1999-04-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 12 Astron 7463', 'as_string() on 1999-04-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-04 Gregorian' );
Hevensday 12 Astron 7463

Gandalf arrives in Hobbiton, 1418
EOT

$epoch = timelocal( 0, 0, 0, 5, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-04-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-04-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-04-05 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 1999-04-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 13 Astron 7463', 'as_string() on 1999-04-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-05 Gregorian' );
Mersday 13 Astron 7463
EOT

$epoch = timelocal( 0, 0, 0, 6, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-04-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-04-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-04-06 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 1999-04-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 14 Astron 7463', 'as_string() on 1999-04-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-06 Gregorian' );
Highday 14 Astron 7463
EOT

$epoch = timelocal( 0, 0, 0, 7, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-04-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-04-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-04-07 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 1999-04-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 15 Astron 7463', 'as_string() on 1999-04-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-07 Gregorian' );
Sterday 15 Astron 7463
EOT

$epoch = timelocal( 0, 0, 0, 8, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-04-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-04-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-04-08 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 1999-04-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 16 Astron 7463', 'as_string() on 1999-04-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-08 Gregorian' );
Sunday 16 Astron 7463
EOT

$epoch = timelocal( 0, 0, 0, 9, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-04-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-04-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-04-09 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 1999-04-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 17 Astron 7463', 'as_string() on 1999-04-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-09 Gregorian' );
Monday 17 Astron 7463
EOT

$epoch = timelocal( 0, 0, 0, 10, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-04-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-04-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-04-10 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 1999-04-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 18 Astron 7463', 'as_string() on 1999-04-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-10 Gregorian' );
Trewsday 18 Astron 7463
EOT

$epoch = timelocal( 0, 0, 0, 11, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-04-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-04-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-04-11 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 1999-04-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 19 Astron 7463', 'as_string() on 1999-04-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-11 Gregorian' );
Hevensday 19 Astron 7463
EOT

$epoch = timelocal( 0, 0, 0, 12, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-04-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-04-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-04-12 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 1999-04-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 20 Astron 7463', 'as_string() on 1999-04-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-12 Gregorian' );
Mersday 20 Astron 7463
EOT

$epoch = timelocal( 0, 0, 0, 13, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-04-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-04-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-04-13 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 1999-04-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 21 Astron 7463', 'as_string() on 1999-04-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-13 Gregorian' );
Highday 21 Astron 7463
EOT

$epoch = timelocal( 0, 0, 0, 14, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-04-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-04-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-04-14 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 1999-04-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 22 Astron 7463', 'as_string() on 1999-04-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-14 Gregorian' );
Sterday 22 Astron 7463
EOT

$epoch = timelocal( 0, 0, 0, 15, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-04-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-04-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-04-15 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 1999-04-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 23 Astron 7463', 'as_string() on 1999-04-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-15 Gregorian' );
Sunday 23 Astron 7463
EOT

$epoch = timelocal( 0, 0, 0, 16, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-04-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-04-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-04-16 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 1999-04-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 24 Astron 7463', 'as_string() on 1999-04-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-16 Gregorian' );
Monday 24 Astron 7463
EOT

$epoch = timelocal( 0, 0, 0, 17, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-04-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-04-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-04-17 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 1999-04-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 25 Astron 7463', 'as_string() on 1999-04-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-17 Gregorian' );
Trewsday 25 Astron 7463
EOT

$epoch = timelocal( 0, 0, 0, 18, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-04-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-04-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-04-18 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 1999-04-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 26 Astron 7463', 'as_string() on 1999-04-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-18 Gregorian' );
Hevensday 26 Astron 7463
EOT

$epoch = timelocal( 0, 0, 0, 19, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-04-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-04-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-04-19 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 1999-04-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 27 Astron 7463', 'as_string() on 1999-04-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-19 Gregorian' );
Mersday 27 Astron 7463
EOT

$epoch = timelocal( 0, 0, 0, 20, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-04-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-04-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-04-20 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 1999-04-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 28 Astron 7463', 'as_string() on 1999-04-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-20 Gregorian' );
Highday 28 Astron 7463
EOT

$epoch = timelocal( 0, 0, 0, 21, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-04-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-04-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-04-21 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 1999-04-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 29 Astron 7463', 'as_string() on 1999-04-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-21 Gregorian' );
Sterday 29 Astron 7463
EOT

$epoch = timelocal( 0, 0, 0, 22, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-04-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-04-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 1999-04-22 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 1999-04-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 30 Astron 7463', 'as_string() on 1999-04-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-22 Gregorian' );
Sunday 30 Astron 7463
EOT

$epoch = timelocal( 0, 0, 0, 23, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-04-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-04-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-04-23 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 1999-04-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 1 Thrimidge 7463', 'as_string() on 1999-04-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-23 Gregorian' );
Monday 1 Thrimidge 7463

Crowning of King Elessar, 1419.
Samwise marries Rose, 1420.
EOT

$epoch = timelocal( 0, 0, 0, 24, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-04-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-04-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-04-24 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 1999-04-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 2 Thrimidge 7463', 'as_string() on 1999-04-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-24 Gregorian' );
Trewsday 2 Thrimidge 7463
EOT

$epoch = timelocal( 0, 0, 0, 25, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-04-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-04-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-04-25 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 1999-04-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 3 Thrimidge 7463', 'as_string() on 1999-04-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-25 Gregorian' );
Hevensday 3 Thrimidge 7463
EOT

$epoch = timelocal( 0, 0, 0, 26, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-04-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-04-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-04-26 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 1999-04-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 4 Thrimidge 7463', 'as_string() on 1999-04-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-26 Gregorian' );
Mersday 4 Thrimidge 7463
EOT

$epoch = timelocal( 0, 0, 0, 27, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-04-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-04-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-04-27 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 1999-04-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 5 Thrimidge 7463', 'as_string() on 1999-04-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-27 Gregorian' );
Highday 5 Thrimidge 7463
EOT

$epoch = timelocal( 0, 0, 0, 28, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-04-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-04-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-04-28 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 1999-04-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 6 Thrimidge 7463', 'as_string() on 1999-04-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-28 Gregorian' );
Sterday 6 Thrimidge 7463
EOT

$epoch = timelocal( 0, 0, 0, 29, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-04-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-04-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-04-29 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 1999-04-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 7 Thrimidge 7463', 'as_string() on 1999-04-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-29 Gregorian' );
Sunday 7 Thrimidge 7463
EOT

$epoch = timelocal( 0, 0, 0, 30, 3, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-04-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-04-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-04-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-04-30 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 1999-04-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-04-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-04-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 8 Thrimidge 7463', 'as_string() on 1999-04-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-04-30 Gregorian' );
Monday 8 Thrimidge 7463
EOT

$epoch = timelocal( 0, 0, 0, 1, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-05-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-05-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-05-01 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 1999-05-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 9 Thrimidge 7463', 'as_string() on 1999-05-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-01 Gregorian' );
Trewsday 9 Thrimidge 7463
EOT

$epoch = timelocal( 0, 0, 0, 2, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-05-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-05-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-05-02 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 1999-05-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 10 Thrimidge 7463', 'as_string() on 1999-05-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-02 Gregorian' );
Hevensday 10 Thrimidge 7463
EOT

$epoch = timelocal( 0, 0, 0, 3, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-05-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-05-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-05-03 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 1999-05-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 11 Thrimidge 7463', 'as_string() on 1999-05-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-03 Gregorian' );
Mersday 11 Thrimidge 7463
EOT

$epoch = timelocal( 0, 0, 0, 4, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-05-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-05-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-05-04 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 1999-05-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 12 Thrimidge 7463', 'as_string() on 1999-05-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-04 Gregorian' );
Highday 12 Thrimidge 7463
EOT

$epoch = timelocal( 0, 0, 0, 5, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-05-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-05-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-05-05 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 1999-05-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 13 Thrimidge 7463', 'as_string() on 1999-05-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-05 Gregorian' );
Sterday 13 Thrimidge 7463
EOT

$epoch = timelocal( 0, 0, 0, 6, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-05-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-05-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-05-06 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 1999-05-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 14 Thrimidge 7463', 'as_string() on 1999-05-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-06 Gregorian' );
Sunday 14 Thrimidge 7463
EOT

$epoch = timelocal( 0, 0, 0, 7, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-05-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-05-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-05-07 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 1999-05-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 15 Thrimidge 7463', 'as_string() on 1999-05-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-07 Gregorian' );
Monday 15 Thrimidge 7463
EOT

$epoch = timelocal( 0, 0, 0, 8, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-05-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-05-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-05-08 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 1999-05-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 16 Thrimidge 7463', 'as_string() on 1999-05-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-08 Gregorian' );
Trewsday 16 Thrimidge 7463
EOT

$epoch = timelocal( 0, 0, 0, 9, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-05-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-05-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-05-09 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 1999-05-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 17 Thrimidge 7463', 'as_string() on 1999-05-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-09 Gregorian' );
Hevensday 17 Thrimidge 7463
EOT

$epoch = timelocal( 0, 0, 0, 10, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-05-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-05-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-05-10 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 1999-05-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 18 Thrimidge 7463', 'as_string() on 1999-05-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-10 Gregorian' );
Mersday 18 Thrimidge 7463
EOT

$epoch = timelocal( 0, 0, 0, 11, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-05-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-05-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-05-11 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 1999-05-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 19 Thrimidge 7463', 'as_string() on 1999-05-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-11 Gregorian' );
Highday 19 Thrimidge 7463
EOT

$epoch = timelocal( 0, 0, 0, 12, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-05-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-05-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-05-12 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 1999-05-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 20 Thrimidge 7463', 'as_string() on 1999-05-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-12 Gregorian' );
Sterday 20 Thrimidge 7463
EOT

$epoch = timelocal( 0, 0, 0, 13, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-05-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-05-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-05-13 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 1999-05-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 21 Thrimidge 7463', 'as_string() on 1999-05-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-13 Gregorian' );
Sunday 21 Thrimidge 7463
EOT

$epoch = timelocal( 0, 0, 0, 14, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-05-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-05-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-05-14 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 1999-05-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 22 Thrimidge 7463', 'as_string() on 1999-05-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-14 Gregorian' );
Monday 22 Thrimidge 7463
EOT

$epoch = timelocal( 0, 0, 0, 15, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-05-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-05-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-05-15 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 1999-05-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 23 Thrimidge 7463', 'as_string() on 1999-05-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-15 Gregorian' );
Trewsday 23 Thrimidge 7463
EOT

$epoch = timelocal( 0, 0, 0, 16, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-05-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-05-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-05-16 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 1999-05-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 24 Thrimidge 7463', 'as_string() on 1999-05-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-16 Gregorian' );
Hevensday 24 Thrimidge 7463
EOT

$epoch = timelocal( 0, 0, 0, 17, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-05-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-05-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-05-17 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 1999-05-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 25 Thrimidge 7463', 'as_string() on 1999-05-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-17 Gregorian' );
Mersday 25 Thrimidge 7463
EOT

$epoch = timelocal( 0, 0, 0, 18, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-05-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-05-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-05-18 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 1999-05-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 26 Thrimidge 7463', 'as_string() on 1999-05-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-18 Gregorian' );
Highday 26 Thrimidge 7463
EOT

$epoch = timelocal( 0, 0, 0, 19, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-05-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-05-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-05-19 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 1999-05-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 27 Thrimidge 7463', 'as_string() on 1999-05-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-19 Gregorian' );
Sterday 27 Thrimidge 7463
EOT

$epoch = timelocal( 0, 0, 0, 20, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-05-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-05-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-05-20 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 1999-05-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 28 Thrimidge 7463', 'as_string() on 1999-05-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-20 Gregorian' );
Sunday 28 Thrimidge 7463
EOT

$epoch = timelocal( 0, 0, 0, 21, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-05-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-05-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-05-21 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 1999-05-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 29 Thrimidge 7463', 'as_string() on 1999-05-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-21 Gregorian' );
Monday 29 Thrimidge 7463
EOT

$epoch = timelocal( 0, 0, 0, 22, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-05-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-05-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 1999-05-22 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 1999-05-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 30 Thrimidge 7463', 'as_string() on 1999-05-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-22 Gregorian' );
Trewsday 30 Thrimidge 7463
EOT

$epoch = timelocal( 0, 0, 0, 23, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-05-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-05-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-05-23 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 1999-05-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 1 Forelithe 7463', 'as_string() on 1999-05-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-23 Gregorian' );
Hevensday 1 Forelithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 24, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-05-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-05-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-05-24 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 1999-05-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 2 Forelithe 7463', 'as_string() on 1999-05-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-24 Gregorian' );
Mersday 2 Forelithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 25, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-05-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-05-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-05-25 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 1999-05-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 3 Forelithe 7463', 'as_string() on 1999-05-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-25 Gregorian' );
Highday 3 Forelithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 26, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-05-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-05-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-05-26 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 1999-05-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 4 Forelithe 7463', 'as_string() on 1999-05-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-26 Gregorian' );
Sterday 4 Forelithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 27, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-05-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-05-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-05-27 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 1999-05-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 5 Forelithe 7463', 'as_string() on 1999-05-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-27 Gregorian' );
Sunday 5 Forelithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 28, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-05-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-05-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-05-28 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 1999-05-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 6 Forelithe 7463', 'as_string() on 1999-05-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-28 Gregorian' );
Monday 6 Forelithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 29, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-05-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-05-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-05-29 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 1999-05-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 7 Forelithe 7463', 'as_string() on 1999-05-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-29 Gregorian' );
Trewsday 7 Forelithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 30, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-05-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-05-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-05-30 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 1999-05-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 8 Forelithe 7463', 'as_string() on 1999-05-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-30 Gregorian' );
Hevensday 8 Forelithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 31, 4, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-05-31 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-05-31 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-05-31 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-05-31 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 1999-05-31 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-05-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-05-31 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 9 Forelithe 7463', 'as_string() on 1999-05-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-05-31 Gregorian' );
Mersday 9 Forelithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 1, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-06-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-06-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-06-01 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 1999-06-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-06-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 10 Forelithe 7463', 'as_string() on 1999-06-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-01 Gregorian' );
Highday 10 Forelithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 2, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-06-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-06-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-06-02 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 1999-06-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-06-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 11 Forelithe 7463', 'as_string() on 1999-06-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-02 Gregorian' );
Sterday 11 Forelithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 3, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-06-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-06-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-06-03 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 1999-06-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-06-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 12 Forelithe 7463', 'as_string() on 1999-06-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-03 Gregorian' );
Sunday 12 Forelithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 4, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-06-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-06-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-06-04 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 1999-06-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-06-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 13 Forelithe 7463', 'as_string() on 1999-06-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-04 Gregorian' );
Monday 13 Forelithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 5, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-06-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-06-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-06-05 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 1999-06-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-06-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 14 Forelithe 7463', 'as_string() on 1999-06-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-05 Gregorian' );
Trewsday 14 Forelithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 6, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-06-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-06-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-06-06 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 1999-06-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-06-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 15 Forelithe 7463', 'as_string() on 1999-06-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-06 Gregorian' );
Hevensday 15 Forelithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 7, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-06-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-06-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-06-07 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 1999-06-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-06-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 16 Forelithe 7463', 'as_string() on 1999-06-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-07 Gregorian' );
Mersday 16 Forelithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 8, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-06-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-06-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-06-08 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 1999-06-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-06-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 17 Forelithe 7463', 'as_string() on 1999-06-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-08 Gregorian' );
Highday 17 Forelithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 9, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-06-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-06-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-06-09 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 1999-06-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-06-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 18 Forelithe 7463', 'as_string() on 1999-06-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-09 Gregorian' );
Sterday 18 Forelithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 10, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-06-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-06-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-06-10 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 1999-06-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-06-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 19 Forelithe 7463', 'as_string() on 1999-06-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-10 Gregorian' );
Sunday 19 Forelithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 11, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-06-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-06-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-06-11 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 1999-06-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-06-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 20 Forelithe 7463', 'as_string() on 1999-06-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-11 Gregorian' );
Monday 20 Forelithe 7463

Sauron attacks Osgiliath, 1418.
Thranduil is attacked, and Gollum escapes, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 12, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-06-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-06-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-06-12 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 1999-06-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-06-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 21 Forelithe 7463', 'as_string() on 1999-06-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-12 Gregorian' );
Trewsday 21 Forelithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 13, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-06-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-06-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-06-13 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 1999-06-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-06-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 22 Forelithe 7463', 'as_string() on 1999-06-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-13 Gregorian' );
Hevensday 22 Forelithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 14, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-06-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-06-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-06-14 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 1999-06-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-06-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 23 Forelithe 7463', 'as_string() on 1999-06-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-14 Gregorian' );
Mersday 23 Forelithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 15, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-06-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-06-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-06-15 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 1999-06-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-06-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 24 Forelithe 7463', 'as_string() on 1999-06-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-15 Gregorian' );
Highday 24 Forelithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 16, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-06-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-06-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-06-16 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 1999-06-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-06-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 25 Forelithe 7463', 'as_string() on 1999-06-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-16 Gregorian' );
Sterday 25 Forelithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 17, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-06-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-06-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-06-17 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 1999-06-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-06-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 26 Forelithe 7463', 'as_string() on 1999-06-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-17 Gregorian' );
Sunday 26 Forelithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 18, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-06-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-06-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-06-18 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 1999-06-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-06-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 27 Forelithe 7463', 'as_string() on 1999-06-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-18 Gregorian' );
Monday 27 Forelithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 19, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-06-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-06-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-06-19 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 1999-06-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-06-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 28 Forelithe 7463', 'as_string() on 1999-06-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-19 Gregorian' );
Trewsday 28 Forelithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 20, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-06-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-06-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-06-20 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 1999-06-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-06-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 29 Forelithe 7463', 'as_string() on 1999-06-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-20 Gregorian' );
Hevensday 29 Forelithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 21, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-06-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-06-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 1999-06-21 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 1999-06-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-06-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 30 Forelithe 7463', 'as_string() on 1999-06-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-21 Gregorian' );
Mersday 30 Forelithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 22, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-06-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-06-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', '', 'month() on 1999-06-22 Gregorian' );
cmp_ok( $dts->day(), '==', 0, 'day() on 1999-06-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '1 Lithe', 'holiday() on 1999-06-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 1 Lithe 7463', 'as_string() on 1999-06-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-22 Gregorian' );
Highday 1 Lithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 23, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', '', 'weekday() on 1999-06-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', '', 'trad_weekday() on 1999-06-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', '', 'month() on 1999-06-23 Gregorian' );
cmp_ok( $dts->day(), '==', 0, 'day() on 1999-06-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', 'Midyear\'s day', 'holiday() on 1999-06-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Midyear\'s day 7463', 'as_string() on 1999-06-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-23 Gregorian' );
Midyear's day 7463

Wedding of King Elessar and Arwen, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 24, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-06-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-06-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', '', 'month() on 1999-06-24 Gregorian' );
cmp_ok( $dts->day(), '==', 0, 'day() on 1999-06-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '2 Lithe', 'holiday() on 1999-06-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 2 Lithe 7463', 'as_string() on 1999-06-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-24 Gregorian' );
Sterday 2 Lithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 25, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-06-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-06-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-06-25 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 1999-06-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-06-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 1 Afterlithe 7463', 'as_string() on 1999-06-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-25 Gregorian' );
Sunday 1 Afterlithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 26, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-06-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-06-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-06-26 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 1999-06-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-06-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 2 Afterlithe 7463', 'as_string() on 1999-06-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-26 Gregorian' );
Monday 2 Afterlithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 27, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-06-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-06-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-06-27 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 1999-06-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-06-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 3 Afterlithe 7463', 'as_string() on 1999-06-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-27 Gregorian' );
Trewsday 3 Afterlithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 28, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-06-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-06-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-06-28 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 1999-06-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-06-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 4 Afterlithe 7463', 'as_string() on 1999-06-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-28 Gregorian' );
Hevensday 4 Afterlithe 7463

Boromir sets out from Minas Tirith, 1418
EOT

$epoch = timelocal( 0, 0, 0, 29, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-06-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-06-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-06-29 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 1999-06-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-06-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 5 Afterlithe 7463', 'as_string() on 1999-06-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-29 Gregorian' );
Mersday 5 Afterlithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 30, 5, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-06-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-06-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-06-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-06-30 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 1999-06-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-06-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-06-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 6 Afterlithe 7463', 'as_string() on 1999-06-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-06-30 Gregorian' );
Highday 6 Afterlithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 1, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-07-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-07-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-07-01 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 1999-07-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 7 Afterlithe 7463', 'as_string() on 1999-07-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-01 Gregorian' );
Sterday 7 Afterlithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 2, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-07-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-07-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-07-02 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 1999-07-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 8 Afterlithe 7463', 'as_string() on 1999-07-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-02 Gregorian' );
Sunday 8 Afterlithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 3, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-07-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-07-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-07-03 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 1999-07-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 9 Afterlithe 7463', 'as_string() on 1999-07-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-03 Gregorian' );
Monday 9 Afterlithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 4, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-07-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-07-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-07-04 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 1999-07-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 10 Afterlithe 7463', 'as_string() on 1999-07-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-04 Gregorian' );
Trewsday 10 Afterlithe 7463

Gandalf imprisoned in Orthanc, 1418
EOT

$epoch = timelocal( 0, 0, 0, 5, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-07-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-07-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-07-05 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 1999-07-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 11 Afterlithe 7463', 'as_string() on 1999-07-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-05 Gregorian' );
Hevensday 11 Afterlithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 6, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-07-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-07-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-07-06 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 1999-07-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 12 Afterlithe 7463', 'as_string() on 1999-07-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-06 Gregorian' );
Mersday 12 Afterlithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 7, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-07-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-07-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-07-07 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 1999-07-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 13 Afterlithe 7463', 'as_string() on 1999-07-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-07 Gregorian' );
Highday 13 Afterlithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 8, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-07-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-07-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-07-08 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 1999-07-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 14 Afterlithe 7463', 'as_string() on 1999-07-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-08 Gregorian' );
Sterday 14 Afterlithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 9, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-07-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-07-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-07-09 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 1999-07-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 15 Afterlithe 7463', 'as_string() on 1999-07-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-09 Gregorian' );
Sunday 15 Afterlithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 10, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-07-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-07-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-07-10 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 1999-07-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 16 Afterlithe 7463', 'as_string() on 1999-07-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-10 Gregorian' );
Monday 16 Afterlithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 11, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-07-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-07-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-07-11 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 1999-07-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 17 Afterlithe 7463', 'as_string() on 1999-07-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-11 Gregorian' );
Trewsday 17 Afterlithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 12, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-07-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-07-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-07-12 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 1999-07-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 18 Afterlithe 7463', 'as_string() on 1999-07-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-12 Gregorian' );
Hevensday 18 Afterlithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 13, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-07-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-07-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-07-13 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 1999-07-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 19 Afterlithe 7463', 'as_string() on 1999-07-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-13 Gregorian' );
Mersday 19 Afterlithe 7463

Funeral Escort of King Theoden leaves Minas Tirith, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 14, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-07-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-07-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-07-14 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 1999-07-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 20 Afterlithe 7463', 'as_string() on 1999-07-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-14 Gregorian' );
Highday 20 Afterlithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 15, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-07-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-07-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-07-15 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 1999-07-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 21 Afterlithe 7463', 'as_string() on 1999-07-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-15 Gregorian' );
Sterday 21 Afterlithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 16, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-07-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-07-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-07-16 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 1999-07-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 22 Afterlithe 7463', 'as_string() on 1999-07-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-16 Gregorian' );
Sunday 22 Afterlithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 17, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-07-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-07-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-07-17 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 1999-07-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 23 Afterlithe 7463', 'as_string() on 1999-07-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-17 Gregorian' );
Monday 23 Afterlithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 18, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-07-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-07-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-07-18 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 1999-07-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 24 Afterlithe 7463', 'as_string() on 1999-07-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-18 Gregorian' );
Trewsday 24 Afterlithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 19, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-07-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-07-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-07-19 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 1999-07-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 25 Afterlithe 7463', 'as_string() on 1999-07-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-19 Gregorian' );
Hevensday 25 Afterlithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 20, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-07-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-07-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-07-20 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 1999-07-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 26 Afterlithe 7463', 'as_string() on 1999-07-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-20 Gregorian' );
Mersday 26 Afterlithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 21, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-07-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-07-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-07-21 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 1999-07-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 27 Afterlithe 7463', 'as_string() on 1999-07-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-21 Gregorian' );
Highday 27 Afterlithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 22, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-07-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-07-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-07-22 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 1999-07-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 28 Afterlithe 7463', 'as_string() on 1999-07-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-22 Gregorian' );
Sterday 28 Afterlithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 23, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-07-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-07-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-07-23 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 1999-07-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 29 Afterlithe 7463', 'as_string() on 1999-07-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-23 Gregorian' );
Sunday 29 Afterlithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 24, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-07-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-07-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 1999-07-24 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 1999-07-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 30 Afterlithe 7463', 'as_string() on 1999-07-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-24 Gregorian' );
Monday 30 Afterlithe 7463
EOT

$epoch = timelocal( 0, 0, 0, 25, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-07-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-07-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-07-25 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 1999-07-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 1 Wedmath 7463', 'as_string() on 1999-07-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-25 Gregorian' );
Trewsday 1 Wedmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 26, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-07-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-07-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-07-26 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 1999-07-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 2 Wedmath 7463', 'as_string() on 1999-07-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-26 Gregorian' );
Hevensday 2 Wedmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 27, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-07-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-07-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-07-27 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 1999-07-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 3 Wedmath 7463', 'as_string() on 1999-07-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-27 Gregorian' );
Mersday 3 Wedmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 28, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-07-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-07-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-07-28 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 1999-07-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 4 Wedmath 7463', 'as_string() on 1999-07-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-28 Gregorian' );
Highday 4 Wedmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 29, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-07-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-07-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-07-29 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 1999-07-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 5 Wedmath 7463', 'as_string() on 1999-07-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-29 Gregorian' );
Sterday 5 Wedmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 30, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-07-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-07-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-07-30 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 1999-07-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 6 Wedmath 7463', 'as_string() on 1999-07-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-30 Gregorian' );
Sunday 6 Wedmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 31, 6, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-07-31 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-07-31 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-07-31 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-07-31 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 1999-07-31 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-07-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-07-31 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 7 Wedmath 7463', 'as_string() on 1999-07-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-07-31 Gregorian' );
Monday 7 Wedmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 1, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-08-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-08-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-08-01 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 1999-08-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 8 Wedmath 7463', 'as_string() on 1999-08-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-01 Gregorian' );
Trewsday 8 Wedmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 2, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-08-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-08-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-08-02 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 1999-08-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 9 Wedmath 7463', 'as_string() on 1999-08-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-02 Gregorian' );
Hevensday 9 Wedmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 3, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-08-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-08-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-08-03 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 1999-08-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 10 Wedmath 7463', 'as_string() on 1999-08-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-03 Gregorian' );
Mersday 10 Wedmath 7463

Funeral of King Theoden, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 4, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-08-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-08-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-08-04 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 1999-08-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 11 Wedmath 7463', 'as_string() on 1999-08-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-04 Gregorian' );
Highday 11 Wedmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 5, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-08-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-08-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-08-05 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 1999-08-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 12 Wedmath 7463', 'as_string() on 1999-08-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-05 Gregorian' );
Sterday 12 Wedmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 6, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-08-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-08-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-08-06 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 1999-08-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 13 Wedmath 7463', 'as_string() on 1999-08-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-06 Gregorian' );
Sunday 13 Wedmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 7, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-08-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-08-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-08-07 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 1999-08-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 14 Wedmath 7463', 'as_string() on 1999-08-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-07 Gregorian' );
Monday 14 Wedmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 8, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-08-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-08-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-08-08 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 1999-08-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 15 Wedmath 7463', 'as_string() on 1999-08-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-08 Gregorian' );
Trewsday 15 Wedmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 9, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-08-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-08-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-08-09 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 1999-08-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 16 Wedmath 7463', 'as_string() on 1999-08-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-09 Gregorian' );
Hevensday 16 Wedmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 10, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-08-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-08-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-08-10 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 1999-08-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 17 Wedmath 7463', 'as_string() on 1999-08-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-10 Gregorian' );
Mersday 17 Wedmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 11, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-08-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-08-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-08-11 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 1999-08-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 18 Wedmath 7463', 'as_string() on 1999-08-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-11 Gregorian' );
Highday 18 Wedmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 12, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-08-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-08-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-08-12 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 1999-08-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 19 Wedmath 7463', 'as_string() on 1999-08-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-12 Gregorian' );
Sterday 19 Wedmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 13, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-08-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-08-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-08-13 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 1999-08-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 20 Wedmath 7463', 'as_string() on 1999-08-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-13 Gregorian' );
Sunday 20 Wedmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 14, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-08-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-08-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-08-14 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 1999-08-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 21 Wedmath 7463', 'as_string() on 1999-08-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-14 Gregorian' );
Monday 21 Wedmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 15, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-08-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-08-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-08-15 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 1999-08-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 22 Wedmath 7463', 'as_string() on 1999-08-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-15 Gregorian' );
Trewsday 22 Wedmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 16, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-08-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-08-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-08-16 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 1999-08-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 23 Wedmath 7463', 'as_string() on 1999-08-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-16 Gregorian' );
Hevensday 23 Wedmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 17, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-08-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-08-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-08-17 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 1999-08-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 24 Wedmath 7463', 'as_string() on 1999-08-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-17 Gregorian' );
Mersday 24 Wedmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 18, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-08-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-08-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-08-18 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 1999-08-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 25 Wedmath 7463', 'as_string() on 1999-08-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-18 Gregorian' );
Highday 25 Wedmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 19, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-08-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-08-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-08-19 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 1999-08-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 26 Wedmath 7463', 'as_string() on 1999-08-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-19 Gregorian' );
Sterday 26 Wedmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 20, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-08-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-08-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-08-20 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 1999-08-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 27 Wedmath 7463', 'as_string() on 1999-08-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-20 Gregorian' );
Sunday 27 Wedmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 21, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-08-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-08-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-08-21 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 1999-08-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 28 Wedmath 7463', 'as_string() on 1999-08-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-21 Gregorian' );
Monday 28 Wedmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 22, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-08-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-08-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-08-22 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 1999-08-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 29 Wedmath 7463', 'as_string() on 1999-08-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-22 Gregorian' );
Trewsday 29 Wedmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 23, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-08-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-08-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 1999-08-23 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 1999-08-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 30 Wedmath 7463', 'as_string() on 1999-08-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-23 Gregorian' );
Hevensday 30 Wedmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 24, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-08-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-08-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-08-24 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 1999-08-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 1 Halimath 7463', 'as_string() on 1999-08-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-24 Gregorian' );
Mersday 1 Halimath 7463
EOT

$epoch = timelocal( 0, 0, 0, 25, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-08-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-08-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-08-25 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 1999-08-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 2 Halimath 7463', 'as_string() on 1999-08-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-25 Gregorian' );
Highday 2 Halimath 7463
EOT

$epoch = timelocal( 0, 0, 0, 26, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-08-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-08-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-08-26 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 1999-08-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 3 Halimath 7463', 'as_string() on 1999-08-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-26 Gregorian' );
Sterday 3 Halimath 7463
EOT

$epoch = timelocal( 0, 0, 0, 27, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-08-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-08-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-08-27 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 1999-08-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 4 Halimath 7463', 'as_string() on 1999-08-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-27 Gregorian' );
Sunday 4 Halimath 7463
EOT

$epoch = timelocal( 0, 0, 0, 28, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-08-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-08-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-08-28 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 1999-08-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 5 Halimath 7463', 'as_string() on 1999-08-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-28 Gregorian' );
Monday 5 Halimath 7463
EOT

$epoch = timelocal( 0, 0, 0, 29, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-08-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-08-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-08-29 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 1999-08-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 6 Halimath 7463', 'as_string() on 1999-08-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-29 Gregorian' );
Trewsday 6 Halimath 7463
EOT

$epoch = timelocal( 0, 0, 0, 30, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-08-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-08-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-08-30 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 1999-08-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 7 Halimath 7463', 'as_string() on 1999-08-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-30 Gregorian' );
Hevensday 7 Halimath 7463
EOT

$epoch = timelocal( 0, 0, 0, 31, 7, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-08-31 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-08-31 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-08-31 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-08-31 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 1999-08-31 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-08-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-08-31 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 8 Halimath 7463', 'as_string() on 1999-08-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-08-31 Gregorian' );
Mersday 8 Halimath 7463
EOT

$epoch = timelocal( 0, 0, 0, 1, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-09-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-09-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-09-01 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 1999-09-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 9 Halimath 7463', 'as_string() on 1999-09-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-01 Gregorian' );
Highday 9 Halimath 7463
EOT

$epoch = timelocal( 0, 0, 0, 2, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-09-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-09-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-09-02 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 1999-09-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 10 Halimath 7463', 'as_string() on 1999-09-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-02 Gregorian' );
Sterday 10 Halimath 7463
EOT

$epoch = timelocal( 0, 0, 0, 3, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-09-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-09-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-09-03 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 1999-09-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 11 Halimath 7463', 'as_string() on 1999-09-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-03 Gregorian' );
Sunday 11 Halimath 7463
EOT

$epoch = timelocal( 0, 0, 0, 4, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-09-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-09-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-09-04 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 1999-09-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 12 Halimath 7463', 'as_string() on 1999-09-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-04 Gregorian' );
Monday 12 Halimath 7463
EOT

$epoch = timelocal( 0, 0, 0, 5, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-09-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-09-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-09-05 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 1999-09-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 13 Halimath 7463', 'as_string() on 1999-09-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-05 Gregorian' );
Trewsday 13 Halimath 7463
EOT

$epoch = timelocal( 0, 0, 0, 6, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-09-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-09-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-09-06 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 1999-09-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 14 Halimath 7463', 'as_string() on 1999-09-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-06 Gregorian' );
Hevensday 14 Halimath 7463
EOT

$epoch = timelocal( 0, 0, 0, 7, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-09-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-09-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-09-07 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 1999-09-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 15 Halimath 7463', 'as_string() on 1999-09-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-07 Gregorian' );
Mersday 15 Halimath 7463
EOT

$epoch = timelocal( 0, 0, 0, 8, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-09-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-09-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-09-08 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 1999-09-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 16 Halimath 7463', 'as_string() on 1999-09-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-08 Gregorian' );
Highday 16 Halimath 7463
EOT

$epoch = timelocal( 0, 0, 0, 9, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-09-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-09-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-09-09 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 1999-09-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 17 Halimath 7463', 'as_string() on 1999-09-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-09 Gregorian' );
Sterday 17 Halimath 7463
EOT

$epoch = timelocal( 0, 0, 0, 10, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-09-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-09-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-09-10 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 1999-09-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 18 Halimath 7463', 'as_string() on 1999-09-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-10 Gregorian' );
Sunday 18 Halimath 7463

Gandalf escapes from Orthanc in the early hours, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 11, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-09-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-09-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-09-11 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 1999-09-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 19 Halimath 7463', 'as_string() on 1999-09-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-11 Gregorian' );
Monday 19 Halimath 7463

Gandalf comes to Edoras as a beggar, and is refused admittance, 1418
EOT

$epoch = timelocal( 0, 0, 0, 12, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-09-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-09-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-09-12 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 1999-09-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 20 Halimath 7463', 'as_string() on 1999-09-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-12 Gregorian' );
Trewsday 20 Halimath 7463

Gandalf gains entrance to Edoras.  Theoden commands him to go:
"Take any horse, only be gone ere tomorrow is old", 1418.
EOT

$epoch = timelocal( 0, 0, 0, 13, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-09-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-09-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-09-13 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 1999-09-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 21 Halimath 7463', 'as_string() on 1999-09-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-13 Gregorian' );
Hevensday 21 Halimath 7463

The hobbits return to Rivendell, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 14, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-09-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-09-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-09-14 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 1999-09-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 22 Halimath 7463', 'as_string() on 1999-09-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-14 Gregorian' );
Mersday 22 Halimath 7463

Birthday of Bilbo and Frodo.
The Black Riders reach Sarn Ford at evening;
  they drive off the guard of Rangers, 1418.
Saruman comes to the Shire, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 15, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-09-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-09-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-09-15 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 1999-09-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 23 Halimath 7463', 'as_string() on 1999-09-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-15 Gregorian' );
Highday 23 Halimath 7463

Four Black Riders enter the shire before dawn.  The others pursue 
the Rangers eastward and then return to watch the Greenway, 1418.
A Black Rider comes to Hobbiton at nightfall, 1418.
Frodo leaves Bag End, 1418.
Gandalf having tamed Shadowfax rides from Rohan, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 16, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-09-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-09-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-09-16 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 1999-09-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 24 Halimath 7463', 'as_string() on 1999-09-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-16 Gregorian' );
Sterday 24 Halimath 7463
EOT

$epoch = timelocal( 0, 0, 0, 17, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-09-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-09-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-09-17 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 1999-09-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 25 Halimath 7463', 'as_string() on 1999-09-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-17 Gregorian' );
Sunday 25 Halimath 7463
EOT

$epoch = timelocal( 0, 0, 0, 18, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-09-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-09-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-09-18 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 1999-09-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 26 Halimath 7463', 'as_string() on 1999-09-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-18 Gregorian' );
Monday 26 Halimath 7463

Frodo comes to Bombadil, 1418
EOT

$epoch = timelocal( 0, 0, 0, 19, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-09-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-09-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-09-19 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 1999-09-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 27 Halimath 7463', 'as_string() on 1999-09-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-19 Gregorian' );
Trewsday 27 Halimath 7463
EOT

$epoch = timelocal( 0, 0, 0, 20, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-09-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-09-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-09-20 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 1999-09-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 28 Halimath 7463', 'as_string() on 1999-09-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-20 Gregorian' );
Hevensday 28 Halimath 7463

The Hobbits are captured by a barrow-wight, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 21, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-09-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-09-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-09-21 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 1999-09-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 29 Halimath 7463', 'as_string() on 1999-09-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-21 Gregorian' );
Mersday 29 Halimath 7463

Frodo reaches Bree at night, 1418.
Frodo and Bilbo depart over the sea with the three Keepers, 1421.
End of the Third Age, 1421.
EOT

$epoch = timelocal( 0, 0, 0, 22, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-09-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-09-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 1999-09-22 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 1999-09-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 30 Halimath 7463', 'as_string() on 1999-09-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-22 Gregorian' );
Highday 30 Halimath 7463

Crickhollow and the inn at Bree are raided in the early hours, 1418.
Frodo leaves Bree, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 23, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-09-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-09-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-09-23 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 1999-09-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 1 Winterfilth 7463', 'as_string() on 1999-09-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-23 Gregorian' );
Sterday 1 Winterfilth 7463
EOT

$epoch = timelocal( 0, 0, 0, 24, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-09-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-09-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-09-24 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 1999-09-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 2 Winterfilth 7463', 'as_string() on 1999-09-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-24 Gregorian' );
Sunday 2 Winterfilth 7463
EOT

$epoch = timelocal( 0, 0, 0, 25, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-09-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-09-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-09-25 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 1999-09-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 3 Winterfilth 7463', 'as_string() on 1999-09-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-25 Gregorian' );
Monday 3 Winterfilth 7463

Gandalf attacked at night on Weathertop, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 26, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-09-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-09-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-09-26 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 1999-09-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 4 Winterfilth 7463', 'as_string() on 1999-09-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-26 Gregorian' );
Trewsday 4 Winterfilth 7463
EOT

$epoch = timelocal( 0, 0, 0, 27, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-09-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-09-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-09-27 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 1999-09-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 5 Winterfilth 7463', 'as_string() on 1999-09-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-27 Gregorian' );
Hevensday 5 Winterfilth 7463

Gandalf and the Hobbits leave Rivendell, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 28, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-09-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-09-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-09-28 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 1999-09-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 6 Winterfilth 7463', 'as_string() on 1999-09-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-28 Gregorian' );
Mersday 6 Winterfilth 7463

The camp under Weathertop is attacked at night and Frodo is wounded, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 29, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-09-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-09-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-09-29 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 1999-09-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 7 Winterfilth 7463', 'as_string() on 1999-09-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-29 Gregorian' );
Highday 7 Winterfilth 7463
EOT

$epoch = timelocal( 0, 0, 0, 30, 8, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-09-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-09-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-09-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-09-30 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 1999-09-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-09-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-09-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 8 Winterfilth 7463', 'as_string() on 1999-09-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-09-30 Gregorian' );
Sterday 8 Winterfilth 7463
EOT

$epoch = timelocal( 0, 0, 0, 1, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-10-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-10-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-10-01 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 1999-10-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 9 Winterfilth 7463', 'as_string() on 1999-10-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-01 Gregorian' );
Sunday 9 Winterfilth 7463
EOT

$epoch = timelocal( 0, 0, 0, 2, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-10-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-10-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-10-02 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 1999-10-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 10 Winterfilth 7463', 'as_string() on 1999-10-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-02 Gregorian' );
Monday 10 Winterfilth 7463
EOT

$epoch = timelocal( 0, 0, 0, 3, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-10-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-10-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-10-03 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 1999-10-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 11 Winterfilth 7463', 'as_string() on 1999-10-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-03 Gregorian' );
Trewsday 11 Winterfilth 7463

Glorfindel drives the Black Riders off the Bridge of Mitheithel, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 4, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-10-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-10-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-10-04 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 1999-10-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 12 Winterfilth 7463', 'as_string() on 1999-10-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-04 Gregorian' );
Hevensday 12 Winterfilth 7463
EOT

$epoch = timelocal( 0, 0, 0, 5, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-10-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-10-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-10-05 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 1999-10-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 13 Winterfilth 7463', 'as_string() on 1999-10-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-05 Gregorian' );
Mersday 13 Winterfilth 7463

Frodo crosses the Bridge of Mitheithel, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 6, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-10-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-10-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-10-06 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 1999-10-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 14 Winterfilth 7463', 'as_string() on 1999-10-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-06 Gregorian' );
Highday 14 Winterfilth 7463
EOT

$epoch = timelocal( 0, 0, 0, 7, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-10-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-10-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-10-07 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 1999-10-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 15 Winterfilth 7463', 'as_string() on 1999-10-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-07 Gregorian' );
Sterday 15 Winterfilth 7463
EOT

$epoch = timelocal( 0, 0, 0, 8, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-10-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-10-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-10-08 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 1999-10-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 16 Winterfilth 7463', 'as_string() on 1999-10-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-08 Gregorian' );
Sunday 16 Winterfilth 7463
EOT

$epoch = timelocal( 0, 0, 0, 9, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-10-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-10-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-10-09 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 1999-10-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 17 Winterfilth 7463', 'as_string() on 1999-10-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-09 Gregorian' );
Monday 17 Winterfilth 7463
EOT

$epoch = timelocal( 0, 0, 0, 10, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-10-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-10-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-10-10 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 1999-10-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 18 Winterfilth 7463', 'as_string() on 1999-10-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-10 Gregorian' );
Trewsday 18 Winterfilth 7463

Glorfindel finds Frodo at dusk, 1418.
Gandalf reaches Rivendell, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 11, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-10-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-10-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-10-11 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 1999-10-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 19 Winterfilth 7463', 'as_string() on 1999-10-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-11 Gregorian' );
Hevensday 19 Winterfilth 7463
EOT

$epoch = timelocal( 0, 0, 0, 12, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-10-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-10-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-10-12 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 1999-10-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 20 Winterfilth 7463', 'as_string() on 1999-10-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-12 Gregorian' );
Mersday 20 Winterfilth 7463

Escape across the Ford of Bruinen, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 13, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-10-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-10-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-10-13 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 1999-10-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 21 Winterfilth 7463', 'as_string() on 1999-10-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-13 Gregorian' );
Highday 21 Winterfilth 7463
EOT

$epoch = timelocal( 0, 0, 0, 14, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-10-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-10-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-10-14 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 1999-10-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 22 Winterfilth 7463', 'as_string() on 1999-10-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-14 Gregorian' );
Sterday 22 Winterfilth 7463
EOT

$epoch = timelocal( 0, 0, 0, 15, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-10-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-10-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-10-15 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 1999-10-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 23 Winterfilth 7463', 'as_string() on 1999-10-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-15 Gregorian' );
Sunday 23 Winterfilth 7463
EOT

$epoch = timelocal( 0, 0, 0, 16, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-10-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-10-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-10-16 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 1999-10-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 24 Winterfilth 7463', 'as_string() on 1999-10-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-16 Gregorian' );
Monday 24 Winterfilth 7463

Frodo recovers and wakes, 1418.
Boromir arrives at Rivendell at night, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 17, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-10-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-10-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-10-17 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 1999-10-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 25 Winterfilth 7463', 'as_string() on 1999-10-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-17 Gregorian' );
Trewsday 25 Winterfilth 7463

Council of Elrond, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 18, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-10-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-10-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-10-18 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 1999-10-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 26 Winterfilth 7463', 'as_string() on 1999-10-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-18 Gregorian' );
Hevensday 26 Winterfilth 7463
EOT

$epoch = timelocal( 0, 0, 0, 19, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-10-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-10-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-10-19 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 1999-10-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 27 Winterfilth 7463', 'as_string() on 1999-10-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-19 Gregorian' );
Mersday 27 Winterfilth 7463
EOT

$epoch = timelocal( 0, 0, 0, 20, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-10-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-10-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-10-20 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 1999-10-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 28 Winterfilth 7463', 'as_string() on 1999-10-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-20 Gregorian' );
Highday 28 Winterfilth 7463
EOT

$epoch = timelocal( 0, 0, 0, 21, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-10-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-10-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-10-21 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 1999-10-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 29 Winterfilth 7463', 'as_string() on 1999-10-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-21 Gregorian' );
Sterday 29 Winterfilth 7463
EOT

$epoch = timelocal( 0, 0, 0, 22, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-10-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-10-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 1999-10-22 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 1999-10-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 30 Winterfilth 7463', 'as_string() on 1999-10-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-22 Gregorian' );
Sunday 30 Winterfilth 7463

The four Hobbits arrive at the Brandywine Bridge in the dark, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 23, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-10-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-10-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-10-23 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 1999-10-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 1 Blotmath 7463', 'as_string() on 1999-10-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-23 Gregorian' );
Monday 1 Blotmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 24, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-10-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-10-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-10-24 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 1999-10-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 2 Blotmath 7463', 'as_string() on 1999-10-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-24 Gregorian' );
Trewsday 2 Blotmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 25, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-10-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-10-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-10-25 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 1999-10-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 3 Blotmath 7463', 'as_string() on 1999-10-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-25 Gregorian' );
Hevensday 3 Blotmath 7463

Battle of Bywater and passing of Saruman, 1419.
End of the War of the Ring, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 26, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-10-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-10-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-10-26 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 1999-10-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 4 Blotmath 7463', 'as_string() on 1999-10-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-26 Gregorian' );
Mersday 4 Blotmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 27, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-10-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-10-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-10-27 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 1999-10-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 5 Blotmath 7463', 'as_string() on 1999-10-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-27 Gregorian' );
Highday 5 Blotmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 28, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-10-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-10-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-10-28 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 1999-10-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 6 Blotmath 7463', 'as_string() on 1999-10-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-28 Gregorian' );
Sterday 6 Blotmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 29, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-10-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-10-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-10-29 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 1999-10-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 7 Blotmath 7463', 'as_string() on 1999-10-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-29 Gregorian' );
Sunday 7 Blotmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 30, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-10-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-10-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-10-30 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 1999-10-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 8 Blotmath 7463', 'as_string() on 1999-10-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-30 Gregorian' );
Monday 8 Blotmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 31, 9, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-10-31 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-10-31 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-10-31 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-10-31 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 1999-10-31 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-10-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-10-31 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 9 Blotmath 7463', 'as_string() on 1999-10-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-10-31 Gregorian' );
Trewsday 9 Blotmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 1, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-11-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-11-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-11-01 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 1999-11-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 10 Blotmath 7463', 'as_string() on 1999-11-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-01 Gregorian' );
Hevensday 10 Blotmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 2, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-11-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-11-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-11-02 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 1999-11-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 11 Blotmath 7463', 'as_string() on 1999-11-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-02 Gregorian' );
Mersday 11 Blotmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 3, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-11-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-11-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-11-03 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 1999-11-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 12 Blotmath 7463', 'as_string() on 1999-11-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-03 Gregorian' );
Highday 12 Blotmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 4, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-11-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-11-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-11-04 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 1999-11-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 13 Blotmath 7463', 'as_string() on 1999-11-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-04 Gregorian' );
Sterday 13 Blotmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 5, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-11-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-11-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-11-05 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 1999-11-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 14 Blotmath 7463', 'as_string() on 1999-11-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-05 Gregorian' );
Sunday 14 Blotmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 6, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-11-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-11-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-11-06 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 1999-11-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 15 Blotmath 7463', 'as_string() on 1999-11-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-06 Gregorian' );
Monday 15 Blotmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 7, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-11-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-11-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-11-07 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 1999-11-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 16 Blotmath 7463', 'as_string() on 1999-11-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-07 Gregorian' );
Trewsday 16 Blotmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 8, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-11-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-11-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-11-08 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 1999-11-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 17 Blotmath 7463', 'as_string() on 1999-11-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-08 Gregorian' );
Hevensday 17 Blotmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 9, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-11-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-11-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-11-09 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 1999-11-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 18 Blotmath 7463', 'as_string() on 1999-11-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-09 Gregorian' );
Mersday 18 Blotmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 10, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-11-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-11-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-11-10 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 1999-11-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 19 Blotmath 7463', 'as_string() on 1999-11-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-10 Gregorian' );
Highday 19 Blotmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 11, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-11-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-11-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-11-11 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 1999-11-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 20 Blotmath 7463', 'as_string() on 1999-11-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-11 Gregorian' );
Sterday 20 Blotmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 12, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-11-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-11-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-11-12 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 1999-11-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 21 Blotmath 7463', 'as_string() on 1999-11-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-12 Gregorian' );
Sunday 21 Blotmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 13, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-11-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-11-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-11-13 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 1999-11-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 22 Blotmath 7463', 'as_string() on 1999-11-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-13 Gregorian' );
Monday 22 Blotmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 14, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-11-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-11-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-11-14 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 1999-11-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 23 Blotmath 7463', 'as_string() on 1999-11-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-14 Gregorian' );
Trewsday 23 Blotmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 15, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-11-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-11-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-11-15 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 1999-11-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 24 Blotmath 7463', 'as_string() on 1999-11-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-15 Gregorian' );
Hevensday 24 Blotmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 16, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-11-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-11-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-11-16 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 1999-11-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 25 Blotmath 7463', 'as_string() on 1999-11-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-16 Gregorian' );
Mersday 25 Blotmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 17, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-11-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-11-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-11-17 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 1999-11-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 26 Blotmath 7463', 'as_string() on 1999-11-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-17 Gregorian' );
Highday 26 Blotmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 18, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-11-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-11-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-11-18 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 1999-11-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 27 Blotmath 7463', 'as_string() on 1999-11-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-18 Gregorian' );
Sterday 27 Blotmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 19, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-11-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-11-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-11-19 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 1999-11-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 28 Blotmath 7463', 'as_string() on 1999-11-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-19 Gregorian' );
Sunday 28 Blotmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 20, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-11-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-11-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-11-20 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 1999-11-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 29 Blotmath 7463', 'as_string() on 1999-11-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-20 Gregorian' );
Monday 29 Blotmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 21, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-11-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-11-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 1999-11-21 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 1999-11-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 30 Blotmath 7463', 'as_string() on 1999-11-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-21 Gregorian' );
Trewsday 30 Blotmath 7463
EOT

$epoch = timelocal( 0, 0, 0, 22, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-11-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-11-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-11-22 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 1999-11-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 1 Foreyule 7463', 'as_string() on 1999-11-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-22 Gregorian' );
Hevensday 1 Foreyule 7463
EOT

$epoch = timelocal( 0, 0, 0, 23, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-11-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-11-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-11-23 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 1999-11-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 2 Foreyule 7463', 'as_string() on 1999-11-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-23 Gregorian' );
Mersday 2 Foreyule 7463
EOT

$epoch = timelocal( 0, 0, 0, 24, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-11-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-11-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-11-24 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 1999-11-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 3 Foreyule 7463', 'as_string() on 1999-11-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-24 Gregorian' );
Highday 3 Foreyule 7463
EOT

$epoch = timelocal( 0, 0, 0, 25, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-11-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-11-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-11-25 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 1999-11-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 4 Foreyule 7463', 'as_string() on 1999-11-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-25 Gregorian' );
Sterday 4 Foreyule 7463
EOT

$epoch = timelocal( 0, 0, 0, 26, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-11-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-11-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-11-26 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 1999-11-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 5 Foreyule 7463', 'as_string() on 1999-11-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-26 Gregorian' );
Sunday 5 Foreyule 7463
EOT

$epoch = timelocal( 0, 0, 0, 27, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-11-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-11-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-11-27 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 1999-11-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 6 Foreyule 7463', 'as_string() on 1999-11-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-27 Gregorian' );
Monday 6 Foreyule 7463
EOT

$epoch = timelocal( 0, 0, 0, 28, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-11-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-11-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-11-28 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 1999-11-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 7 Foreyule 7463', 'as_string() on 1999-11-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-28 Gregorian' );
Trewsday 7 Foreyule 7463
EOT

$epoch = timelocal( 0, 0, 0, 29, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-11-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-11-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-11-29 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 1999-11-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 8 Foreyule 7463', 'as_string() on 1999-11-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-29 Gregorian' );
Hevensday 8 Foreyule 7463
EOT

$epoch = timelocal( 0, 0, 0, 30, 10, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-11-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-11-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-11-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-11-30 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 1999-11-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-11-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-11-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 9 Foreyule 7463', 'as_string() on 1999-11-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-11-30 Gregorian' );
Mersday 9 Foreyule 7463
EOT

$epoch = timelocal( 0, 0, 0, 1, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-12-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-12-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-12-01 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 1999-12-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-12-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 10 Foreyule 7463', 'as_string() on 1999-12-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-01 Gregorian' );
Highday 10 Foreyule 7463
EOT

$epoch = timelocal( 0, 0, 0, 2, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-12-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-12-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-12-02 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 1999-12-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-12-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 11 Foreyule 7463', 'as_string() on 1999-12-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-02 Gregorian' );
Sterday 11 Foreyule 7463
EOT

$epoch = timelocal( 0, 0, 0, 3, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-12-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-12-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-12-03 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 1999-12-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-12-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 12 Foreyule 7463', 'as_string() on 1999-12-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-03 Gregorian' );
Sunday 12 Foreyule 7463
EOT

$epoch = timelocal( 0, 0, 0, 4, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-12-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-12-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-12-04 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 1999-12-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-12-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 13 Foreyule 7463', 'as_string() on 1999-12-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-04 Gregorian' );
Monday 13 Foreyule 7463
EOT

$epoch = timelocal( 0, 0, 0, 5, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-12-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-12-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-12-05 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 1999-12-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-12-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 14 Foreyule 7463', 'as_string() on 1999-12-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-05 Gregorian' );
Trewsday 14 Foreyule 7463
EOT

$epoch = timelocal( 0, 0, 0, 6, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-12-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-12-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-12-06 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 1999-12-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-12-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 15 Foreyule 7463', 'as_string() on 1999-12-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-06 Gregorian' );
Hevensday 15 Foreyule 7463
EOT

$epoch = timelocal( 0, 0, 0, 7, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-12-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-12-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-12-07 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 1999-12-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-12-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 16 Foreyule 7463', 'as_string() on 1999-12-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-07 Gregorian' );
Mersday 16 Foreyule 7463
EOT

$epoch = timelocal( 0, 0, 0, 8, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-12-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-12-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-12-08 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 1999-12-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-12-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 17 Foreyule 7463', 'as_string() on 1999-12-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-08 Gregorian' );
Highday 17 Foreyule 7463
EOT

$epoch = timelocal( 0, 0, 0, 9, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-12-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-12-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-12-09 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 1999-12-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-12-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 18 Foreyule 7463', 'as_string() on 1999-12-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-09 Gregorian' );
Sterday 18 Foreyule 7463
EOT

$epoch = timelocal( 0, 0, 0, 10, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-12-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-12-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-12-10 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 1999-12-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-12-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 19 Foreyule 7463', 'as_string() on 1999-12-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-10 Gregorian' );
Sunday 19 Foreyule 7463
EOT

$epoch = timelocal( 0, 0, 0, 11, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-12-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-12-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-12-11 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 1999-12-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-12-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 20 Foreyule 7463', 'as_string() on 1999-12-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-11 Gregorian' );
Monday 20 Foreyule 7463
EOT

$epoch = timelocal( 0, 0, 0, 12, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-12-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-12-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-12-12 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 1999-12-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-12-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 21 Foreyule 7463', 'as_string() on 1999-12-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-12 Gregorian' );
Trewsday 21 Foreyule 7463
EOT

$epoch = timelocal( 0, 0, 0, 13, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-12-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-12-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-12-13 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 1999-12-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-12-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 22 Foreyule 7463', 'as_string() on 1999-12-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-13 Gregorian' );
Hevensday 22 Foreyule 7463
EOT

$epoch = timelocal( 0, 0, 0, 14, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-12-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-12-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-12-14 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 1999-12-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-12-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 23 Foreyule 7463', 'as_string() on 1999-12-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-14 Gregorian' );
Mersday 23 Foreyule 7463
EOT

$epoch = timelocal( 0, 0, 0, 15, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-12-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-12-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-12-15 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 1999-12-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-12-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 24 Foreyule 7463', 'as_string() on 1999-12-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-15 Gregorian' );
Highday 24 Foreyule 7463
EOT

$epoch = timelocal( 0, 0, 0, 16, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-12-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-12-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-12-16 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 1999-12-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-12-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 25 Foreyule 7463', 'as_string() on 1999-12-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-16 Gregorian' );
Sterday 25 Foreyule 7463

The Company of the Ring leaves Rivendell at dusk, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 17, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-12-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-12-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-12-17 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 1999-12-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-12-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 26 Foreyule 7463', 'as_string() on 1999-12-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-17 Gregorian' );
Sunday 26 Foreyule 7463
EOT

$epoch = timelocal( 0, 0, 0, 18, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-12-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-12-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-12-18 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 1999-12-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-12-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 27 Foreyule 7463', 'as_string() on 1999-12-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-18 Gregorian' );
Monday 27 Foreyule 7463
EOT

$epoch = timelocal( 0, 0, 0, 19, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-12-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-12-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-12-19 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 1999-12-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-12-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 28 Foreyule 7463', 'as_string() on 1999-12-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-19 Gregorian' );
Trewsday 28 Foreyule 7463
EOT

$epoch = timelocal( 0, 0, 0, 20, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-12-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-12-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-12-20 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 1999-12-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-12-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 29 Foreyule 7463', 'as_string() on 1999-12-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-20 Gregorian' );
Hevensday 29 Foreyule 7463
EOT

$epoch = timelocal( 0, 0, 0, 21, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-12-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-12-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 1999-12-21 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 1999-12-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-12-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 30 Foreyule 7463', 'as_string() on 1999-12-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-21 Gregorian' );
Mersday 30 Foreyule 7463
EOT

$epoch = timelocal( 0, 0, 0, 22, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-12-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-12-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', '', 'month() on 1999-12-22 Gregorian' );
cmp_ok( $dts->day(), '==', 0, 'day() on 1999-12-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '1 Yule', 'holiday() on 1999-12-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7463, 'year() on 1999-12-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 1 Yule 7463', 'as_string() on 1999-12-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-22 Gregorian' );
Highday 1 Yule 7463
EOT

$epoch = timelocal( 0, 0, 0, 23, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-12-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-12-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', '', 'month() on 1999-12-23 Gregorian' );
cmp_ok( $dts->day(), '==', 0, 'day() on 1999-12-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '2 Yule', 'holiday() on 1999-12-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 1999-12-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 2 Yule 7464', 'as_string() on 1999-12-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-23 Gregorian' );
Sterday 2 Yule 7464
EOT

$epoch = timelocal( 0, 0, 0, 24, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-12-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-12-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-12-24 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 1999-12-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-12-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 1999-12-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 1 Afteryule 7464', 'as_string() on 1999-12-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-24 Gregorian' );
Sunday 1 Afteryule 7464
EOT

$epoch = timelocal( 0, 0, 0, 25, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 1999-12-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 1999-12-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-12-25 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 1999-12-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-12-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 1999-12-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 2 Afteryule 7464', 'as_string() on 1999-12-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-25 Gregorian' );
Monday 2 Afteryule 7464
EOT

$epoch = timelocal( 0, 0, 0, 26, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 1999-12-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 1999-12-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-12-26 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 1999-12-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-12-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 1999-12-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 3 Afteryule 7464', 'as_string() on 1999-12-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-26 Gregorian' );
Trewsday 3 Afteryule 7464
EOT

$epoch = timelocal( 0, 0, 0, 27, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 1999-12-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 1999-12-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-12-27 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 1999-12-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-12-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 1999-12-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 4 Afteryule 7464', 'as_string() on 1999-12-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-27 Gregorian' );
Hevensday 4 Afteryule 7464
EOT

$epoch = timelocal( 0, 0, 0, 28, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 1999-12-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 1999-12-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-12-28 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 1999-12-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-12-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 1999-12-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 5 Afteryule 7464', 'as_string() on 1999-12-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-28 Gregorian' );
Mersday 5 Afteryule 7464
EOT

$epoch = timelocal( 0, 0, 0, 29, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 1999-12-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 1999-12-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-12-29 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 1999-12-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-12-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 1999-12-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 6 Afteryule 7464', 'as_string() on 1999-12-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-29 Gregorian' );
Highday 6 Afteryule 7464
EOT

$epoch = timelocal( 0, 0, 0, 30, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 1999-12-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 1999-12-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-12-30 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 1999-12-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-12-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 1999-12-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 7 Afteryule 7464', 'as_string() on 1999-12-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-30 Gregorian' );
Sterday 7 Afteryule 7464
EOT

$epoch = timelocal( 0, 0, 0, 31, 11, 1999 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 1999-12-31 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 1999-12-31 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 1999-12-31 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 1999-12-31 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 1999-12-31 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 1999-12-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 1999-12-31 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 8 Afteryule 7464', 'as_string() on 1999-12-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 1999-12-31 Gregorian' );
Sunday 8 Afteryule 7464

The Company of the Ring reaches Hollin, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 1, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-01-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-01-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-01-01 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 2000-01-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 9 Afteryule 7464', 'as_string() on 2000-01-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-01 Gregorian' );
Monday 9 Afteryule 7464
EOT

$epoch = timelocal( 0, 0, 0, 2, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-01-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-01-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-01-02 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 2000-01-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 10 Afteryule 7464', 'as_string() on 2000-01-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-02 Gregorian' );
Trewsday 10 Afteryule 7464
EOT

$epoch = timelocal( 0, 0, 0, 3, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-01-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-01-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-01-03 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 2000-01-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 11 Afteryule 7464', 'as_string() on 2000-01-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-03 Gregorian' );
Hevensday 11 Afteryule 7464
EOT

$epoch = timelocal( 0, 0, 0, 4, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-01-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-01-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-01-04 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 2000-01-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 12 Afteryule 7464', 'as_string() on 2000-01-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-04 Gregorian' );
Mersday 12 Afteryule 7464
EOT

$epoch = timelocal( 0, 0, 0, 5, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-01-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-01-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-01-05 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 2000-01-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 13 Afteryule 7464', 'as_string() on 2000-01-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-05 Gregorian' );
Highday 13 Afteryule 7464

The Company of the Ring reaches the West-gate of Moria at nightfall, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 6, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-01-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-01-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-01-06 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 2000-01-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 14 Afteryule 7464', 'as_string() on 2000-01-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-06 Gregorian' );
Sterday 14 Afteryule 7464

The Company of the Ring spends the night in Moria hall 21, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 7, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-01-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-01-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-01-07 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 2000-01-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 15 Afteryule 7464', 'as_string() on 2000-01-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-07 Gregorian' );
Sunday 15 Afteryule 7464

The Bridge of Khazad-dum, and the fall of Gandalf, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 8, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-01-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-01-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-01-08 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 2000-01-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 16 Afteryule 7464', 'as_string() on 2000-01-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-08 Gregorian' );
Monday 16 Afteryule 7464
EOT

$epoch = timelocal( 0, 0, 0, 9, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-01-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-01-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-01-09 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 2000-01-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 17 Afteryule 7464', 'as_string() on 2000-01-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-09 Gregorian' );
Trewsday 17 Afteryule 7464

The Company of the Ring comes to Caras Galadhon at evening, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 10, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-01-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-01-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-01-10 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 2000-01-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 18 Afteryule 7464', 'as_string() on 2000-01-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-10 Gregorian' );
Hevensday 18 Afteryule 7464
EOT

$epoch = timelocal( 0, 0, 0, 11, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-01-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-01-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-01-11 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 2000-01-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 19 Afteryule 7464', 'as_string() on 2000-01-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-11 Gregorian' );
Mersday 19 Afteryule 7464
EOT

$epoch = timelocal( 0, 0, 0, 12, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-01-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-01-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-01-12 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 2000-01-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 20 Afteryule 7464', 'as_string() on 2000-01-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-12 Gregorian' );
Highday 20 Afteryule 7464
EOT

$epoch = timelocal( 0, 0, 0, 13, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-01-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-01-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-01-13 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 2000-01-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 21 Afteryule 7464', 'as_string() on 2000-01-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-13 Gregorian' );
Sterday 21 Afteryule 7464
EOT

$epoch = timelocal( 0, 0, 0, 14, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-01-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-01-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-01-14 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 2000-01-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 22 Afteryule 7464', 'as_string() on 2000-01-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-14 Gregorian' );
Sunday 22 Afteryule 7464
EOT

$epoch = timelocal( 0, 0, 0, 15, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-01-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-01-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-01-15 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 2000-01-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 23 Afteryule 7464', 'as_string() on 2000-01-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-15 Gregorian' );
Monday 23 Afteryule 7464

Gandalf pursues the Balrog to the peak of Zirakzigil, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 16, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-01-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-01-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-01-16 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 2000-01-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 24 Afteryule 7464', 'as_string() on 2000-01-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-16 Gregorian' );
Trewsday 24 Afteryule 7464
EOT

$epoch = timelocal( 0, 0, 0, 17, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-01-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-01-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-01-17 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 2000-01-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 25 Afteryule 7464', 'as_string() on 2000-01-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-17 Gregorian' );
Hevensday 25 Afteryule 7464

Gandalf casts down the Balrog, and passes away.
His body lies on the peak of Zirakzigil, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 18, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-01-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-01-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-01-18 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 2000-01-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 26 Afteryule 7464', 'as_string() on 2000-01-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-18 Gregorian' );
Mersday 26 Afteryule 7464
EOT

$epoch = timelocal( 0, 0, 0, 19, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-01-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-01-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-01-19 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 2000-01-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 27 Afteryule 7464', 'as_string() on 2000-01-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-19 Gregorian' );
Highday 27 Afteryule 7464
EOT

$epoch = timelocal( 0, 0, 0, 20, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-01-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-01-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-01-20 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 2000-01-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 28 Afteryule 7464', 'as_string() on 2000-01-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-20 Gregorian' );
Sterday 28 Afteryule 7464
EOT

$epoch = timelocal( 0, 0, 0, 21, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-01-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-01-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-01-21 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 2000-01-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 29 Afteryule 7464', 'as_string() on 2000-01-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-21 Gregorian' );
Sunday 29 Afteryule 7464
EOT

$epoch = timelocal( 0, 0, 0, 22, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-01-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-01-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-01-22 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 2000-01-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 30 Afteryule 7464', 'as_string() on 2000-01-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-22 Gregorian' );
Monday 30 Afteryule 7464
EOT

$epoch = timelocal( 0, 0, 0, 23, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-01-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-01-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-01-23 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 2000-01-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 1 Solmath 7464', 'as_string() on 2000-01-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-23 Gregorian' );
Trewsday 1 Solmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 24, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-01-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-01-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-01-24 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 2000-01-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 2 Solmath 7464', 'as_string() on 2000-01-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-24 Gregorian' );
Hevensday 2 Solmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 25, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-01-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-01-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-01-25 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 2000-01-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 3 Solmath 7464', 'as_string() on 2000-01-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-25 Gregorian' );
Mersday 3 Solmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 26, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-01-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-01-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-01-26 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 2000-01-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 4 Solmath 7464', 'as_string() on 2000-01-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-26 Gregorian' );
Highday 4 Solmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 27, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-01-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-01-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-01-27 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 2000-01-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 5 Solmath 7464', 'as_string() on 2000-01-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-27 Gregorian' );
Sterday 5 Solmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 28, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-01-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-01-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-01-28 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 2000-01-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 6 Solmath 7464', 'as_string() on 2000-01-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-28 Gregorian' );
Sunday 6 Solmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 29, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-01-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-01-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-01-29 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 2000-01-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 7 Solmath 7464', 'as_string() on 2000-01-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-29 Gregorian' );
Monday 7 Solmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 30, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-01-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-01-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-01-30 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 2000-01-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 8 Solmath 7464', 'as_string() on 2000-01-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-30 Gregorian' );
Trewsday 8 Solmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 31, 0, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-01-31 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-01-31 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-01-31 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-01-31 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 2000-01-31 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-01-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-01-31 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 9 Solmath 7464', 'as_string() on 2000-01-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-01-31 Gregorian' );
Hevensday 9 Solmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 1, 1, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-02-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-02-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-02-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-02-01 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 2000-02-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-02-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 10 Solmath 7464', 'as_string() on 2000-02-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-01 Gregorian' );
Mersday 10 Solmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 2, 1, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-02-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-02-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-02-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-02-02 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 2000-02-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-02-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 11 Solmath 7464', 'as_string() on 2000-02-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-02 Gregorian' );
Highday 11 Solmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 3, 1, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-02-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-02-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-02-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-02-03 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 2000-02-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-02-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 12 Solmath 7464', 'as_string() on 2000-02-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-03 Gregorian' );
Sterday 12 Solmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 4, 1, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-02-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-02-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-02-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-02-04 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 2000-02-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-02-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 13 Solmath 7464', 'as_string() on 2000-02-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-04 Gregorian' );
Sunday 13 Solmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 5, 1, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-02-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-02-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-02-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-02-05 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 2000-02-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-02-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 14 Solmath 7464', 'as_string() on 2000-02-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-05 Gregorian' );
Monday 14 Solmath 7464

Frodo and Sam look in the Mirror of Galadriel, 1419.
Gandalf returns to life, and lies in a trance, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 6, 1, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-02-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-02-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-02-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-02-06 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 2000-02-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-02-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 15 Solmath 7464', 'as_string() on 2000-02-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-06 Gregorian' );
Trewsday 15 Solmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 7, 1, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-02-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-02-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-02-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-02-07 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 2000-02-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-02-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 16 Solmath 7464', 'as_string() on 2000-02-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-07 Gregorian' );
Hevensday 16 Solmath 7464

Company of the Ring says farewell to Lorien --
Gollum observes departure, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 8, 1, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-02-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-02-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-02-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-02-08 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 2000-02-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-02-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 17 Solmath 7464', 'as_string() on 2000-02-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-08 Gregorian' );
Mersday 17 Solmath 7464

Gwaihir the eagle bears Gandalf to Lorien, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 9, 1, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-02-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-02-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-02-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-02-09 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 2000-02-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-02-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 18 Solmath 7464', 'as_string() on 2000-02-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-09 Gregorian' );
Highday 18 Solmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 10, 1, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-02-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-02-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-02-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-02-10 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 2000-02-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-02-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 19 Solmath 7464', 'as_string() on 2000-02-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-10 Gregorian' );
Sterday 19 Solmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 11, 1, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-02-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-02-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-02-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-02-11 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 2000-02-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-02-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 20 Solmath 7464', 'as_string() on 2000-02-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-11 Gregorian' );
Sunday 20 Solmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 12, 1, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-02-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-02-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-02-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-02-12 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 2000-02-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-02-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 21 Solmath 7464', 'as_string() on 2000-02-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-12 Gregorian' );
Monday 21 Solmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 13, 1, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-02-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-02-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-02-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-02-13 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 2000-02-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-02-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 22 Solmath 7464', 'as_string() on 2000-02-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-13 Gregorian' );
Trewsday 22 Solmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 14, 1, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-02-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-02-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-02-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-02-14 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 2000-02-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-02-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 23 Solmath 7464', 'as_string() on 2000-02-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-14 Gregorian' );
Hevensday 23 Solmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 15, 1, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-02-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-02-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-02-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-02-15 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 2000-02-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-02-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 24 Solmath 7464', 'as_string() on 2000-02-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-15 Gregorian' );
Mersday 24 Solmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 16, 1, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-02-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-02-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-02-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-02-16 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 2000-02-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-02-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 25 Solmath 7464', 'as_string() on 2000-02-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-16 Gregorian' );
Highday 25 Solmath 7464

The Company of the Ring pass the Argonath and camp at Parth Galen, 1419.
First battle of the Fords of Isen -- Theodred son of Theoden slain, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 17, 1, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-02-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-02-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-02-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-02-17 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 2000-02-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-02-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 26 Solmath 7464', 'as_string() on 2000-02-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-17 Gregorian' );
Sterday 26 Solmath 7464

Breaking of the Fellowship, 1419.
Death of Boromir; his horn is heard in Minas Tirith, 1419.
Meriadoc and Peregrin captured by Orcs -- Aragorn pursues, 1419.
Eomer hears of the descent of the Orc-band from Emyn Muil, 1419.
Frodo and Samwise enter the eastern Emyn Muil, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 18, 1, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-02-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-02-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-02-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-02-18 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 2000-02-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-02-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 27 Solmath 7464', 'as_string() on 2000-02-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-18 Gregorian' );
Sunday 27 Solmath 7464

Aragorn reaches the west-cliff at sunrise, 1419.
Eomer sets out from Eastfold against Theoden's orders to pursue the Orcs, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 19, 1, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-02-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-02-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-02-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-02-19 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 2000-02-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-02-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 28 Solmath 7464', 'as_string() on 2000-02-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-19 Gregorian' );
Monday 28 Solmath 7464

Eomer overtakes the Orcs just outside of Fangorn Forest, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 20, 1, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-02-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-02-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-02-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-02-20 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 2000-02-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-02-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 29 Solmath 7464', 'as_string() on 2000-02-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-20 Gregorian' );
Trewsday 29 Solmath 7464

Meriodoc and Pippin escape and meet Treebeard, 1419.
The Rohirrim attack at sunrise and destroy the Orcs, 1419.
Frodo descends from the Emyn Muil and meets Gollum, 1419.
Faramir sees the funeral boat of Boromir, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 21, 1, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-02-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-02-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-02-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2000-02-21 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 2000-02-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-02-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 30 Solmath 7464', 'as_string() on 2000-02-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-21 Gregorian' );
Hevensday 30 Solmath 7464

Entmoot begins, 1419.
Eomer, returning to Edoras, meets Aragorn, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 22, 1, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-02-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-02-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-02-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-02-22 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 2000-02-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-02-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 1 Rethe 7464', 'as_string() on 2000-02-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-22 Gregorian' );
Mersday 1 Rethe 7464

Aragorn meets Gandalf the White, and they set out for Edoras, 1419.
Faramir leaves Minas Tirith on an errand to Ithilien, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 23, 1, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-02-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-02-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-02-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-02-23 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 2000-02-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-02-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 2 Rethe 7464', 'as_string() on 2000-02-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-23 Gregorian' );
Highday 2 Rethe 7464

The Rohirrim ride west against Saruman, 1419.
Second battle at the Fords of Isen; Erkenbrand defeated, 1419.
Entmoot ends.  Ents march on Isengard and reach it at night, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 24, 1, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-02-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-02-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-02-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-02-24 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 2000-02-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-02-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 3 Rethe 7464', 'as_string() on 2000-02-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-24 Gregorian' );
Sterday 3 Rethe 7464

Theoden retreats to Helm's Deep; battle of the Hornburg begins, 1419.
Ents complete the destruction of Isengard.
EOT

$epoch = timelocal( 0, 0, 0, 25, 1, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-02-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-02-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-02-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-02-25 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 2000-02-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-02-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 4 Rethe 7464', 'as_string() on 2000-02-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-25 Gregorian' );
Sunday 4 Rethe 7464

Theoden and Gandalf set out from Helm's Deep for Isengard, 1419.
Frodo reaches the slag mound on the edge of the of the Morannon, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 26, 1, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-02-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-02-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-02-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-02-26 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 2000-02-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-02-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 5 Rethe 7464', 'as_string() on 2000-02-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-26 Gregorian' );
Monday 5 Rethe 7464

Theoden reaches Isengard at noon; parley with Saruman in Orthanc, 1419.
Gandalf sets out with Peregrin for Minas Tirith, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 27, 1, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-02-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-02-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-02-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-02-27 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 2000-02-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-02-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 6 Rethe 7464', 'as_string() on 2000-02-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-27 Gregorian' );
Trewsday 6 Rethe 7464

Aragorn overtaken by the Dunedain in the early hours, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 28, 1, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-02-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-02-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-02-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-02-28 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 2000-02-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-02-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 7 Rethe 7464', 'as_string() on 2000-02-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-28 Gregorian' );
Hevensday 7 Rethe 7464

Frodo taken by Faramir to Henneth Annun, 1419.
Aragorn comes to Dunharrow at nightfall, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 29, 1, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-02-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-02-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-02-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-02-29 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 2000-02-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-02-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-02-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 8 Rethe 7464', 'as_string() on 2000-02-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-02-29 Gregorian' );
Mersday 8 Rethe 7464

Aragorn takes the "Paths of the Dead", and reaches Erech at midnight, 1419.
Frodo leaves Henneth Annun, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 1, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-03-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-03-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-03-01 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 2000-03-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 9 Rethe 7464', 'as_string() on 2000-03-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-01 Gregorian' );
Highday 9 Rethe 7464

Gandalf reaches Minas Tirith, 1419.
Darkness begins to flow out of Mordor, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 2, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-03-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-03-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-03-02 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 2000-03-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 10 Rethe 7464', 'as_string() on 2000-03-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-02 Gregorian' );
Sterday 10 Rethe 7464

The Dawnless Day, 1419.
The Rohirrim are mustered and ride from Harrowdale, 1419.
Faramir rescued by Gandalf at the gates of Minas Tirith, 1419.
An army from the Morannon takes Cair Andros and passes into Anorien, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 3, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-03-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-03-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-03-03 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 2000-03-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 11 Rethe 7464', 'as_string() on 2000-03-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-03 Gregorian' );
Sunday 11 Rethe 7464

Gollum visits Shelob, 1419.
Denethor sends Faramir to Osgiliath, 1419.
Eastern Rohan is invaded and Lorien assaulted, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 4, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-03-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-03-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-03-04 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 2000-03-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 12 Rethe 7464', 'as_string() on 2000-03-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-04 Gregorian' );
Monday 12 Rethe 7464

Gollum leads Frodo into Shelob's lair, 1419.
Ents defeat the invaders of Rohan, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 5, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-03-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-03-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-03-05 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 2000-03-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 13 Rethe 7464', 'as_string() on 2000-03-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-05 Gregorian' );
Trewsday 13 Rethe 7464

Frodo captured by the Orcs of Cirith Ungol, 1419.
The Pelennor is overrun and Faramir is wounded, 1419.
Aragorn reaches Pelargir and captures the fleet of Umbar, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 6, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-03-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-03-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-03-06 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 2000-03-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 14 Rethe 7464', 'as_string() on 2000-03-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-06 Gregorian' );
Hevensday 14 Rethe 7464

Samwise finds Frodo in the tower of Cirith Ungol, 1419.
Minas Tirith besieged, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 7, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-03-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-03-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-03-07 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 2000-03-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 15 Rethe 7464', 'as_string() on 2000-03-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-07 Gregorian' );
Mersday 15 Rethe 7464

Witch King breaks the gates of Minas Tirith, 1419.
Denethor, Steward of Gondor, burns himself on a pyre, 1419.
The battle of the Pelennor occurs as Theoden and Aragorn arrive, 1419.
Thranduil repels the forces of Dol Guldur in Mirkwood, 1419.
Lorien assaulted for second time, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 8, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-03-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-03-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-03-08 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 2000-03-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 16 Rethe 7464', 'as_string() on 2000-03-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-08 Gregorian' );
Highday 16 Rethe 7464
EOT

$epoch = timelocal( 0, 0, 0, 9, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-03-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-03-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-03-09 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 2000-03-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 17 Rethe 7464', 'as_string() on 2000-03-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-09 Gregorian' );
Sterday 17 Rethe 7464

Battle of Dale, where King Brand and King Dain Ironfoot fall, 1419.
Shagrat brings Frodo's cloak, mail-shirt, and sword to Barad-dur, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 10, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-03-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-03-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-03-10 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 2000-03-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 18 Rethe 7464', 'as_string() on 2000-03-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-10 Gregorian' );
Sunday 18 Rethe 7464

Host of the west leaves Minas Tirith, 1419.
Frodo and Sam overtaken by Orcs on the road from Durthang to Udun, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 11, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-03-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-03-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-03-11 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 2000-03-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 19 Rethe 7464', 'as_string() on 2000-03-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-11 Gregorian' );
Monday 19 Rethe 7464

Frodo and Sam escape the Orcs and start on the road toward Mount Doom, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 12, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-03-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-03-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-03-12 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 2000-03-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 20 Rethe 7464', 'as_string() on 2000-03-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-12 Gregorian' );
Trewsday 20 Rethe 7464
EOT

$epoch = timelocal( 0, 0, 0, 13, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-03-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-03-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-03-13 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 2000-03-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 21 Rethe 7464', 'as_string() on 2000-03-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-13 Gregorian' );
Hevensday 21 Rethe 7464
EOT

$epoch = timelocal( 0, 0, 0, 14, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-03-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-03-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-03-14 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 2000-03-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 22 Rethe 7464', 'as_string() on 2000-03-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-14 Gregorian' );
Mersday 22 Rethe 7464

Lorien assaulted for the third time, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 15, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-03-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-03-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-03-15 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 2000-03-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 23 Rethe 7464', 'as_string() on 2000-03-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-15 Gregorian' );
Highday 23 Rethe 7464
EOT

$epoch = timelocal( 0, 0, 0, 16, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-03-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-03-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-03-16 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 2000-03-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 24 Rethe 7464', 'as_string() on 2000-03-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-16 Gregorian' );
Sterday 24 Rethe 7464

Frodo and Sam reach the base of Mount Doom, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 17, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-03-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-03-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-03-17 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 2000-03-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 25 Rethe 7464', 'as_string() on 2000-03-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-17 Gregorian' );
Sunday 25 Rethe 7464

Battle of the Host of the West on the slag hill of the Morannon, 1419.
Gollum siezes the Ring of Power and falls into the Cracks of Doom, 1419.
Downfall of Barad-dur and the passing of Sauron!, 1419.
Birth of Elanor the Fair, daughter of Samwise, 1421.
Fourth age begins in the reckoning of Gondor, 1421.
EOT

$epoch = timelocal( 0, 0, 0, 18, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-03-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-03-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-03-18 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 2000-03-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 26 Rethe 7464', 'as_string() on 2000-03-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-18 Gregorian' );
Monday 26 Rethe 7464
EOT

$epoch = timelocal( 0, 0, 0, 19, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-03-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-03-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-03-19 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 2000-03-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 27 Rethe 7464', 'as_string() on 2000-03-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-19 Gregorian' );
Trewsday 27 Rethe 7464

Bard II and Thorin III Stonehelm drive the enemy from Dale, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 20, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-03-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-03-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-03-20 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 2000-03-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 28 Rethe 7464', 'as_string() on 2000-03-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-20 Gregorian' );
Hevensday 28 Rethe 7464

Celeborn crosses the Anduin and begins destruction of Dol Guldur, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 21, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-03-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-03-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-03-21 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 2000-03-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 29 Rethe 7464', 'as_string() on 2000-03-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-21 Gregorian' );
Mersday 29 Rethe 7464
EOT

$epoch = timelocal( 0, 0, 0, 22, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-03-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-03-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2000-03-22 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 2000-03-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 30 Rethe 7464', 'as_string() on 2000-03-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-22 Gregorian' );
Highday 30 Rethe 7464
EOT

$epoch = timelocal( 0, 0, 0, 23, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-03-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-03-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-03-23 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 2000-03-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 1 Astron 7464', 'as_string() on 2000-03-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-23 Gregorian' );
Sterday 1 Astron 7464
EOT

$epoch = timelocal( 0, 0, 0, 24, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-03-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-03-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-03-24 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 2000-03-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 2 Astron 7464', 'as_string() on 2000-03-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-24 Gregorian' );
Sunday 2 Astron 7464
EOT

$epoch = timelocal( 0, 0, 0, 25, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-03-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-03-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-03-25 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 2000-03-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 3 Astron 7464', 'as_string() on 2000-03-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-25 Gregorian' );
Monday 3 Astron 7464
EOT

$epoch = timelocal( 0, 0, 0, 26, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-03-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-03-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-03-26 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 2000-03-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 4 Astron 7464', 'as_string() on 2000-03-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-26 Gregorian' );
Trewsday 4 Astron 7464
EOT

$epoch = timelocal( 0, 0, 0, 27, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-03-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-03-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-03-27 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 2000-03-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 5 Astron 7464', 'as_string() on 2000-03-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-27 Gregorian' );
Hevensday 5 Astron 7464
EOT

$epoch = timelocal( 0, 0, 0, 28, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-03-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-03-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-03-28 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 2000-03-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 6 Astron 7464', 'as_string() on 2000-03-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-28 Gregorian' );
Mersday 6 Astron 7464

The mallorn tree flowers in the party field, 1420.
EOT

$epoch = timelocal( 0, 0, 0, 29, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-03-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-03-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-03-29 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 2000-03-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 7 Astron 7464', 'as_string() on 2000-03-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-29 Gregorian' );
Highday 7 Astron 7464
EOT

$epoch = timelocal( 0, 0, 0, 30, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-03-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-03-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-03-30 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 2000-03-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 8 Astron 7464', 'as_string() on 2000-03-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-30 Gregorian' );
Sterday 8 Astron 7464

Ring bearers are honored on the fields of Cormallen, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 31, 2, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-03-31 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-03-31 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-03-31 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-03-31 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 2000-03-31 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-03-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-03-31 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 9 Astron 7464', 'as_string() on 2000-03-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-03-31 Gregorian' );
Sunday 9 Astron 7464
EOT

$epoch = timelocal( 0, 0, 0, 1, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-04-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-04-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-04-01 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 2000-04-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 10 Astron 7464', 'as_string() on 2000-04-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-01 Gregorian' );
Monday 10 Astron 7464
EOT

$epoch = timelocal( 0, 0, 0, 2, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-04-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-04-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-04-02 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 2000-04-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 11 Astron 7464', 'as_string() on 2000-04-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-02 Gregorian' );
Trewsday 11 Astron 7464
EOT

$epoch = timelocal( 0, 0, 0, 3, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-04-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-04-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-04-03 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 2000-04-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 12 Astron 7464', 'as_string() on 2000-04-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-03 Gregorian' );
Hevensday 12 Astron 7464

Gandalf arrives in Hobbiton, 1418
EOT

$epoch = timelocal( 0, 0, 0, 4, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-04-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-04-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-04-04 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 2000-04-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 13 Astron 7464', 'as_string() on 2000-04-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-04 Gregorian' );
Mersday 13 Astron 7464
EOT

$epoch = timelocal( 0, 0, 0, 5, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-04-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-04-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-04-05 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 2000-04-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 14 Astron 7464', 'as_string() on 2000-04-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-05 Gregorian' );
Highday 14 Astron 7464
EOT

$epoch = timelocal( 0, 0, 0, 6, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-04-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-04-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-04-06 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 2000-04-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 15 Astron 7464', 'as_string() on 2000-04-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-06 Gregorian' );
Sterday 15 Astron 7464
EOT

$epoch = timelocal( 0, 0, 0, 7, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-04-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-04-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-04-07 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 2000-04-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 16 Astron 7464', 'as_string() on 2000-04-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-07 Gregorian' );
Sunday 16 Astron 7464
EOT

$epoch = timelocal( 0, 0, 0, 8, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-04-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-04-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-04-08 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 2000-04-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 17 Astron 7464', 'as_string() on 2000-04-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-08 Gregorian' );
Monday 17 Astron 7464
EOT

$epoch = timelocal( 0, 0, 0, 9, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-04-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-04-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-04-09 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 2000-04-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 18 Astron 7464', 'as_string() on 2000-04-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-09 Gregorian' );
Trewsday 18 Astron 7464
EOT

$epoch = timelocal( 0, 0, 0, 10, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-04-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-04-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-04-10 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 2000-04-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 19 Astron 7464', 'as_string() on 2000-04-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-10 Gregorian' );
Hevensday 19 Astron 7464
EOT

$epoch = timelocal( 0, 0, 0, 11, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-04-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-04-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-04-11 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 2000-04-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 20 Astron 7464', 'as_string() on 2000-04-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-11 Gregorian' );
Mersday 20 Astron 7464
EOT

$epoch = timelocal( 0, 0, 0, 12, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-04-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-04-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-04-12 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 2000-04-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 21 Astron 7464', 'as_string() on 2000-04-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-12 Gregorian' );
Highday 21 Astron 7464
EOT

$epoch = timelocal( 0, 0, 0, 13, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-04-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-04-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-04-13 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 2000-04-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 22 Astron 7464', 'as_string() on 2000-04-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-13 Gregorian' );
Sterday 22 Astron 7464
EOT

$epoch = timelocal( 0, 0, 0, 14, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-04-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-04-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-04-14 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 2000-04-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 23 Astron 7464', 'as_string() on 2000-04-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-14 Gregorian' );
Sunday 23 Astron 7464
EOT

$epoch = timelocal( 0, 0, 0, 15, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-04-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-04-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-04-15 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 2000-04-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 24 Astron 7464', 'as_string() on 2000-04-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-15 Gregorian' );
Monday 24 Astron 7464
EOT

$epoch = timelocal( 0, 0, 0, 16, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-04-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-04-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-04-16 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 2000-04-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 25 Astron 7464', 'as_string() on 2000-04-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-16 Gregorian' );
Trewsday 25 Astron 7464
EOT

$epoch = timelocal( 0, 0, 0, 17, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-04-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-04-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-04-17 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 2000-04-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 26 Astron 7464', 'as_string() on 2000-04-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-17 Gregorian' );
Hevensday 26 Astron 7464
EOT

$epoch = timelocal( 0, 0, 0, 18, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-04-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-04-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-04-18 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 2000-04-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 27 Astron 7464', 'as_string() on 2000-04-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-18 Gregorian' );
Mersday 27 Astron 7464
EOT

$epoch = timelocal( 0, 0, 0, 19, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-04-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-04-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-04-19 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 2000-04-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 28 Astron 7464', 'as_string() on 2000-04-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-19 Gregorian' );
Highday 28 Astron 7464
EOT

$epoch = timelocal( 0, 0, 0, 20, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-04-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-04-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-04-20 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 2000-04-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 29 Astron 7464', 'as_string() on 2000-04-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-20 Gregorian' );
Sterday 29 Astron 7464
EOT

$epoch = timelocal( 0, 0, 0, 21, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-04-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-04-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2000-04-21 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 2000-04-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 30 Astron 7464', 'as_string() on 2000-04-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-21 Gregorian' );
Sunday 30 Astron 7464
EOT

$epoch = timelocal( 0, 0, 0, 22, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-04-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-04-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-04-22 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 2000-04-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 1 Thrimidge 7464', 'as_string() on 2000-04-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-22 Gregorian' );
Monday 1 Thrimidge 7464

Crowning of King Elessar, 1419.
Samwise marries Rose, 1420.
EOT

$epoch = timelocal( 0, 0, 0, 23, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-04-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-04-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-04-23 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 2000-04-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 2 Thrimidge 7464', 'as_string() on 2000-04-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-23 Gregorian' );
Trewsday 2 Thrimidge 7464
EOT

$epoch = timelocal( 0, 0, 0, 24, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-04-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-04-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-04-24 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 2000-04-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 3 Thrimidge 7464', 'as_string() on 2000-04-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-24 Gregorian' );
Hevensday 3 Thrimidge 7464
EOT

$epoch = timelocal( 0, 0, 0, 25, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-04-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-04-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-04-25 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 2000-04-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 4 Thrimidge 7464', 'as_string() on 2000-04-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-25 Gregorian' );
Mersday 4 Thrimidge 7464
EOT

$epoch = timelocal( 0, 0, 0, 26, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-04-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-04-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-04-26 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 2000-04-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 5 Thrimidge 7464', 'as_string() on 2000-04-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-26 Gregorian' );
Highday 5 Thrimidge 7464
EOT

$epoch = timelocal( 0, 0, 0, 27, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-04-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-04-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-04-27 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 2000-04-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 6 Thrimidge 7464', 'as_string() on 2000-04-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-27 Gregorian' );
Sterday 6 Thrimidge 7464
EOT

$epoch = timelocal( 0, 0, 0, 28, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-04-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-04-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-04-28 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 2000-04-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 7 Thrimidge 7464', 'as_string() on 2000-04-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-28 Gregorian' );
Sunday 7 Thrimidge 7464
EOT

$epoch = timelocal( 0, 0, 0, 29, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-04-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-04-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-04-29 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 2000-04-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 8 Thrimidge 7464', 'as_string() on 2000-04-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-29 Gregorian' );
Monday 8 Thrimidge 7464
EOT

$epoch = timelocal( 0, 0, 0, 30, 3, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-04-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-04-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-04-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-04-30 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 2000-04-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-04-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-04-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 9 Thrimidge 7464', 'as_string() on 2000-04-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-04-30 Gregorian' );
Trewsday 9 Thrimidge 7464
EOT

$epoch = timelocal( 0, 0, 0, 1, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-05-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-05-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-05-01 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 2000-05-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 10 Thrimidge 7464', 'as_string() on 2000-05-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-01 Gregorian' );
Hevensday 10 Thrimidge 7464
EOT

$epoch = timelocal( 0, 0, 0, 2, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-05-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-05-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-05-02 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 2000-05-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 11 Thrimidge 7464', 'as_string() on 2000-05-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-02 Gregorian' );
Mersday 11 Thrimidge 7464
EOT

$epoch = timelocal( 0, 0, 0, 3, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-05-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-05-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-05-03 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 2000-05-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 12 Thrimidge 7464', 'as_string() on 2000-05-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-03 Gregorian' );
Highday 12 Thrimidge 7464
EOT

$epoch = timelocal( 0, 0, 0, 4, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-05-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-05-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-05-04 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 2000-05-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 13 Thrimidge 7464', 'as_string() on 2000-05-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-04 Gregorian' );
Sterday 13 Thrimidge 7464
EOT

$epoch = timelocal( 0, 0, 0, 5, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-05-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-05-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-05-05 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 2000-05-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 14 Thrimidge 7464', 'as_string() on 2000-05-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-05 Gregorian' );
Sunday 14 Thrimidge 7464
EOT

$epoch = timelocal( 0, 0, 0, 6, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-05-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-05-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-05-06 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 2000-05-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 15 Thrimidge 7464', 'as_string() on 2000-05-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-06 Gregorian' );
Monday 15 Thrimidge 7464
EOT

$epoch = timelocal( 0, 0, 0, 7, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-05-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-05-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-05-07 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 2000-05-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 16 Thrimidge 7464', 'as_string() on 2000-05-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-07 Gregorian' );
Trewsday 16 Thrimidge 7464
EOT

$epoch = timelocal( 0, 0, 0, 8, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-05-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-05-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-05-08 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 2000-05-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 17 Thrimidge 7464', 'as_string() on 2000-05-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-08 Gregorian' );
Hevensday 17 Thrimidge 7464
EOT

$epoch = timelocal( 0, 0, 0, 9, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-05-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-05-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-05-09 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 2000-05-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 18 Thrimidge 7464', 'as_string() on 2000-05-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-09 Gregorian' );
Mersday 18 Thrimidge 7464
EOT

$epoch = timelocal( 0, 0, 0, 10, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-05-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-05-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-05-10 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 2000-05-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 19 Thrimidge 7464', 'as_string() on 2000-05-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-10 Gregorian' );
Highday 19 Thrimidge 7464
EOT

$epoch = timelocal( 0, 0, 0, 11, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-05-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-05-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-05-11 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 2000-05-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 20 Thrimidge 7464', 'as_string() on 2000-05-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-11 Gregorian' );
Sterday 20 Thrimidge 7464
EOT

$epoch = timelocal( 0, 0, 0, 12, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-05-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-05-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-05-12 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 2000-05-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 21 Thrimidge 7464', 'as_string() on 2000-05-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-12 Gregorian' );
Sunday 21 Thrimidge 7464
EOT

$epoch = timelocal( 0, 0, 0, 13, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-05-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-05-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-05-13 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 2000-05-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 22 Thrimidge 7464', 'as_string() on 2000-05-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-13 Gregorian' );
Monday 22 Thrimidge 7464
EOT

$epoch = timelocal( 0, 0, 0, 14, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-05-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-05-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-05-14 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 2000-05-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 23 Thrimidge 7464', 'as_string() on 2000-05-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-14 Gregorian' );
Trewsday 23 Thrimidge 7464
EOT

$epoch = timelocal( 0, 0, 0, 15, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-05-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-05-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-05-15 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 2000-05-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 24 Thrimidge 7464', 'as_string() on 2000-05-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-15 Gregorian' );
Hevensday 24 Thrimidge 7464
EOT

$epoch = timelocal( 0, 0, 0, 16, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-05-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-05-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-05-16 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 2000-05-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 25 Thrimidge 7464', 'as_string() on 2000-05-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-16 Gregorian' );
Mersday 25 Thrimidge 7464
EOT

$epoch = timelocal( 0, 0, 0, 17, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-05-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-05-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-05-17 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 2000-05-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 26 Thrimidge 7464', 'as_string() on 2000-05-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-17 Gregorian' );
Highday 26 Thrimidge 7464
EOT

$epoch = timelocal( 0, 0, 0, 18, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-05-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-05-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-05-18 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 2000-05-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 27 Thrimidge 7464', 'as_string() on 2000-05-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-18 Gregorian' );
Sterday 27 Thrimidge 7464
EOT

$epoch = timelocal( 0, 0, 0, 19, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-05-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-05-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-05-19 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 2000-05-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 28 Thrimidge 7464', 'as_string() on 2000-05-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-19 Gregorian' );
Sunday 28 Thrimidge 7464
EOT

$epoch = timelocal( 0, 0, 0, 20, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-05-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-05-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-05-20 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 2000-05-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 29 Thrimidge 7464', 'as_string() on 2000-05-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-20 Gregorian' );
Monday 29 Thrimidge 7464
EOT

$epoch = timelocal( 0, 0, 0, 21, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-05-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-05-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2000-05-21 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 2000-05-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 30 Thrimidge 7464', 'as_string() on 2000-05-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-21 Gregorian' );
Trewsday 30 Thrimidge 7464
EOT

$epoch = timelocal( 0, 0, 0, 22, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-05-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-05-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-05-22 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 2000-05-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 1 Forelithe 7464', 'as_string() on 2000-05-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-22 Gregorian' );
Hevensday 1 Forelithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 23, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-05-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-05-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-05-23 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 2000-05-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 2 Forelithe 7464', 'as_string() on 2000-05-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-23 Gregorian' );
Mersday 2 Forelithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 24, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-05-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-05-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-05-24 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 2000-05-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 3 Forelithe 7464', 'as_string() on 2000-05-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-24 Gregorian' );
Highday 3 Forelithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 25, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-05-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-05-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-05-25 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 2000-05-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 4 Forelithe 7464', 'as_string() on 2000-05-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-25 Gregorian' );
Sterday 4 Forelithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 26, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-05-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-05-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-05-26 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 2000-05-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 5 Forelithe 7464', 'as_string() on 2000-05-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-26 Gregorian' );
Sunday 5 Forelithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 27, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-05-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-05-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-05-27 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 2000-05-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 6 Forelithe 7464', 'as_string() on 2000-05-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-27 Gregorian' );
Monday 6 Forelithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 28, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-05-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-05-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-05-28 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 2000-05-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 7 Forelithe 7464', 'as_string() on 2000-05-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-28 Gregorian' );
Trewsday 7 Forelithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 29, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-05-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-05-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-05-29 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 2000-05-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 8 Forelithe 7464', 'as_string() on 2000-05-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-29 Gregorian' );
Hevensday 8 Forelithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 30, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-05-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-05-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-05-30 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 2000-05-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 9 Forelithe 7464', 'as_string() on 2000-05-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-30 Gregorian' );
Mersday 9 Forelithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 31, 4, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-05-31 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-05-31 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-05-31 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-05-31 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 2000-05-31 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-05-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-05-31 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 10 Forelithe 7464', 'as_string() on 2000-05-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-05-31 Gregorian' );
Highday 10 Forelithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 1, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-06-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-06-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-06-01 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 2000-06-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-06-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 11 Forelithe 7464', 'as_string() on 2000-06-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-01 Gregorian' );
Sterday 11 Forelithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 2, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-06-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-06-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-06-02 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 2000-06-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-06-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 12 Forelithe 7464', 'as_string() on 2000-06-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-02 Gregorian' );
Sunday 12 Forelithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 3, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-06-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-06-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-06-03 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 2000-06-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-06-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 13 Forelithe 7464', 'as_string() on 2000-06-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-03 Gregorian' );
Monday 13 Forelithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 4, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-06-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-06-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-06-04 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 2000-06-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-06-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 14 Forelithe 7464', 'as_string() on 2000-06-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-04 Gregorian' );
Trewsday 14 Forelithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 5, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-06-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-06-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-06-05 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 2000-06-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-06-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 15 Forelithe 7464', 'as_string() on 2000-06-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-05 Gregorian' );
Hevensday 15 Forelithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 6, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-06-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-06-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-06-06 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 2000-06-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-06-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 16 Forelithe 7464', 'as_string() on 2000-06-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-06 Gregorian' );
Mersday 16 Forelithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 7, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-06-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-06-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-06-07 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 2000-06-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-06-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 17 Forelithe 7464', 'as_string() on 2000-06-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-07 Gregorian' );
Highday 17 Forelithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 8, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-06-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-06-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-06-08 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 2000-06-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-06-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 18 Forelithe 7464', 'as_string() on 2000-06-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-08 Gregorian' );
Sterday 18 Forelithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 9, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-06-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-06-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-06-09 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 2000-06-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-06-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 19 Forelithe 7464', 'as_string() on 2000-06-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-09 Gregorian' );
Sunday 19 Forelithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 10, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-06-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-06-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-06-10 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 2000-06-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-06-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 20 Forelithe 7464', 'as_string() on 2000-06-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-10 Gregorian' );
Monday 20 Forelithe 7464

Sauron attacks Osgiliath, 1418.
Thranduil is attacked, and Gollum escapes, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 11, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-06-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-06-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-06-11 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 2000-06-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-06-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 21 Forelithe 7464', 'as_string() on 2000-06-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-11 Gregorian' );
Trewsday 21 Forelithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 12, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-06-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-06-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-06-12 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 2000-06-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-06-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 22 Forelithe 7464', 'as_string() on 2000-06-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-12 Gregorian' );
Hevensday 22 Forelithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 13, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-06-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-06-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-06-13 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 2000-06-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-06-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 23 Forelithe 7464', 'as_string() on 2000-06-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-13 Gregorian' );
Mersday 23 Forelithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 14, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-06-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-06-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-06-14 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 2000-06-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-06-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 24 Forelithe 7464', 'as_string() on 2000-06-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-14 Gregorian' );
Highday 24 Forelithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 15, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-06-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-06-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-06-15 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 2000-06-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-06-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 25 Forelithe 7464', 'as_string() on 2000-06-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-15 Gregorian' );
Sterday 25 Forelithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 16, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-06-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-06-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-06-16 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 2000-06-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-06-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 26 Forelithe 7464', 'as_string() on 2000-06-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-16 Gregorian' );
Sunday 26 Forelithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 17, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-06-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-06-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-06-17 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 2000-06-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-06-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 27 Forelithe 7464', 'as_string() on 2000-06-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-17 Gregorian' );
Monday 27 Forelithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 18, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-06-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-06-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-06-18 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 2000-06-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-06-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 28 Forelithe 7464', 'as_string() on 2000-06-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-18 Gregorian' );
Trewsday 28 Forelithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 19, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-06-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-06-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-06-19 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 2000-06-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-06-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 29 Forelithe 7464', 'as_string() on 2000-06-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-19 Gregorian' );
Hevensday 29 Forelithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 20, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-06-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-06-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2000-06-20 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 2000-06-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-06-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 30 Forelithe 7464', 'as_string() on 2000-06-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-20 Gregorian' );
Mersday 30 Forelithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 21, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-06-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-06-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', '', 'month() on 2000-06-21 Gregorian' );
cmp_ok( $dts->day(), '==', 0, 'day() on 2000-06-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '1 Lithe', 'holiday() on 2000-06-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 1 Lithe 7464', 'as_string() on 2000-06-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-21 Gregorian' );
Highday 1 Lithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 22, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', '', 'weekday() on 2000-06-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', '', 'trad_weekday() on 2000-06-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', '', 'month() on 2000-06-22 Gregorian' );
cmp_ok( $dts->day(), '==', 0, 'day() on 2000-06-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', 'Midyear\'s day', 'holiday() on 2000-06-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Midyear\'s day 7464', 'as_string() on 2000-06-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-22 Gregorian' );
Midyear's day 7464

Wedding of King Elessar and Arwen, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 23, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', '', 'weekday() on 2000-06-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', '', 'trad_weekday() on 2000-06-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', '', 'month() on 2000-06-23 Gregorian' );
cmp_ok( $dts->day(), '==', 0, 'day() on 2000-06-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', 'Overlithe', 'holiday() on 2000-06-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Overlithe 7464', 'as_string() on 2000-06-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-23 Gregorian' );
Overlithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 24, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-06-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-06-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', '', 'month() on 2000-06-24 Gregorian' );
cmp_ok( $dts->day(), '==', 0, 'day() on 2000-06-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '2 Lithe', 'holiday() on 2000-06-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 2 Lithe 7464', 'as_string() on 2000-06-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-24 Gregorian' );
Sterday 2 Lithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 25, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-06-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-06-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-06-25 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 2000-06-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-06-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 1 Afterlithe 7464', 'as_string() on 2000-06-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-25 Gregorian' );
Sunday 1 Afterlithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 26, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-06-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-06-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-06-26 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 2000-06-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-06-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 2 Afterlithe 7464', 'as_string() on 2000-06-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-26 Gregorian' );
Monday 2 Afterlithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 27, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-06-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-06-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-06-27 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 2000-06-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-06-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 3 Afterlithe 7464', 'as_string() on 2000-06-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-27 Gregorian' );
Trewsday 3 Afterlithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 28, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-06-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-06-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-06-28 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 2000-06-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-06-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 4 Afterlithe 7464', 'as_string() on 2000-06-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-28 Gregorian' );
Hevensday 4 Afterlithe 7464

Boromir sets out from Minas Tirith, 1418
EOT

$epoch = timelocal( 0, 0, 0, 29, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-06-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-06-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-06-29 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 2000-06-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-06-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 5 Afterlithe 7464', 'as_string() on 2000-06-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-29 Gregorian' );
Mersday 5 Afterlithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 30, 5, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-06-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-06-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-06-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-06-30 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 2000-06-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-06-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-06-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 6 Afterlithe 7464', 'as_string() on 2000-06-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-06-30 Gregorian' );
Highday 6 Afterlithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 1, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-07-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-07-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-07-01 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 2000-07-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 7 Afterlithe 7464', 'as_string() on 2000-07-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-01 Gregorian' );
Sterday 7 Afterlithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 2, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-07-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-07-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-07-02 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 2000-07-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 8 Afterlithe 7464', 'as_string() on 2000-07-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-02 Gregorian' );
Sunday 8 Afterlithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 3, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-07-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-07-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-07-03 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 2000-07-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 9 Afterlithe 7464', 'as_string() on 2000-07-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-03 Gregorian' );
Monday 9 Afterlithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 4, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-07-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-07-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-07-04 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 2000-07-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 10 Afterlithe 7464', 'as_string() on 2000-07-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-04 Gregorian' );
Trewsday 10 Afterlithe 7464

Gandalf imprisoned in Orthanc, 1418
EOT

$epoch = timelocal( 0, 0, 0, 5, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-07-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-07-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-07-05 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 2000-07-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 11 Afterlithe 7464', 'as_string() on 2000-07-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-05 Gregorian' );
Hevensday 11 Afterlithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 6, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-07-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-07-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-07-06 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 2000-07-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 12 Afterlithe 7464', 'as_string() on 2000-07-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-06 Gregorian' );
Mersday 12 Afterlithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 7, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-07-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-07-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-07-07 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 2000-07-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 13 Afterlithe 7464', 'as_string() on 2000-07-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-07 Gregorian' );
Highday 13 Afterlithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 8, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-07-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-07-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-07-08 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 2000-07-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 14 Afterlithe 7464', 'as_string() on 2000-07-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-08 Gregorian' );
Sterday 14 Afterlithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 9, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-07-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-07-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-07-09 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 2000-07-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 15 Afterlithe 7464', 'as_string() on 2000-07-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-09 Gregorian' );
Sunday 15 Afterlithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 10, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-07-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-07-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-07-10 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 2000-07-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 16 Afterlithe 7464', 'as_string() on 2000-07-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-10 Gregorian' );
Monday 16 Afterlithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 11, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-07-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-07-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-07-11 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 2000-07-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 17 Afterlithe 7464', 'as_string() on 2000-07-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-11 Gregorian' );
Trewsday 17 Afterlithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 12, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-07-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-07-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-07-12 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 2000-07-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 18 Afterlithe 7464', 'as_string() on 2000-07-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-12 Gregorian' );
Hevensday 18 Afterlithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 13, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-07-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-07-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-07-13 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 2000-07-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 19 Afterlithe 7464', 'as_string() on 2000-07-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-13 Gregorian' );
Mersday 19 Afterlithe 7464

Funeral Escort of King Theoden leaves Minas Tirith, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 14, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-07-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-07-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-07-14 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 2000-07-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 20 Afterlithe 7464', 'as_string() on 2000-07-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-14 Gregorian' );
Highday 20 Afterlithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 15, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-07-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-07-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-07-15 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 2000-07-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 21 Afterlithe 7464', 'as_string() on 2000-07-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-15 Gregorian' );
Sterday 21 Afterlithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 16, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-07-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-07-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-07-16 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 2000-07-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 22 Afterlithe 7464', 'as_string() on 2000-07-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-16 Gregorian' );
Sunday 22 Afterlithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 17, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-07-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-07-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-07-17 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 2000-07-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 23 Afterlithe 7464', 'as_string() on 2000-07-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-17 Gregorian' );
Monday 23 Afterlithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 18, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-07-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-07-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-07-18 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 2000-07-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 24 Afterlithe 7464', 'as_string() on 2000-07-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-18 Gregorian' );
Trewsday 24 Afterlithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 19, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-07-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-07-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-07-19 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 2000-07-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 25 Afterlithe 7464', 'as_string() on 2000-07-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-19 Gregorian' );
Hevensday 25 Afterlithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 20, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-07-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-07-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-07-20 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 2000-07-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 26 Afterlithe 7464', 'as_string() on 2000-07-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-20 Gregorian' );
Mersday 26 Afterlithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 21, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-07-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-07-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-07-21 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 2000-07-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 27 Afterlithe 7464', 'as_string() on 2000-07-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-21 Gregorian' );
Highday 27 Afterlithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 22, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-07-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-07-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-07-22 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 2000-07-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 28 Afterlithe 7464', 'as_string() on 2000-07-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-22 Gregorian' );
Sterday 28 Afterlithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 23, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-07-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-07-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-07-23 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 2000-07-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 29 Afterlithe 7464', 'as_string() on 2000-07-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-23 Gregorian' );
Sunday 29 Afterlithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 24, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-07-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-07-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2000-07-24 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 2000-07-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 30 Afterlithe 7464', 'as_string() on 2000-07-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-24 Gregorian' );
Monday 30 Afterlithe 7464
EOT

$epoch = timelocal( 0, 0, 0, 25, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-07-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-07-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-07-25 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 2000-07-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 1 Wedmath 7464', 'as_string() on 2000-07-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-25 Gregorian' );
Trewsday 1 Wedmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 26, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-07-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-07-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-07-26 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 2000-07-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 2 Wedmath 7464', 'as_string() on 2000-07-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-26 Gregorian' );
Hevensday 2 Wedmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 27, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-07-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-07-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-07-27 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 2000-07-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 3 Wedmath 7464', 'as_string() on 2000-07-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-27 Gregorian' );
Mersday 3 Wedmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 28, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-07-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-07-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-07-28 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 2000-07-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 4 Wedmath 7464', 'as_string() on 2000-07-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-28 Gregorian' );
Highday 4 Wedmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 29, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-07-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-07-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-07-29 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 2000-07-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 5 Wedmath 7464', 'as_string() on 2000-07-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-29 Gregorian' );
Sterday 5 Wedmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 30, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-07-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-07-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-07-30 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 2000-07-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 6 Wedmath 7464', 'as_string() on 2000-07-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-30 Gregorian' );
Sunday 6 Wedmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 31, 6, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-07-31 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-07-31 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-07-31 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-07-31 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 2000-07-31 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-07-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-07-31 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 7 Wedmath 7464', 'as_string() on 2000-07-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-07-31 Gregorian' );
Monday 7 Wedmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 1, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-08-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-08-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-08-01 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 2000-08-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 8 Wedmath 7464', 'as_string() on 2000-08-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-01 Gregorian' );
Trewsday 8 Wedmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 2, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-08-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-08-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-08-02 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 2000-08-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 9 Wedmath 7464', 'as_string() on 2000-08-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-02 Gregorian' );
Hevensday 9 Wedmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 3, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-08-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-08-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-08-03 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 2000-08-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 10 Wedmath 7464', 'as_string() on 2000-08-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-03 Gregorian' );
Mersday 10 Wedmath 7464

Funeral of King Theoden, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 4, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-08-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-08-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-08-04 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 2000-08-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 11 Wedmath 7464', 'as_string() on 2000-08-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-04 Gregorian' );
Highday 11 Wedmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 5, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-08-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-08-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-08-05 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 2000-08-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 12 Wedmath 7464', 'as_string() on 2000-08-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-05 Gregorian' );
Sterday 12 Wedmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 6, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-08-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-08-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-08-06 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 2000-08-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 13 Wedmath 7464', 'as_string() on 2000-08-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-06 Gregorian' );
Sunday 13 Wedmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 7, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-08-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-08-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-08-07 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 2000-08-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 14 Wedmath 7464', 'as_string() on 2000-08-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-07 Gregorian' );
Monday 14 Wedmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 8, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-08-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-08-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-08-08 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 2000-08-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 15 Wedmath 7464', 'as_string() on 2000-08-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-08 Gregorian' );
Trewsday 15 Wedmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 9, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-08-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-08-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-08-09 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 2000-08-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 16 Wedmath 7464', 'as_string() on 2000-08-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-09 Gregorian' );
Hevensday 16 Wedmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 10, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-08-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-08-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-08-10 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 2000-08-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 17 Wedmath 7464', 'as_string() on 2000-08-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-10 Gregorian' );
Mersday 17 Wedmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 11, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-08-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-08-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-08-11 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 2000-08-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 18 Wedmath 7464', 'as_string() on 2000-08-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-11 Gregorian' );
Highday 18 Wedmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 12, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-08-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-08-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-08-12 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 2000-08-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 19 Wedmath 7464', 'as_string() on 2000-08-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-12 Gregorian' );
Sterday 19 Wedmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 13, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-08-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-08-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-08-13 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 2000-08-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 20 Wedmath 7464', 'as_string() on 2000-08-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-13 Gregorian' );
Sunday 20 Wedmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 14, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-08-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-08-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-08-14 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 2000-08-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 21 Wedmath 7464', 'as_string() on 2000-08-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-14 Gregorian' );
Monday 21 Wedmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 15, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-08-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-08-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-08-15 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 2000-08-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 22 Wedmath 7464', 'as_string() on 2000-08-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-15 Gregorian' );
Trewsday 22 Wedmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 16, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-08-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-08-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-08-16 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 2000-08-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 23 Wedmath 7464', 'as_string() on 2000-08-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-16 Gregorian' );
Hevensday 23 Wedmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 17, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-08-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-08-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-08-17 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 2000-08-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 24 Wedmath 7464', 'as_string() on 2000-08-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-17 Gregorian' );
Mersday 24 Wedmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 18, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-08-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-08-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-08-18 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 2000-08-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 25 Wedmath 7464', 'as_string() on 2000-08-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-18 Gregorian' );
Highday 25 Wedmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 19, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-08-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-08-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-08-19 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 2000-08-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 26 Wedmath 7464', 'as_string() on 2000-08-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-19 Gregorian' );
Sterday 26 Wedmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 20, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-08-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-08-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-08-20 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 2000-08-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 27 Wedmath 7464', 'as_string() on 2000-08-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-20 Gregorian' );
Sunday 27 Wedmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 21, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-08-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-08-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-08-21 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 2000-08-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 28 Wedmath 7464', 'as_string() on 2000-08-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-21 Gregorian' );
Monday 28 Wedmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 22, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-08-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-08-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-08-22 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 2000-08-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 29 Wedmath 7464', 'as_string() on 2000-08-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-22 Gregorian' );
Trewsday 29 Wedmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 23, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-08-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-08-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2000-08-23 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 2000-08-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 30 Wedmath 7464', 'as_string() on 2000-08-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-23 Gregorian' );
Hevensday 30 Wedmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 24, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-08-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-08-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-08-24 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 2000-08-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 1 Halimath 7464', 'as_string() on 2000-08-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-24 Gregorian' );
Mersday 1 Halimath 7464
EOT

$epoch = timelocal( 0, 0, 0, 25, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-08-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-08-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-08-25 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 2000-08-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 2 Halimath 7464', 'as_string() on 2000-08-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-25 Gregorian' );
Highday 2 Halimath 7464
EOT

$epoch = timelocal( 0, 0, 0, 26, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-08-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-08-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-08-26 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 2000-08-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 3 Halimath 7464', 'as_string() on 2000-08-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-26 Gregorian' );
Sterday 3 Halimath 7464
EOT

$epoch = timelocal( 0, 0, 0, 27, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-08-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-08-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-08-27 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 2000-08-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 4 Halimath 7464', 'as_string() on 2000-08-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-27 Gregorian' );
Sunday 4 Halimath 7464
EOT

$epoch = timelocal( 0, 0, 0, 28, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-08-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-08-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-08-28 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 2000-08-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 5 Halimath 7464', 'as_string() on 2000-08-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-28 Gregorian' );
Monday 5 Halimath 7464
EOT

$epoch = timelocal( 0, 0, 0, 29, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-08-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-08-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-08-29 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 2000-08-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 6 Halimath 7464', 'as_string() on 2000-08-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-29 Gregorian' );
Trewsday 6 Halimath 7464
EOT

$epoch = timelocal( 0, 0, 0, 30, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-08-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-08-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-08-30 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 2000-08-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 7 Halimath 7464', 'as_string() on 2000-08-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-30 Gregorian' );
Hevensday 7 Halimath 7464
EOT

$epoch = timelocal( 0, 0, 0, 31, 7, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-08-31 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-08-31 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-08-31 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-08-31 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 2000-08-31 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-08-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-08-31 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 8 Halimath 7464', 'as_string() on 2000-08-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-08-31 Gregorian' );
Mersday 8 Halimath 7464
EOT

$epoch = timelocal( 0, 0, 0, 1, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-09-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-09-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-09-01 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 2000-09-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 9 Halimath 7464', 'as_string() on 2000-09-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-01 Gregorian' );
Highday 9 Halimath 7464
EOT

$epoch = timelocal( 0, 0, 0, 2, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-09-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-09-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-09-02 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 2000-09-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 10 Halimath 7464', 'as_string() on 2000-09-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-02 Gregorian' );
Sterday 10 Halimath 7464
EOT

$epoch = timelocal( 0, 0, 0, 3, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-09-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-09-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-09-03 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 2000-09-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 11 Halimath 7464', 'as_string() on 2000-09-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-03 Gregorian' );
Sunday 11 Halimath 7464
EOT

$epoch = timelocal( 0, 0, 0, 4, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-09-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-09-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-09-04 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 2000-09-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 12 Halimath 7464', 'as_string() on 2000-09-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-04 Gregorian' );
Monday 12 Halimath 7464
EOT

$epoch = timelocal( 0, 0, 0, 5, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-09-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-09-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-09-05 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 2000-09-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 13 Halimath 7464', 'as_string() on 2000-09-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-05 Gregorian' );
Trewsday 13 Halimath 7464
EOT

$epoch = timelocal( 0, 0, 0, 6, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-09-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-09-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-09-06 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 2000-09-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 14 Halimath 7464', 'as_string() on 2000-09-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-06 Gregorian' );
Hevensday 14 Halimath 7464
EOT

$epoch = timelocal( 0, 0, 0, 7, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-09-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-09-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-09-07 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 2000-09-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 15 Halimath 7464', 'as_string() on 2000-09-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-07 Gregorian' );
Mersday 15 Halimath 7464
EOT

$epoch = timelocal( 0, 0, 0, 8, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-09-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-09-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-09-08 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 2000-09-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 16 Halimath 7464', 'as_string() on 2000-09-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-08 Gregorian' );
Highday 16 Halimath 7464
EOT

$epoch = timelocal( 0, 0, 0, 9, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-09-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-09-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-09-09 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 2000-09-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 17 Halimath 7464', 'as_string() on 2000-09-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-09 Gregorian' );
Sterday 17 Halimath 7464
EOT

$epoch = timelocal( 0, 0, 0, 10, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-09-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-09-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-09-10 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 2000-09-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 18 Halimath 7464', 'as_string() on 2000-09-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-10 Gregorian' );
Sunday 18 Halimath 7464

Gandalf escapes from Orthanc in the early hours, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 11, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-09-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-09-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-09-11 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 2000-09-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 19 Halimath 7464', 'as_string() on 2000-09-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-11 Gregorian' );
Monday 19 Halimath 7464

Gandalf comes to Edoras as a beggar, and is refused admittance, 1418
EOT

$epoch = timelocal( 0, 0, 0, 12, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-09-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-09-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-09-12 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 2000-09-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 20 Halimath 7464', 'as_string() on 2000-09-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-12 Gregorian' );
Trewsday 20 Halimath 7464

Gandalf gains entrance to Edoras.  Theoden commands him to go:
"Take any horse, only be gone ere tomorrow is old", 1418.
EOT

$epoch = timelocal( 0, 0, 0, 13, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-09-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-09-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-09-13 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 2000-09-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 21 Halimath 7464', 'as_string() on 2000-09-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-13 Gregorian' );
Hevensday 21 Halimath 7464

The hobbits return to Rivendell, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 14, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-09-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-09-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-09-14 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 2000-09-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 22 Halimath 7464', 'as_string() on 2000-09-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-14 Gregorian' );
Mersday 22 Halimath 7464

Birthday of Bilbo and Frodo.
The Black Riders reach Sarn Ford at evening;
  they drive off the guard of Rangers, 1418.
Saruman comes to the Shire, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 15, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-09-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-09-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-09-15 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 2000-09-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 23 Halimath 7464', 'as_string() on 2000-09-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-15 Gregorian' );
Highday 23 Halimath 7464

Four Black Riders enter the shire before dawn.  The others pursue 
the Rangers eastward and then return to watch the Greenway, 1418.
A Black Rider comes to Hobbiton at nightfall, 1418.
Frodo leaves Bag End, 1418.
Gandalf having tamed Shadowfax rides from Rohan, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 16, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-09-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-09-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-09-16 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 2000-09-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 24 Halimath 7464', 'as_string() on 2000-09-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-16 Gregorian' );
Sterday 24 Halimath 7464
EOT

$epoch = timelocal( 0, 0, 0, 17, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-09-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-09-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-09-17 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 2000-09-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 25 Halimath 7464', 'as_string() on 2000-09-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-17 Gregorian' );
Sunday 25 Halimath 7464
EOT

$epoch = timelocal( 0, 0, 0, 18, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-09-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-09-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-09-18 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 2000-09-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 26 Halimath 7464', 'as_string() on 2000-09-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-18 Gregorian' );
Monday 26 Halimath 7464

Frodo comes to Bombadil, 1418
EOT

$epoch = timelocal( 0, 0, 0, 19, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-09-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-09-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-09-19 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 2000-09-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 27 Halimath 7464', 'as_string() on 2000-09-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-19 Gregorian' );
Trewsday 27 Halimath 7464
EOT

$epoch = timelocal( 0, 0, 0, 20, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-09-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-09-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-09-20 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 2000-09-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 28 Halimath 7464', 'as_string() on 2000-09-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-20 Gregorian' );
Hevensday 28 Halimath 7464

The Hobbits are captured by a barrow-wight, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 21, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-09-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-09-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-09-21 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 2000-09-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 29 Halimath 7464', 'as_string() on 2000-09-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-21 Gregorian' );
Mersday 29 Halimath 7464

Frodo reaches Bree at night, 1418.
Frodo and Bilbo depart over the sea with the three Keepers, 1421.
End of the Third Age, 1421.
EOT

$epoch = timelocal( 0, 0, 0, 22, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-09-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-09-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2000-09-22 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 2000-09-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 30 Halimath 7464', 'as_string() on 2000-09-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-22 Gregorian' );
Highday 30 Halimath 7464

Crickhollow and the inn at Bree are raided in the early hours, 1418.
Frodo leaves Bree, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 23, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-09-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-09-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-09-23 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 2000-09-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 1 Winterfilth 7464', 'as_string() on 2000-09-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-23 Gregorian' );
Sterday 1 Winterfilth 7464
EOT

$epoch = timelocal( 0, 0, 0, 24, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-09-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-09-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-09-24 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 2000-09-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 2 Winterfilth 7464', 'as_string() on 2000-09-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-24 Gregorian' );
Sunday 2 Winterfilth 7464
EOT

$epoch = timelocal( 0, 0, 0, 25, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-09-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-09-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-09-25 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 2000-09-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 3 Winterfilth 7464', 'as_string() on 2000-09-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-25 Gregorian' );
Monday 3 Winterfilth 7464

Gandalf attacked at night on Weathertop, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 26, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-09-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-09-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-09-26 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 2000-09-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 4 Winterfilth 7464', 'as_string() on 2000-09-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-26 Gregorian' );
Trewsday 4 Winterfilth 7464
EOT

$epoch = timelocal( 0, 0, 0, 27, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-09-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-09-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-09-27 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 2000-09-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 5 Winterfilth 7464', 'as_string() on 2000-09-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-27 Gregorian' );
Hevensday 5 Winterfilth 7464

Gandalf and the Hobbits leave Rivendell, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 28, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-09-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-09-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-09-28 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 2000-09-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 6 Winterfilth 7464', 'as_string() on 2000-09-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-28 Gregorian' );
Mersday 6 Winterfilth 7464

The camp under Weathertop is attacked at night and Frodo is wounded, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 29, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-09-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-09-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-09-29 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 2000-09-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 7 Winterfilth 7464', 'as_string() on 2000-09-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-29 Gregorian' );
Highday 7 Winterfilth 7464
EOT

$epoch = timelocal( 0, 0, 0, 30, 8, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-09-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-09-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-09-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-09-30 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 2000-09-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-09-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-09-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 8 Winterfilth 7464', 'as_string() on 2000-09-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-09-30 Gregorian' );
Sterday 8 Winterfilth 7464
EOT

$epoch = timelocal( 0, 0, 0, 1, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-10-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-10-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-10-01 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 2000-10-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 9 Winterfilth 7464', 'as_string() on 2000-10-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-01 Gregorian' );
Sunday 9 Winterfilth 7464
EOT

$epoch = timelocal( 0, 0, 0, 2, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-10-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-10-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-10-02 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 2000-10-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 10 Winterfilth 7464', 'as_string() on 2000-10-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-02 Gregorian' );
Monday 10 Winterfilth 7464
EOT

$epoch = timelocal( 0, 0, 0, 3, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-10-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-10-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-10-03 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 2000-10-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 11 Winterfilth 7464', 'as_string() on 2000-10-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-03 Gregorian' );
Trewsday 11 Winterfilth 7464

Glorfindel drives the Black Riders off the Bridge of Mitheithel, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 4, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-10-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-10-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-10-04 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 2000-10-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 12 Winterfilth 7464', 'as_string() on 2000-10-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-04 Gregorian' );
Hevensday 12 Winterfilth 7464
EOT

$epoch = timelocal( 0, 0, 0, 5, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-10-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-10-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-10-05 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 2000-10-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 13 Winterfilth 7464', 'as_string() on 2000-10-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-05 Gregorian' );
Mersday 13 Winterfilth 7464

Frodo crosses the Bridge of Mitheithel, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 6, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-10-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-10-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-10-06 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 2000-10-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 14 Winterfilth 7464', 'as_string() on 2000-10-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-06 Gregorian' );
Highday 14 Winterfilth 7464
EOT

$epoch = timelocal( 0, 0, 0, 7, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-10-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-10-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-10-07 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 2000-10-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 15 Winterfilth 7464', 'as_string() on 2000-10-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-07 Gregorian' );
Sterday 15 Winterfilth 7464
EOT

$epoch = timelocal( 0, 0, 0, 8, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-10-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-10-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-10-08 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 2000-10-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 16 Winterfilth 7464', 'as_string() on 2000-10-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-08 Gregorian' );
Sunday 16 Winterfilth 7464
EOT

$epoch = timelocal( 0, 0, 0, 9, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-10-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-10-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-10-09 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 2000-10-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 17 Winterfilth 7464', 'as_string() on 2000-10-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-09 Gregorian' );
Monday 17 Winterfilth 7464
EOT

$epoch = timelocal( 0, 0, 0, 10, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-10-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-10-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-10-10 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 2000-10-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 18 Winterfilth 7464', 'as_string() on 2000-10-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-10 Gregorian' );
Trewsday 18 Winterfilth 7464

Glorfindel finds Frodo at dusk, 1418.
Gandalf reaches Rivendell, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 11, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-10-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-10-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-10-11 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 2000-10-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 19 Winterfilth 7464', 'as_string() on 2000-10-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-11 Gregorian' );
Hevensday 19 Winterfilth 7464
EOT

$epoch = timelocal( 0, 0, 0, 12, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-10-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-10-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-10-12 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 2000-10-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 20 Winterfilth 7464', 'as_string() on 2000-10-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-12 Gregorian' );
Mersday 20 Winterfilth 7464

Escape across the Ford of Bruinen, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 13, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-10-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-10-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-10-13 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 2000-10-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 21 Winterfilth 7464', 'as_string() on 2000-10-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-13 Gregorian' );
Highday 21 Winterfilth 7464
EOT

$epoch = timelocal( 0, 0, 0, 14, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-10-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-10-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-10-14 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 2000-10-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 22 Winterfilth 7464', 'as_string() on 2000-10-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-14 Gregorian' );
Sterday 22 Winterfilth 7464
EOT

$epoch = timelocal( 0, 0, 0, 15, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-10-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-10-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-10-15 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 2000-10-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 23 Winterfilth 7464', 'as_string() on 2000-10-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-15 Gregorian' );
Sunday 23 Winterfilth 7464
EOT

$epoch = timelocal( 0, 0, 0, 16, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-10-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-10-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-10-16 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 2000-10-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 24 Winterfilth 7464', 'as_string() on 2000-10-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-16 Gregorian' );
Monday 24 Winterfilth 7464

Frodo recovers and wakes, 1418.
Boromir arrives at Rivendell at night, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 17, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-10-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-10-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-10-17 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 2000-10-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 25 Winterfilth 7464', 'as_string() on 2000-10-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-17 Gregorian' );
Trewsday 25 Winterfilth 7464

Council of Elrond, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 18, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-10-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-10-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-10-18 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 2000-10-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 26 Winterfilth 7464', 'as_string() on 2000-10-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-18 Gregorian' );
Hevensday 26 Winterfilth 7464
EOT

$epoch = timelocal( 0, 0, 0, 19, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-10-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-10-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-10-19 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 2000-10-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 27 Winterfilth 7464', 'as_string() on 2000-10-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-19 Gregorian' );
Mersday 27 Winterfilth 7464
EOT

$epoch = timelocal( 0, 0, 0, 20, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-10-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-10-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-10-20 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 2000-10-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 28 Winterfilth 7464', 'as_string() on 2000-10-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-20 Gregorian' );
Highday 28 Winterfilth 7464
EOT

$epoch = timelocal( 0, 0, 0, 21, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-10-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-10-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-10-21 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 2000-10-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 29 Winterfilth 7464', 'as_string() on 2000-10-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-21 Gregorian' );
Sterday 29 Winterfilth 7464
EOT

$epoch = timelocal( 0, 0, 0, 22, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-10-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-10-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2000-10-22 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 2000-10-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 30 Winterfilth 7464', 'as_string() on 2000-10-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-22 Gregorian' );
Sunday 30 Winterfilth 7464

The four Hobbits arrive at the Brandywine Bridge in the dark, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 23, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-10-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-10-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-10-23 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 2000-10-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 1 Blotmath 7464', 'as_string() on 2000-10-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-23 Gregorian' );
Monday 1 Blotmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 24, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-10-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-10-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-10-24 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 2000-10-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 2 Blotmath 7464', 'as_string() on 2000-10-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-24 Gregorian' );
Trewsday 2 Blotmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 25, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-10-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-10-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-10-25 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 2000-10-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 3 Blotmath 7464', 'as_string() on 2000-10-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-25 Gregorian' );
Hevensday 3 Blotmath 7464

Battle of Bywater and passing of Saruman, 1419.
End of the War of the Ring, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 26, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-10-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-10-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-10-26 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 2000-10-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 4 Blotmath 7464', 'as_string() on 2000-10-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-26 Gregorian' );
Mersday 4 Blotmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 27, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-10-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-10-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-10-27 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 2000-10-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 5 Blotmath 7464', 'as_string() on 2000-10-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-27 Gregorian' );
Highday 5 Blotmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 28, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-10-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-10-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-10-28 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 2000-10-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 6 Blotmath 7464', 'as_string() on 2000-10-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-28 Gregorian' );
Sterday 6 Blotmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 29, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-10-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-10-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-10-29 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 2000-10-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 7 Blotmath 7464', 'as_string() on 2000-10-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-29 Gregorian' );
Sunday 7 Blotmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 30, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-10-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-10-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-10-30 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 2000-10-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 8 Blotmath 7464', 'as_string() on 2000-10-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-30 Gregorian' );
Monday 8 Blotmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 31, 9, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-10-31 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-10-31 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-10-31 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-10-31 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 2000-10-31 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-10-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-10-31 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 9 Blotmath 7464', 'as_string() on 2000-10-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-10-31 Gregorian' );
Trewsday 9 Blotmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 1, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-11-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-11-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-11-01 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 2000-11-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 10 Blotmath 7464', 'as_string() on 2000-11-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-01 Gregorian' );
Hevensday 10 Blotmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 2, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-11-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-11-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-11-02 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 2000-11-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 11 Blotmath 7464', 'as_string() on 2000-11-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-02 Gregorian' );
Mersday 11 Blotmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 3, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-11-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-11-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-11-03 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 2000-11-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 12 Blotmath 7464', 'as_string() on 2000-11-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-03 Gregorian' );
Highday 12 Blotmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 4, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-11-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-11-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-11-04 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 2000-11-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 13 Blotmath 7464', 'as_string() on 2000-11-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-04 Gregorian' );
Sterday 13 Blotmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 5, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-11-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-11-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-11-05 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 2000-11-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 14 Blotmath 7464', 'as_string() on 2000-11-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-05 Gregorian' );
Sunday 14 Blotmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 6, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-11-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-11-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-11-06 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 2000-11-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 15 Blotmath 7464', 'as_string() on 2000-11-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-06 Gregorian' );
Monday 15 Blotmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 7, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-11-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-11-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-11-07 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 2000-11-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 16 Blotmath 7464', 'as_string() on 2000-11-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-07 Gregorian' );
Trewsday 16 Blotmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 8, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-11-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-11-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-11-08 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 2000-11-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 17 Blotmath 7464', 'as_string() on 2000-11-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-08 Gregorian' );
Hevensday 17 Blotmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 9, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-11-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-11-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-11-09 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 2000-11-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 18 Blotmath 7464', 'as_string() on 2000-11-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-09 Gregorian' );
Mersday 18 Blotmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 10, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-11-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-11-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-11-10 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 2000-11-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 19 Blotmath 7464', 'as_string() on 2000-11-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-10 Gregorian' );
Highday 19 Blotmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 11, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-11-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-11-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-11-11 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 2000-11-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 20 Blotmath 7464', 'as_string() on 2000-11-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-11 Gregorian' );
Sterday 20 Blotmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 12, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-11-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-11-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-11-12 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 2000-11-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 21 Blotmath 7464', 'as_string() on 2000-11-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-12 Gregorian' );
Sunday 21 Blotmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 13, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-11-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-11-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-11-13 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 2000-11-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 22 Blotmath 7464', 'as_string() on 2000-11-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-13 Gregorian' );
Monday 22 Blotmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 14, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-11-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-11-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-11-14 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 2000-11-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 23 Blotmath 7464', 'as_string() on 2000-11-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-14 Gregorian' );
Trewsday 23 Blotmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 15, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-11-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-11-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-11-15 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 2000-11-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 24 Blotmath 7464', 'as_string() on 2000-11-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-15 Gregorian' );
Hevensday 24 Blotmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 16, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-11-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-11-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-11-16 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 2000-11-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 25 Blotmath 7464', 'as_string() on 2000-11-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-16 Gregorian' );
Mersday 25 Blotmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 17, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-11-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-11-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-11-17 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 2000-11-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 26 Blotmath 7464', 'as_string() on 2000-11-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-17 Gregorian' );
Highday 26 Blotmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 18, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-11-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-11-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-11-18 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 2000-11-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 27 Blotmath 7464', 'as_string() on 2000-11-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-18 Gregorian' );
Sterday 27 Blotmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 19, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-11-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-11-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-11-19 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 2000-11-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 28 Blotmath 7464', 'as_string() on 2000-11-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-19 Gregorian' );
Sunday 28 Blotmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 20, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-11-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-11-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-11-20 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 2000-11-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 29 Blotmath 7464', 'as_string() on 2000-11-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-20 Gregorian' );
Monday 29 Blotmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 21, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-11-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-11-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2000-11-21 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 2000-11-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 30 Blotmath 7464', 'as_string() on 2000-11-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-21 Gregorian' );
Trewsday 30 Blotmath 7464
EOT

$epoch = timelocal( 0, 0, 0, 22, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-11-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-11-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-11-22 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 2000-11-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 1 Foreyule 7464', 'as_string() on 2000-11-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-22 Gregorian' );
Hevensday 1 Foreyule 7464
EOT

$epoch = timelocal( 0, 0, 0, 23, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-11-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-11-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-11-23 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 2000-11-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 2 Foreyule 7464', 'as_string() on 2000-11-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-23 Gregorian' );
Mersday 2 Foreyule 7464
EOT

$epoch = timelocal( 0, 0, 0, 24, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-11-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-11-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-11-24 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 2000-11-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 3 Foreyule 7464', 'as_string() on 2000-11-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-24 Gregorian' );
Highday 3 Foreyule 7464
EOT

$epoch = timelocal( 0, 0, 0, 25, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-11-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-11-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-11-25 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 2000-11-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 4 Foreyule 7464', 'as_string() on 2000-11-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-25 Gregorian' );
Sterday 4 Foreyule 7464
EOT

$epoch = timelocal( 0, 0, 0, 26, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-11-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-11-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-11-26 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 2000-11-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 5 Foreyule 7464', 'as_string() on 2000-11-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-26 Gregorian' );
Sunday 5 Foreyule 7464
EOT

$epoch = timelocal( 0, 0, 0, 27, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-11-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-11-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-11-27 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 2000-11-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 6 Foreyule 7464', 'as_string() on 2000-11-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-27 Gregorian' );
Monday 6 Foreyule 7464
EOT

$epoch = timelocal( 0, 0, 0, 28, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-11-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-11-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-11-28 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 2000-11-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 7 Foreyule 7464', 'as_string() on 2000-11-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-28 Gregorian' );
Trewsday 7 Foreyule 7464
EOT

$epoch = timelocal( 0, 0, 0, 29, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-11-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-11-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-11-29 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 2000-11-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 8 Foreyule 7464', 'as_string() on 2000-11-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-29 Gregorian' );
Hevensday 8 Foreyule 7464
EOT

$epoch = timelocal( 0, 0, 0, 30, 10, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-11-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-11-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-11-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-11-30 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 2000-11-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-11-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-11-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 9 Foreyule 7464', 'as_string() on 2000-11-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-11-30 Gregorian' );
Mersday 9 Foreyule 7464
EOT

$epoch = timelocal( 0, 0, 0, 1, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-12-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-12-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-12-01 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 2000-12-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-12-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-12-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 10 Foreyule 7464', 'as_string() on 2000-12-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-01 Gregorian' );
Highday 10 Foreyule 7464
EOT

$epoch = timelocal( 0, 0, 0, 2, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-12-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-12-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-12-02 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 2000-12-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-12-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-12-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 11 Foreyule 7464', 'as_string() on 2000-12-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-02 Gregorian' );
Sterday 11 Foreyule 7464
EOT

$epoch = timelocal( 0, 0, 0, 3, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-12-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-12-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-12-03 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 2000-12-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-12-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-12-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 12 Foreyule 7464', 'as_string() on 2000-12-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-03 Gregorian' );
Sunday 12 Foreyule 7464
EOT

$epoch = timelocal( 0, 0, 0, 4, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-12-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-12-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-12-04 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 2000-12-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-12-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-12-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 13 Foreyule 7464', 'as_string() on 2000-12-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-04 Gregorian' );
Monday 13 Foreyule 7464
EOT

$epoch = timelocal( 0, 0, 0, 5, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-12-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-12-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-12-05 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 2000-12-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-12-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-12-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 14 Foreyule 7464', 'as_string() on 2000-12-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-05 Gregorian' );
Trewsday 14 Foreyule 7464
EOT

$epoch = timelocal( 0, 0, 0, 6, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-12-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-12-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-12-06 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 2000-12-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-12-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-12-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 15 Foreyule 7464', 'as_string() on 2000-12-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-06 Gregorian' );
Hevensday 15 Foreyule 7464
EOT

$epoch = timelocal( 0, 0, 0, 7, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-12-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-12-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-12-07 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 2000-12-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-12-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-12-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 16 Foreyule 7464', 'as_string() on 2000-12-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-07 Gregorian' );
Mersday 16 Foreyule 7464
EOT

$epoch = timelocal( 0, 0, 0, 8, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-12-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-12-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-12-08 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 2000-12-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-12-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-12-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 17 Foreyule 7464', 'as_string() on 2000-12-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-08 Gregorian' );
Highday 17 Foreyule 7464
EOT

$epoch = timelocal( 0, 0, 0, 9, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-12-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-12-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-12-09 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 2000-12-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-12-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-12-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 18 Foreyule 7464', 'as_string() on 2000-12-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-09 Gregorian' );
Sterday 18 Foreyule 7464
EOT

$epoch = timelocal( 0, 0, 0, 10, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-12-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-12-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-12-10 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 2000-12-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-12-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-12-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 19 Foreyule 7464', 'as_string() on 2000-12-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-10 Gregorian' );
Sunday 19 Foreyule 7464
EOT

$epoch = timelocal( 0, 0, 0, 11, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-12-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-12-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-12-11 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 2000-12-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-12-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-12-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 20 Foreyule 7464', 'as_string() on 2000-12-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-11 Gregorian' );
Monday 20 Foreyule 7464
EOT

$epoch = timelocal( 0, 0, 0, 12, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-12-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-12-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-12-12 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 2000-12-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-12-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-12-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 21 Foreyule 7464', 'as_string() on 2000-12-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-12 Gregorian' );
Trewsday 21 Foreyule 7464
EOT

$epoch = timelocal( 0, 0, 0, 13, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-12-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-12-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-12-13 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 2000-12-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-12-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-12-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 22 Foreyule 7464', 'as_string() on 2000-12-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-13 Gregorian' );
Hevensday 22 Foreyule 7464
EOT

$epoch = timelocal( 0, 0, 0, 14, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-12-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-12-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-12-14 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 2000-12-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-12-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-12-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 23 Foreyule 7464', 'as_string() on 2000-12-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-14 Gregorian' );
Mersday 23 Foreyule 7464
EOT

$epoch = timelocal( 0, 0, 0, 15, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-12-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-12-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-12-15 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 2000-12-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-12-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-12-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 24 Foreyule 7464', 'as_string() on 2000-12-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-15 Gregorian' );
Highday 24 Foreyule 7464
EOT

$epoch = timelocal( 0, 0, 0, 16, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-12-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-12-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-12-16 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 2000-12-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-12-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-12-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 25 Foreyule 7464', 'as_string() on 2000-12-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-16 Gregorian' );
Sterday 25 Foreyule 7464

The Company of the Ring leaves Rivendell at dusk, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 17, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-12-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-12-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-12-17 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 2000-12-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-12-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-12-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 26 Foreyule 7464', 'as_string() on 2000-12-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-17 Gregorian' );
Sunday 26 Foreyule 7464
EOT

$epoch = timelocal( 0, 0, 0, 18, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-12-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-12-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-12-18 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 2000-12-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-12-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-12-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 27 Foreyule 7464', 'as_string() on 2000-12-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-18 Gregorian' );
Monday 27 Foreyule 7464
EOT

$epoch = timelocal( 0, 0, 0, 19, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-12-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-12-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-12-19 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 2000-12-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-12-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-12-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 28 Foreyule 7464', 'as_string() on 2000-12-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-19 Gregorian' );
Trewsday 28 Foreyule 7464
EOT

$epoch = timelocal( 0, 0, 0, 20, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-12-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-12-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-12-20 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 2000-12-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-12-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-12-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 29 Foreyule 7464', 'as_string() on 2000-12-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-20 Gregorian' );
Hevensday 29 Foreyule 7464
EOT

$epoch = timelocal( 0, 0, 0, 21, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-12-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-12-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2000-12-21 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 2000-12-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-12-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-12-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 30 Foreyule 7464', 'as_string() on 2000-12-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-21 Gregorian' );
Mersday 30 Foreyule 7464
EOT

$epoch = timelocal( 0, 0, 0, 22, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-12-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-12-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', '', 'month() on 2000-12-22 Gregorian' );
cmp_ok( $dts->day(), '==', 0, 'day() on 2000-12-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '1 Yule', 'holiday() on 2000-12-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7464, 'year() on 2000-12-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 1 Yule 7464', 'as_string() on 2000-12-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-22 Gregorian' );
Highday 1 Yule 7464
EOT

$epoch = timelocal( 0, 0, 0, 23, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-12-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-12-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', '', 'month() on 2000-12-23 Gregorian' );
cmp_ok( $dts->day(), '==', 0, 'day() on 2000-12-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '2 Yule', 'holiday() on 2000-12-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2000-12-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 2 Yule 7465', 'as_string() on 2000-12-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-23 Gregorian' );
Sterday 2 Yule 7465
EOT

$epoch = timelocal( 0, 0, 0, 24, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-12-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-12-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-12-24 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 2000-12-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-12-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2000-12-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 1 Afteryule 7465', 'as_string() on 2000-12-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-24 Gregorian' );
Sunday 1 Afteryule 7465
EOT

$epoch = timelocal( 0, 0, 0, 25, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2000-12-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2000-12-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-12-25 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 2000-12-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-12-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2000-12-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 2 Afteryule 7465', 'as_string() on 2000-12-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-25 Gregorian' );
Monday 2 Afteryule 7465
EOT

$epoch = timelocal( 0, 0, 0, 26, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2000-12-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2000-12-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-12-26 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 2000-12-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-12-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2000-12-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 3 Afteryule 7465', 'as_string() on 2000-12-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-26 Gregorian' );
Trewsday 3 Afteryule 7465
EOT

$epoch = timelocal( 0, 0, 0, 27, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2000-12-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2000-12-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-12-27 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 2000-12-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-12-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2000-12-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 4 Afteryule 7465', 'as_string() on 2000-12-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-27 Gregorian' );
Hevensday 4 Afteryule 7465
EOT

$epoch = timelocal( 0, 0, 0, 28, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2000-12-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2000-12-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-12-28 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 2000-12-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-12-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2000-12-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 5 Afteryule 7465', 'as_string() on 2000-12-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-28 Gregorian' );
Mersday 5 Afteryule 7465
EOT

$epoch = timelocal( 0, 0, 0, 29, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2000-12-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2000-12-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-12-29 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 2000-12-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-12-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2000-12-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 6 Afteryule 7465', 'as_string() on 2000-12-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-29 Gregorian' );
Highday 6 Afteryule 7465
EOT

$epoch = timelocal( 0, 0, 0, 30, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2000-12-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2000-12-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-12-30 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 2000-12-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-12-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2000-12-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 7 Afteryule 7465', 'as_string() on 2000-12-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-30 Gregorian' );
Sterday 7 Afteryule 7465
EOT

$epoch = timelocal( 0, 0, 0, 31, 11, 2000 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2000-12-31 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2000-12-31 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2000-12-31 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2000-12-31 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 2000-12-31 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2000-12-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2000-12-31 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 8 Afteryule 7465', 'as_string() on 2000-12-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2000-12-31 Gregorian' );
Sunday 8 Afteryule 7465

The Company of the Ring reaches Hollin, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 1, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-01-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-01-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-01-01 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 2001-01-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 9 Afteryule 7465', 'as_string() on 2001-01-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-01 Gregorian' );
Monday 9 Afteryule 7465
EOT

$epoch = timelocal( 0, 0, 0, 2, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-01-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-01-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-01-02 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 2001-01-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 10 Afteryule 7465', 'as_string() on 2001-01-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-02 Gregorian' );
Trewsday 10 Afteryule 7465
EOT

$epoch = timelocal( 0, 0, 0, 3, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-01-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-01-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-01-03 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 2001-01-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 11 Afteryule 7465', 'as_string() on 2001-01-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-03 Gregorian' );
Hevensday 11 Afteryule 7465
EOT

$epoch = timelocal( 0, 0, 0, 4, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-01-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-01-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-01-04 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 2001-01-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 12 Afteryule 7465', 'as_string() on 2001-01-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-04 Gregorian' );
Mersday 12 Afteryule 7465
EOT

$epoch = timelocal( 0, 0, 0, 5, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-01-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-01-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-01-05 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 2001-01-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 13 Afteryule 7465', 'as_string() on 2001-01-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-05 Gregorian' );
Highday 13 Afteryule 7465

The Company of the Ring reaches the West-gate of Moria at nightfall, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 6, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-01-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-01-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-01-06 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 2001-01-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 14 Afteryule 7465', 'as_string() on 2001-01-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-06 Gregorian' );
Sterday 14 Afteryule 7465

The Company of the Ring spends the night in Moria hall 21, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 7, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-01-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-01-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-01-07 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 2001-01-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 15 Afteryule 7465', 'as_string() on 2001-01-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-07 Gregorian' );
Sunday 15 Afteryule 7465

The Bridge of Khazad-dum, and the fall of Gandalf, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 8, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-01-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-01-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-01-08 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 2001-01-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 16 Afteryule 7465', 'as_string() on 2001-01-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-08 Gregorian' );
Monday 16 Afteryule 7465
EOT

$epoch = timelocal( 0, 0, 0, 9, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-01-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-01-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-01-09 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 2001-01-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 17 Afteryule 7465', 'as_string() on 2001-01-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-09 Gregorian' );
Trewsday 17 Afteryule 7465

The Company of the Ring comes to Caras Galadhon at evening, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 10, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-01-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-01-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-01-10 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 2001-01-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 18 Afteryule 7465', 'as_string() on 2001-01-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-10 Gregorian' );
Hevensday 18 Afteryule 7465
EOT

$epoch = timelocal( 0, 0, 0, 11, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-01-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-01-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-01-11 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 2001-01-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 19 Afteryule 7465', 'as_string() on 2001-01-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-11 Gregorian' );
Mersday 19 Afteryule 7465
EOT

$epoch = timelocal( 0, 0, 0, 12, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-01-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-01-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-01-12 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 2001-01-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 20 Afteryule 7465', 'as_string() on 2001-01-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-12 Gregorian' );
Highday 20 Afteryule 7465
EOT

$epoch = timelocal( 0, 0, 0, 13, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-01-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-01-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-01-13 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 2001-01-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 21 Afteryule 7465', 'as_string() on 2001-01-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-13 Gregorian' );
Sterday 21 Afteryule 7465
EOT

$epoch = timelocal( 0, 0, 0, 14, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-01-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-01-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-01-14 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 2001-01-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 22 Afteryule 7465', 'as_string() on 2001-01-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-14 Gregorian' );
Sunday 22 Afteryule 7465
EOT

$epoch = timelocal( 0, 0, 0, 15, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-01-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-01-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-01-15 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 2001-01-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 23 Afteryule 7465', 'as_string() on 2001-01-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-15 Gregorian' );
Monday 23 Afteryule 7465

Gandalf pursues the Balrog to the peak of Zirakzigil, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 16, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-01-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-01-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-01-16 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 2001-01-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 24 Afteryule 7465', 'as_string() on 2001-01-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-16 Gregorian' );
Trewsday 24 Afteryule 7465
EOT

$epoch = timelocal( 0, 0, 0, 17, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-01-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-01-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-01-17 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 2001-01-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 25 Afteryule 7465', 'as_string() on 2001-01-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-17 Gregorian' );
Hevensday 25 Afteryule 7465

Gandalf casts down the Balrog, and passes away.
His body lies on the peak of Zirakzigil, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 18, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-01-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-01-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-01-18 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 2001-01-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 26 Afteryule 7465', 'as_string() on 2001-01-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-18 Gregorian' );
Mersday 26 Afteryule 7465
EOT

$epoch = timelocal( 0, 0, 0, 19, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-01-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-01-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-01-19 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 2001-01-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 27 Afteryule 7465', 'as_string() on 2001-01-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-19 Gregorian' );
Highday 27 Afteryule 7465
EOT

$epoch = timelocal( 0, 0, 0, 20, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-01-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-01-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-01-20 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 2001-01-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 28 Afteryule 7465', 'as_string() on 2001-01-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-20 Gregorian' );
Sterday 28 Afteryule 7465
EOT

$epoch = timelocal( 0, 0, 0, 21, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-01-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-01-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-01-21 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 2001-01-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 29 Afteryule 7465', 'as_string() on 2001-01-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-21 Gregorian' );
Sunday 29 Afteryule 7465
EOT

$epoch = timelocal( 0, 0, 0, 22, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-01-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-01-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-01-22 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 2001-01-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 30 Afteryule 7465', 'as_string() on 2001-01-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-22 Gregorian' );
Monday 30 Afteryule 7465
EOT

$epoch = timelocal( 0, 0, 0, 23, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-01-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-01-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-01-23 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 2001-01-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 1 Solmath 7465', 'as_string() on 2001-01-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-23 Gregorian' );
Trewsday 1 Solmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 24, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-01-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-01-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-01-24 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 2001-01-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 2 Solmath 7465', 'as_string() on 2001-01-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-24 Gregorian' );
Hevensday 2 Solmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 25, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-01-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-01-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-01-25 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 2001-01-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 3 Solmath 7465', 'as_string() on 2001-01-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-25 Gregorian' );
Mersday 3 Solmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 26, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-01-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-01-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-01-26 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 2001-01-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 4 Solmath 7465', 'as_string() on 2001-01-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-26 Gregorian' );
Highday 4 Solmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 27, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-01-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-01-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-01-27 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 2001-01-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 5 Solmath 7465', 'as_string() on 2001-01-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-27 Gregorian' );
Sterday 5 Solmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 28, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-01-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-01-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-01-28 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 2001-01-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 6 Solmath 7465', 'as_string() on 2001-01-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-28 Gregorian' );
Sunday 6 Solmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 29, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-01-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-01-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-01-29 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 2001-01-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 7 Solmath 7465', 'as_string() on 2001-01-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-29 Gregorian' );
Monday 7 Solmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 30, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-01-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-01-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-01-30 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 2001-01-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 8 Solmath 7465', 'as_string() on 2001-01-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-30 Gregorian' );
Trewsday 8 Solmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 31, 0, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-01-31 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-01-31 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-01-31 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-01-31 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 2001-01-31 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-01-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-01-31 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 9 Solmath 7465', 'as_string() on 2001-01-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-01-31 Gregorian' );
Hevensday 9 Solmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 1, 1, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-02-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-02-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-02-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-02-01 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 2001-02-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-02-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-02-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 10 Solmath 7465', 'as_string() on 2001-02-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-02-01 Gregorian' );
Mersday 10 Solmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 2, 1, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-02-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-02-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-02-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-02-02 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 2001-02-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-02-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-02-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 11 Solmath 7465', 'as_string() on 2001-02-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-02-02 Gregorian' );
Highday 11 Solmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 3, 1, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-02-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-02-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-02-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-02-03 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 2001-02-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-02-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-02-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 12 Solmath 7465', 'as_string() on 2001-02-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-02-03 Gregorian' );
Sterday 12 Solmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 4, 1, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-02-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-02-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-02-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-02-04 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 2001-02-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-02-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-02-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 13 Solmath 7465', 'as_string() on 2001-02-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-02-04 Gregorian' );
Sunday 13 Solmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 5, 1, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-02-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-02-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-02-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-02-05 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 2001-02-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-02-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-02-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 14 Solmath 7465', 'as_string() on 2001-02-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-02-05 Gregorian' );
Monday 14 Solmath 7465

Frodo and Sam look in the Mirror of Galadriel, 1419.
Gandalf returns to life, and lies in a trance, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 6, 1, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-02-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-02-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-02-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-02-06 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 2001-02-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-02-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-02-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 15 Solmath 7465', 'as_string() on 2001-02-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-02-06 Gregorian' );
Trewsday 15 Solmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 7, 1, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-02-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-02-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-02-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-02-07 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 2001-02-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-02-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-02-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 16 Solmath 7465', 'as_string() on 2001-02-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-02-07 Gregorian' );
Hevensday 16 Solmath 7465

Company of the Ring says farewell to Lorien --
Gollum observes departure, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 8, 1, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-02-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-02-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-02-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-02-08 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 2001-02-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-02-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-02-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 17 Solmath 7465', 'as_string() on 2001-02-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-02-08 Gregorian' );
Mersday 17 Solmath 7465

Gwaihir the eagle bears Gandalf to Lorien, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 9, 1, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-02-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-02-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-02-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-02-09 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 2001-02-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-02-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-02-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 18 Solmath 7465', 'as_string() on 2001-02-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-02-09 Gregorian' );
Highday 18 Solmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 10, 1, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-02-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-02-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-02-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-02-10 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 2001-02-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-02-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-02-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 19 Solmath 7465', 'as_string() on 2001-02-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-02-10 Gregorian' );
Sterday 19 Solmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 11, 1, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-02-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-02-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-02-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-02-11 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 2001-02-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-02-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-02-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 20 Solmath 7465', 'as_string() on 2001-02-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-02-11 Gregorian' );
Sunday 20 Solmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 12, 1, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-02-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-02-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-02-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-02-12 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 2001-02-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-02-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-02-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 21 Solmath 7465', 'as_string() on 2001-02-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-02-12 Gregorian' );
Monday 21 Solmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 13, 1, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-02-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-02-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-02-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-02-13 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 2001-02-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-02-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-02-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 22 Solmath 7465', 'as_string() on 2001-02-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-02-13 Gregorian' );
Trewsday 22 Solmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 14, 1, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-02-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-02-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-02-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-02-14 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 2001-02-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-02-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-02-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 23 Solmath 7465', 'as_string() on 2001-02-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-02-14 Gregorian' );
Hevensday 23 Solmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 15, 1, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-02-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-02-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-02-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-02-15 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 2001-02-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-02-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-02-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 24 Solmath 7465', 'as_string() on 2001-02-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-02-15 Gregorian' );
Mersday 24 Solmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 16, 1, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-02-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-02-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-02-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-02-16 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 2001-02-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-02-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-02-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 25 Solmath 7465', 'as_string() on 2001-02-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-02-16 Gregorian' );
Highday 25 Solmath 7465

The Company of the Ring pass the Argonath and camp at Parth Galen, 1419.
First battle of the Fords of Isen -- Theodred son of Theoden slain, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 17, 1, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-02-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-02-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-02-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-02-17 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 2001-02-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-02-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-02-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 26 Solmath 7465', 'as_string() on 2001-02-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-02-17 Gregorian' );
Sterday 26 Solmath 7465

Breaking of the Fellowship, 1419.
Death of Boromir; his horn is heard in Minas Tirith, 1419.
Meriadoc and Peregrin captured by Orcs -- Aragorn pursues, 1419.
Eomer hears of the descent of the Orc-band from Emyn Muil, 1419.
Frodo and Samwise enter the eastern Emyn Muil, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 18, 1, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-02-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-02-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-02-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-02-18 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 2001-02-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-02-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-02-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 27 Solmath 7465', 'as_string() on 2001-02-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-02-18 Gregorian' );
Sunday 27 Solmath 7465

Aragorn reaches the west-cliff at sunrise, 1419.
Eomer sets out from Eastfold against Theoden's orders to pursue the Orcs, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 19, 1, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-02-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-02-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-02-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-02-19 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 2001-02-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-02-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-02-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 28 Solmath 7465', 'as_string() on 2001-02-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-02-19 Gregorian' );
Monday 28 Solmath 7465

Eomer overtakes the Orcs just outside of Fangorn Forest, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 20, 1, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-02-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-02-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-02-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-02-20 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 2001-02-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-02-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-02-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 29 Solmath 7465', 'as_string() on 2001-02-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-02-20 Gregorian' );
Trewsday 29 Solmath 7465

Meriodoc and Pippin escape and meet Treebeard, 1419.
The Rohirrim attack at sunrise and destroy the Orcs, 1419.
Frodo descends from the Emyn Muil and meets Gollum, 1419.
Faramir sees the funeral boat of Boromir, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 21, 1, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-02-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-02-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-02-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2001-02-21 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 2001-02-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-02-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-02-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 30 Solmath 7465', 'as_string() on 2001-02-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-02-21 Gregorian' );
Hevensday 30 Solmath 7465

Entmoot begins, 1419.
Eomer, returning to Edoras, meets Aragorn, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 22, 1, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-02-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-02-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-02-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-02-22 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 2001-02-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-02-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-02-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 1 Rethe 7465', 'as_string() on 2001-02-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-02-22 Gregorian' );
Mersday 1 Rethe 7465

Aragorn meets Gandalf the White, and they set out for Edoras, 1419.
Faramir leaves Minas Tirith on an errand to Ithilien, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 23, 1, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-02-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-02-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-02-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-02-23 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 2001-02-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-02-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-02-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 2 Rethe 7465', 'as_string() on 2001-02-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-02-23 Gregorian' );
Highday 2 Rethe 7465

The Rohirrim ride west against Saruman, 1419.
Second battle at the Fords of Isen; Erkenbrand defeated, 1419.
Entmoot ends.  Ents march on Isengard and reach it at night, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 24, 1, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-02-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-02-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-02-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-02-24 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 2001-02-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-02-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-02-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 3 Rethe 7465', 'as_string() on 2001-02-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-02-24 Gregorian' );
Sterday 3 Rethe 7465

Theoden retreats to Helm's Deep; battle of the Hornburg begins, 1419.
Ents complete the destruction of Isengard.
EOT

$epoch = timelocal( 0, 0, 0, 25, 1, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-02-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-02-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-02-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-02-25 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 2001-02-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-02-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-02-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 4 Rethe 7465', 'as_string() on 2001-02-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-02-25 Gregorian' );
Sunday 4 Rethe 7465

Theoden and Gandalf set out from Helm's Deep for Isengard, 1419.
Frodo reaches the slag mound on the edge of the of the Morannon, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 26, 1, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-02-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-02-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-02-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-02-26 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 2001-02-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-02-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-02-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 5 Rethe 7465', 'as_string() on 2001-02-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-02-26 Gregorian' );
Monday 5 Rethe 7465

Theoden reaches Isengard at noon; parley with Saruman in Orthanc, 1419.
Gandalf sets out with Peregrin for Minas Tirith, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 27, 1, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-02-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-02-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-02-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-02-27 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 2001-02-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-02-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-02-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 6 Rethe 7465', 'as_string() on 2001-02-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-02-27 Gregorian' );
Trewsday 6 Rethe 7465

Aragorn overtaken by the Dunedain in the early hours, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 28, 1, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-02-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-02-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-02-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-02-28 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 2001-02-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-02-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-02-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 7 Rethe 7465', 'as_string() on 2001-02-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-02-28 Gregorian' );
Hevensday 7 Rethe 7465

Frodo taken by Faramir to Henneth Annun, 1419.
Aragorn comes to Dunharrow at nightfall, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 1, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-03-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-03-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-03-01 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 2001-03-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 8 Rethe 7465', 'as_string() on 2001-03-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-01 Gregorian' );
Mersday 8 Rethe 7465

Aragorn takes the "Paths of the Dead", and reaches Erech at midnight, 1419.
Frodo leaves Henneth Annun, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 2, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-03-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-03-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-03-02 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 2001-03-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 9 Rethe 7465', 'as_string() on 2001-03-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-02 Gregorian' );
Highday 9 Rethe 7465

Gandalf reaches Minas Tirith, 1419.
Darkness begins to flow out of Mordor, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 3, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-03-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-03-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-03-03 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 2001-03-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 10 Rethe 7465', 'as_string() on 2001-03-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-03 Gregorian' );
Sterday 10 Rethe 7465

The Dawnless Day, 1419.
The Rohirrim are mustered and ride from Harrowdale, 1419.
Faramir rescued by Gandalf at the gates of Minas Tirith, 1419.
An army from the Morannon takes Cair Andros and passes into Anorien, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 4, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-03-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-03-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-03-04 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 2001-03-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 11 Rethe 7465', 'as_string() on 2001-03-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-04 Gregorian' );
Sunday 11 Rethe 7465

Gollum visits Shelob, 1419.
Denethor sends Faramir to Osgiliath, 1419.
Eastern Rohan is invaded and Lorien assaulted, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 5, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-03-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-03-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-03-05 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 2001-03-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 12 Rethe 7465', 'as_string() on 2001-03-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-05 Gregorian' );
Monday 12 Rethe 7465

Gollum leads Frodo into Shelob's lair, 1419.
Ents defeat the invaders of Rohan, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 6, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-03-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-03-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-03-06 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 2001-03-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 13 Rethe 7465', 'as_string() on 2001-03-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-06 Gregorian' );
Trewsday 13 Rethe 7465

Frodo captured by the Orcs of Cirith Ungol, 1419.
The Pelennor is overrun and Faramir is wounded, 1419.
Aragorn reaches Pelargir and captures the fleet of Umbar, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 7, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-03-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-03-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-03-07 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 2001-03-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 14 Rethe 7465', 'as_string() on 2001-03-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-07 Gregorian' );
Hevensday 14 Rethe 7465

Samwise finds Frodo in the tower of Cirith Ungol, 1419.
Minas Tirith besieged, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 8, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-03-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-03-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-03-08 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 2001-03-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 15 Rethe 7465', 'as_string() on 2001-03-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-08 Gregorian' );
Mersday 15 Rethe 7465

Witch King breaks the gates of Minas Tirith, 1419.
Denethor, Steward of Gondor, burns himself on a pyre, 1419.
The battle of the Pelennor occurs as Theoden and Aragorn arrive, 1419.
Thranduil repels the forces of Dol Guldur in Mirkwood, 1419.
Lorien assaulted for second time, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 9, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-03-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-03-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-03-09 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 2001-03-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 16 Rethe 7465', 'as_string() on 2001-03-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-09 Gregorian' );
Highday 16 Rethe 7465
EOT

$epoch = timelocal( 0, 0, 0, 10, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-03-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-03-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-03-10 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 2001-03-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 17 Rethe 7465', 'as_string() on 2001-03-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-10 Gregorian' );
Sterday 17 Rethe 7465

Battle of Dale, where King Brand and King Dain Ironfoot fall, 1419.
Shagrat brings Frodo's cloak, mail-shirt, and sword to Barad-dur, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 11, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-03-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-03-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-03-11 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 2001-03-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 18 Rethe 7465', 'as_string() on 2001-03-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-11 Gregorian' );
Sunday 18 Rethe 7465

Host of the west leaves Minas Tirith, 1419.
Frodo and Sam overtaken by Orcs on the road from Durthang to Udun, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 12, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-03-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-03-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-03-12 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 2001-03-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 19 Rethe 7465', 'as_string() on 2001-03-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-12 Gregorian' );
Monday 19 Rethe 7465

Frodo and Sam escape the Orcs and start on the road toward Mount Doom, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 13, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-03-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-03-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-03-13 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 2001-03-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 20 Rethe 7465', 'as_string() on 2001-03-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-13 Gregorian' );
Trewsday 20 Rethe 7465
EOT

$epoch = timelocal( 0, 0, 0, 14, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-03-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-03-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-03-14 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 2001-03-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 21 Rethe 7465', 'as_string() on 2001-03-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-14 Gregorian' );
Hevensday 21 Rethe 7465
EOT

$epoch = timelocal( 0, 0, 0, 15, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-03-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-03-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-03-15 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 2001-03-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 22 Rethe 7465', 'as_string() on 2001-03-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-15 Gregorian' );
Mersday 22 Rethe 7465

Lorien assaulted for the third time, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 16, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-03-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-03-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-03-16 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 2001-03-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 23 Rethe 7465', 'as_string() on 2001-03-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-16 Gregorian' );
Highday 23 Rethe 7465
EOT

$epoch = timelocal( 0, 0, 0, 17, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-03-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-03-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-03-17 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 2001-03-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 24 Rethe 7465', 'as_string() on 2001-03-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-17 Gregorian' );
Sterday 24 Rethe 7465

Frodo and Sam reach the base of Mount Doom, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 18, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-03-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-03-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-03-18 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 2001-03-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 25 Rethe 7465', 'as_string() on 2001-03-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-18 Gregorian' );
Sunday 25 Rethe 7465

Battle of the Host of the West on the slag hill of the Morannon, 1419.
Gollum siezes the Ring of Power and falls into the Cracks of Doom, 1419.
Downfall of Barad-dur and the passing of Sauron!, 1419.
Birth of Elanor the Fair, daughter of Samwise, 1421.
Fourth age begins in the reckoning of Gondor, 1421.
EOT

$epoch = timelocal( 0, 0, 0, 19, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-03-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-03-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-03-19 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 2001-03-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 26 Rethe 7465', 'as_string() on 2001-03-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-19 Gregorian' );
Monday 26 Rethe 7465
EOT

$epoch = timelocal( 0, 0, 0, 20, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-03-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-03-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-03-20 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 2001-03-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 27 Rethe 7465', 'as_string() on 2001-03-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-20 Gregorian' );
Trewsday 27 Rethe 7465

Bard II and Thorin III Stonehelm drive the enemy from Dale, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 21, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-03-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-03-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-03-21 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 2001-03-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 28 Rethe 7465', 'as_string() on 2001-03-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-21 Gregorian' );
Hevensday 28 Rethe 7465

Celeborn crosses the Anduin and begins destruction of Dol Guldur, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 22, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-03-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-03-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-03-22 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 2001-03-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 29 Rethe 7465', 'as_string() on 2001-03-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-22 Gregorian' );
Mersday 29 Rethe 7465
EOT

$epoch = timelocal( 0, 0, 0, 23, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-03-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-03-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2001-03-23 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 2001-03-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 30 Rethe 7465', 'as_string() on 2001-03-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-23 Gregorian' );
Highday 30 Rethe 7465
EOT

$epoch = timelocal( 0, 0, 0, 24, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-03-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-03-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-03-24 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 2001-03-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 1 Astron 7465', 'as_string() on 2001-03-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-24 Gregorian' );
Sterday 1 Astron 7465
EOT

$epoch = timelocal( 0, 0, 0, 25, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-03-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-03-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-03-25 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 2001-03-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 2 Astron 7465', 'as_string() on 2001-03-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-25 Gregorian' );
Sunday 2 Astron 7465
EOT

$epoch = timelocal( 0, 0, 0, 26, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-03-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-03-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-03-26 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 2001-03-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 3 Astron 7465', 'as_string() on 2001-03-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-26 Gregorian' );
Monday 3 Astron 7465
EOT

$epoch = timelocal( 0, 0, 0, 27, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-03-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-03-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-03-27 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 2001-03-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 4 Astron 7465', 'as_string() on 2001-03-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-27 Gregorian' );
Trewsday 4 Astron 7465
EOT

$epoch = timelocal( 0, 0, 0, 28, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-03-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-03-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-03-28 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 2001-03-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 5 Astron 7465', 'as_string() on 2001-03-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-28 Gregorian' );
Hevensday 5 Astron 7465
EOT

$epoch = timelocal( 0, 0, 0, 29, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-03-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-03-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-03-29 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 2001-03-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 6 Astron 7465', 'as_string() on 2001-03-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-29 Gregorian' );
Mersday 6 Astron 7465

The mallorn tree flowers in the party field, 1420.
EOT

$epoch = timelocal( 0, 0, 0, 30, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-03-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-03-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-03-30 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 2001-03-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 7 Astron 7465', 'as_string() on 2001-03-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-30 Gregorian' );
Highday 7 Astron 7465
EOT

$epoch = timelocal( 0, 0, 0, 31, 2, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-03-31 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-03-31 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-03-31 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-03-31 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 2001-03-31 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-03-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-03-31 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 8 Astron 7465', 'as_string() on 2001-03-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-03-31 Gregorian' );
Sterday 8 Astron 7465

Ring bearers are honored on the fields of Cormallen, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 1, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-04-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-04-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-04-01 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 2001-04-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 9 Astron 7465', 'as_string() on 2001-04-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-01 Gregorian' );
Sunday 9 Astron 7465
EOT

$epoch = timelocal( 0, 0, 0, 2, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-04-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-04-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-04-02 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 2001-04-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 10 Astron 7465', 'as_string() on 2001-04-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-02 Gregorian' );
Monday 10 Astron 7465
EOT

$epoch = timelocal( 0, 0, 0, 3, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-04-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-04-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-04-03 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 2001-04-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 11 Astron 7465', 'as_string() on 2001-04-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-03 Gregorian' );
Trewsday 11 Astron 7465
EOT

$epoch = timelocal( 0, 0, 0, 4, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-04-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-04-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-04-04 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 2001-04-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 12 Astron 7465', 'as_string() on 2001-04-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-04 Gregorian' );
Hevensday 12 Astron 7465

Gandalf arrives in Hobbiton, 1418
EOT

$epoch = timelocal( 0, 0, 0, 5, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-04-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-04-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-04-05 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 2001-04-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 13 Astron 7465', 'as_string() on 2001-04-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-05 Gregorian' );
Mersday 13 Astron 7465
EOT

$epoch = timelocal( 0, 0, 0, 6, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-04-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-04-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-04-06 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 2001-04-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 14 Astron 7465', 'as_string() on 2001-04-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-06 Gregorian' );
Highday 14 Astron 7465
EOT

$epoch = timelocal( 0, 0, 0, 7, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-04-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-04-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-04-07 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 2001-04-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 15 Astron 7465', 'as_string() on 2001-04-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-07 Gregorian' );
Sterday 15 Astron 7465
EOT

$epoch = timelocal( 0, 0, 0, 8, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-04-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-04-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-04-08 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 2001-04-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 16 Astron 7465', 'as_string() on 2001-04-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-08 Gregorian' );
Sunday 16 Astron 7465
EOT

$epoch = timelocal( 0, 0, 0, 9, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-04-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-04-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-04-09 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 2001-04-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 17 Astron 7465', 'as_string() on 2001-04-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-09 Gregorian' );
Monday 17 Astron 7465
EOT

$epoch = timelocal( 0, 0, 0, 10, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-04-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-04-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-04-10 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 2001-04-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 18 Astron 7465', 'as_string() on 2001-04-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-10 Gregorian' );
Trewsday 18 Astron 7465
EOT

$epoch = timelocal( 0, 0, 0, 11, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-04-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-04-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-04-11 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 2001-04-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 19 Astron 7465', 'as_string() on 2001-04-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-11 Gregorian' );
Hevensday 19 Astron 7465
EOT

$epoch = timelocal( 0, 0, 0, 12, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-04-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-04-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-04-12 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 2001-04-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 20 Astron 7465', 'as_string() on 2001-04-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-12 Gregorian' );
Mersday 20 Astron 7465
EOT

$epoch = timelocal( 0, 0, 0, 13, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-04-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-04-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-04-13 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 2001-04-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 21 Astron 7465', 'as_string() on 2001-04-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-13 Gregorian' );
Highday 21 Astron 7465
EOT

$epoch = timelocal( 0, 0, 0, 14, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-04-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-04-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-04-14 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 2001-04-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 22 Astron 7465', 'as_string() on 2001-04-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-14 Gregorian' );
Sterday 22 Astron 7465
EOT

$epoch = timelocal( 0, 0, 0, 15, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-04-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-04-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-04-15 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 2001-04-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 23 Astron 7465', 'as_string() on 2001-04-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-15 Gregorian' );
Sunday 23 Astron 7465
EOT

$epoch = timelocal( 0, 0, 0, 16, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-04-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-04-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-04-16 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 2001-04-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 24 Astron 7465', 'as_string() on 2001-04-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-16 Gregorian' );
Monday 24 Astron 7465
EOT

$epoch = timelocal( 0, 0, 0, 17, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-04-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-04-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-04-17 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 2001-04-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 25 Astron 7465', 'as_string() on 2001-04-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-17 Gregorian' );
Trewsday 25 Astron 7465
EOT

$epoch = timelocal( 0, 0, 0, 18, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-04-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-04-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-04-18 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 2001-04-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 26 Astron 7465', 'as_string() on 2001-04-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-18 Gregorian' );
Hevensday 26 Astron 7465
EOT

$epoch = timelocal( 0, 0, 0, 19, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-04-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-04-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-04-19 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 2001-04-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 27 Astron 7465', 'as_string() on 2001-04-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-19 Gregorian' );
Mersday 27 Astron 7465
EOT

$epoch = timelocal( 0, 0, 0, 20, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-04-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-04-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-04-20 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 2001-04-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 28 Astron 7465', 'as_string() on 2001-04-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-20 Gregorian' );
Highday 28 Astron 7465
EOT

$epoch = timelocal( 0, 0, 0, 21, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-04-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-04-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-04-21 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 2001-04-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 29 Astron 7465', 'as_string() on 2001-04-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-21 Gregorian' );
Sterday 29 Astron 7465
EOT

$epoch = timelocal( 0, 0, 0, 22, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-04-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-04-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Astron', 'month() on 2001-04-22 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 2001-04-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 30 Astron 7465', 'as_string() on 2001-04-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-22 Gregorian' );
Sunday 30 Astron 7465
EOT

$epoch = timelocal( 0, 0, 0, 23, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-04-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-04-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-04-23 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 2001-04-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 1 Thrimidge 7465', 'as_string() on 2001-04-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-23 Gregorian' );
Monday 1 Thrimidge 7465

Crowning of King Elessar, 1419.
Samwise marries Rose, 1420.
EOT

$epoch = timelocal( 0, 0, 0, 24, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-04-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-04-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-04-24 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 2001-04-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 2 Thrimidge 7465', 'as_string() on 2001-04-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-24 Gregorian' );
Trewsday 2 Thrimidge 7465
EOT

$epoch = timelocal( 0, 0, 0, 25, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-04-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-04-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-04-25 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 2001-04-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 3 Thrimidge 7465', 'as_string() on 2001-04-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-25 Gregorian' );
Hevensday 3 Thrimidge 7465
EOT

$epoch = timelocal( 0, 0, 0, 26, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-04-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-04-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-04-26 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 2001-04-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 4 Thrimidge 7465', 'as_string() on 2001-04-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-26 Gregorian' );
Mersday 4 Thrimidge 7465
EOT

$epoch = timelocal( 0, 0, 0, 27, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-04-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-04-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-04-27 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 2001-04-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 5 Thrimidge 7465', 'as_string() on 2001-04-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-27 Gregorian' );
Highday 5 Thrimidge 7465
EOT

$epoch = timelocal( 0, 0, 0, 28, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-04-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-04-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-04-28 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 2001-04-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 6 Thrimidge 7465', 'as_string() on 2001-04-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-28 Gregorian' );
Sterday 6 Thrimidge 7465
EOT

$epoch = timelocal( 0, 0, 0, 29, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-04-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-04-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-04-29 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 2001-04-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 7 Thrimidge 7465', 'as_string() on 2001-04-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-29 Gregorian' );
Sunday 7 Thrimidge 7465
EOT

$epoch = timelocal( 0, 0, 0, 30, 3, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-04-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-04-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-04-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-04-30 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 2001-04-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-04-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-04-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 8 Thrimidge 7465', 'as_string() on 2001-04-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-04-30 Gregorian' );
Monday 8 Thrimidge 7465
EOT

$epoch = timelocal( 0, 0, 0, 1, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-05-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-05-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-05-01 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 2001-05-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 9 Thrimidge 7465', 'as_string() on 2001-05-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-01 Gregorian' );
Trewsday 9 Thrimidge 7465
EOT

$epoch = timelocal( 0, 0, 0, 2, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-05-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-05-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-05-02 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 2001-05-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 10 Thrimidge 7465', 'as_string() on 2001-05-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-02 Gregorian' );
Hevensday 10 Thrimidge 7465
EOT

$epoch = timelocal( 0, 0, 0, 3, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-05-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-05-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-05-03 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 2001-05-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 11 Thrimidge 7465', 'as_string() on 2001-05-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-03 Gregorian' );
Mersday 11 Thrimidge 7465
EOT

$epoch = timelocal( 0, 0, 0, 4, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-05-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-05-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-05-04 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 2001-05-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 12 Thrimidge 7465', 'as_string() on 2001-05-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-04 Gregorian' );
Highday 12 Thrimidge 7465
EOT

$epoch = timelocal( 0, 0, 0, 5, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-05-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-05-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-05-05 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 2001-05-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 13 Thrimidge 7465', 'as_string() on 2001-05-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-05 Gregorian' );
Sterday 13 Thrimidge 7465
EOT

$epoch = timelocal( 0, 0, 0, 6, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-05-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-05-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-05-06 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 2001-05-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 14 Thrimidge 7465', 'as_string() on 2001-05-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-06 Gregorian' );
Sunday 14 Thrimidge 7465
EOT

$epoch = timelocal( 0, 0, 0, 7, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-05-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-05-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-05-07 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 2001-05-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 15 Thrimidge 7465', 'as_string() on 2001-05-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-07 Gregorian' );
Monday 15 Thrimidge 7465
EOT

$epoch = timelocal( 0, 0, 0, 8, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-05-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-05-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-05-08 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 2001-05-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 16 Thrimidge 7465', 'as_string() on 2001-05-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-08 Gregorian' );
Trewsday 16 Thrimidge 7465
EOT

$epoch = timelocal( 0, 0, 0, 9, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-05-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-05-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-05-09 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 2001-05-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 17 Thrimidge 7465', 'as_string() on 2001-05-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-09 Gregorian' );
Hevensday 17 Thrimidge 7465
EOT

$epoch = timelocal( 0, 0, 0, 10, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-05-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-05-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-05-10 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 2001-05-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 18 Thrimidge 7465', 'as_string() on 2001-05-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-10 Gregorian' );
Mersday 18 Thrimidge 7465
EOT

$epoch = timelocal( 0, 0, 0, 11, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-05-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-05-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-05-11 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 2001-05-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 19 Thrimidge 7465', 'as_string() on 2001-05-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-11 Gregorian' );
Highday 19 Thrimidge 7465
EOT

$epoch = timelocal( 0, 0, 0, 12, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-05-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-05-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-05-12 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 2001-05-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 20 Thrimidge 7465', 'as_string() on 2001-05-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-12 Gregorian' );
Sterday 20 Thrimidge 7465
EOT

$epoch = timelocal( 0, 0, 0, 13, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-05-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-05-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-05-13 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 2001-05-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 21 Thrimidge 7465', 'as_string() on 2001-05-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-13 Gregorian' );
Sunday 21 Thrimidge 7465
EOT

$epoch = timelocal( 0, 0, 0, 14, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-05-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-05-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-05-14 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 2001-05-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 22 Thrimidge 7465', 'as_string() on 2001-05-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-14 Gregorian' );
Monday 22 Thrimidge 7465
EOT

$epoch = timelocal( 0, 0, 0, 15, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-05-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-05-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-05-15 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 2001-05-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 23 Thrimidge 7465', 'as_string() on 2001-05-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-15 Gregorian' );
Trewsday 23 Thrimidge 7465
EOT

$epoch = timelocal( 0, 0, 0, 16, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-05-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-05-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-05-16 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 2001-05-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 24 Thrimidge 7465', 'as_string() on 2001-05-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-16 Gregorian' );
Hevensday 24 Thrimidge 7465
EOT

$epoch = timelocal( 0, 0, 0, 17, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-05-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-05-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-05-17 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 2001-05-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 25 Thrimidge 7465', 'as_string() on 2001-05-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-17 Gregorian' );
Mersday 25 Thrimidge 7465
EOT

$epoch = timelocal( 0, 0, 0, 18, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-05-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-05-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-05-18 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 2001-05-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 26 Thrimidge 7465', 'as_string() on 2001-05-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-18 Gregorian' );
Highday 26 Thrimidge 7465
EOT

$epoch = timelocal( 0, 0, 0, 19, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-05-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-05-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-05-19 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 2001-05-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 27 Thrimidge 7465', 'as_string() on 2001-05-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-19 Gregorian' );
Sterday 27 Thrimidge 7465
EOT

$epoch = timelocal( 0, 0, 0, 20, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-05-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-05-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-05-20 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 2001-05-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 28 Thrimidge 7465', 'as_string() on 2001-05-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-20 Gregorian' );
Sunday 28 Thrimidge 7465
EOT

$epoch = timelocal( 0, 0, 0, 21, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-05-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-05-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-05-21 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 2001-05-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 29 Thrimidge 7465', 'as_string() on 2001-05-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-21 Gregorian' );
Monday 29 Thrimidge 7465
EOT

$epoch = timelocal( 0, 0, 0, 22, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-05-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-05-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Thrimidge', 'month() on 2001-05-22 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 2001-05-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 30 Thrimidge 7465', 'as_string() on 2001-05-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-22 Gregorian' );
Trewsday 30 Thrimidge 7465
EOT

$epoch = timelocal( 0, 0, 0, 23, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-05-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-05-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-05-23 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 2001-05-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 1 Forelithe 7465', 'as_string() on 2001-05-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-23 Gregorian' );
Hevensday 1 Forelithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 24, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-05-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-05-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-05-24 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 2001-05-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 2 Forelithe 7465', 'as_string() on 2001-05-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-24 Gregorian' );
Mersday 2 Forelithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 25, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-05-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-05-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-05-25 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 2001-05-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 3 Forelithe 7465', 'as_string() on 2001-05-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-25 Gregorian' );
Highday 3 Forelithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 26, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-05-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-05-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-05-26 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 2001-05-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 4 Forelithe 7465', 'as_string() on 2001-05-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-26 Gregorian' );
Sterday 4 Forelithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 27, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-05-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-05-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-05-27 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 2001-05-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 5 Forelithe 7465', 'as_string() on 2001-05-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-27 Gregorian' );
Sunday 5 Forelithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 28, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-05-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-05-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-05-28 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 2001-05-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 6 Forelithe 7465', 'as_string() on 2001-05-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-28 Gregorian' );
Monday 6 Forelithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 29, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-05-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-05-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-05-29 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 2001-05-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 7 Forelithe 7465', 'as_string() on 2001-05-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-29 Gregorian' );
Trewsday 7 Forelithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 30, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-05-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-05-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-05-30 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 2001-05-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 8 Forelithe 7465', 'as_string() on 2001-05-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-30 Gregorian' );
Hevensday 8 Forelithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 31, 4, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-05-31 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-05-31 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-05-31 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-05-31 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 2001-05-31 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-05-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-05-31 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 9 Forelithe 7465', 'as_string() on 2001-05-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-05-31 Gregorian' );
Mersday 9 Forelithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 1, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-06-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-06-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-06-01 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 2001-06-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-06-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 10 Forelithe 7465', 'as_string() on 2001-06-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-01 Gregorian' );
Highday 10 Forelithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 2, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-06-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-06-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-06-02 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 2001-06-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-06-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 11 Forelithe 7465', 'as_string() on 2001-06-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-02 Gregorian' );
Sterday 11 Forelithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 3, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-06-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-06-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-06-03 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 2001-06-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-06-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 12 Forelithe 7465', 'as_string() on 2001-06-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-03 Gregorian' );
Sunday 12 Forelithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 4, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-06-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-06-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-06-04 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 2001-06-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-06-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 13 Forelithe 7465', 'as_string() on 2001-06-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-04 Gregorian' );
Monday 13 Forelithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 5, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-06-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-06-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-06-05 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 2001-06-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-06-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 14 Forelithe 7465', 'as_string() on 2001-06-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-05 Gregorian' );
Trewsday 14 Forelithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 6, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-06-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-06-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-06-06 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 2001-06-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-06-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 15 Forelithe 7465', 'as_string() on 2001-06-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-06 Gregorian' );
Hevensday 15 Forelithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 7, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-06-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-06-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-06-07 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 2001-06-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-06-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 16 Forelithe 7465', 'as_string() on 2001-06-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-07 Gregorian' );
Mersday 16 Forelithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 8, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-06-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-06-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-06-08 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 2001-06-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-06-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 17 Forelithe 7465', 'as_string() on 2001-06-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-08 Gregorian' );
Highday 17 Forelithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 9, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-06-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-06-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-06-09 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 2001-06-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-06-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 18 Forelithe 7465', 'as_string() on 2001-06-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-09 Gregorian' );
Sterday 18 Forelithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 10, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-06-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-06-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-06-10 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 2001-06-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-06-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 19 Forelithe 7465', 'as_string() on 2001-06-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-10 Gregorian' );
Sunday 19 Forelithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 11, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-06-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-06-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-06-11 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 2001-06-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-06-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 20 Forelithe 7465', 'as_string() on 2001-06-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-11 Gregorian' );
Monday 20 Forelithe 7465

Sauron attacks Osgiliath, 1418.
Thranduil is attacked, and Gollum escapes, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 12, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-06-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-06-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-06-12 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 2001-06-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-06-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 21 Forelithe 7465', 'as_string() on 2001-06-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-12 Gregorian' );
Trewsday 21 Forelithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 13, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-06-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-06-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-06-13 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 2001-06-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-06-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 22 Forelithe 7465', 'as_string() on 2001-06-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-13 Gregorian' );
Hevensday 22 Forelithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 14, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-06-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-06-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-06-14 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 2001-06-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-06-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 23 Forelithe 7465', 'as_string() on 2001-06-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-14 Gregorian' );
Mersday 23 Forelithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 15, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-06-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-06-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-06-15 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 2001-06-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-06-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 24 Forelithe 7465', 'as_string() on 2001-06-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-15 Gregorian' );
Highday 24 Forelithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 16, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-06-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-06-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-06-16 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 2001-06-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-06-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 25 Forelithe 7465', 'as_string() on 2001-06-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-16 Gregorian' );
Sterday 25 Forelithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 17, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-06-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-06-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-06-17 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 2001-06-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-06-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 26 Forelithe 7465', 'as_string() on 2001-06-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-17 Gregorian' );
Sunday 26 Forelithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 18, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-06-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-06-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-06-18 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 2001-06-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-06-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 27 Forelithe 7465', 'as_string() on 2001-06-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-18 Gregorian' );
Monday 27 Forelithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 19, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-06-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-06-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-06-19 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 2001-06-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-06-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 28 Forelithe 7465', 'as_string() on 2001-06-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-19 Gregorian' );
Trewsday 28 Forelithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 20, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-06-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-06-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-06-20 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 2001-06-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-06-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 29 Forelithe 7465', 'as_string() on 2001-06-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-20 Gregorian' );
Hevensday 29 Forelithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 21, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-06-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-06-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Forelithe', 'month() on 2001-06-21 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 2001-06-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-06-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 30 Forelithe 7465', 'as_string() on 2001-06-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-21 Gregorian' );
Mersday 30 Forelithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 22, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-06-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-06-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', '', 'month() on 2001-06-22 Gregorian' );
cmp_ok( $dts->day(), '==', 0, 'day() on 2001-06-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '1 Lithe', 'holiday() on 2001-06-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 1 Lithe 7465', 'as_string() on 2001-06-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-22 Gregorian' );
Highday 1 Lithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 23, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', '', 'weekday() on 2001-06-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', '', 'trad_weekday() on 2001-06-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', '', 'month() on 2001-06-23 Gregorian' );
cmp_ok( $dts->day(), '==', 0, 'day() on 2001-06-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', 'Midyear\'s day', 'holiday() on 2001-06-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Midyear\'s day 7465', 'as_string() on 2001-06-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-23 Gregorian' );
Midyear's day 7465

Wedding of King Elessar and Arwen, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 24, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-06-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-06-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', '', 'month() on 2001-06-24 Gregorian' );
cmp_ok( $dts->day(), '==', 0, 'day() on 2001-06-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '2 Lithe', 'holiday() on 2001-06-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 2 Lithe 7465', 'as_string() on 2001-06-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-24 Gregorian' );
Sterday 2 Lithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 25, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-06-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-06-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-06-25 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 2001-06-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-06-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 1 Afterlithe 7465', 'as_string() on 2001-06-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-25 Gregorian' );
Sunday 1 Afterlithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 26, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-06-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-06-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-06-26 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 2001-06-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-06-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 2 Afterlithe 7465', 'as_string() on 2001-06-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-26 Gregorian' );
Monday 2 Afterlithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 27, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-06-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-06-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-06-27 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 2001-06-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-06-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 3 Afterlithe 7465', 'as_string() on 2001-06-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-27 Gregorian' );
Trewsday 3 Afterlithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 28, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-06-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-06-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-06-28 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 2001-06-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-06-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 4 Afterlithe 7465', 'as_string() on 2001-06-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-28 Gregorian' );
Hevensday 4 Afterlithe 7465

Boromir sets out from Minas Tirith, 1418
EOT

$epoch = timelocal( 0, 0, 0, 29, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-06-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-06-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-06-29 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 2001-06-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-06-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 5 Afterlithe 7465', 'as_string() on 2001-06-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-29 Gregorian' );
Mersday 5 Afterlithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 30, 5, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-06-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-06-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-06-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-06-30 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 2001-06-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-06-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-06-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 6 Afterlithe 7465', 'as_string() on 2001-06-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-06-30 Gregorian' );
Highday 6 Afterlithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 1, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-07-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-07-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-07-01 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 2001-07-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 7 Afterlithe 7465', 'as_string() on 2001-07-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-01 Gregorian' );
Sterday 7 Afterlithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 2, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-07-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-07-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-07-02 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 2001-07-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 8 Afterlithe 7465', 'as_string() on 2001-07-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-02 Gregorian' );
Sunday 8 Afterlithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 3, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-07-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-07-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-07-03 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 2001-07-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 9 Afterlithe 7465', 'as_string() on 2001-07-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-03 Gregorian' );
Monday 9 Afterlithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 4, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-07-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-07-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-07-04 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 2001-07-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 10 Afterlithe 7465', 'as_string() on 2001-07-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-04 Gregorian' );
Trewsday 10 Afterlithe 7465

Gandalf imprisoned in Orthanc, 1418
EOT

$epoch = timelocal( 0, 0, 0, 5, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-07-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-07-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-07-05 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 2001-07-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 11 Afterlithe 7465', 'as_string() on 2001-07-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-05 Gregorian' );
Hevensday 11 Afterlithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 6, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-07-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-07-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-07-06 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 2001-07-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 12 Afterlithe 7465', 'as_string() on 2001-07-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-06 Gregorian' );
Mersday 12 Afterlithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 7, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-07-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-07-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-07-07 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 2001-07-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 13 Afterlithe 7465', 'as_string() on 2001-07-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-07 Gregorian' );
Highday 13 Afterlithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 8, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-07-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-07-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-07-08 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 2001-07-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 14 Afterlithe 7465', 'as_string() on 2001-07-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-08 Gregorian' );
Sterday 14 Afterlithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 9, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-07-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-07-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-07-09 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 2001-07-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 15 Afterlithe 7465', 'as_string() on 2001-07-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-09 Gregorian' );
Sunday 15 Afterlithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 10, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-07-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-07-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-07-10 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 2001-07-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 16 Afterlithe 7465', 'as_string() on 2001-07-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-10 Gregorian' );
Monday 16 Afterlithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 11, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-07-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-07-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-07-11 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 2001-07-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 17 Afterlithe 7465', 'as_string() on 2001-07-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-11 Gregorian' );
Trewsday 17 Afterlithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 12, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-07-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-07-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-07-12 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 2001-07-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 18 Afterlithe 7465', 'as_string() on 2001-07-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-12 Gregorian' );
Hevensday 18 Afterlithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 13, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-07-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-07-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-07-13 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 2001-07-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 19 Afterlithe 7465', 'as_string() on 2001-07-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-13 Gregorian' );
Mersday 19 Afterlithe 7465

Funeral Escort of King Theoden leaves Minas Tirith, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 14, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-07-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-07-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-07-14 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 2001-07-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 20 Afterlithe 7465', 'as_string() on 2001-07-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-14 Gregorian' );
Highday 20 Afterlithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 15, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-07-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-07-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-07-15 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 2001-07-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 21 Afterlithe 7465', 'as_string() on 2001-07-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-15 Gregorian' );
Sterday 21 Afterlithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 16, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-07-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-07-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-07-16 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 2001-07-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 22 Afterlithe 7465', 'as_string() on 2001-07-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-16 Gregorian' );
Sunday 22 Afterlithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 17, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-07-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-07-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-07-17 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 2001-07-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 23 Afterlithe 7465', 'as_string() on 2001-07-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-17 Gregorian' );
Monday 23 Afterlithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 18, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-07-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-07-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-07-18 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 2001-07-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 24 Afterlithe 7465', 'as_string() on 2001-07-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-18 Gregorian' );
Trewsday 24 Afterlithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 19, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-07-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-07-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-07-19 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 2001-07-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 25 Afterlithe 7465', 'as_string() on 2001-07-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-19 Gregorian' );
Hevensday 25 Afterlithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 20, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-07-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-07-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-07-20 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 2001-07-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 26 Afterlithe 7465', 'as_string() on 2001-07-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-20 Gregorian' );
Mersday 26 Afterlithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 21, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-07-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-07-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-07-21 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 2001-07-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 27 Afterlithe 7465', 'as_string() on 2001-07-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-21 Gregorian' );
Highday 27 Afterlithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 22, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-07-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-07-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-07-22 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 2001-07-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 28 Afterlithe 7465', 'as_string() on 2001-07-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-22 Gregorian' );
Sterday 28 Afterlithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 23, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-07-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-07-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-07-23 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 2001-07-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 29 Afterlithe 7465', 'as_string() on 2001-07-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-23 Gregorian' );
Sunday 29 Afterlithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 24, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-07-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-07-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afterlithe', 'month() on 2001-07-24 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 2001-07-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 30 Afterlithe 7465', 'as_string() on 2001-07-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-24 Gregorian' );
Monday 30 Afterlithe 7465
EOT

$epoch = timelocal( 0, 0, 0, 25, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-07-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-07-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-07-25 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 2001-07-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 1 Wedmath 7465', 'as_string() on 2001-07-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-25 Gregorian' );
Trewsday 1 Wedmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 26, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-07-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-07-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-07-26 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 2001-07-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 2 Wedmath 7465', 'as_string() on 2001-07-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-26 Gregorian' );
Hevensday 2 Wedmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 27, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-07-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-07-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-07-27 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 2001-07-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 3 Wedmath 7465', 'as_string() on 2001-07-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-27 Gregorian' );
Mersday 3 Wedmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 28, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-07-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-07-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-07-28 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 2001-07-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 4 Wedmath 7465', 'as_string() on 2001-07-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-28 Gregorian' );
Highday 4 Wedmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 29, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-07-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-07-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-07-29 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 2001-07-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 5 Wedmath 7465', 'as_string() on 2001-07-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-29 Gregorian' );
Sterday 5 Wedmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 30, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-07-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-07-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-07-30 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 2001-07-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 6 Wedmath 7465', 'as_string() on 2001-07-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-30 Gregorian' );
Sunday 6 Wedmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 31, 6, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-07-31 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-07-31 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-07-31 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-07-31 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 2001-07-31 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-07-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-07-31 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 7 Wedmath 7465', 'as_string() on 2001-07-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-07-31 Gregorian' );
Monday 7 Wedmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 1, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-08-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-08-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-08-01 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 2001-08-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 8 Wedmath 7465', 'as_string() on 2001-08-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-01 Gregorian' );
Trewsday 8 Wedmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 2, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-08-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-08-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-08-02 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 2001-08-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 9 Wedmath 7465', 'as_string() on 2001-08-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-02 Gregorian' );
Hevensday 9 Wedmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 3, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-08-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-08-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-08-03 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 2001-08-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 10 Wedmath 7465', 'as_string() on 2001-08-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-03 Gregorian' );
Mersday 10 Wedmath 7465

Funeral of King Theoden, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 4, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-08-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-08-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-08-04 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 2001-08-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 11 Wedmath 7465', 'as_string() on 2001-08-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-04 Gregorian' );
Highday 11 Wedmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 5, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-08-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-08-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-08-05 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 2001-08-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 12 Wedmath 7465', 'as_string() on 2001-08-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-05 Gregorian' );
Sterday 12 Wedmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 6, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-08-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-08-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-08-06 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 2001-08-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 13 Wedmath 7465', 'as_string() on 2001-08-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-06 Gregorian' );
Sunday 13 Wedmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 7, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-08-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-08-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-08-07 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 2001-08-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 14 Wedmath 7465', 'as_string() on 2001-08-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-07 Gregorian' );
Monday 14 Wedmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 8, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-08-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-08-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-08-08 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 2001-08-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 15 Wedmath 7465', 'as_string() on 2001-08-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-08 Gregorian' );
Trewsday 15 Wedmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 9, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-08-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-08-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-08-09 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 2001-08-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 16 Wedmath 7465', 'as_string() on 2001-08-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-09 Gregorian' );
Hevensday 16 Wedmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 10, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-08-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-08-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-08-10 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 2001-08-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 17 Wedmath 7465', 'as_string() on 2001-08-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-10 Gregorian' );
Mersday 17 Wedmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 11, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-08-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-08-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-08-11 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 2001-08-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 18 Wedmath 7465', 'as_string() on 2001-08-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-11 Gregorian' );
Highday 18 Wedmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 12, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-08-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-08-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-08-12 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 2001-08-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 19 Wedmath 7465', 'as_string() on 2001-08-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-12 Gregorian' );
Sterday 19 Wedmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 13, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-08-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-08-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-08-13 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 2001-08-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 20 Wedmath 7465', 'as_string() on 2001-08-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-13 Gregorian' );
Sunday 20 Wedmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 14, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-08-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-08-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-08-14 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 2001-08-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 21 Wedmath 7465', 'as_string() on 2001-08-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-14 Gregorian' );
Monday 21 Wedmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 15, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-08-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-08-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-08-15 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 2001-08-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 22 Wedmath 7465', 'as_string() on 2001-08-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-15 Gregorian' );
Trewsday 22 Wedmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 16, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-08-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-08-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-08-16 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 2001-08-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 23 Wedmath 7465', 'as_string() on 2001-08-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-16 Gregorian' );
Hevensday 23 Wedmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 17, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-08-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-08-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-08-17 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 2001-08-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 24 Wedmath 7465', 'as_string() on 2001-08-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-17 Gregorian' );
Mersday 24 Wedmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 18, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-08-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-08-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-08-18 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 2001-08-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 25 Wedmath 7465', 'as_string() on 2001-08-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-18 Gregorian' );
Highday 25 Wedmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 19, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-08-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-08-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-08-19 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 2001-08-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 26 Wedmath 7465', 'as_string() on 2001-08-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-19 Gregorian' );
Sterday 26 Wedmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 20, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-08-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-08-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-08-20 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 2001-08-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 27 Wedmath 7465', 'as_string() on 2001-08-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-20 Gregorian' );
Sunday 27 Wedmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 21, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-08-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-08-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-08-21 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 2001-08-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 28 Wedmath 7465', 'as_string() on 2001-08-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-21 Gregorian' );
Monday 28 Wedmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 22, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-08-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-08-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-08-22 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 2001-08-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 29 Wedmath 7465', 'as_string() on 2001-08-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-22 Gregorian' );
Trewsday 29 Wedmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 23, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-08-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-08-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Wedmath', 'month() on 2001-08-23 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 2001-08-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 30 Wedmath 7465', 'as_string() on 2001-08-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-23 Gregorian' );
Hevensday 30 Wedmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 24, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-08-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-08-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-08-24 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 2001-08-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 1 Halimath 7465', 'as_string() on 2001-08-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-24 Gregorian' );
Mersday 1 Halimath 7465
EOT

$epoch = timelocal( 0, 0, 0, 25, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-08-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-08-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-08-25 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 2001-08-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 2 Halimath 7465', 'as_string() on 2001-08-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-25 Gregorian' );
Highday 2 Halimath 7465
EOT

$epoch = timelocal( 0, 0, 0, 26, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-08-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-08-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-08-26 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 2001-08-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 3 Halimath 7465', 'as_string() on 2001-08-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-26 Gregorian' );
Sterday 3 Halimath 7465
EOT

$epoch = timelocal( 0, 0, 0, 27, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-08-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-08-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-08-27 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 2001-08-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 4 Halimath 7465', 'as_string() on 2001-08-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-27 Gregorian' );
Sunday 4 Halimath 7465
EOT

$epoch = timelocal( 0, 0, 0, 28, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-08-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-08-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-08-28 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 2001-08-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 5 Halimath 7465', 'as_string() on 2001-08-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-28 Gregorian' );
Monday 5 Halimath 7465
EOT

$epoch = timelocal( 0, 0, 0, 29, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-08-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-08-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-08-29 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 2001-08-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 6 Halimath 7465', 'as_string() on 2001-08-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-29 Gregorian' );
Trewsday 6 Halimath 7465
EOT

$epoch = timelocal( 0, 0, 0, 30, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-08-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-08-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-08-30 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 2001-08-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 7 Halimath 7465', 'as_string() on 2001-08-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-30 Gregorian' );
Hevensday 7 Halimath 7465
EOT

$epoch = timelocal( 0, 0, 0, 31, 7, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-08-31 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-08-31 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-08-31 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-08-31 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 2001-08-31 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-08-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-08-31 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 8 Halimath 7465', 'as_string() on 2001-08-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-08-31 Gregorian' );
Mersday 8 Halimath 7465
EOT

$epoch = timelocal( 0, 0, 0, 1, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-09-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-09-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-09-01 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 2001-09-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 9 Halimath 7465', 'as_string() on 2001-09-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-01 Gregorian' );
Highday 9 Halimath 7465
EOT

$epoch = timelocal( 0, 0, 0, 2, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-09-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-09-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-09-02 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 2001-09-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 10 Halimath 7465', 'as_string() on 2001-09-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-02 Gregorian' );
Sterday 10 Halimath 7465
EOT

$epoch = timelocal( 0, 0, 0, 3, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-09-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-09-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-09-03 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 2001-09-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 11 Halimath 7465', 'as_string() on 2001-09-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-03 Gregorian' );
Sunday 11 Halimath 7465
EOT

$epoch = timelocal( 0, 0, 0, 4, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-09-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-09-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-09-04 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 2001-09-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 12 Halimath 7465', 'as_string() on 2001-09-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-04 Gregorian' );
Monday 12 Halimath 7465
EOT

$epoch = timelocal( 0, 0, 0, 5, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-09-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-09-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-09-05 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 2001-09-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 13 Halimath 7465', 'as_string() on 2001-09-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-05 Gregorian' );
Trewsday 13 Halimath 7465
EOT

$epoch = timelocal( 0, 0, 0, 6, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-09-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-09-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-09-06 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 2001-09-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 14 Halimath 7465', 'as_string() on 2001-09-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-06 Gregorian' );
Hevensday 14 Halimath 7465
EOT

$epoch = timelocal( 0, 0, 0, 7, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-09-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-09-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-09-07 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 2001-09-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 15 Halimath 7465', 'as_string() on 2001-09-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-07 Gregorian' );
Mersday 15 Halimath 7465
EOT

$epoch = timelocal( 0, 0, 0, 8, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-09-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-09-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-09-08 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 2001-09-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 16 Halimath 7465', 'as_string() on 2001-09-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-08 Gregorian' );
Highday 16 Halimath 7465
EOT

$epoch = timelocal( 0, 0, 0, 9, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-09-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-09-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-09-09 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 2001-09-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 17 Halimath 7465', 'as_string() on 2001-09-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-09 Gregorian' );
Sterday 17 Halimath 7465
EOT

$epoch = timelocal( 0, 0, 0, 10, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-09-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-09-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-09-10 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 2001-09-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 18 Halimath 7465', 'as_string() on 2001-09-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-10 Gregorian' );
Sunday 18 Halimath 7465

Gandalf escapes from Orthanc in the early hours, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 11, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-09-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-09-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-09-11 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 2001-09-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 19 Halimath 7465', 'as_string() on 2001-09-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-11 Gregorian' );
Monday 19 Halimath 7465

Gandalf comes to Edoras as a beggar, and is refused admittance, 1418
EOT

$epoch = timelocal( 0, 0, 0, 12, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-09-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-09-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-09-12 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 2001-09-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 20 Halimath 7465', 'as_string() on 2001-09-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-12 Gregorian' );
Trewsday 20 Halimath 7465

Gandalf gains entrance to Edoras.  Theoden commands him to go:
"Take any horse, only be gone ere tomorrow is old", 1418.
EOT

$epoch = timelocal( 0, 0, 0, 13, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-09-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-09-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-09-13 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 2001-09-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 21 Halimath 7465', 'as_string() on 2001-09-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-13 Gregorian' );
Hevensday 21 Halimath 7465

The hobbits return to Rivendell, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 14, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-09-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-09-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-09-14 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 2001-09-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 22 Halimath 7465', 'as_string() on 2001-09-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-14 Gregorian' );
Mersday 22 Halimath 7465

Birthday of Bilbo and Frodo.
The Black Riders reach Sarn Ford at evening;
  they drive off the guard of Rangers, 1418.
Saruman comes to the Shire, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 15, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-09-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-09-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-09-15 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 2001-09-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 23 Halimath 7465', 'as_string() on 2001-09-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-15 Gregorian' );
Highday 23 Halimath 7465

Four Black Riders enter the shire before dawn.  The others pursue 
the Rangers eastward and then return to watch the Greenway, 1418.
A Black Rider comes to Hobbiton at nightfall, 1418.
Frodo leaves Bag End, 1418.
Gandalf having tamed Shadowfax rides from Rohan, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 16, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-09-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-09-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-09-16 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 2001-09-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 24 Halimath 7465', 'as_string() on 2001-09-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-16 Gregorian' );
Sterday 24 Halimath 7465
EOT

$epoch = timelocal( 0, 0, 0, 17, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-09-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-09-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-09-17 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 2001-09-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 25 Halimath 7465', 'as_string() on 2001-09-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-17 Gregorian' );
Sunday 25 Halimath 7465
EOT

$epoch = timelocal( 0, 0, 0, 18, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-09-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-09-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-09-18 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 2001-09-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 26 Halimath 7465', 'as_string() on 2001-09-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-18 Gregorian' );
Monday 26 Halimath 7465

Frodo comes to Bombadil, 1418
EOT

$epoch = timelocal( 0, 0, 0, 19, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-09-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-09-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-09-19 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 2001-09-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 27 Halimath 7465', 'as_string() on 2001-09-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-19 Gregorian' );
Trewsday 27 Halimath 7465
EOT

$epoch = timelocal( 0, 0, 0, 20, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-09-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-09-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-09-20 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 2001-09-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 28 Halimath 7465', 'as_string() on 2001-09-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-20 Gregorian' );
Hevensday 28 Halimath 7465

The Hobbits are captured by a barrow-wight, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 21, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-09-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-09-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-09-21 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 2001-09-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 29 Halimath 7465', 'as_string() on 2001-09-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-21 Gregorian' );
Mersday 29 Halimath 7465

Frodo reaches Bree at night, 1418.
Frodo and Bilbo depart over the sea with the three Keepers, 1421.
End of the Third Age, 1421.
EOT

$epoch = timelocal( 0, 0, 0, 22, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-09-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-09-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Halimath', 'month() on 2001-09-22 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 2001-09-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 30 Halimath 7465', 'as_string() on 2001-09-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-22 Gregorian' );
Highday 30 Halimath 7465

Crickhollow and the inn at Bree are raided in the early hours, 1418.
Frodo leaves Bree, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 23, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-09-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-09-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-09-23 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 2001-09-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 1 Winterfilth 7465', 'as_string() on 2001-09-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-23 Gregorian' );
Sterday 1 Winterfilth 7465
EOT

$epoch = timelocal( 0, 0, 0, 24, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-09-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-09-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-09-24 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 2001-09-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 2 Winterfilth 7465', 'as_string() on 2001-09-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-24 Gregorian' );
Sunday 2 Winterfilth 7465
EOT

$epoch = timelocal( 0, 0, 0, 25, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-09-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-09-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-09-25 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 2001-09-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 3 Winterfilth 7465', 'as_string() on 2001-09-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-25 Gregorian' );
Monday 3 Winterfilth 7465

Gandalf attacked at night on Weathertop, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 26, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-09-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-09-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-09-26 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 2001-09-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 4 Winterfilth 7465', 'as_string() on 2001-09-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-26 Gregorian' );
Trewsday 4 Winterfilth 7465
EOT

$epoch = timelocal( 0, 0, 0, 27, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-09-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-09-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-09-27 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 2001-09-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 5 Winterfilth 7465', 'as_string() on 2001-09-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-27 Gregorian' );
Hevensday 5 Winterfilth 7465

Gandalf and the Hobbits leave Rivendell, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 28, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-09-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-09-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-09-28 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 2001-09-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 6 Winterfilth 7465', 'as_string() on 2001-09-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-28 Gregorian' );
Mersday 6 Winterfilth 7465

The camp under Weathertop is attacked at night and Frodo is wounded, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 29, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-09-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-09-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-09-29 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 2001-09-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 7 Winterfilth 7465', 'as_string() on 2001-09-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-29 Gregorian' );
Highday 7 Winterfilth 7465
EOT

$epoch = timelocal( 0, 0, 0, 30, 8, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-09-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-09-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-09-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-09-30 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 2001-09-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-09-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-09-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 8 Winterfilth 7465', 'as_string() on 2001-09-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-09-30 Gregorian' );
Sterday 8 Winterfilth 7465
EOT

$epoch = timelocal( 0, 0, 0, 1, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-10-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-10-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-10-01 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 2001-10-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 9 Winterfilth 7465', 'as_string() on 2001-10-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-01 Gregorian' );
Sunday 9 Winterfilth 7465
EOT

$epoch = timelocal( 0, 0, 0, 2, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-10-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-10-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-10-02 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 2001-10-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 10 Winterfilth 7465', 'as_string() on 2001-10-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-02 Gregorian' );
Monday 10 Winterfilth 7465
EOT

$epoch = timelocal( 0, 0, 0, 3, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-10-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-10-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-10-03 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 2001-10-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 11 Winterfilth 7465', 'as_string() on 2001-10-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-03 Gregorian' );
Trewsday 11 Winterfilth 7465

Glorfindel drives the Black Riders off the Bridge of Mitheithel, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 4, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-10-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-10-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-10-04 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 2001-10-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 12 Winterfilth 7465', 'as_string() on 2001-10-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-04 Gregorian' );
Hevensday 12 Winterfilth 7465
EOT

$epoch = timelocal( 0, 0, 0, 5, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-10-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-10-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-10-05 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 2001-10-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 13 Winterfilth 7465', 'as_string() on 2001-10-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-05 Gregorian' );
Mersday 13 Winterfilth 7465

Frodo crosses the Bridge of Mitheithel, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 6, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-10-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-10-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-10-06 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 2001-10-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 14 Winterfilth 7465', 'as_string() on 2001-10-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-06 Gregorian' );
Highday 14 Winterfilth 7465
EOT

$epoch = timelocal( 0, 0, 0, 7, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-10-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-10-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-10-07 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 2001-10-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 15 Winterfilth 7465', 'as_string() on 2001-10-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-07 Gregorian' );
Sterday 15 Winterfilth 7465
EOT

$epoch = timelocal( 0, 0, 0, 8, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-10-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-10-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-10-08 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 2001-10-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 16 Winterfilth 7465', 'as_string() on 2001-10-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-08 Gregorian' );
Sunday 16 Winterfilth 7465
EOT

$epoch = timelocal( 0, 0, 0, 9, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-10-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-10-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-10-09 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 2001-10-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 17 Winterfilth 7465', 'as_string() on 2001-10-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-09 Gregorian' );
Monday 17 Winterfilth 7465
EOT

$epoch = timelocal( 0, 0, 0, 10, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-10-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-10-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-10-10 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 2001-10-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 18 Winterfilth 7465', 'as_string() on 2001-10-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-10 Gregorian' );
Trewsday 18 Winterfilth 7465

Glorfindel finds Frodo at dusk, 1418.
Gandalf reaches Rivendell, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 11, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-10-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-10-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-10-11 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 2001-10-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 19 Winterfilth 7465', 'as_string() on 2001-10-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-11 Gregorian' );
Hevensday 19 Winterfilth 7465
EOT

$epoch = timelocal( 0, 0, 0, 12, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-10-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-10-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-10-12 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 2001-10-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 20 Winterfilth 7465', 'as_string() on 2001-10-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-12 Gregorian' );
Mersday 20 Winterfilth 7465

Escape across the Ford of Bruinen, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 13, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-10-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-10-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-10-13 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 2001-10-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 21 Winterfilth 7465', 'as_string() on 2001-10-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-13 Gregorian' );
Highday 21 Winterfilth 7465
EOT

$epoch = timelocal( 0, 0, 0, 14, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-10-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-10-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-10-14 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 2001-10-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 22 Winterfilth 7465', 'as_string() on 2001-10-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-14 Gregorian' );
Sterday 22 Winterfilth 7465
EOT

$epoch = timelocal( 0, 0, 0, 15, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-10-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-10-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-10-15 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 2001-10-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 23 Winterfilth 7465', 'as_string() on 2001-10-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-15 Gregorian' );
Sunday 23 Winterfilth 7465
EOT

$epoch = timelocal( 0, 0, 0, 16, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-10-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-10-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-10-16 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 2001-10-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 24 Winterfilth 7465', 'as_string() on 2001-10-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-16 Gregorian' );
Monday 24 Winterfilth 7465

Frodo recovers and wakes, 1418.
Boromir arrives at Rivendell at night, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 17, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-10-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-10-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-10-17 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 2001-10-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 25 Winterfilth 7465', 'as_string() on 2001-10-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-17 Gregorian' );
Trewsday 25 Winterfilth 7465

Council of Elrond, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 18, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-10-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-10-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-10-18 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 2001-10-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 26 Winterfilth 7465', 'as_string() on 2001-10-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-18 Gregorian' );
Hevensday 26 Winterfilth 7465
EOT

$epoch = timelocal( 0, 0, 0, 19, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-10-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-10-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-10-19 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 2001-10-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 27 Winterfilth 7465', 'as_string() on 2001-10-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-19 Gregorian' );
Mersday 27 Winterfilth 7465
EOT

$epoch = timelocal( 0, 0, 0, 20, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-10-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-10-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-10-20 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 2001-10-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 28 Winterfilth 7465', 'as_string() on 2001-10-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-20 Gregorian' );
Highday 28 Winterfilth 7465
EOT

$epoch = timelocal( 0, 0, 0, 21, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-10-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-10-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-10-21 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 2001-10-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 29 Winterfilth 7465', 'as_string() on 2001-10-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-21 Gregorian' );
Sterday 29 Winterfilth 7465
EOT

$epoch = timelocal( 0, 0, 0, 22, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-10-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-10-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Winterfilth', 'month() on 2001-10-22 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 2001-10-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 30 Winterfilth 7465', 'as_string() on 2001-10-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-22 Gregorian' );
Sunday 30 Winterfilth 7465

The four Hobbits arrive at the Brandywine Bridge in the dark, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 23, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-10-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-10-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-10-23 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 2001-10-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 1 Blotmath 7465', 'as_string() on 2001-10-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-23 Gregorian' );
Monday 1 Blotmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 24, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-10-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-10-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-10-24 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 2001-10-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 2 Blotmath 7465', 'as_string() on 2001-10-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-24 Gregorian' );
Trewsday 2 Blotmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 25, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-10-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-10-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-10-25 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 2001-10-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 3 Blotmath 7465', 'as_string() on 2001-10-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-25 Gregorian' );
Hevensday 3 Blotmath 7465

Battle of Bywater and passing of Saruman, 1419.
End of the War of the Ring, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 26, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-10-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-10-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-10-26 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 2001-10-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 4 Blotmath 7465', 'as_string() on 2001-10-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-26 Gregorian' );
Mersday 4 Blotmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 27, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-10-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-10-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-10-27 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 2001-10-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 5 Blotmath 7465', 'as_string() on 2001-10-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-27 Gregorian' );
Highday 5 Blotmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 28, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-10-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-10-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-10-28 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 2001-10-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 6 Blotmath 7465', 'as_string() on 2001-10-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-28 Gregorian' );
Sterday 6 Blotmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 29, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-10-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-10-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-10-29 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 2001-10-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 7 Blotmath 7465', 'as_string() on 2001-10-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-29 Gregorian' );
Sunday 7 Blotmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 30, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-10-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-10-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-10-30 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 2001-10-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 8 Blotmath 7465', 'as_string() on 2001-10-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-30 Gregorian' );
Monday 8 Blotmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 31, 9, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-10-31 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-10-31 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-10-31 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-10-31 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 2001-10-31 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-10-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-10-31 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 9 Blotmath 7465', 'as_string() on 2001-10-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-10-31 Gregorian' );
Trewsday 9 Blotmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 1, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-11-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-11-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-11-01 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 2001-11-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 10 Blotmath 7465', 'as_string() on 2001-11-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-01 Gregorian' );
Hevensday 10 Blotmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 2, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-11-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-11-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-11-02 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 2001-11-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 11 Blotmath 7465', 'as_string() on 2001-11-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-02 Gregorian' );
Mersday 11 Blotmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 3, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-11-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-11-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-11-03 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 2001-11-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 12 Blotmath 7465', 'as_string() on 2001-11-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-03 Gregorian' );
Highday 12 Blotmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 4, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-11-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-11-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-11-04 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 2001-11-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 13 Blotmath 7465', 'as_string() on 2001-11-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-04 Gregorian' );
Sterday 13 Blotmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 5, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-11-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-11-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-11-05 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 2001-11-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 14 Blotmath 7465', 'as_string() on 2001-11-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-05 Gregorian' );
Sunday 14 Blotmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 6, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-11-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-11-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-11-06 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 2001-11-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 15 Blotmath 7465', 'as_string() on 2001-11-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-06 Gregorian' );
Monday 15 Blotmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 7, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-11-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-11-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-11-07 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 2001-11-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 16 Blotmath 7465', 'as_string() on 2001-11-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-07 Gregorian' );
Trewsday 16 Blotmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 8, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-11-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-11-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-11-08 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 2001-11-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 17 Blotmath 7465', 'as_string() on 2001-11-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-08 Gregorian' );
Hevensday 17 Blotmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 9, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-11-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-11-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-11-09 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 2001-11-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 18 Blotmath 7465', 'as_string() on 2001-11-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-09 Gregorian' );
Mersday 18 Blotmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 10, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-11-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-11-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-11-10 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 2001-11-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 19 Blotmath 7465', 'as_string() on 2001-11-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-10 Gregorian' );
Highday 19 Blotmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 11, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-11-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-11-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-11-11 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 2001-11-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 20 Blotmath 7465', 'as_string() on 2001-11-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-11 Gregorian' );
Sterday 20 Blotmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 12, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-11-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-11-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-11-12 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 2001-11-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 21 Blotmath 7465', 'as_string() on 2001-11-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-12 Gregorian' );
Sunday 21 Blotmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 13, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-11-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-11-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-11-13 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 2001-11-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 22 Blotmath 7465', 'as_string() on 2001-11-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-13 Gregorian' );
Monday 22 Blotmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 14, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-11-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-11-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-11-14 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 2001-11-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 23 Blotmath 7465', 'as_string() on 2001-11-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-14 Gregorian' );
Trewsday 23 Blotmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 15, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-11-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-11-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-11-15 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 2001-11-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 24 Blotmath 7465', 'as_string() on 2001-11-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-15 Gregorian' );
Hevensday 24 Blotmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 16, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-11-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-11-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-11-16 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 2001-11-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 25 Blotmath 7465', 'as_string() on 2001-11-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-16 Gregorian' );
Mersday 25 Blotmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 17, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-11-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-11-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-11-17 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 2001-11-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 26 Blotmath 7465', 'as_string() on 2001-11-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-17 Gregorian' );
Highday 26 Blotmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 18, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-11-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-11-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-11-18 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 2001-11-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 27 Blotmath 7465', 'as_string() on 2001-11-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-18 Gregorian' );
Sterday 27 Blotmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 19, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-11-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-11-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-11-19 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 2001-11-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 28 Blotmath 7465', 'as_string() on 2001-11-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-19 Gregorian' );
Sunday 28 Blotmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 20, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-11-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-11-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-11-20 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 2001-11-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 29 Blotmath 7465', 'as_string() on 2001-11-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-20 Gregorian' );
Monday 29 Blotmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 21, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-11-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-11-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Blotmath', 'month() on 2001-11-21 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 2001-11-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 30 Blotmath 7465', 'as_string() on 2001-11-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-21 Gregorian' );
Trewsday 30 Blotmath 7465
EOT

$epoch = timelocal( 0, 0, 0, 22, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-11-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-11-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-11-22 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 2001-11-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 1 Foreyule 7465', 'as_string() on 2001-11-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-22 Gregorian' );
Hevensday 1 Foreyule 7465
EOT

$epoch = timelocal( 0, 0, 0, 23, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-11-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-11-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-11-23 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 2001-11-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 2 Foreyule 7465', 'as_string() on 2001-11-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-23 Gregorian' );
Mersday 2 Foreyule 7465
EOT

$epoch = timelocal( 0, 0, 0, 24, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-11-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-11-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-11-24 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 2001-11-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 3 Foreyule 7465', 'as_string() on 2001-11-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-24 Gregorian' );
Highday 3 Foreyule 7465
EOT

$epoch = timelocal( 0, 0, 0, 25, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-11-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-11-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-11-25 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 2001-11-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 4 Foreyule 7465', 'as_string() on 2001-11-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-25 Gregorian' );
Sterday 4 Foreyule 7465
EOT

$epoch = timelocal( 0, 0, 0, 26, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-11-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-11-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-11-26 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 2001-11-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 5 Foreyule 7465', 'as_string() on 2001-11-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-26 Gregorian' );
Sunday 5 Foreyule 7465
EOT

$epoch = timelocal( 0, 0, 0, 27, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-11-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-11-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-11-27 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 2001-11-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 6 Foreyule 7465', 'as_string() on 2001-11-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-27 Gregorian' );
Monday 6 Foreyule 7465
EOT

$epoch = timelocal( 0, 0, 0, 28, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-11-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-11-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-11-28 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 2001-11-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 7 Foreyule 7465', 'as_string() on 2001-11-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-28 Gregorian' );
Trewsday 7 Foreyule 7465
EOT

$epoch = timelocal( 0, 0, 0, 29, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-11-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-11-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-11-29 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 2001-11-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 8 Foreyule 7465', 'as_string() on 2001-11-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-29 Gregorian' );
Hevensday 8 Foreyule 7465
EOT

$epoch = timelocal( 0, 0, 0, 30, 10, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-11-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-11-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-11-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-11-30 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 2001-11-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-11-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-11-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 9 Foreyule 7465', 'as_string() on 2001-11-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-11-30 Gregorian' );
Mersday 9 Foreyule 7465
EOT

$epoch = timelocal( 0, 0, 0, 1, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-12-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-12-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-12-01 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 2001-12-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-12-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-12-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 10 Foreyule 7465', 'as_string() on 2001-12-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-01 Gregorian' );
Highday 10 Foreyule 7465
EOT

$epoch = timelocal( 0, 0, 0, 2, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-12-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-12-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-12-02 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 2001-12-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-12-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-12-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 11 Foreyule 7465', 'as_string() on 2001-12-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-02 Gregorian' );
Sterday 11 Foreyule 7465
EOT

$epoch = timelocal( 0, 0, 0, 3, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-12-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-12-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-12-03 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 2001-12-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-12-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-12-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 12 Foreyule 7465', 'as_string() on 2001-12-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-03 Gregorian' );
Sunday 12 Foreyule 7465
EOT

$epoch = timelocal( 0, 0, 0, 4, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-12-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-12-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-12-04 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 2001-12-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-12-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-12-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 13 Foreyule 7465', 'as_string() on 2001-12-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-04 Gregorian' );
Monday 13 Foreyule 7465
EOT

$epoch = timelocal( 0, 0, 0, 5, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-12-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-12-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-12-05 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 2001-12-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-12-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-12-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 14 Foreyule 7465', 'as_string() on 2001-12-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-05 Gregorian' );
Trewsday 14 Foreyule 7465
EOT

$epoch = timelocal( 0, 0, 0, 6, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-12-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-12-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-12-06 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 2001-12-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-12-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-12-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 15 Foreyule 7465', 'as_string() on 2001-12-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-06 Gregorian' );
Hevensday 15 Foreyule 7465
EOT

$epoch = timelocal( 0, 0, 0, 7, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-12-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-12-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-12-07 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 2001-12-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-12-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-12-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 16 Foreyule 7465', 'as_string() on 2001-12-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-07 Gregorian' );
Mersday 16 Foreyule 7465
EOT

$epoch = timelocal( 0, 0, 0, 8, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-12-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-12-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-12-08 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 2001-12-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-12-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-12-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 17 Foreyule 7465', 'as_string() on 2001-12-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-08 Gregorian' );
Highday 17 Foreyule 7465
EOT

$epoch = timelocal( 0, 0, 0, 9, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-12-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-12-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-12-09 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 2001-12-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-12-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-12-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 18 Foreyule 7465', 'as_string() on 2001-12-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-09 Gregorian' );
Sterday 18 Foreyule 7465
EOT

$epoch = timelocal( 0, 0, 0, 10, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-12-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-12-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-12-10 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 2001-12-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-12-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-12-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 19 Foreyule 7465', 'as_string() on 2001-12-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-10 Gregorian' );
Sunday 19 Foreyule 7465
EOT

$epoch = timelocal( 0, 0, 0, 11, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-12-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-12-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-12-11 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 2001-12-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-12-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-12-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 20 Foreyule 7465', 'as_string() on 2001-12-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-11 Gregorian' );
Monday 20 Foreyule 7465
EOT

$epoch = timelocal( 0, 0, 0, 12, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-12-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-12-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-12-12 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 2001-12-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-12-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-12-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 21 Foreyule 7465', 'as_string() on 2001-12-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-12 Gregorian' );
Trewsday 21 Foreyule 7465
EOT

$epoch = timelocal( 0, 0, 0, 13, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-12-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-12-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-12-13 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 2001-12-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-12-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-12-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 22 Foreyule 7465', 'as_string() on 2001-12-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-13 Gregorian' );
Hevensday 22 Foreyule 7465
EOT

$epoch = timelocal( 0, 0, 0, 14, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-12-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-12-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-12-14 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 2001-12-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-12-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-12-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 23 Foreyule 7465', 'as_string() on 2001-12-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-14 Gregorian' );
Mersday 23 Foreyule 7465
EOT

$epoch = timelocal( 0, 0, 0, 15, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-12-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-12-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-12-15 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 2001-12-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-12-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-12-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 24 Foreyule 7465', 'as_string() on 2001-12-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-15 Gregorian' );
Highday 24 Foreyule 7465
EOT

$epoch = timelocal( 0, 0, 0, 16, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-12-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-12-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-12-16 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 2001-12-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-12-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-12-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 25 Foreyule 7465', 'as_string() on 2001-12-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-16 Gregorian' );
Sterday 25 Foreyule 7465

The Company of the Ring leaves Rivendell at dusk, 1418.
EOT

$epoch = timelocal( 0, 0, 0, 17, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-12-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-12-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-12-17 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 2001-12-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-12-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-12-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 26 Foreyule 7465', 'as_string() on 2001-12-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-17 Gregorian' );
Sunday 26 Foreyule 7465
EOT

$epoch = timelocal( 0, 0, 0, 18, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-12-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-12-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-12-18 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 2001-12-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-12-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-12-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 27 Foreyule 7465', 'as_string() on 2001-12-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-18 Gregorian' );
Monday 27 Foreyule 7465
EOT

$epoch = timelocal( 0, 0, 0, 19, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-12-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-12-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-12-19 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 2001-12-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-12-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-12-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 28 Foreyule 7465', 'as_string() on 2001-12-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-19 Gregorian' );
Trewsday 28 Foreyule 7465
EOT

$epoch = timelocal( 0, 0, 0, 20, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-12-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-12-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-12-20 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 2001-12-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-12-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-12-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 29 Foreyule 7465', 'as_string() on 2001-12-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-20 Gregorian' );
Hevensday 29 Foreyule 7465
EOT

$epoch = timelocal( 0, 0, 0, 21, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-12-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-12-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Foreyule', 'month() on 2001-12-21 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 2001-12-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-12-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-12-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 30 Foreyule 7465', 'as_string() on 2001-12-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-21 Gregorian' );
Mersday 30 Foreyule 7465
EOT

$epoch = timelocal( 0, 0, 0, 22, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-12-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-12-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', '', 'month() on 2001-12-22 Gregorian' );
cmp_ok( $dts->day(), '==', 0, 'day() on 2001-12-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '1 Yule', 'holiday() on 2001-12-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7465, 'year() on 2001-12-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 1 Yule 7465', 'as_string() on 2001-12-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-22 Gregorian' );
Highday 1 Yule 7465
EOT

$epoch = timelocal( 0, 0, 0, 23, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-12-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-12-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', '', 'month() on 2001-12-23 Gregorian' );
cmp_ok( $dts->day(), '==', 0, 'day() on 2001-12-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '2 Yule', 'holiday() on 2001-12-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2001-12-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 2 Yule 7466', 'as_string() on 2001-12-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-23 Gregorian' );
Sterday 2 Yule 7466
EOT

$epoch = timelocal( 0, 0, 0, 24, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-12-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-12-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-12-24 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 2001-12-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-12-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2001-12-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 1 Afteryule 7466', 'as_string() on 2001-12-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-24 Gregorian' );
Sunday 1 Afteryule 7466
EOT

$epoch = timelocal( 0, 0, 0, 25, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2001-12-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2001-12-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-12-25 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 2001-12-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-12-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2001-12-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 2 Afteryule 7466', 'as_string() on 2001-12-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-25 Gregorian' );
Monday 2 Afteryule 7466
EOT

$epoch = timelocal( 0, 0, 0, 26, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2001-12-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2001-12-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-12-26 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 2001-12-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-12-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2001-12-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 3 Afteryule 7466', 'as_string() on 2001-12-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-26 Gregorian' );
Trewsday 3 Afteryule 7466
EOT

$epoch = timelocal( 0, 0, 0, 27, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2001-12-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2001-12-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-12-27 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 2001-12-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-12-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2001-12-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 4 Afteryule 7466', 'as_string() on 2001-12-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-27 Gregorian' );
Hevensday 4 Afteryule 7466
EOT

$epoch = timelocal( 0, 0, 0, 28, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2001-12-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2001-12-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-12-28 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 2001-12-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-12-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2001-12-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 5 Afteryule 7466', 'as_string() on 2001-12-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-28 Gregorian' );
Mersday 5 Afteryule 7466
EOT

$epoch = timelocal( 0, 0, 0, 29, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2001-12-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2001-12-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-12-29 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 2001-12-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-12-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2001-12-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 6 Afteryule 7466', 'as_string() on 2001-12-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-29 Gregorian' );
Highday 6 Afteryule 7466
EOT

$epoch = timelocal( 0, 0, 0, 30, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2001-12-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2001-12-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-12-30 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 2001-12-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-12-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2001-12-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 7 Afteryule 7466', 'as_string() on 2001-12-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-30 Gregorian' );
Sterday 7 Afteryule 7466
EOT

$epoch = timelocal( 0, 0, 0, 31, 11, 2001 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2001-12-31 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2001-12-31 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2001-12-31 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2001-12-31 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 2001-12-31 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2001-12-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2001-12-31 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 8 Afteryule 7466', 'as_string() on 2001-12-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2001-12-31 Gregorian' );
Sunday 8 Afteryule 7466

The Company of the Ring reaches Hollin, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 1, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2002-01-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2002-01-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2002-01-01 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 2002-01-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 9 Afteryule 7466', 'as_string() on 2002-01-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-01 Gregorian' );
Monday 9 Afteryule 7466
EOT

$epoch = timelocal( 0, 0, 0, 2, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2002-01-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2002-01-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2002-01-02 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 2002-01-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 10 Afteryule 7466', 'as_string() on 2002-01-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-02 Gregorian' );
Trewsday 10 Afteryule 7466
EOT

$epoch = timelocal( 0, 0, 0, 3, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2002-01-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2002-01-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2002-01-03 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 2002-01-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 11 Afteryule 7466', 'as_string() on 2002-01-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-03 Gregorian' );
Hevensday 11 Afteryule 7466
EOT

$epoch = timelocal( 0, 0, 0, 4, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2002-01-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2002-01-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2002-01-04 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 2002-01-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 12 Afteryule 7466', 'as_string() on 2002-01-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-04 Gregorian' );
Mersday 12 Afteryule 7466
EOT

$epoch = timelocal( 0, 0, 0, 5, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2002-01-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2002-01-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2002-01-05 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 2002-01-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 13 Afteryule 7466', 'as_string() on 2002-01-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-05 Gregorian' );
Highday 13 Afteryule 7466

The Company of the Ring reaches the West-gate of Moria at nightfall, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 6, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2002-01-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2002-01-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2002-01-06 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 2002-01-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 14 Afteryule 7466', 'as_string() on 2002-01-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-06 Gregorian' );
Sterday 14 Afteryule 7466

The Company of the Ring spends the night in Moria hall 21, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 7, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2002-01-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2002-01-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2002-01-07 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 2002-01-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 15 Afteryule 7466', 'as_string() on 2002-01-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-07 Gregorian' );
Sunday 15 Afteryule 7466

The Bridge of Khazad-dum, and the fall of Gandalf, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 8, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2002-01-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2002-01-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2002-01-08 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 2002-01-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 16 Afteryule 7466', 'as_string() on 2002-01-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-08 Gregorian' );
Monday 16 Afteryule 7466
EOT

$epoch = timelocal( 0, 0, 0, 9, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2002-01-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2002-01-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2002-01-09 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 2002-01-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 17 Afteryule 7466', 'as_string() on 2002-01-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-09 Gregorian' );
Trewsday 17 Afteryule 7466

The Company of the Ring comes to Caras Galadhon at evening, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 10, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2002-01-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2002-01-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2002-01-10 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 2002-01-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 18 Afteryule 7466', 'as_string() on 2002-01-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-10 Gregorian' );
Hevensday 18 Afteryule 7466
EOT

$epoch = timelocal( 0, 0, 0, 11, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2002-01-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2002-01-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2002-01-11 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 2002-01-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 19 Afteryule 7466', 'as_string() on 2002-01-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-11 Gregorian' );
Mersday 19 Afteryule 7466
EOT

$epoch = timelocal( 0, 0, 0, 12, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2002-01-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2002-01-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2002-01-12 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 2002-01-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 20 Afteryule 7466', 'as_string() on 2002-01-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-12 Gregorian' );
Highday 20 Afteryule 7466
EOT

$epoch = timelocal( 0, 0, 0, 13, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2002-01-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2002-01-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2002-01-13 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 2002-01-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 21 Afteryule 7466', 'as_string() on 2002-01-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-13 Gregorian' );
Sterday 21 Afteryule 7466
EOT

$epoch = timelocal( 0, 0, 0, 14, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2002-01-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2002-01-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2002-01-14 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 2002-01-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 22 Afteryule 7466', 'as_string() on 2002-01-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-14 Gregorian' );
Sunday 22 Afteryule 7466
EOT

$epoch = timelocal( 0, 0, 0, 15, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2002-01-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2002-01-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2002-01-15 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 2002-01-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 23 Afteryule 7466', 'as_string() on 2002-01-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-15 Gregorian' );
Monday 23 Afteryule 7466

Gandalf pursues the Balrog to the peak of Zirakzigil, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 16, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2002-01-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2002-01-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2002-01-16 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 2002-01-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 24 Afteryule 7466', 'as_string() on 2002-01-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-16 Gregorian' );
Trewsday 24 Afteryule 7466
EOT

$epoch = timelocal( 0, 0, 0, 17, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2002-01-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2002-01-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2002-01-17 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 2002-01-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 25 Afteryule 7466', 'as_string() on 2002-01-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-17 Gregorian' );
Hevensday 25 Afteryule 7466

Gandalf casts down the Balrog, and passes away.
His body lies on the peak of Zirakzigil, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 18, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2002-01-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2002-01-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2002-01-18 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 2002-01-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 26 Afteryule 7466', 'as_string() on 2002-01-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-18 Gregorian' );
Mersday 26 Afteryule 7466
EOT

$epoch = timelocal( 0, 0, 0, 19, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2002-01-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2002-01-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2002-01-19 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 2002-01-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 27 Afteryule 7466', 'as_string() on 2002-01-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-19 Gregorian' );
Highday 27 Afteryule 7466
EOT

$epoch = timelocal( 0, 0, 0, 20, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2002-01-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2002-01-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2002-01-20 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 2002-01-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 28 Afteryule 7466', 'as_string() on 2002-01-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-20 Gregorian' );
Sterday 28 Afteryule 7466
EOT

$epoch = timelocal( 0, 0, 0, 21, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2002-01-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2002-01-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2002-01-21 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 2002-01-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 29 Afteryule 7466', 'as_string() on 2002-01-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-21 Gregorian' );
Sunday 29 Afteryule 7466
EOT

$epoch = timelocal( 0, 0, 0, 22, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2002-01-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2002-01-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Afteryule', 'month() on 2002-01-22 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 2002-01-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 30 Afteryule 7466', 'as_string() on 2002-01-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-22 Gregorian' );
Monday 30 Afteryule 7466
EOT

$epoch = timelocal( 0, 0, 0, 23, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2002-01-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2002-01-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-01-23 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 2002-01-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 1 Solmath 7466', 'as_string() on 2002-01-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-23 Gregorian' );
Trewsday 1 Solmath 7466
EOT

$epoch = timelocal( 0, 0, 0, 24, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2002-01-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2002-01-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-01-24 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 2002-01-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 2 Solmath 7466', 'as_string() on 2002-01-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-24 Gregorian' );
Hevensday 2 Solmath 7466
EOT

$epoch = timelocal( 0, 0, 0, 25, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2002-01-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2002-01-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-01-25 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 2002-01-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 3 Solmath 7466', 'as_string() on 2002-01-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-25 Gregorian' );
Mersday 3 Solmath 7466
EOT

$epoch = timelocal( 0, 0, 0, 26, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2002-01-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2002-01-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-01-26 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 2002-01-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 4 Solmath 7466', 'as_string() on 2002-01-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-26 Gregorian' );
Highday 4 Solmath 7466
EOT

$epoch = timelocal( 0, 0, 0, 27, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2002-01-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2002-01-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-01-27 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 2002-01-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 5 Solmath 7466', 'as_string() on 2002-01-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-27 Gregorian' );
Sterday 5 Solmath 7466
EOT

$epoch = timelocal( 0, 0, 0, 28, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2002-01-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2002-01-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-01-28 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 2002-01-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 6 Solmath 7466', 'as_string() on 2002-01-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-28 Gregorian' );
Sunday 6 Solmath 7466
EOT

$epoch = timelocal( 0, 0, 0, 29, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-29 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2002-01-29 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2002-01-29 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-01-29 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 2002-01-29 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-29 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-29 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 7 Solmath 7466', 'as_string() on 2002-01-29 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-29 Gregorian' );
Monday 7 Solmath 7466
EOT

$epoch = timelocal( 0, 0, 0, 30, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-30 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2002-01-30 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2002-01-30 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-01-30 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 2002-01-30 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-30 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-30 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 8 Solmath 7466', 'as_string() on 2002-01-30 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-30 Gregorian' );
Trewsday 8 Solmath 7466
EOT

$epoch = timelocal( 0, 0, 0, 31, 0, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-01-31 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2002-01-31 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2002-01-31 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-01-31 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 2002-01-31 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-01-31 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-01-31 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 9 Solmath 7466', 'as_string() on 2002-01-31 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-01-31 Gregorian' );
Hevensday 9 Solmath 7466
EOT

$epoch = timelocal( 0, 0, 0, 1, 1, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-02-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2002-02-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2002-02-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-02-01 Gregorian' );
cmp_ok( $dts->day(), '==', 10, 'day() on 2002-02-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-02-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-02-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 10 Solmath 7466', 'as_string() on 2002-02-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-02-01 Gregorian' );
Mersday 10 Solmath 7466
EOT

$epoch = timelocal( 0, 0, 0, 2, 1, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-02-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2002-02-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2002-02-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-02-02 Gregorian' );
cmp_ok( $dts->day(), '==', 11, 'day() on 2002-02-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-02-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-02-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 11 Solmath 7466', 'as_string() on 2002-02-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-02-02 Gregorian' );
Highday 11 Solmath 7466
EOT

$epoch = timelocal( 0, 0, 0, 3, 1, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-02-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2002-02-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2002-02-03 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-02-03 Gregorian' );
cmp_ok( $dts->day(), '==', 12, 'day() on 2002-02-03 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-02-03 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-02-03 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 12 Solmath 7466', 'as_string() on 2002-02-03 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-02-03 Gregorian' );
Sterday 12 Solmath 7466
EOT

$epoch = timelocal( 0, 0, 0, 4, 1, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-02-04 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2002-02-04 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2002-02-04 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-02-04 Gregorian' );
cmp_ok( $dts->day(), '==', 13, 'day() on 2002-02-04 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-02-04 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-02-04 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 13 Solmath 7466', 'as_string() on 2002-02-04 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-02-04 Gregorian' );
Sunday 13 Solmath 7466
EOT

$epoch = timelocal( 0, 0, 0, 5, 1, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-02-05 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2002-02-05 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2002-02-05 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-02-05 Gregorian' );
cmp_ok( $dts->day(), '==', 14, 'day() on 2002-02-05 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-02-05 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-02-05 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 14 Solmath 7466', 'as_string() on 2002-02-05 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-02-05 Gregorian' );
Monday 14 Solmath 7466

Frodo and Sam look in the Mirror of Galadriel, 1419.
Gandalf returns to life, and lies in a trance, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 6, 1, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-02-06 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2002-02-06 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2002-02-06 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-02-06 Gregorian' );
cmp_ok( $dts->day(), '==', 15, 'day() on 2002-02-06 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-02-06 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-02-06 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 15 Solmath 7466', 'as_string() on 2002-02-06 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-02-06 Gregorian' );
Trewsday 15 Solmath 7466
EOT

$epoch = timelocal( 0, 0, 0, 7, 1, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-02-07 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2002-02-07 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2002-02-07 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-02-07 Gregorian' );
cmp_ok( $dts->day(), '==', 16, 'day() on 2002-02-07 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-02-07 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-02-07 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 16 Solmath 7466', 'as_string() on 2002-02-07 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-02-07 Gregorian' );
Hevensday 16 Solmath 7466

Company of the Ring says farewell to Lorien --
Gollum observes departure, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 8, 1, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-02-08 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2002-02-08 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2002-02-08 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-02-08 Gregorian' );
cmp_ok( $dts->day(), '==', 17, 'day() on 2002-02-08 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-02-08 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-02-08 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 17 Solmath 7466', 'as_string() on 2002-02-08 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-02-08 Gregorian' );
Mersday 17 Solmath 7466

Gwaihir the eagle bears Gandalf to Lorien, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 9, 1, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-02-09 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2002-02-09 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2002-02-09 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-02-09 Gregorian' );
cmp_ok( $dts->day(), '==', 18, 'day() on 2002-02-09 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-02-09 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-02-09 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 18 Solmath 7466', 'as_string() on 2002-02-09 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-02-09 Gregorian' );
Highday 18 Solmath 7466
EOT

$epoch = timelocal( 0, 0, 0, 10, 1, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-02-10 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2002-02-10 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2002-02-10 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-02-10 Gregorian' );
cmp_ok( $dts->day(), '==', 19, 'day() on 2002-02-10 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-02-10 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-02-10 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 19 Solmath 7466', 'as_string() on 2002-02-10 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-02-10 Gregorian' );
Sterday 19 Solmath 7466
EOT

$epoch = timelocal( 0, 0, 0, 11, 1, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-02-11 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2002-02-11 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2002-02-11 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-02-11 Gregorian' );
cmp_ok( $dts->day(), '==', 20, 'day() on 2002-02-11 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-02-11 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-02-11 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 20 Solmath 7466', 'as_string() on 2002-02-11 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-02-11 Gregorian' );
Sunday 20 Solmath 7466
EOT

$epoch = timelocal( 0, 0, 0, 12, 1, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-02-12 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2002-02-12 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2002-02-12 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-02-12 Gregorian' );
cmp_ok( $dts->day(), '==', 21, 'day() on 2002-02-12 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-02-12 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-02-12 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 21 Solmath 7466', 'as_string() on 2002-02-12 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-02-12 Gregorian' );
Monday 21 Solmath 7466
EOT

$epoch = timelocal( 0, 0, 0, 13, 1, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-02-13 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2002-02-13 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2002-02-13 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-02-13 Gregorian' );
cmp_ok( $dts->day(), '==', 22, 'day() on 2002-02-13 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-02-13 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-02-13 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 22 Solmath 7466', 'as_string() on 2002-02-13 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-02-13 Gregorian' );
Trewsday 22 Solmath 7466
EOT

$epoch = timelocal( 0, 0, 0, 14, 1, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-02-14 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2002-02-14 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2002-02-14 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-02-14 Gregorian' );
cmp_ok( $dts->day(), '==', 23, 'day() on 2002-02-14 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-02-14 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-02-14 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 23 Solmath 7466', 'as_string() on 2002-02-14 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-02-14 Gregorian' );
Hevensday 23 Solmath 7466
EOT

$epoch = timelocal( 0, 0, 0, 15, 1, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-02-15 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2002-02-15 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2002-02-15 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-02-15 Gregorian' );
cmp_ok( $dts->day(), '==', 24, 'day() on 2002-02-15 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-02-15 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-02-15 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 24 Solmath 7466', 'as_string() on 2002-02-15 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-02-15 Gregorian' );
Mersday 24 Solmath 7466
EOT

$epoch = timelocal( 0, 0, 0, 16, 1, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-02-16 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2002-02-16 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2002-02-16 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-02-16 Gregorian' );
cmp_ok( $dts->day(), '==', 25, 'day() on 2002-02-16 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-02-16 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-02-16 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 25 Solmath 7466', 'as_string() on 2002-02-16 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-02-16 Gregorian' );
Highday 25 Solmath 7466

The Company of the Ring pass the Argonath and camp at Parth Galen, 1419.
First battle of the Fords of Isen -- Theodred son of Theoden slain, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 17, 1, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-02-17 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2002-02-17 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2002-02-17 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-02-17 Gregorian' );
cmp_ok( $dts->day(), '==', 26, 'day() on 2002-02-17 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-02-17 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-02-17 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 26 Solmath 7466', 'as_string() on 2002-02-17 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-02-17 Gregorian' );
Sterday 26 Solmath 7466

Breaking of the Fellowship, 1419.
Death of Boromir; his horn is heard in Minas Tirith, 1419.
Meriadoc and Peregrin captured by Orcs -- Aragorn pursues, 1419.
Eomer hears of the descent of the Orc-band from Emyn Muil, 1419.
Frodo and Samwise enter the eastern Emyn Muil, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 18, 1, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-02-18 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2002-02-18 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2002-02-18 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-02-18 Gregorian' );
cmp_ok( $dts->day(), '==', 27, 'day() on 2002-02-18 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-02-18 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-02-18 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 27 Solmath 7466', 'as_string() on 2002-02-18 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-02-18 Gregorian' );
Sunday 27 Solmath 7466

Aragorn reaches the west-cliff at sunrise, 1419.
Eomer sets out from Eastfold against Theoden's orders to pursue the Orcs, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 19, 1, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-02-19 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2002-02-19 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2002-02-19 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-02-19 Gregorian' );
cmp_ok( $dts->day(), '==', 28, 'day() on 2002-02-19 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-02-19 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-02-19 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 28 Solmath 7466', 'as_string() on 2002-02-19 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-02-19 Gregorian' );
Monday 28 Solmath 7466

Eomer overtakes the Orcs just outside of Fangorn Forest, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 20, 1, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-02-20 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2002-02-20 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2002-02-20 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-02-20 Gregorian' );
cmp_ok( $dts->day(), '==', 29, 'day() on 2002-02-20 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-02-20 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-02-20 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 29 Solmath 7466', 'as_string() on 2002-02-20 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-02-20 Gregorian' );
Trewsday 29 Solmath 7466

Meriodoc and Pippin escape and meet Treebeard, 1419.
The Rohirrim attack at sunrise and destroy the Orcs, 1419.
Frodo descends from the Emyn Muil and meets Gollum, 1419.
Faramir sees the funeral boat of Boromir, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 21, 1, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-02-21 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2002-02-21 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2002-02-21 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Solmath', 'month() on 2002-02-21 Gregorian' );
cmp_ok( $dts->day(), '==', 30, 'day() on 2002-02-21 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-02-21 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-02-21 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 30 Solmath 7466', 'as_string() on 2002-02-21 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-02-21 Gregorian' );
Hevensday 30 Solmath 7466

Entmoot begins, 1419.
Eomer, returning to Edoras, meets Aragorn, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 22, 1, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-02-22 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2002-02-22 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2002-02-22 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2002-02-22 Gregorian' );
cmp_ok( $dts->day(), '==', 1, 'day() on 2002-02-22 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-02-22 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-02-22 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 1 Rethe 7466', 'as_string() on 2002-02-22 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-02-22 Gregorian' );
Mersday 1 Rethe 7466

Aragorn meets Gandalf the White, and they set out for Edoras, 1419.
Faramir leaves Minas Tirith on an errand to Ithilien, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 23, 1, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-02-23 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2002-02-23 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2002-02-23 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2002-02-23 Gregorian' );
cmp_ok( $dts->day(), '==', 2, 'day() on 2002-02-23 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-02-23 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-02-23 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 2 Rethe 7466', 'as_string() on 2002-02-23 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-02-23 Gregorian' );
Highday 2 Rethe 7466

The Rohirrim ride west against Saruman, 1419.
Second battle at the Fords of Isen; Erkenbrand defeated, 1419.
Entmoot ends.  Ents march on Isengard and reach it at night, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 24, 1, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-02-24 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2002-02-24 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_weekday() on 2002-02-24 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2002-02-24 Gregorian' );
cmp_ok( $dts->day(), '==', 3, 'day() on 2002-02-24 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-02-24 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-02-24 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sterday 3 Rethe 7466', 'as_string() on 2002-02-24 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-02-24 Gregorian' );
Sterday 3 Rethe 7466

Theoden retreats to Helm's Deep; battle of the Hornburg begins, 1419.
Ents complete the destruction of Isengard.
EOT

$epoch = timelocal( 0, 0, 0, 25, 1, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-02-25 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sunday', 'weekday() on 2002-02-25 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sunnendei', 'trad_weekday() on 2002-02-25 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2002-02-25 Gregorian' );
cmp_ok( $dts->day(), '==', 4, 'day() on 2002-02-25 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-02-25 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-02-25 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Sunday 4 Rethe 7466', 'as_string() on 2002-02-25 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-02-25 Gregorian' );
Sunday 4 Rethe 7466

Theoden and Gandalf set out from Helm's Deep for Isengard, 1419.
Frodo reaches the slag mound on the edge of the of the Morannon, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 26, 1, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-02-26 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Monday', 'weekday() on 2002-02-26 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Monendei', 'trad_weekday() on 2002-02-26 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2002-02-26 Gregorian' );
cmp_ok( $dts->day(), '==', 5, 'day() on 2002-02-26 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-02-26 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-02-26 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Monday 5 Rethe 7466', 'as_string() on 2002-02-26 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-02-26 Gregorian' );
Monday 5 Rethe 7466

Theoden reaches Isengard at noon; parley with Saruman in Orthanc, 1419.
Gandalf sets out with Peregrin for Minas Tirith, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 27, 1, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-02-27 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Trewsday', 'weekday() on 2002-02-27 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Trewesdei', 'trad_weekday() on 2002-02-27 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2002-02-27 Gregorian' );
cmp_ok( $dts->day(), '==', 6, 'day() on 2002-02-27 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-02-27 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-02-27 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Trewsday 6 Rethe 7466', 'as_string() on 2002-02-27 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-02-27 Gregorian' );
Trewsday 6 Rethe 7466

Aragorn overtaken by the Dunedain in the early hours, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 28, 1, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-02-28 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Hevensday', 'weekday() on 2002-02-28 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Hevenesdei', 'trad_weekday() on 2002-02-28 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2002-02-28 Gregorian' );
cmp_ok( $dts->day(), '==', 7, 'day() on 2002-02-28 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-02-28 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-02-28 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Hevensday 7 Rethe 7466', 'as_string() on 2002-02-28 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-02-28 Gregorian' );
Hevensday 7 Rethe 7466

Frodo taken by Faramir to Henneth Annun, 1419.
Aragorn comes to Dunharrow at nightfall, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 1, 2, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-03-01 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Mersday', 'weekday() on 2002-03-01 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Meresdei', 'trad_weekday() on 2002-03-01 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2002-03-01 Gregorian' );
cmp_ok( $dts->day(), '==', 8, 'day() on 2002-03-01 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-03-01 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-03-01 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Mersday 8 Rethe 7466', 'as_string() on 2002-03-01 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-03-01 Gregorian' );
Mersday 8 Rethe 7466

Aragorn takes the "Paths of the Dead", and reaches Erech at midnight, 1419.
Frodo leaves Henneth Annun, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 2, 2, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-03-02 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Highday', 'weekday() on 2002-03-02 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Highdei', 'trad_weekday() on 2002-03-02 Gregorian' );
cmp_ok( $dts->month(), 'eq', 'Rethe', 'month() on 2002-03-02 Gregorian' );
cmp_ok( $dts->day(), '==', 9, 'day() on 2002-03-02 Gregorian' );
cmp_ok( $dts->holiday(), 'eq', '', 'holiday() on 2002-03-02 Gregorian' );
cmp_ok( $dts->year(), '==', 7466, 'year() on 2002-03-02 Gregorian' );
cmp_ok( $dts->as_string(), 'eq', 'Highday 9 Rethe 7466', 'as_string() on 2002-03-02 Gregorian' );
cmp_ok( $dts->on_date(), 'eq', <<'EOT', 'on_date() on 2002-03-02 Gregorian' );
Highday 9 Rethe 7466

Gandalf reaches Minas Tirith, 1419.
Darkness begins to flow out of Mordor, 1419.
EOT

$epoch = timelocal( 0, 0, 0, 3, 2, 2002 );
$dts = Date::Tolkien::Shire->new( $epoch );
cmp_ok( $dts->time_in_seconds(), '==', $epoch, 'epoch() on 2002-03-03 Gregorian' );
cmp_ok( $dts->weekday(), 'eq', 'Sterday', 'weekday() on 2002-03-03 Gregorian' );
cmp_ok( $dts->trad_weekday(), 'eq', 'Sterrendei', 'trad_we