package Chart::Plotly::Trace::Heatmapgl;
use Moose;

our $VERSION = '0.004';    # VERSION

=encoding utf-8

=head1 NAME 

Chart::Plotly::Trace::Heatmapgl

=head1 SYNOPSIS

	use HTML::Show;
	use Chart::Plotly;
	use Chart::Plotly::Trace::Heatmapgl;
	my $heatmapgl = Chart::Plotly::Trace::Heatmapgl->new(x => [1 .. 5], y => [1 .. 5]);
	
	HTML::Show::show(Chart::Plotly::render_full_html(data => [$heatmapgl]));


=head1 DESCRIPTION

This file has been autogenerated from the official plotly.js source.

If you like Plotly, please support them: L<https://plot.ly/> 
Open source announcement: L<https://plot.ly/javascript/open-source-announcement/>

Full reference: L<https://plot.ly/javascript/reference/#heatmapgl>

=head1 DISCLAIMER

This is an unofficial Plotly Perl module. Currently I'm not affiliated in any way with Plotly. 
But I think plotly.js is a great library and I want to use it with perl.

=head1 METHODS

=cut

=head2 TO_JSON

Serialize the trace to JSON. This method should be called only by L<JSON> serializer.

=cut

sub TO_JSON {
    my $self = shift;
    my %hash = %$self;
    $hash{type} = $self->type();
    return \%hash;
}

=head2 type

Trace type.

=cut

sub type {
    my @components = split( /::/, __PACKAGE__ );
    return lc( $components[-1] );
}

=head1 ATTRIBUTES

=over

=cut

=item * ids

A list of keys for object constancy of data points during animation

=cut

has ids => ( is            => 'rw',
             documentation => "A list of keys for object constancy of data points during animation", );

=item * y

Sets the y coordinates.

=cut

has y => ( is            => 'rw',
           documentation => "Sets the y coordinates.", );

=item * dy

Sets the y coordinate step. See `y0` for more info.

=cut

has dy => ( is            => 'rw',
            documentation => "Sets the y coordinate step. See `y0` for more info.", );

=item * text

Sets text elements associated with each (x,y) pair. If a single string, the same string appears over all the data points. If an array of string, the items are mapped in order to the this trace's (x,y) coordinates.

=cut

has text => (
    is => 'rw',
    documentation =>
      "Sets text elements associated with each (x,y) pair. If a single string, the same string appears over all the data points. If an array of string, the items are mapped in order to the this trace's (x,y) coordinates.",
);

=item * t

For polar chart only.Sets the angular coordinates.

=cut

has t => ( is            => 'rw',
           documentation => "For polar chart only.Sets the angular coordinates.", );

=item * x

Sets the x coordinates.

=cut

has x => ( is            => 'rw',
           documentation => "Sets the x coordinates.", );

=item * hoveron

Do the hover effects highlight individual points (markers or line points) or do they highlight filled regions? If the fill is *toself* or *tonext* and there are no markers or text, then the default is *fills*, otherwise it is *points*.

=cut

has hoveron => (
    is => 'rw',
    documentation =>
      "Do the hover effects highlight individual points (markers or line points) or do they highlight filled regions? If the fill is *toself* or *tonext* and there are no markers or text, then the default is *fills*, otherwise it is *points*.",
);

=item * fillcolor

Sets the fill color. Defaults to a half-transparent variant of the line color, marker color, or marker line color, whichever is available.

=cut

has fillcolor => (
    is => 'rw',
    documentation =>
      "Sets the fill color. Defaults to a half-transparent variant of the line color, marker color, or marker line color, whichever is available.",
);

=item * fill

Sets the area to fill with a solid color. Use with `fillcolor` if not *none*. *tozerox* and *tozeroy* fill to x=0 and y=0 respectively. *tonextx* and *tonexty* fill between the endpoints of this trace and the endpoints of the trace before it, connecting those endpoints with straight lines (to make a stacked area graph); if there is no trace before it, they behave like *tozerox* and *tozeroy*. *toself* connects the endpoints of the trace (or each segment of the trace if it has gaps) into a closed shape. *tonext* fills the space between two traces if one completely encloses the other (eg consecutive contour lines), and behaves like *toself* if there is no trace before it. *tonext* should not be used if one trace does not enclose the other.

=cut

has fill => (
    is => 'rw',
    documentation =>
      "Sets the area to fill with a solid color. Use with `fillcolor` if not *none*. *tozerox* and *tozeroy* fill to x=0 and y=0 respectively. *tonextx* and *tonexty* fill between the endpoints of this trace and the endpoints of the trace before it, connecting those endpoints with straight lines (to make a stacked area graph); if there is no trace before it, they behave like *tozerox* and *tozeroy*. *toself* connects the endpoints of the trace (or each segment of the trace if it has gaps) into a closed shape. *tonext* fills the space between two traces if one completely encloses the other (eg consecutive contour lines), and behaves like *toself* if there is no trace before it. *tonext* should not be used if one trace does not enclose the other.",
);

=item * textposition

Sets the positions of the `text` elements with respects to the (x,y) coordinates.

=cut

has textposition => (
                   is            => 'rw',
                   documentation => "Sets the positions of the `text` elements with respects to the (x,y) coordinates.",
);

=item * connectgaps

Determines whether or not gaps (i.e. {nan} or missing values) in the provided data arrays are connected.

=cut

has connectgaps => (
           is => 'rw',
           documentation =>
             "Determines whether or not gaps (i.e. {nan} or missing values) in the provided data arrays are connected.",
);

=item * r

For polar chart only.Sets the radial coordinates.

=cut

has r => ( is            => 'rw',
           documentation => "For polar chart only.Sets the radial coordinates.", );

=item * mode

Determines the drawing mode for this scatter trace. If the provided `mode` includes *text* then the `text` elements appear at the coordinates. Otherwise, the `text` elements appear on hover. If there are less than 20 points, then the default is *lines+markers*. Otherwise, *lines*.

=cut

has mode => (
    is => 'rw',
    documentation =>
      "Determines the drawing mode for this scatter trace. If the provided `mode` includes *text* then the `text` elements appear at the coordinates. Otherwise, the `text` elements appear on hover. If there are less than 20 points, then the default is *lines+markers*. Otherwise, *lines*.",
);

=item * y0

Alternate to `y`. Builds a linear space of y coordinates. Use with `dy` where `y0` is the starting coordinate and `dy` the step.

=cut

has y0 => (
    is => 'rw',
    documentation =>
      "Alternate to `y`. Builds a linear space of y coordinates. Use with `dy` where `y0` is the starting coordinate and `dy` the step.",
);

=item * _nestedModules


=cut

has _nestedModules => ( is => 'rw', );

=item * line


=cut

has line => ( is => 'rw', );

=item * textfont

Sets the text font.

=cut

has textfont => ( is            => 'rw',
                  documentation => "Sets the text font.", );

=item * x0

Alternate to `x`. Builds a linear space of x coordinates. Use with `dx` where `x0` is the starting coordinate and `dx` the step.

=cut

has x0 => (
    is => 'rw',
    documentation =>
      "Alternate to `x`. Builds a linear space of x coordinates. Use with `dx` where `x0` is the starting coordinate and `dx` the step.",
);

=item * marker


=cut

has marker => ( is => 'rw', );

=item * dx

Sets the x coordinate step. See `x0` for more info.

=cut

has dx => ( is            => 'rw',
            documentation => "Sets the x coordinate step. See `x0` for more info.", );

=pod

=back

=cut

__PACKAGE__->meta->make_immutable();
1;
