package Chart::Plotly::Trace::Attribute::Lighting;
use Moose;

our $VERSION = '0.008';    # VERSION

sub TO_JSON {
    my $self = shift;
    my %hash = %$self;
    if ( $self->can('type') && ( !defined $hash{'type'} ) ) {
        $hash{type} = $self->type();
    }
    return \%hash;
}

has ambient => ( is            => 'rw',
                 isa           => "Num",
                 documentation => "Ambient light increases overall color visibility but can wash out the image.",
);

has diffuse => ( is            => 'rw',
                 isa           => "Num",
                 documentation => "Represents the extent that incident rays are reflected in a range of angles.",
);

has fresnel => (
    is  => 'rw',
    isa => "Num",
    documentation =>
      "Represents the reflectance as a dependency of the viewing angle; e.g. paper is reflective when viewing it from the edge of the paper (almost 90 degrees), causing shine.",
);

has roughness => (
        is            => 'rw',
        isa           => "Num",
        documentation => "Alters specular reflection; the rougher the surface, the wider and less contrasty the shine.",
);

has specular => (
         is            => 'rw',
         isa           => "Num",
         documentation => "Represents the level that incident rays are reflected in a single direction, causing shine.",
);

has name => ( is            => 'rw',
              isa           => "Str",
              documentation => "Sets the trace name",
);

__PACKAGE__->meta->make_immutable();
1;

__END__

=pod

=encoding utf-8

=head1 NAME

Chart::Plotly::Trace::Attribute::Lighting

=head1 VERSION

version 0.008

=head1 SYNOPSIS

	use HTML::Show;
	use Chart::Plotly;
	use Chart::Plotly::Trace::Attribute::Lighting;
	my $lighting = Chart::Plotly::Trace::Attribute::Lighting->new(x => [1 .. 5], y => [1 .. 5]);
	
	HTML::Show::show(Chart::Plotly::render_full_html(data => [$lighting]));

=head1 DESCRIPTION

This file has been autogenerated from the official plotly.js source.

If you like Plotly, please support them: L<https://plot.ly/> 
Open source announcement: L<https://plot.ly/javascript/open-source-announcement/>

Full reference: L<https://plot.ly/javascript/reference/#lighting>

=head1 NAME 

Chart::Plotly::Trace::Attribute::Lighting

=head1 DISCLAIMER

This is an unofficial Plotly Perl module. Currently I'm not affiliated in any way with Plotly. 
But I think plotly.js is a great library and I want to use it with perl.

=head1 METHODS

=head2 TO_JSON

Serialize the trace to JSON. This method should be called only by L<JSON> serializer.

=head1 ATTRIBUTES

=over

=item * ambient

Ambient light increases overall color visibility but can wash out the image.

=item * diffuse

Represents the extent that incident rays are reflected in a range of angles.

=item * fresnel

Represents the reflectance as a dependency of the viewing angle; e.g. paper is reflective when viewing it from the edge of the paper (almost 90 degrees), causing shine.

=item * roughness

Alters specular reflection; the rougher the surface, the wider and less contrasty the shine.

=item * specular

Represents the level that incident rays are reflected in a single direction, causing shine.

=item * name

Sets the trace name

=back

=head1 AUTHOR

Pablo Rodríguez González <pablo.rodriguez.gonzalez@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2016 by Pablo Rodríguez González.

This is free software, licensed under:

  The MIT (X11) License

=cut
