
package Paws::ApiGateway::UpdateDeployment;
  use Moose;
  has DeploymentId => (is => 'ro', isa => 'Str', traits => ['ParamInURI'], uri_name => 'deployment_id', required => 1);
  has PatchOperations => (is => 'ro', isa => 'ArrayRef[Paws::ApiGateway::PatchOperation]', traits => ['NameInRequest'], request_name => 'patchOperations');
  has RestApiId => (is => 'ro', isa => 'Str', traits => ['ParamInURI'], uri_name => 'restapi_id', required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'UpdateDeployment');
  class_has _api_uri  => (isa => 'Str', is => 'ro', default => '/restapis/{restapi_id}/deployments/{deployment_id}');
  class_has _api_method  => (isa => 'Str', is => 'ro', default => 'PATCH');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::ApiGateway::Deployment');
1;

### main pod documentation begin ###

=head1 NAME

Paws::ApiGateway::UpdateDeployment - Arguments for method UpdateDeployment on L<Paws::ApiGateway>

=head1 DESCRIPTION

This class represents the parameters used for calling the method UpdateDeployment on the
L<Amazon API Gateway|Paws::ApiGateway> service. Use the attributes of this class
as arguments to method UpdateDeployment.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to UpdateDeployment.

=head1 SYNOPSIS

    my $apigateway = Paws->service('ApiGateway');
    my $Deployment = $apigateway->UpdateDeployment(
      DeploymentId    => 'MyString',
      RestApiId       => 'MyString',
      PatchOperations => [
        {
          from => 'MyString',
          op =>
            'add',    # values: add, remove, replace, move, copy, test; OPTIONAL
          path  => 'MyString',
          value => 'MyString',
        },
        ...
      ],              # OPTIONAL
    );

    # Results:
    my $ApiSummary  = $Deployment->ApiSummary;
    my $CreatedDate = $Deployment->CreatedDate;
    my $Description = $Deployment->Description;
    my $Id          = $Deployment->Id;

    # Returns a L<Paws::ApiGateway::Deployment> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://aws.amazon.com/documentation/apigateway/>

=head1 ATTRIBUTES


=head2 B<REQUIRED> DeploymentId => Str

The replacement identifier for the Deployment resource to change
information about.



=head2 PatchOperations => ArrayRef[L<Paws::ApiGateway::PatchOperation>]

A list of update operations to be applied to the specified resource and
in the order specified in this list.



=head2 B<REQUIRED> RestApiId => Str

[Required] The string identifier of the associated RestApi.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method UpdateDeployment in L<Paws::ApiGateway>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

