#########################################################################################
# Package        HiPi::Interface::MonoOLED::Font::Serif21
# Description  : Monochrome OLED Font
# License      : This is free software; you can redistribute it and/or modify it under
#                the same terms as the Perl 5 programming language system itself.
#########################################################################################

package HiPi::Interface::MonoOLED::Font::Serif21;

#########################################################################################

use utf8;
use strict;
use warnings;
use parent qw( HiPi::Interface::MonoOLED::Font);

our $VERSION ='0.70';

my $gap_width = 0;
my $char_height = 21;
my $line_spacing = 2;
my $name = 'Serif 21';
my $space_width = 6;
 
my $symbols = {
    '33' => {    # '!'
        'width'    => 2, 
        'xoffset'  => 3, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x00, ##    
            0x00, ##    
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '34' => {    # '"'
        'width'    => 5, 
        'xoffset'  => 2, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xD8, ##  00 00
            0xD8, ##  00 00
            0xD8, ##  00 00
            0xD8, ##  00 00
            0xD8, ##  00 00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '35' => {    # '#'
        'width'    => 14, 
        'xoffset'  => 2, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x02, 0x30, ##        0   00  
            0x06, 0x30, ##       00   00  
            0x06, 0x20, ##       00   0   
            0x06, 0x60, ##       00  00   
            0x7F, 0xFC, ##   0000000000000
            0x0C, 0x60, ##      00   00   
            0x0C, 0x40, ##      00   0    
            0x0C, 0xC0, ##      00  00    
            0x08, 0xC0, ##      0   00    
            0x18, 0xC0, ##     00   00    
            0xFF, 0xF8, ##  0000000000000 
            0x18, 0x80, ##     00   0     
            0x11, 0x80, ##     0   00     
            0x31, 0x80, ##    00   00     
            0x31, 0x00, ##    00   0      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '36' => {    # '$'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0x3E, 0x00, ##    00000  
            0x6B, 0x00, ##   00 0 00 
            0xC9, 0x00, ##  00  0  0 
            0xC9, 0x00, ##  00  0  0 
            0xE8, 0x00, ##  000 0    
            0x78, 0x00, ##   0000    
            0x3E, 0x00, ##    00000  
            0x0F, 0x80, ##      00000
            0x09, 0x80, ##      0  00
            0x89, 0x80, ##  0   0  00
            0x89, 0x80, ##  0   0  00
            0xCB, 0x00, ##  00  0 00 
            0x7E, 0x00, ##   000000  
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0x00, 0x00, ##  
        ], 
    }, 
    '37' => {    # '%'
        'width'    => 17, 
        'xoffset'  => 1, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x38, 0x08, 0x00, ##    000       0    
            0x6C, 0x08, 0x00, ##   00 00      0    
            0xC6, 0x10, 0x00, ##  00   00    0     
            0xC6, 0x30, 0x00, ##  00   00   00     
            0xC6, 0x20, 0x00, ##  00   00   0      
            0xC6, 0x40, 0x00, ##  00   00  0       
            0x6C, 0xC0, 0x00, ##   00 00  00       
            0x38, 0x8E, 0x00, ##    000   0   000  
            0x01, 0x9B, 0x00, ##         00  00 00 
            0x01, 0x31, 0x80, ##         0  00   00
            0x02, 0x31, 0x80, ##        0   00   00
            0x06, 0x31, 0x80, ##       00   00   00
            0x04, 0x31, 0x80, ##       0    00   00
            0x08, 0x1B, 0x00, ##      0      00 00 
            0x08, 0x0E, 0x00, ##      0       000  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '38' => {    # '&'
        'width'    => 16, 
        'xoffset'  => 1, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0x80, ##      00000       
            0x38, 0x80, ##    000   0       
            0x30, 0x80, ##    00    0       
            0x30, 0x00, ##    00            
            0x38, 0x00, ##    000           
            0x18, 0x00, ##     00           
            0x2C, 0x3E, ##    0 00    00000 
            0x66, 0x08, ##   00  00     0   
            0xC3, 0x08, ##  00    00    0   
            0xC1, 0x98, ##  00     00  00   
            0xC0, 0xD0, ##  00      00 0    
            0xC0, 0x70, ##  00       000    
            0x60, 0x70, ##   00      000    
            0x70, 0xF8, ##   000    00000   
            0x1F, 0x1F, ##     00000   00000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '39' => {    # '''
        'width'    => 2, 
        'xoffset'  => 2, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '40' => {    # '('
        'width'    => 5, 
        'xoffset'  => 2, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##       
            0x18, ##     00
            0x30, ##    00 
            0x60, ##   00  
            0x60, ##   00  
            0x40, ##   0   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0x40, ##   0   
            0x60, ##   00  
            0x20, ##    0  
            0x10, ##     0 
            0x08, ##      0
            0x00, ##  
        ], 
    }, 
    '41' => {    # ')'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##       
            0xC0, ##  00   
            0x60, ##   00  
            0x30, ##    00 
            0x30, ##    00 
            0x10, ##     0 
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x30, ##    00 
            0x30, ##    00 
            0x20, ##    0  
            0x40, ##   0   
            0x80, ##  0    
            0x00, ##  
        ], 
    }, 
    '42' => {    # '*'
        'width'    => 9, 
        'xoffset'  => 0, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0xC9, 0x80, ##  00  0  00
            0x3E, 0x00, ##    00000  
            0x08, 0x00, ##      0    
            0x3E, 0x00, ##    00000  
            0xC9, 0x80, ##  00  0  00
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '43' => {    # '+'
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0xFF, 0xF8, ##  0000000000000
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '44' => {    # ','
        'width'    => 4, 
        'xoffset'  => 0, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x60, ##   00 
            0xC0, ##  00  
            0x00, ##  
        ], 
    }, 
    '45' => {    # '-'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '46' => {    # '.'
        'width'    => 2, 
        'xoffset'  => 2, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '47' => {    # '/'
        'width'    => 7, 
        'xoffset'  => 0, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x06, ##       00
            0x04, ##       0 
            0x0C, ##      00 
            0x0C, ##      00 
            0x08, ##      0  
            0x18, ##     00  
            0x18, ##     00  
            0x10, ##     0   
            0x10, ##     0   
            0x30, ##    00   
            0x30, ##    00   
            0x20, ##    0    
            0x60, ##   00    
            0x60, ##   00    
            0x40, ##   0     
            0xC0, ##  00     
            0xC0, ##  00     
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '48' => {    # '0'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1E, 0x00, ##     0000   
            0x33, 0x00, ##    00  00  
            0x61, 0x80, ##   00    00 
            0x40, 0x80, ##   0      0 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0x40, 0x80, ##   0      0 
            0x61, 0x80, ##   00    00 
            0x33, 0x00, ##    00  00  
            0x1E, 0x00, ##     0000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '49' => {    # '1'
        'width'    => 7, 
        'xoffset'  => 3, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x18, ##     00  
            0x78, ##   0000  
            0xD8, ##  00 00  
            0x18, ##     00  
            0x18, ##     00  
            0x18, ##     00  
            0x18, ##     00  
            0x18, ##     00  
            0x18, ##     00  
            0x18, ##     00  
            0x18, ##     00  
            0x18, ##     00  
            0x18, ##     00  
            0x18, ##     00  
            0xFE, ##  0000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '50' => {    # '2'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3E, 0x00, ##    00000  
            0xC3, 0x00, ##  00    00 
            0x81, 0x80, ##  0      00
            0x81, 0x80, ##  0      00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x01, 0x00, ##         0 
            0x03, 0x00, ##        00 
            0x06, 0x00, ##       00  
            0x04, 0x00, ##       0   
            0x08, 0x00, ##      0    
            0x10, 0x00, ##     0     
            0x20, 0x80, ##    0     0
            0x60, 0x80, ##   00     0
            0xFF, 0x80, ##  000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '51' => {    # '3'
        'width'    => 10, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3E, 0x00, ##    00000   
            0xC3, 0x00, ##  00    00  
            0xC1, 0x80, ##  00     00 
            0x01, 0x80, ##         00 
            0x01, 0x80, ##         00 
            0x03, 0x00, ##        00  
            0x1C, 0x00, ##     000    
            0x03, 0x80, ##        000 
            0x01, 0x80, ##         00 
            0x00, 0xC0, ##          00
            0x00, 0xC0, ##          00
            0x80, 0xC0, ##  0       00
            0x80, 0xC0, ##  0       00
            0xC1, 0x80, ##  00     00 
            0x7E, 0x00, ##   000000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '52' => {    # '4'
        'width'    => 11, 
        'xoffset'  => 1, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0x00, ##        00   
            0x07, 0x00, ##       000   
            0x0F, 0x00, ##      0000   
            0x0B, 0x00, ##      0 00   
            0x1B, 0x00, ##     00 00   
            0x13, 0x00, ##     0  00   
            0x23, 0x00, ##    0   00   
            0x63, 0x00, ##   00   00   
            0x43, 0x00, ##   0    00   
            0xC3, 0x00, ##  00    00   
            0xFF, 0xE0, ##  00000000000
            0x03, 0x00, ##        00   
            0x03, 0x00, ##        00   
            0x03, 0x00, ##        00   
            0x0F, 0xE0, ##      0000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '53' => {    # '5'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x7F, 0x00, ##   0000000 
            0x40, 0x00, ##   0       
            0x40, 0x00, ##   0       
            0x40, 0x00, ##   0       
            0x40, 0x00, ##   0       
            0x7E, 0x00, ##   000000  
            0x43, 0x00, ##   0    00 
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x81, 0x80, ##  0      00
            0x83, 0x80, ##  0     000
            0xC3, 0x00, ##  00    00 
            0x7C, 0x00, ##   00000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '54' => {    # '6'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0x80, ##      00000 
            0x31, 0x80, ##    00   00 
            0x60, 0x80, ##   00     0 
            0x40, 0x00, ##   0        
            0xC0, 0x00, ##  00        
            0xDF, 0x00, ##  00 00000  
            0xF1, 0x80, ##  0000   00 
            0xE0, 0x80, ##  000     0 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xE0, 0xC0, ##  000     00
            0x60, 0x80, ##   00     0 
            0x31, 0x80, ##    00   00 
            0x1E, 0x00, ##     0000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '55' => {    # '7'
        'width'    => 10, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xC0, ##  0000000000
            0x80, 0x80, ##  0       0 
            0x81, 0x80, ##  0      00 
            0x01, 0x00, ##         0  
            0x03, 0x00, ##        00  
            0x03, 0x00, ##        00  
            0x02, 0x00, ##        0   
            0x06, 0x00, ##       00   
            0x04, 0x00, ##       0    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x08, 0x00, ##      0     
            0x18, 0x00, ##     00     
            0x10, 0x00, ##     0      
            0x30, 0x00, ##    00      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '56' => {    # '8'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3F, 0x00, ##    000000  
            0x61, 0x80, ##   00    00 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0x61, 0xC0, ##   00    000
            0x1F, 0x00, ##     00000  
            0x61, 0x00, ##   00    0  
            0xC0, 0x80, ##  00      0 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0x61, 0x80, ##   00    00 
            0x3F, 0x00, ##    000000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '57' => {    # '9'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3E, 0x00, ##    00000   
            0x61, 0x00, ##   00    0  
            0xC1, 0x80, ##  00     00 
            0xC0, 0x80, ##  00      0 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC1, 0xC0, ##  00     000
            0x61, 0xC0, ##   00    000
            0x3E, 0xC0, ##    00000 00
            0x00, 0xC0, ##          00
            0x00, 0xC0, ##          00
            0x00, 0x80, ##          0 
            0x41, 0x80, ##   0     00 
            0x63, 0x00, ##   00   00  
            0x7E, 0x00, ##   000000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '58' => {    # ':'
        'width'    => 2, 
        'xoffset'  => 2, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '59' => {    # ';'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x60, ##   00
            0x60, ##   00
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0xC0, ##  00 
            0x80, ##  0  
            0x00, ##  
        ], 
    }, 
    '60' => {    # '<'
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x18, ##             00
            0x00, 0x78, ##           0000
            0x03, 0xC0, ##        0000   
            0x1F, 0x00, ##     00000     
            0x78, 0x00, ##   0000        
            0xE0, 0x00, ##  000          
            0xF8, 0x00, ##  00000        
            0x1F, 0x00, ##     00000     
            0x03, 0xC0, ##        0000   
            0x00, 0xF8, ##          00000
            0x00, 0x18, ##             00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '61' => {    # '='
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xF8, ##  0000000000000
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0xFF, 0xF8, ##  0000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '62' => {    # '>'
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x80, 0x00, ##  0            
            0xF0, 0x00, ##  0000         
            0x3E, 0x00, ##    00000      
            0x07, 0x80, ##       0000    
            0x01, 0xF0, ##         00000 
            0x00, 0x38, ##            000
            0x00, 0xF0, ##          0000 
            0x07, 0xC0, ##       00000   
            0x3E, 0x00, ##    00000      
            0xF0, 0x00, ##  0000         
            0x80, 0x00, ##  0            
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '63' => {    # '?'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x7C, ##   00000  
            0xC6, ##  00   00 
            0x83, ##  0     00
            0x83, ##  0     00
            0x03, ##        00
            0x03, ##        00
            0x06, ##       00 
            0x0E, ##      000 
            0x18, ##     00   
            0x10, ##     0    
            0x10, ##     0    
            0x00, ##          
            0x00, ##          
            0x30, ##    00    
            0x30, ##    00    
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '64' => {    # '@'
        'width'    => 17, 
        'xoffset'  => 1, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x03, 0xF0, 0x00, ##        000000     
            0x0E, 0x0C, 0x00, ##      000     00   
            0x18, 0x02, 0x00, ##     00         0  
            0x30, 0x01, 0x00, ##    00           0 
            0x60, 0x19, 0x00, ##   00        00  0 
            0x63, 0xD8, 0x80, ##   00   0000 00   0
            0xC6, 0x38, 0x80, ##  00   00   000   0
            0xCC, 0x18, 0x80, ##  00  00     00   0
            0xCC, 0x18, 0x80, ##  00  00     00   0
            0xCC, 0x18, 0x80, ##  00  00     00   0
            0xCC, 0x19, 0x00, ##  00  00     00  0 
            0xC6, 0x3A, 0x00, ##  00   00   000 0  
            0x63, 0xDC, 0x00, ##   00   0000 000   
            0x60, 0x00, 0x00, ##   00              
            0x30, 0x00, 0x00, ##    00             
            0x18, 0x04, 0x00, ##     00        0   
            0x0E, 0x0C, 0x00, ##      000     00   
            0x03, 0xF0, 0x00, ##        000000     
        ], 
    }, 
    '65' => {    # 'A'
        'width'    => 15, 
        'xoffset'  => 0, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0x80, ##        000      
            0x03, 0x80, ##        000      
            0x03, 0x80, ##        000      
            0x07, 0xC0, ##       00000     
            0x04, 0xC0, ##       0  00     
            0x04, 0xE0, ##       0  000    
            0x08, 0x60, ##      0    00    
            0x08, 0x60, ##      0    00    
            0x18, 0x70, ##     00    000   
            0x10, 0x30, ##     0      00   
            0x1F, 0xF0, ##     000000000   
            0x20, 0x18, ##    0        00  
            0x20, 0x18, ##    0        00  
            0x60, 0x18, ##   00        00  
            0xF0, 0x3E, ##  0000      00000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '66' => {    # 'B'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xC0, ##  0000000000  
            0x30, 0x60, ##    00     00 
            0x30, 0x30, ##    00      00
            0x30, 0x30, ##    00      00
            0x30, 0x30, ##    00      00
            0x30, 0x60, ##    00     00 
            0x3F, 0x80, ##    0000000   
            0x30, 0x60, ##    00     00 
            0x30, 0x30, ##    00      00
            0x30, 0x30, ##    00      00
            0x30, 0x30, ##    00      00
            0x30, 0x30, ##    00      00
            0x30, 0x30, ##    00      00
            0x30, 0x60, ##    00     00 
            0xFF, 0xC0, ##  0000000000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '67' => {    # 'C'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0xC0, ##      000000   
            0x18, 0x78, ##     00    0000
            0x20, 0x38, ##    0       000
            0x60, 0x18, ##   00        00
            0xC0, 0x18, ##  00         00
            0xC0, 0x00, ##  00           
            0xC0, 0x00, ##  00           
            0xC0, 0x00, ##  00           
            0xC0, 0x00, ##  00           
            0xC0, 0x00, ##  00           
            0xC0, 0x00, ##  00           
            0x60, 0x18, ##   00        00
            0x20, 0x30, ##    0       00 
            0x18, 0x60, ##     00    00  
            0x0F, 0xC0, ##      000000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '68' => {    # 'D'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x80, ##  000000000     
            0x30, 0x60, ##    00     00   
            0x30, 0x30, ##    00      00  
            0x30, 0x18, ##    00       00 
            0x30, 0x0C, ##    00        00
            0x30, 0x0C, ##    00        00
            0x30, 0x0C, ##    00        00
            0x30, 0x0C, ##    00        00
            0x30, 0x0C, ##    00        00
            0x30, 0x0C, ##    00        00
            0x30, 0x1C, ##    00       000
            0x30, 0x18, ##    00       00 
            0x30, 0x30, ##    00      00  
            0x30, 0x60, ##    00     00   
            0xFF, 0x80, ##  000000000     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '69' => {    # 'E'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xF0, ##  000000000000
            0x30, 0x10, ##    00       0
            0x30, 0x10, ##    00       0
            0x30, 0x00, ##    00        
            0x30, 0x40, ##    00     0  
            0x30, 0x40, ##    00     0  
            0x3F, 0xC0, ##    00000000  
            0x30, 0x40, ##    00     0  
            0x30, 0x40, ##    00     0  
            0x30, 0x00, ##    00        
            0x30, 0x00, ##    00        
            0x30, 0x00, ##    00        
            0x30, 0x10, ##    00       0
            0x30, 0x10, ##    00       0
            0xFF, 0xF0, ##  000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '70' => {    # 'F'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xF0, ##  000000000000
            0x30, 0x10, ##    00       0
            0x30, 0x10, ##    00       0
            0x30, 0x00, ##    00        
            0x30, 0x40, ##    00     0  
            0x30, 0x40, ##    00     0  
            0x3F, 0xC0, ##    00000000  
            0x30, 0x40, ##    00     0  
            0x30, 0x40, ##    00     0  
            0x30, 0x00, ##    00        
            0x30, 0x00, ##    00        
            0x30, 0x00, ##    00        
            0x30, 0x00, ##    00        
            0x30, 0x00, ##    00        
            0xFC, 0x00, ##  000000      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '71' => {    # 'G'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0xE0, ##      0000000  
            0x18, 0x70, ##     00    000 
            0x20, 0x10, ##    0        0 
            0x60, 0x10, ##   00        0 
            0xC0, 0x10, ##  00         0 
            0xC0, 0x00, ##  00           
            0xC0, 0x00, ##  00           
            0xC0, 0x00, ##  00           
            0xC0, 0xF8, ##  00      00000
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0x60, 0x18, ##   00        00
            0x20, 0x18, ##    0        00
            0x18, 0x38, ##     00     000
            0x0F, 0xE0, ##      0000000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '72' => {    # 'H'
        'width'    => 15, 
        'xoffset'  => 1, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFC, 0x7E, ##  000000   000000
            0x30, 0x18, ##    00       00  
            0x30, 0x18, ##    00       00  
            0x30, 0x18, ##    00       00  
            0x30, 0x18, ##    00       00  
            0x30, 0x18, ##    00       00  
            0x3F, 0xF8, ##    00000000000  
            0x30, 0x18, ##    00       00  
            0x30, 0x18, ##    00       00  
            0x30, 0x18, ##    00       00  
            0x30, 0x18, ##    00       00  
            0x30, 0x18, ##    00       00  
            0x30, 0x18, ##    00       00  
            0x30, 0x18, ##    00       00  
            0xFC, 0x7E, ##  000000   000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '73' => {    # 'I'
        'width'    => 6, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xFC, ##  000000
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0xFC, ##  000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '74' => {    # 'J'
        'width'    => 9, 
        'xoffset'  => -2, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x80, ##     000000
            0x06, 0x00, ##       00  
            0x06, 0x00, ##       00  
            0x06, 0x00, ##       00  
            0x06, 0x00, ##       00  
            0x06, 0x00, ##       00  
            0x06, 0x00, ##       00  
            0x06, 0x00, ##       00  
            0x06, 0x00, ##       00  
            0x06, 0x00, ##       00  
            0x06, 0x00, ##       00  
            0x06, 0x00, ##       00  
            0x06, 0x00, ##       00  
            0x06, 0x00, ##       00  
            0x06, 0x00, ##       00  
            0x06, 0x00, ##       00  
            0x86, 0x00, ##  0    00  
            0x8C, 0x00, ##  0   00   
            0xF8, 0x00, ##  00000    
        ], 
    }, 
    '75' => {    # 'K'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFC, 0xF8, ##  000000  00000 
            0x30, 0x60, ##    00     00   
            0x30, 0xC0, ##    00    00    
            0x31, 0x80, ##    00   00     
            0x33, 0x00, ##    00  00      
            0x36, 0x00, ##    00 00       
            0x3C, 0x00, ##    0000        
            0x3C, 0x00, ##    0000        
            0x36, 0x00, ##    00 00       
            0x37, 0x00, ##    00 000      
            0x33, 0x80, ##    00  000     
            0x31, 0xC0, ##    00   000    
            0x30, 0xE0, ##    00    000   
            0x30, 0x70, ##    00     000  
            0xFC, 0x3C, ##  000000    0000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '76' => {    # 'L'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFC, 0x00, ##  000000      
            0x30, 0x00, ##    00        
            0x30, 0x00, ##    00        
            0x30, 0x00, ##    00        
            0x30, 0x00, ##    00        
            0x30, 0x00, ##    00        
            0x30, 0x00, ##    00        
            0x30, 0x00, ##    00        
            0x30, 0x00, ##    00        
            0x30, 0x00, ##    00        
            0x30, 0x00, ##    00        
            0x30, 0x10, ##    00       0
            0x30, 0x10, ##    00       0
            0x30, 0x10, ##    00       0
            0xFF, 0xF0, ##  000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '77' => {    # 'M'
        'width'    => 18, 
        'xoffset'  => 1, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF0, 0x03, 0xC0, ##  0000          0000
            0x38, 0x07, 0x00, ##    000        000  
            0x38, 0x07, 0x00, ##    000        000  
            0x2C, 0x0B, 0x00, ##    0 00      0 00  
            0x2C, 0x0B, 0x00, ##    0 00      0 00  
            0x2E, 0x1B, 0x00, ##    0 000    00 00  
            0x26, 0x13, 0x00, ##    0  00    0  00  
            0x27, 0x33, 0x00, ##    0  000  00  00  
            0x23, 0x23, 0x00, ##    0   00  0   00  
            0x23, 0x23, 0x00, ##    0   00  0   00  
            0x21, 0xC3, 0x00, ##    0    000    00  
            0x21, 0xC3, 0x00, ##    0    000    00  
            0x20, 0x83, 0x00, ##    0     0     00  
            0x20, 0x03, 0x00, ##    0           00  
            0xF8, 0x0F, 0xC0, ##  00000       000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '78' => {    # 'N'
        'width'    => 16, 
        'xoffset'  => 1, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF0, 0x1F, ##  0000       00000
            0x38, 0x04, ##    000        0  
            0x3C, 0x04, ##    0000       0  
            0x2C, 0x04, ##    0 00       0  
            0x26, 0x04, ##    0  00      0  
            0x27, 0x04, ##    0  000     0  
            0x23, 0x84, ##    0   000    0  
            0x21, 0xC4, ##    0    000   0  
            0x20, 0xC4, ##    0     00   0  
            0x20, 0x64, ##    0      00  0  
            0x20, 0x74, ##    0      000 0  
            0x20, 0x3C, ##    0       0000  
            0x20, 0x1C, ##    0        000  
            0x20, 0x0C, ##    0         00  
            0xF8, 0x04, ##  00000        0  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '79' => {    # 'O'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0xC0, ##      000000    
            0x18, 0x60, ##     00    00   
            0x20, 0x10, ##    0        0  
            0x60, 0x18, ##   00        00 
            0xC0, 0x0C, ##  00          00
            0xC0, 0x0C, ##  00          00
            0xC0, 0x0C, ##  00          00
            0xC0, 0x0C, ##  00          00
            0xC0, 0x0C, ##  00          00
            0xC0, 0x0C, ##  00          00
            0xC0, 0x0C, ##  00          00
            0x60, 0x18, ##   00        00 
            0x20, 0x10, ##    0        0  
            0x18, 0x60, ##     00    00   
            0x0F, 0xC0, ##      000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '80' => {    # 'P'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xC0, ##  0000000000  
            0x30, 0x60, ##    00     00 
            0x30, 0x30, ##    00      00
            0x30, 0x30, ##    00      00
            0x30, 0x30, ##    00      00
            0x30, 0x30, ##    00      00
            0x30, 0x60, ##    00     00 
            0x3F, 0xC0, ##    00000000  
            0x30, 0x00, ##    00        
            0x30, 0x00, ##    00        
            0x30, 0x00, ##    00        
            0x30, 0x00, ##    00        
            0x30, 0x00, ##    00        
            0x30, 0x00, ##    00        
            0xFC, 0x00, ##  000000      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '81' => {    # 'Q'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0xC0, ##      000000    
            0x18, 0x60, ##     00    00   
            0x20, 0x10, ##    0        0  
            0x60, 0x18, ##   00        00 
            0xC0, 0x0C, ##  00          00
            0xC0, 0x0C, ##  00          00
            0xC0, 0x0C, ##  00          00
            0xC0, 0x0C, ##  00          00
            0xC0, 0x0C, ##  00          00
            0xC0, 0x0C, ##  00          00
            0xC0, 0x0C, ##  00          00
            0x60, 0x18, ##   00        00 
            0x20, 0x10, ##    0        0  
            0x18, 0x60, ##     00    00   
            0x0F, 0xC0, ##      000000    
            0x00, 0xC0, ##          00    
            0x00, 0xF0, ##          0000  
            0x00, 0x30, ##            00  
            0x00, 0x00, ##  
        ], 
    }, 
    '82' => {    # 'R'
        'width'    => 15, 
        'xoffset'  => 1, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xC0, ##  0000000000     
            0x30, 0x60, ##    00     00    
            0x30, 0x30, ##    00      00   
            0x30, 0x30, ##    00      00   
            0x30, 0x30, ##    00      00   
            0x30, 0x30, ##    00      00   
            0x30, 0x60, ##    00     00    
            0x3F, 0x80, ##    0000000      
            0x30, 0xC0, ##    00    00     
            0x30, 0x60, ##    00     00    
            0x30, 0x60, ##    00     00    
            0x30, 0x30, ##    00      00   
            0x30, 0x30, ##    00      00   
            0x30, 0x18, ##    00       00  
            0xFC, 0x1E, ##  000000     0000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '83' => {    # 'S'
        'width'    => 10, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3F, 0x00, ##    000000  
            0x61, 0x80, ##   00    00 
            0xC0, 0x80, ##  00      0 
            0xC0, 0x80, ##  00      0 
            0xC0, 0x00, ##  00        
            0xE0, 0x00, ##  000       
            0x7C, 0x00, ##   00000    
            0x3F, 0x00, ##    000000  
            0x07, 0x80, ##       0000 
            0x01, 0xC0, ##         000
            0x00, 0xC0, ##          00
            0x80, 0xC0, ##  0       00
            0x80, 0xC0, ##  0       00
            0xC1, 0x80, ##  00     00 
            0x7F, 0x00, ##   0000000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '84' => {    # 'T'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xF8, ##  0000000000000
            0x86, 0x08, ##  0    00     0
            0x86, 0x08, ##  0    00     0
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x1F, 0x80, ##     000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '85' => {    # 'U'
        'width'    => 15, 
        'xoffset'  => 1, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFC, 0x3E, ##  000000    00000
            0x30, 0x08, ##    00        0  
            0x30, 0x08, ##    00        0  
            0x30, 0x08, ##    00        0  
            0x30, 0x08, ##    00        0  
            0x30, 0x08, ##    00        0  
            0x30, 0x08, ##    00        0  
            0x30, 0x08, ##    00        0  
            0x30, 0x08, ##    00        0  
            0x30, 0x08, ##    00        0  
            0x30, 0x08, ##    00        0  
            0x30, 0x08, ##    00        0  
            0x18, 0x10, ##     00      0   
            0x1C, 0x30, ##     000    00   
            0x07, 0xC0, ##       00000     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '86' => {    # 'V'
        'width'    => 15, 
        'xoffset'  => 0, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF8, 0x1E, ##  00000      0000
            0x30, 0x08, ##    00        0  
            0x30, 0x08, ##    00        0  
            0x30, 0x08, ##    00        0  
            0x18, 0x10, ##     00      0   
            0x18, 0x10, ##     00      0   
            0x1C, 0x30, ##     000    00   
            0x0C, 0x20, ##      00    0    
            0x0C, 0x20, ##      00    0    
            0x0E, 0x40, ##      000  0     
            0x06, 0x40, ##       00  0     
            0x07, 0xC0, ##       00000     
            0x03, 0x80, ##        000      
            0x03, 0x80, ##        000      
            0x03, 0x80, ##        000      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '87' => {    # 'W'
        'width'    => 20, 
        'xoffset'  => 1, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF8, 0x60, 0xF0, ##  00000    00     0000
            0x60, 0x70, 0x60, ##   00      000     00 
            0x30, 0x70, 0x40, ##    00     000     0  
            0x30, 0x70, 0x40, ##    00     000     0  
            0x30, 0xB0, 0x40, ##    00    0 00     0  
            0x10, 0x98, 0x80, ##     0    0  00   0   
            0x18, 0x98, 0x80, ##     00   0  00   0   
            0x19, 0x98, 0x80, ##     00  00  00   0   
            0x19, 0x0C, 0x80, ##     00  0    00  0   
            0x0D, 0x0D, 0x00, ##      00 0    00 0    
            0x0D, 0x0D, 0x00, ##      00 0    00 0    
            0x0F, 0x0D, 0x00, ##      0000    00 0    
            0x0E, 0x07, 0x00, ##      000      000    
            0x06, 0x06, 0x00, ##       00      00     
            0x06, 0x06, 0x00, ##       00      00     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '88' => {    # 'X'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFC, 0xF8, ##  000000  00000 
            0x38, 0x20, ##    000     0   
            0x18, 0x40, ##     00    0    
            0x1C, 0x40, ##     000   0    
            0x0C, 0x80, ##      00  0     
            0x07, 0x80, ##       0000     
            0x07, 0x00, ##       000      
            0x03, 0x00, ##        00      
            0x07, 0x80, ##       0000     
            0x05, 0x80, ##       0 00     
            0x09, 0xC0, ##      0  000    
            0x18, 0xE0, ##     00   000   
            0x10, 0x60, ##     0     00   
            0x20, 0x70, ##    0      000  
            0xF8, 0xFC, ##  00000   000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '89' => {    # 'Y'
        'width'    => 13, 
        'xoffset'  => 0, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF8, 0x78, ##  00000    0000
            0x30, 0x10, ##    00       0 
            0x38, 0x20, ##    000     0  
            0x18, 0x20, ##     00     0  
            0x0C, 0x40, ##      00   0   
            0x0E, 0xC0, ##      000 00   
            0x06, 0x80, ##       00 0    
            0x07, 0x00, ##       000     
            0x03, 0x00, ##        00     
            0x03, 0x00, ##        00     
            0x03, 0x00, ##        00     
            0x03, 0x00, ##        00     
            0x03, 0x00, ##        00     
            0x03, 0x00, ##        00     
            0x0F, 0xC0, ##      000000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '90' => {    # 'Z'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xF0, ##  000000000000
            0x80, 0x60, ##  0        00 
            0x80, 0xC0, ##  0       00  
            0x01, 0xC0, ##         000  
            0x03, 0x80, ##        000   
            0x03, 0x00, ##        00    
            0x07, 0x00, ##       000    
            0x0E, 0x00, ##      000     
            0x0C, 0x00, ##      00      
            0x18, 0x00, ##     00       
            0x38, 0x00, ##    000       
            0x30, 0x00, ##    00        
            0x60, 0x10, ##   00        0
            0xE0, 0x10, ##  000        0
            0xFF, 0xF0, ##  000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '91' => {    # '['
        'width'    => 5, 
        'xoffset'  => 2, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xF8, ##  00000
            0x00, ##  
        ], 
    }, 
    '92' => {    # '\'
        'width'    => 7, 
        'xoffset'  => 0, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xC0, ##  00     
            0xC0, ##  00     
            0x40, ##   0     
            0x60, ##   00    
            0x60, ##   00    
            0x20, ##    0    
            0x30, ##    00   
            0x30, ##    00   
            0x10, ##     0   
            0x10, ##     0   
            0x18, ##     00  
            0x18, ##     00  
            0x08, ##      0  
            0x0C, ##      00 
            0x0C, ##      00 
            0x04, ##       0 
            0x06, ##       00
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '93' => {    # ']'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0xF8, ##  00000
            0x00, ##  
        ], 
    }, 
    '94' => {    # '^'
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x06, 0x00, ##       00      
            0x0F, 0x00, ##      0000     
            0x1D, 0x80, ##     000 00    
            0x18, 0xC0, ##     00   00   
            0x30, 0x60, ##    00     00  
            0x40, 0x10, ##   0         0 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '95' => {    # '_'
        'width'    => 10, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '96' => {    # '`'
        'width'    => 4, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0xC0, ##  00  
            0x60, ##   00 
            0x20, ##    0 
            0x10, ##     0
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '97' => {    # 'a'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3E, 0x00, ##    00000   
            0x43, 0x00, ##   0    00  
            0x41, 0x80, ##   0     00 
            0x01, 0x80, ##         00 
            0x3F, 0x80, ##    0000000 
            0x61, 0x80, ##   00    00 
            0xC1, 0x80, ##  00     00 
            0xC1, 0x80, ##  00     00 
            0xC1, 0x80, ##  00     00 
            0x63, 0x80, ##   00   000 
            0x3D, 0xC0, ##    0000 000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '98' => {    # 'b'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x00, ##  000       
            0x60, 0x00, ##   00       
            0x60, 0x00, ##   00       
            0x60, 0x00, ##   00       
            0x6F, 0x00, ##   00 0000  
            0x71, 0x80, ##   000   00 
            0x60, 0x80, ##   00     0 
            0x60, 0xC0, ##   00     00
            0x60, 0xC0, ##   00     00
            0x60, 0xC0, ##   00     00
            0x60, 0xC0, ##   00     00
            0x60, 0xC0, ##   00     00
            0x60, 0x80, ##   00     0 
            0x71, 0x80, ##   000   00 
            0xEF, 0x00, ##  000 0000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '99' => {    # 'c'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x00, ##     00000 
            0x61, 0x80, ##   00    00
            0x60, 0x80, ##   00     0
            0xC0, 0x80, ##  00      0
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0x60, 0x80, ##   00     0
            0x61, 0x00, ##   00    0 
            0x1E, 0x00, ##     0000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '100' => {    # 'd'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0xC0, ##        0000  
            0x00, 0xC0, ##          00  
            0x00, 0xC0, ##          00  
            0x00, 0xC0, ##          00  
            0x3E, 0xC0, ##    00000 00  
            0x61, 0xC0, ##   00    000  
            0x60, 0xC0, ##   00     00  
            0xC0, 0xC0, ##  00      00  
            0xC0, 0xC0, ##  00      00  
            0xC0, 0xC0, ##  00      00  
            0xC0, 0xC0, ##  00      00  
            0xC0, 0xC0, ##  00      00  
            0x60, 0xC0, ##   00     00  
            0x61, 0xC0, ##   00    000  
            0x1E, 0xF0, ##     0000 0000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '101' => {    # 'e'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1E, 0x00, ##     0000   
            0x61, 0x80, ##   00    00 
            0x60, 0x80, ##   00     0 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xFF, 0xC0, ##  0000000000
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0x40, 0xC0, ##   0      00
            0x61, 0x80, ##   00    00 
            0x1F, 0x00, ##     00000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '102' => {    # 'f'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x1F, ##     00000
            0x31, ##    00   0
            0x30, ##    00    
            0x30, ##    00    
            0xFC, ##  000000  
            0x30, ##    00    
            0x30, ##    00    
            0x30, ##    00    
            0x30, ##    00    
            0x30, ##    00    
            0x30, ##    00    
            0x30, ##    00    
            0x30, ##    00    
            0x30, ##    00    
            0xFC, ##  000000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '103' => {    # 'g'
        'width'    => 11, 
        'xoffset'  => 1, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3E, 0xE0, ##    00000 000
            0x61, 0xC0, ##   00    000 
            0x60, 0xC0, ##   00     00 
            0xC0, 0xC0, ##  00      00 
            0xC0, 0xC0, ##  00      00 
            0xC0, 0xC0, ##  00      00 
            0xC0, 0xC0, ##  00      00 
            0xC0, 0xC0, ##  00      00 
            0x60, 0xC0, ##   00     00 
            0x61, 0xC0, ##   00    000 
            0x3E, 0xC0, ##    00000 00 
            0x00, 0xC0, ##          00 
            0x40, 0xC0, ##   0      00 
            0x61, 0x80, ##   00    00  
            0x3F, 0x00, ##    000000   
        ], 
    }, 
    '104' => {    # 'h'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x00, ##  000         
            0x60, 0x00, ##   00         
            0x60, 0x00, ##   00         
            0x60, 0x00, ##   00         
            0x6F, 0x00, ##   00 0000    
            0x71, 0x80, ##   000   00   
            0x60, 0xC0, ##   00     00  
            0x60, 0xC0, ##   00     00  
            0x60, 0xC0, ##   00     00  
            0x60, 0xC0, ##   00     00  
            0x60, 0xC0, ##   00     00  
            0x60, 0xC0, ##   00     00  
            0x60, 0xC0, ##   00     00  
            0x60, 0xC0, ##   00     00  
            0xF9, 0xF0, ##  00000  00000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '105' => {    # 'i'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x60, ##   00  
            0x60, ##   00  
            0x00, ##       
            0x00, ##       
            0xE0, ##  000  
            0x60, ##   00  
            0x60, ##   00  
            0x60, ##   00  
            0x60, ##   00  
            0x60, ##   00  
            0x60, ##   00  
            0x60, ##   00  
            0x60, ##   00  
            0x60, ##   00  
            0xF8, ##  00000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '106' => {    # 'j'
        'width'    => 6, 
        'xoffset'  => -2, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x0C, ##      00
            0x0C, ##      00
            0x00, ##        
            0x00, ##        
            0x1C, ##     000
            0x0C, ##      00
            0x0C, ##      00
            0x0C, ##      00
            0x0C, ##      00
            0x0C, ##      00
            0x0C, ##      00
            0x0C, ##      00
            0x0C, ##      00
            0x0C, ##      00
            0x0C, ##      00
            0x0C, ##      00
            0x8C, ##  0   00
            0x9C, ##  0  000
            0xF8, ##  00000 
        ], 
    }, 
    '107' => {    # 'k'
        'width'    => 11, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF0, 0x00, ##  0000       
            0x30, 0x00, ##    00       
            0x30, 0x00, ##    00       
            0x30, 0x00, ##    00       
            0x33, 0xE0, ##    00  00000
            0x31, 0x80, ##    00   00  
            0x33, 0x00, ##    00  00   
            0x32, 0x00, ##    00  0    
            0x34, 0x00, ##    00 0     
            0x3E, 0x00, ##    00000    
            0x33, 0x00, ##    00  00   
            0x33, 0x00, ##    00  00   
            0x31, 0x80, ##    00   00  
            0x31, 0xC0, ##    00   000 
            0xFB, 0xE0, ##  00000 00000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '108' => {    # 'l'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000 
            0x30, ##    00 
            0x30, ##    00 
            0x30, ##    00 
            0x30, ##    00 
            0x30, ##    00 
            0x30, ##    00 
            0x30, ##    00 
            0x30, ##    00 
            0x30, ##    00 
            0x30, ##    00 
            0x30, ##    00 
            0x30, ##    00 
            0x30, ##    00 
            0xF8, ##  00000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '109' => {    # 'm'
        'width'    => 19, 
        'xoffset'  => 1, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xEF, 0x1E, 0x00, ##  000 0000   0000    
            0x71, 0xA3, 0x00, ##   000   00 0   00   
            0x60, 0xC1, 0x80, ##   00     00     00  
            0x60, 0xC1, 0x80, ##   00     00     00  
            0x60, 0xC1, 0x80, ##   00     00     00  
            0x60, 0xC1, 0x80, ##   00     00     00  
            0x60, 0xC1, 0x80, ##   00     00     00  
            0x60, 0xC1, 0x80, ##   00     00     00  
            0x60, 0xC1, 0x80, ##   00     00     00  
            0x60, 0xC1, 0x80, ##   00     00     00  
            0xFB, 0xE3, 0xE0, ##  00000 00000   00000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '110' => {    # 'n'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xEF, 0x00, ##  000 0000    
            0x71, 0x80, ##   000   00   
            0x60, 0xC0, ##   00     00  
            0x60, 0xC0, ##   00     00  
            0x60, 0xC0, ##   00     00  
            0x60, 0xC0, ##   00     00  
            0x60, 0xC0, ##   00     00  
            0x60, 0xC0, ##   00     00  
            0x60, 0xC0, ##   00     00  
            0x60, 0xC0, ##   00     00  
            0xF9, 0xF0, ##  00000  00000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '111' => {    # 'o'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1E, 0x00, ##     0000   
            0x61, 0x80, ##   00    00 
            0x61, 0x80, ##   00    00 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0x61, 0x80, ##   00    00 
            0x61, 0x80, ##   00    00 
            0x1E, 0x00, ##     0000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '112' => {    # 'p'
        'width'    => 11, 
        'xoffset'  => 1, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF7, 0x80, ##  0000 0000  
            0x38, 0xC0, ##    000   00 
            0x30, 0x40, ##    00     0 
            0x30, 0x60, ##    00     00
            0x30, 0x60, ##    00     00
            0x30, 0x60, ##    00     00
            0x30, 0x60, ##    00     00
            0x30, 0x60, ##    00     00
            0x30, 0x40, ##    00     0 
            0x38, 0xC0, ##    000   00 
            0x37, 0x80, ##    00 0000  
            0x30, 0x00, ##    00       
            0x30, 0x00, ##    00       
            0x30, 0x00, ##    00       
            0xF8, 0x00, ##  00000      
        ], 
    }, 
    '113' => {    # 'q'
        'width'    => 11, 
        'xoffset'  => 1, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3E, 0xE0, ##    00000 000
            0x61, 0xC0, ##   00    000 
            0x60, 0xC0, ##   00     00 
            0xC0, 0xC0, ##  00      00 
            0xC0, 0xC0, ##  00      00 
            0xC0, 0xC0, ##  00      00 
            0xC0, 0xC0, ##  00      00 
            0xC0, 0xC0, ##  00      00 
            0x60, 0xC0, ##   00     00 
            0x61, 0xC0, ##   00    000 
            0x3E, 0xC0, ##    00000 00 
            0x00, 0xC0, ##          00 
            0x00, 0xC0, ##          00 
            0x00, 0xC0, ##          00 
            0x03, 0xE0, ##        00000
        ], 
    }, 
    '114' => {    # 'r'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xEF, 0x80, ##  000 00000
            0x70, 0x80, ##   000    0
            0x70, 0x80, ##   000    0
            0x60, 0x00, ##   00      
            0x60, 0x00, ##   00      
            0x60, 0x00, ##   00      
            0x60, 0x00, ##   00      
            0x60, 0x00, ##   00      
            0x60, 0x00, ##   00      
            0x60, 0x00, ##   00      
            0xF8, 0x00, ##  00000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '115' => {    # 's'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3E, ##    00000 
            0xC7, ##  00   000
            0xC3, ##  00    00
            0xC0, ##  00      
            0xF0, ##  0000    
            0x3E, ##    00000 
            0x0F, ##      0000
            0x03, ##        00
            0x83, ##  0     00
            0xC7, ##  00   000
            0x7C, ##   00000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '116' => {    # 't'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x30, 0x00, ##    00     
            0x30, 0x00, ##    00     
            0x30, 0x00, ##    00     
            0x30, 0x00, ##    00     
            0xFE, 0x00, ##  0000000  
            0x30, 0x00, ##    00     
            0x30, 0x00, ##    00     
            0x30, 0x00, ##    00     
            0x30, 0x00, ##    00     
            0x30, 0x00, ##    00     
            0x30, 0x00, ##    00     
            0x30, 0x00, ##    00     
            0x31, 0x80, ##    00   00
            0x31, 0x80, ##    00   00
            0x1F, 0x00, ##     00000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '117' => {    # 'u'
        'width'    => 12, 
        'xoffset'  => 0, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF1, 0xC0, ##  0000   000  
            0x30, 0xC0, ##    00    00  
            0x30, 0xC0, ##    00    00  
            0x30, 0xC0, ##    00    00  
            0x30, 0xC0, ##    00    00  
            0x30, 0xC0, ##    00    00  
            0x30, 0xC0, ##    00    00  
            0x30, 0xC0, ##    00    00  
            0x30, 0xC0, ##    00    00  
            0x39, 0xC0, ##    000  000  
            0x1E, 0xF0, ##     0000 0000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '118' => {    # 'v'
        'width'    => 11, 
        'xoffset'  => 0, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF9, 0xE0, ##  00000  0000
            0x60, 0xC0, ##   00     00 
            0x30, 0x80, ##    00    0  
            0x30, 0x80, ##    00    0  
            0x11, 0x80, ##     0   00  
            0x19, 0x00, ##     00  0   
            0x19, 0x00, ##     00  0   
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x06, 0x00, ##       00    
            0x04, 0x00, ##       0     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '119' => {    # 'w'
        'width'    => 17, 
        'xoffset'  => 1, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF8, 0xC7, 0x80, ##  00000   00   0000
            0x60, 0xC3, 0x00, ##   00     00    00 
            0x31, 0xC2, 0x00, ##    00   000    0  
            0x31, 0x62, 0x00, ##    00   0 00   0  
            0x31, 0x66, 0x00, ##    00   0 00  00  
            0x19, 0x64, 0x00, ##     00  0 00  0   
            0x1A, 0x34, 0x00, ##     00 0   00 0   
            0x1A, 0x3C, 0x00, ##     00 0   0000   
            0x0E, 0x38, 0x00, ##      000   000    
            0x0C, 0x18, 0x00, ##      00     00    
            0x0C, 0x18, 0x00, ##      00     00    
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '120' => {    # 'x'
        'width'    => 11, 
        'xoffset'  => 1, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF3, 0xC0, ##  0000  0000 
            0x71, 0x00, ##   000   0   
            0x33, 0x00, ##    00  00   
            0x1A, 0x00, ##     00 0    
            0x1C, 0x00, ##     000     
            0x0C, 0x00, ##      00     
            0x0E, 0x00, ##      000    
            0x16, 0x00, ##     0 00    
            0x33, 0x00, ##    00  00   
            0x21, 0x80, ##    0    00  
            0xF3, 0xE0, ##  0000  00000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '121' => {    # 'y'
        'width'    => 11, 
        'xoffset'  => 0, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF9, 0xE0, ##  00000  0000
            0x60, 0xC0, ##   00     00 
            0x30, 0x80, ##    00    0  
            0x30, 0x80, ##    00    0  
            0x19, 0x00, ##     00  0   
            0x19, 0x00, ##     00  0   
            0x19, 0x00, ##     00  0   
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x06, 0x00, ##       00    
            0x04, 0x00, ##       0     
            0x04, 0x00, ##       0     
            0x08, 0x00, ##      0      
            0x48, 0x00, ##   0  0      
            0x70, 0x00, ##   000       
        ], 
    }, 
    '122' => {    # 'z'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x80, ##  000000000
            0x83, 0x00, ##  0     00 
            0x87, 0x00, ##  0    000 
            0x06, 0x00, ##       00  
            0x0C, 0x00, ##      00   
            0x18, 0x00, ##     00    
            0x38, 0x00, ##    000    
            0x30, 0x00, ##    00     
            0x60, 0x80, ##   00     0
            0xC0, 0x80, ##  00      0
            0xFF, 0x80, ##  000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '123' => {    # '{'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x0F, ##      0000
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x30, ##    00    
            0xE0, ##  000     
            0x30, ##    00    
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x0F, ##      0000
        ], 
    }, 
    '124' => {    # '|'
        'width'    => 2, 
        'xoffset'  => 3, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
        ], 
    }, 
    '125' => {    # '}'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000    
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x0C, ##      00  
            0x07, ##       000
            0x0C, ##      00  
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0xF0, ##  0000    
        ], 
    }, 
    '126' => {    # '~'
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x7C, 0x18, ##   00000     00
            0xC7, 0xF0, ##  00   0000000 
            0x81, 0xE0, ##  0      0000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '176' => {    # '°'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x38, ##    000  
            0xEE, ##  000 000
            0xC6, ##  00   00
            0xC6, ##  00   00
            0xCE, ##  00  000
            0x78, ##   0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
};
 
my $kerning = {
    '33' => { },  # !
    '34' => { },  # "
    '35' => { },  # #
    '36' => { },  # $
    '37' => { },  # %
    '38' => { },  # &
    '39' => { },  # '
    '40' => { },  # (
    '41' => { },  # )
    '42' => { },  # *
    '43' => { },  # +
    '44' => { },  # ,
    '45' => { '84' => -1, '86' => -1, '87' => -1, '88' => -1, '89' => -2, },  # -
    '46' => { },  # .
    '47' => { },  # /
    '48' => { },  # 0
    '49' => { },  # 1
    '50' => { },  # 2
    '51' => { },  # 3
    '52' => { },  # 4
    '53' => { },  # 5
    '54' => { },  # 6
    '55' => { },  # 7
    '56' => { },  # 8
    '57' => { },  # 9
    '58' => { },  # :
    '59' => { },  # ;
    '60' => { },  # <
    '61' => { },  # =
    '62' => { },  # >
    '63' => { },  # ?
    '64' => { },  # @
    '65' => { '84' => -1, '86' => -1, '87' => -1, '89' => -1, '118' => -1, '119' => -1, '121' => -1, },  # A
    '66' => { },  # B
    '67' => { '44' => -1, '46' => -1, },  # C
    '68' => { '44' => -1, '46' => -1, },  # D
    '69' => { },  # E
    '70' => { '44' => -2, '45' => -1, '46' => -2, '58' => -1, '59' => -1, '65' => -1, '97' => -1, '101' => -1, '111' => -1, },  # F
    '71' => { '44' => -1, '46' => -1, },  # G
    '72' => { },  # H
    '73' => { },  # I
    '74' => { '44' => -1, '46' => -1, '58' => -1, '59' => -1, },  # J
    '75' => { '45' => -1, '65' => -1, '85' => -1, '87' => -1, '121' => -1, },  # K
    '76' => { '84' => -1, '85' => -1, '86' => -2, '87' => -1, '89' => -1, },  # L
    '77' => { },  # M
    '78' => { '44' => -1, '46' => -1, '58' => -1, '59' => -1, },  # N
    '79' => { '44' => -1, '45' => 1, '46' => -1, },  # O
    '80' => { '44' => -3, '45' => -1, '46' => -3, '58' => -1, '59' => -1, '65' => -1, '97' => -1, '101' => -1, '111' => -1, },  # P
    '81' => { '44' => -1, '45' => 1, '46' => -1, },  # Q
    '82' => { '86' => -1, },  # R
    '83' => { '44' => -1, '45' => 1, '46' => -1, },  # S
    '84' => { '44' => -2, '45' => -2, '46' => -2, '58' => -1, '59' => -1, '65' => -1, '97' => -1, '99' => -1, '101' => -1, '111' => -1, '115' => -1, '119' => -1, },  # T
    '85' => { '44' => -1, '46' => -1, '58' => -1, '59' => -1, },  # U
    '86' => { '44' => -3, '45' => -1, '46' => -3, '58' => -2, '59' => -2, '65' => -1, '97' => -1, '101' => -1, '111' => -1, '117' => -1, '121' => -1, },  # V
    '87' => { '44' => -3, '45' => -1, '46' => -3, '58' => -1, '59' => -1, '65' => -1, '97' => -1, '101' => -1, '111' => -1, '114' => -1, '117' => -1, },  # W
    '88' => { '45' => -1, '65' => -1, },  # X
    '89' => { '44' => -2, '45' => -2, '46' => -2, '58' => -2, '59' => -2, '65' => -1, '97' => -1, '101' => -1, '111' => -1, '117' => -1, },  # Y
    '90' => { },  # Z
    '91' => { },  # [
    '92' => { },  # \
    '93' => { },  # ]
    '94' => { },  # ^
    '95' => { },  # _
    '96' => { },  # `
    '97' => { },  # a
    '98' => { },  # b
    '99' => { },  # c
    '100' => { },  # d
    '101' => { },  # e
    '102' => { '44' => -1, '45' => -1, '46' => -1, },  # f
    '103' => { },  # g
    '104' => { },  # h
    '105' => { },  # i
    '106' => { },  # j
    '107' => { },  # k
    '108' => { },  # l
    '109' => { },  # m
    '110' => { },  # n
    '111' => { },  # o
    '112' => { },  # p
    '113' => { },  # q
    '114' => { '44' => -2, '46' => -2, },  # r
    '115' => { },  # s
    '116' => { },  # t
    '117' => { },  # u
    '118' => { '44' => -2, '46' => -2, },  # v
    '119' => { '44' => -2, '46' => -2, },  # w
    '120' => { },  # x
    '121' => { '44' => -2, '46' => -2, },  # y
    '122' => { },  # z
    '123' => { },  # {
    '124' => { },  # |
    '125' => { },  # }
    '126' => { },  # ~
    '176' => { },  # °
};


sub new {
    my($class) = @_;
    
    my $self = $class->SUPER::new(
        name        => $name,
        char_height => $char_height,
        space_width => $space_width,
        gap_width   => $gap_width,
        symbols     => $symbols,
        kerning     => $kerning,
        line_spacing => $line_spacing,
        class       => 'hipi_2',
    );
    
    return $self;
}

1;

__END__
