
package Paws::CognitoIdp::AdminDeleteUserAttributes;
  use Moose;
  has UserAttributeNames => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);
  has Username => (is => 'ro', isa => 'Str', required => 1);
  has UserPoolId => (is => 'ro', isa => 'Str', required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'AdminDeleteUserAttributes');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::CognitoIdp::AdminDeleteUserAttributesResponse');
  class_has _result_key => (isa => 'Str', is => 'ro');
1;

### main pod documentation begin ###

=head1 NAME

Paws::CognitoIdp::AdminDeleteUserAttributes - Arguments for method AdminDeleteUserAttributes on Paws::CognitoIdp

=head1 DESCRIPTION

This class represents the parameters used for calling the method AdminDeleteUserAttributes on the 
Amazon Cognito Identity Provider service. Use the attributes of this class
as arguments to method AdminDeleteUserAttributes.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to AdminDeleteUserAttributes.

As an example:

  $service_obj->AdminDeleteUserAttributes(Att1 => $value1, Att2 => $value2, ...);

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.

=head1 ATTRIBUTES


=head2 B<REQUIRED> UserAttributeNames => ArrayRef[Str|Undef]

An array of strings representing the user attribute names you wish to
delete.



=head2 B<REQUIRED> Username => Str

The user name of the user from which you would like to delete
attributes.



=head2 B<REQUIRED> UserPoolId => Str

The user pool ID for the user pool where you want to delete user
attributes.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method AdminDeleteUserAttributes in L<Paws::CognitoIdp>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: https://github.com/pplu/aws-sdk-perl

Please report bugs to: https://github.com/pplu/aws-sdk-perl/issues

=cut

