# This Makefile.PL for UV-Util was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.41.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.008001;
use ExtUtils::MakeMaker;

use Config;
use Alien::libuv ();

# Some options behave differently on Windows
sub WINLIKE () {
    return 1 if $^O eq 'MSWin32';
    # return 1 if $^O eq 'cygwin';
    return 1 if $^O eq 'msys';
    return '';
}
sub WINVER() {
    return undef unless WINLIKE();
    my $ver;
    my $err = do {
        local $@;
        eval { require Win32; $ver = Win32::GetOSName(); 1; };
        $@;
    };
    $ver = 'Win10' unless $ver; # just pick one if we couldn't find it
    if ($err) {
        warn "We had an error grabbing the Win32 OS Name: $err";
    }

    if ($ver =~ /^Win(?:Win32s|95|98|Me|NT4|NT3\.51|HomeSvr)/) {
        warn "This version of Windows is really old and we can't install here";
        exit(1);
    }
    return '0x0500' if $ver =~ /^Win2000/;
    return '0x0501' if $ver =~ /^WinXP\/\.Net/;
    return '0x0502' if $ver =~ /^Win2003/;
    return '0x0600' if $ver =~ /^Win(?:Vista|2008)/;
    return '0x0601' if $ver =~ /^Win7/;
    return '0x0603' if $ver =~ /^Win8\.1/;
    return '0x0602' if $ver =~ /^Win8/;
    return '0x0A00' if $ver =~ /^Win10/;
    return '0x0A00' if $ver =~ /^Win(?:2012|2014|2016)/; # not sure here

    warn "We couldn't determine the version of Windows you're on.";
    return undef;

}

# make sure we actually get stuff back from Alien::libuv
sub TRIM {
    my $s = shift;
    return '' unless $s;
    $s =~ s/\A\s*//;
    $s =~ s/\s*\z//;
    return $s;
}

my @flags = ('-I.', $Config{ccflags});
if (my $ver = WINVER()) {
    push @flags, "-DWIN32_LEAN_AND_MEAN" unless $Config{ccflags} =~ /LEAN_AND_MEAN/;
    push @flags, "-D_WINVER=$ver", "-D_WIN32_WINNT=$ver";
    #push @flags, "-D_WIN32_WINDOWS=$ver";
    #push @flags, "-D_WIN32_IE=$ver";
}
my $libs = Alien::libuv->libs();
$libs .= ' -lpsapi -luserenv -lIphlpapi' if WINLIKE();
{
    my $cflags = TRIM(Alien::libuv->cflags);
    my $cflags_s = TRIM(Alien::libuv->cflags_static);
    if ($cflags eq $cflags_s) {
        unshift @flags, $cflags if $cflags;
    }
    else {
        unshift @flags, $cflags if $cflags;
        unshift @flags, $cflags_s if $cflags_s;
    }
}
my %xsbuild = (
    XSMULTI => 1,
    # XSBUILD => {
    #     xs => {
    #         'lib/UV' => {
    #           OBJECT => 'lib/UV$(OBJ_EXT) lib/perl_math_int64$(OBJ_EXT)',
    #         },
    #     },
    # },
    # OBJECT  => '$(O_FILES)',
    LIBS => [$libs],
    CCFLAGS => join(' ', @flags),
);

my %WriteMakefileArgs = (
  "ABSTRACT" => "Some utility functions from libUV.",
  "AUTHOR" => "Chase Whitener <capoeirab\@cpan.org>",
  "BUILD_REQUIRES" => {
    "Alien::libuv" => "0.006",
    "Config" => 0,
    "ExtUtils::MakeMaker" => "7.12"
  },
  "CONFIGURE_REQUIRES" => {
    "Alien::libuv" => 0,
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "UV-Util",
  "LICENSE" => "perl",
  "MIN_PERL_VERSION" => "5.008001",
  "NAME" => "UV::Util",
  "PREREQ_PM" => {
    "Alien::libuv" => "0.006",
    "Exporter" => "5.57",
    "XSLoader" => "0.14",
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "Alien::libuv" => "0.006",
    "ExtUtils::MakeMaker" => "7.12",
    "File::Spec" => 0,
    "Test::More" => "0.88"
  },
  "VERSION" => "0.010",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

%WriteMakefileArgs = (
    %WriteMakefileArgs,
    %xsbuild,
);

my %FallbackPrereqs = (
  "Alien::libuv" => "0.006",
  "Config" => 0,
  "Exporter" => "5.57",
  "ExtUtils::MakeMaker" => "7.12",
  "File::Spec" => 0,
  "Test::More" => "0.88",
  "XSLoader" => "0.14",
  "strict" => 0,
  "warnings" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
