
# t/03meta.t

use Test::More;

# --no-live-tests to skip this script
BEGIN {
    $no_live_tests = grep { $_ eq '--no-live-tests' } @ARGV;
    plan( skip_all => 'live tests disabled' ) if $no_live_tests;

}

use lib qw( t/lib );

BEGIN {
    require Devel::CheckNet;
    my $ok = Devel::CheckNet->can_http('http://search.cpan.org/');
    if ($ok) {
        plan( tests => 20 );
    }
    else {
        plan( skip_all => 'could not reach http://search.cpan.org/' );
    }
}

use WWW::CPAN ();

diag("live testing with access to http://search.cpan.org");

{
    my $c = WWW::CPAN->new();
    my $m = $c->fetch_distmeta('CPAN');

    isa_ok( $m, 'HASH', 'fetch_distmeta result' );
    isnt( $m->{generated_by}, 'search.cpan.org', 'Metafile included in dist' );
    is( $m->{name}, 'CPAN', 'dist name ok' );
    for my $field (
        qw( abstract author generated_by license meta-spec prereqs version ))
    {
        ok( exists $m->{$field}, "has $field" );
    }
    #
}

{
    # Data-Denter is an old deprecate data serializer.
    # Its latest release 0.15 does not contain a META.yml
    # so search.cpan.org will generate one.

    my $m = WWW::CPAN->new->fetch_distmeta('Data-Denter');

    # FIXME if the line above is replaced by the line below, it crashes
    #my $m = WWW::CPAN->fetch_distmeta('Data-Denter'); # XXX

    isa_ok( $m, 'HASH', 'fetch_distmeta result' );

# FIXME search.cpan.org stopped using this "generated_by"
#is( $m->{generated_by}, 'search.cpan.org', 'Metafile generated by search.cpan.org' );
    is( $m->{name}, 'Data-Denter', 'dist name ok' );
    for my $field (
        qw( abstract author generated_by license meta-spec provides resources version )
      )
    {
        ok( exists $m->{$field}, "has $field" );
    }
}
