package Paws::Glue::JobUpdate;
  use Moose;
  has AllocatedCapacity => (is => 'ro', isa => 'Int');
  has Command => (is => 'ro', isa => 'Paws::Glue::JobCommand');
  has Connections => (is => 'ro', isa => 'Paws::Glue::ConnectionsList');
  has DefaultArguments => (is => 'ro', isa => 'Paws::Glue::GenericMap');
  has Description => (is => 'ro', isa => 'Str');
  has ExecutionProperty => (is => 'ro', isa => 'Paws::Glue::ExecutionProperty');
  has LogUri => (is => 'ro', isa => 'Str');
  has MaxRetries => (is => 'ro', isa => 'Int');
  has NotificationProperty => (is => 'ro', isa => 'Paws::Glue::NotificationProperty');
  has Role => (is => 'ro', isa => 'Str');
  has Timeout => (is => 'ro', isa => 'Int');
1;

### main pod documentation begin ###

=head1 NAME

Paws::Glue::JobUpdate

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Glue::JobUpdate object:

  $service_obj->Method(Att1 => { AllocatedCapacity => $value, ..., Timeout => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Glue::JobUpdate object:

  $result = $service_obj->Method(...);
  $result->Att1->AllocatedCapacity

=head1 DESCRIPTION

Specifies information used to update an existing job definition. Note
that the previous job definition will be completely overwritten by this
information.

=head1 ATTRIBUTES


=head2 AllocatedCapacity => Int

  The number of AWS Glue data processing units (DPUs) to allocate to this
Job. From 2 to 100 DPUs can be allocated; the default is 10. A DPU is a
relative measure of processing power that consists of 4 vCPUs of
compute capacity and 16 GB of memory. For more information, see the AWS
Glue pricing page (https://aws.amazon.com/glue/pricing/).


=head2 Command => L<Paws::Glue::JobCommand>

  The JobCommand that executes this job (required).


=head2 Connections => L<Paws::Glue::ConnectionsList>

  The connections used for this job.


=head2 DefaultArguments => L<Paws::Glue::GenericMap>

  The default arguments for this job.

You can specify arguments here that your own job-execution script
consumes, as well as arguments that AWS Glue itself consumes.

For information about how to specify and consume your own Job
arguments, see the Calling AWS Glue APIs in Python
(http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html)
topic in the developer guide.

For information about the key-value pairs that AWS Glue consumes to set
up your job, see the Special Parameters Used by AWS Glue
(http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)
topic in the developer guide.


=head2 Description => Str

  Description of the job being defined.


=head2 ExecutionProperty => L<Paws::Glue::ExecutionProperty>

  An ExecutionProperty specifying the maximum number of concurrent runs
allowed for this job.


=head2 LogUri => Str

  This field is reserved for future use.


=head2 MaxRetries => Int

  The maximum number of times to retry this job if it fails.


=head2 NotificationProperty => L<Paws::Glue::NotificationProperty>

  Specifies configuration properties of a job notification.


=head2 Role => Str

  The name or ARN of the IAM role associated with this job (required).


=head2 Timeout => Int

  The job timeout in minutes. The default is 2880 minutes (48 hours).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Glue>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

