#! perl

use strict;
use warnings;

# Implementation of App::Music::ChordPro::Wx::PreferencesDialog_wxg details.

package App::Music::ChordPro::Wx::PreferencesDialog;

# App::Music::ChordPro::Wx::PreferencesDialog_wxg is generated by wxGlade and contains
# all UI associated code.

use base qw( App::Music::ChordPro::Wx::PreferencesDialog_wxg );

use Wx qw[:everything];
use Wx::Locale gettext => '_T';

sub get_configfile {
    my ( $self ) = @_;
    warn("CF: ", $self->GetParent->{prefs_configfile} || "");
    $self->GetParent->{prefs_configfile} || ""
}

sub __set_properties {
    my ( $self ) = @_;
    $self->SUPER::__set_properties;
    $self->{t_configfiledialog}->SetValue($self->GetParent->{prefs_configfile})
      if $self->GetParent->{prefs_configfile};
    $self->{t_pdfviewer}->SetValue($self->GetParent->{prefs_pdfviewer})
      if $self->GetParent->{prefs_pdfviewer};
}

################ Event handlers ################

# Event handlers override the subs generated by wxGlade in the _wxg class.

sub OnConfigFileDialog {
    my ( $self, $event ) = @_;
    my $fd = Wx::FileDialog->new
      ($self, _T("Choose config file"),
       "", $self->GetParent->{prefs_configfile} || "",
       "Config files (*.cfg,*.json)|*.cfg;*.json|All files|*.*",
       0|wxFD_OPEN|wxFD_FILE_MUST_EXIST,
       wxDefaultPosition);
    my $ret = $fd->ShowModal;
    if ( $ret == wxID_OK ) {
	$self->{t_configfiledialog}->SetValue($fd->GetPath);
    }
    $fd->Destroy;
}

#               C      D      E  F      G      A        B
my @xpmap = qw( 0 1  1 2 3  3 4  5 6  6 7 8  8 9 10 10 11 );
my @sfmap = qw( 0 7 -5 2 9 -3 4 -1 6 -6 1 8 -4 3 10 -2  5 );

sub OnAccept {
    my ( $self, $event ) = @_;

    $self->GetParent->{prefs_configfile} = $self->{t_configfiledialog}->GetValue;
    $self->GetParent->{prefs_pdfviewer} = $self->{t_pdfviewer}->GetValue;

    my $xp = $xpmap[$self->{ch_xpose_to}->GetSelection]
      - $xpmap[$self->{ch_xpose_from}->GetSelection];
    $xp += 12 if $xp < 0;
    $xp = $xp - 12 if $self->{rb_xpose_flat }->GetValue;
    $self->GetParent->{prefs_xpose} = $xp;

    $event->Skip;
}

sub OnCancel {
    my ( $self, $event ) = @_;
    $event->Skip;
}

sub OnXposeFrom {
    my ( $self, $event ) = @_;
    $event->Skip;
}

sub OnXposeTo {
    my ( $self, $event ) = @_;
    my $sel = $self->{ch_xpose_to}->GetSelection;
    my $sf = $sfmap[$sel];
    if ( $sf < 0 ) {
	$self->{rb_xpose_flat }->SetValue(1);
	$self->{rb_xpose_sharp}->SetValue(0);
    }
    elsif ( $sf > 0 ) {
	$self->{rb_xpose_flat }->SetValue(0);
	$self->{rb_xpose_sharp}->SetValue(1);
    }
    else {
	$self->{rb_xpose_flat }->SetValue(0);
	$self->{rb_xpose_sharp}->SetValue(0);
    }
    $event->Skip;
}

sub OnXposeSharp {
    my ( $self, $event ) = @_;
    $self->{rb_xpose_flat }->SetValue(0);
    $event->Skip;
}

sub onXposeFlat {
    my ( $self, $event ) = @_;
    $self->{rb_xpose_sharp}->SetValue(0);
    $event->Skip;
}

1;
