package Chart::Plotly::Trace::Ohlc;
use Moose;
use MooseX::ExtraArgs;

use Chart::Plotly::Trace::Attribute::Decreasing;
use Chart::Plotly::Trace::Attribute::Increasing;
use Chart::Plotly::Trace::Attribute::Line;

our $VERSION = '0.013';    # VERSION

sub TO_JSON {
    my $self       = shift;
    my $extra_args = $self->extra_args // {};
    my %hash       = ( %$self, %$extra_args );
    delete $hash{'extra_args'};
    if ( $self->can('type') && ( !defined $hash{'type'} ) ) {
        $hash{type} = $self->type();
    }
    return \%hash;
}

has close => ( is            => 'rw',
               documentation => "Sets the close values.", );

has decreasing => ( is  => 'rw',
                    isa => "Maybe[HashRef]|Chart::Plotly::Trace::Attribute::Decreasing" );

has high => ( is            => 'rw',
              documentation => "Sets the high values.", );

has increasing => ( is  => 'rw',
                    isa => "Maybe[HashRef]|Chart::Plotly::Trace::Attribute::Increasing" );

has line => ( is  => 'rw',
              isa => "Maybe[HashRef]|Chart::Plotly::Trace::Attribute::Line" );

has low => ( is            => 'rw',
             documentation => "Sets the low values.", );

has open => ( is            => 'rw',
              documentation => "Sets the open values.", );

has text => (
    is  => 'rw',
    isa => "Maybe[ArrayRef]|Str",
    documentation =>
      "Sets hover text elements associated with each sample point. If a single string, the same string appears over all the data points. If an array of string, the items are mapped in order to this trace's sample points.",
);

has tickwidth => ( is            => 'rw',
                   isa           => "Num",
                   documentation => "Sets the width of the open/close tick marks relative to the *x* minimal interval.",
);

has x => ( is            => 'rw',
           documentation => "Sets the x coordinates. If absent, linear coordinate will be generated.", );

has name => ( is            => 'rw',
              isa           => "Str",
              documentation => "Sets the trace name",
);

sub type {
    my @components = split( /::/, __PACKAGE__ );
    return lc( $components[-1] );
}

__PACKAGE__->meta->make_immutable();
1;

__END__

=pod

=encoding utf-8

=head1 NAME

Chart::Plotly::Trace::Ohlc

=head1 VERSION

version 0.013

=head1 SYNOPSIS

 use HTML::Show;
 use Chart::Plotly;
 use Chart::Plotly::Trace::Ohlc;
 my $ohlc = Chart::Plotly::Trace::Ohlc->new( x => [ 1 .. 5 ], y => [ 1 .. 5 ] );
 
 HTML::Show::show( Chart::Plotly::render_full_html( data => [$ohlc] ) );

=head1 DESCRIPTION

This file has been autogenerated from the official plotly.js source.

If you like Plotly, please support them: L<https://plot.ly/> 
Open source announcement: L<https://plot.ly/javascript/open-source-announcement/>

Full reference: L<https://plot.ly/javascript/reference/#ohlc>

=head1 NAME 

Chart::Plotly::Trace::Ohlc

=head1 DISCLAIMER

This is an unofficial Plotly Perl module. Currently I'm not affiliated in any way with Plotly. 
But I think plotly.js is a great library and I want to use it with perl.

=head1 METHODS

=head2 TO_JSON

Serialize the trace to JSON. This method should be called only by L<JSON> serializer.

=head1 ATTRIBUTES

=over

=item * close

Sets the close values.

=item * decreasing

=item * high

Sets the high values.

=item * increasing

=item * line

=item * low

Sets the low values.

=item * open

Sets the open values.

=item * text

Sets hover text elements associated with each sample point. If a single string, the same string appears over all the data points. If an array of string, the items are mapped in order to this trace's sample points.

=item * tickwidth

Sets the width of the open/close tick marks relative to the *x* minimal interval.

=item * x

Sets the x coordinates. If absent, linear coordinate will be generated.

=item * name

Sets the trace name

=back

=head2 type

Trace type.

=head1 AUTHOR

Pablo Rodríguez González <pablo.rodriguez.gonzalez@gmail.com>

=head1 COPYRIGHT AND LICENSE

Copyright (c) 2017 by Pablo Rodríguez González.

This is free software, licensed under:

  The MIT (X11) License

=cut
