package #
Date::Manip::TZ::euchis00;
# Copyright (c) 2008-2018 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Wed May 30 14:49:29 EDT 2018
#    Data version: tzdata2018e
#    Code version: tzcode2018e

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://ftp.iana.org/tz

use strict;
use warnings;
require 5.010000;

our (%Dates,%LastRule);
END {
   undef %Dates;
   undef %LastRule;
}

our ($VERSION);
$VERSION='6.73';
END { undef $VERSION; }

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,2,1,55,20],'+01:55:20',[1,55,20],
          'LMT',0,[1879,12,31,22,4,39],[1879,12,31,23,59,59],
          '0001010200:00:00','0001010201:55:20','1879123122:04:39','1879123123:59:59' ],
     ],
   1879 =>
     [
        [ [1879,12,31,22,4,40],[1879,12,31,23,59,40],'+01:55:00',[1,55,0],
          'CMT',0,[1918,2,14,22,4,59],[1918,2,14,23,59,59],
          '1879123122:04:40','1879123123:59:40','1918021422:04:59','1918021423:59:59' ],
     ],
   1918 =>
     [
        [ [1918,2,14,22,5,0],[1918,2,14,23,49,24],'+01:44:24',[1,44,24],
          'BMT',0,[1931,7,23,22,15,35],[1931,7,23,23,59,59],
          '1918021422:05:00','1918021423:49:24','1931072322:15:35','1931072323:59:59' ],
     ],
   1931 =>
     [
        [ [1931,7,23,22,15,36],[1931,7,24,0,15,36],'+02:00:00',[2,0,0],
          'EET',0,[1932,5,20,21,59,59],[1932,5,20,23,59,59],
          '1931072322:15:36','1931072400:15:36','1932052021:59:59','1932052023:59:59' ],
     ],
   1932 =>
     [
        [ [1932,5,20,22,0,0],[1932,5,21,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1932,10,1,21,59,59],[1932,10,2,0,59,59],
          '1932052022:00:00','1932052101:00:00','1932100121:59:59','1932100200:59:59' ],
        [ [1932,10,1,22,0,0],[1932,10,2,0,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1933,4,1,21,59,59],[1933,4,1,23,59,59],
          '1932100122:00:00','1932100200:00:00','1933040121:59:59','1933040123:59:59' ],
     ],
   1933 =>
     [
        [ [1933,4,1,22,0,0],[1933,4,2,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1933,9,30,21,59,59],[1933,10,1,0,59,59],
          '1933040122:00:00','1933040201:00:00','1933093021:59:59','1933100100:59:59' ],
        [ [1933,9,30,22,0,0],[1933,10,1,0,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1934,4,7,21,59,59],[1934,4,7,23,59,59],
          '1933093022:00:00','1933100100:00:00','1934040721:59:59','1934040723:59:59' ],
     ],
   1934 =>
     [
        [ [1934,4,7,22,0,0],[1934,4,8,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1934,10,6,21,59,59],[1934,10,7,0,59,59],
          '1934040722:00:00','1934040801:00:00','1934100621:59:59','1934100700:59:59' ],
        [ [1934,10,6,22,0,0],[1934,10,7,0,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1935,4,6,21,59,59],[1935,4,6,23,59,59],
          '1934100622:00:00','1934100700:00:00','1935040621:59:59','1935040623:59:59' ],
     ],
   1935 =>
     [
        [ [1935,4,6,22,0,0],[1935,4,7,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1935,10,5,21,59,59],[1935,10,6,0,59,59],
          '1935040622:00:00','1935040701:00:00','1935100521:59:59','1935100600:59:59' ],
        [ [1935,10,5,22,0,0],[1935,10,6,0,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1936,4,4,21,59,59],[1936,4,4,23,59,59],
          '1935100522:00:00','1935100600:00:00','1936040421:59:59','1936040423:59:59' ],
     ],
   1936 =>
     [
        [ [1936,4,4,22,0,0],[1936,4,5,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1936,10,3,21,59,59],[1936,10,4,0,59,59],
          '1936040422:00:00','1936040501:00:00','1936100321:59:59','1936100400:59:59' ],
        [ [1936,10,3,22,0,0],[1936,10,4,0,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1937,4,3,21,59,59],[1937,4,3,23,59,59],
          '1936100322:00:00','1936100400:00:00','1937040321:59:59','1937040323:59:59' ],
     ],
   1937 =>
     [
        [ [1937,4,3,22,0,0],[1937,4,4,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1937,10,2,21,59,59],[1937,10,3,0,59,59],
          '1937040322:00:00','1937040401:00:00','1937100221:59:59','1937100300:59:59' ],
        [ [1937,10,2,22,0,0],[1937,10,3,0,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1938,4,2,21,59,59],[1938,4,2,23,59,59],
          '1937100222:00:00','1937100300:00:00','1938040221:59:59','1938040223:59:59' ],
     ],
   1938 =>
     [
        [ [1938,4,2,22,0,0],[1938,4,3,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1938,10,1,21,59,59],[1938,10,2,0,59,59],
          '1938040222:00:00','1938040301:00:00','1938100121:59:59','1938100200:59:59' ],
        [ [1938,10,1,22,0,0],[1938,10,2,0,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1939,4,1,21,59,59],[1939,4,1,23,59,59],
          '1938100122:00:00','1938100200:00:00','1939040121:59:59','1939040123:59:59' ],
     ],
   1939 =>
     [
        [ [1939,4,1,22,0,0],[1939,4,2,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1939,9,30,21,59,59],[1939,10,1,0,59,59],
          '1939040122:00:00','1939040201:00:00','1939093021:59:59','1939100100:59:59' ],
        [ [1939,9,30,22,0,0],[1939,10,1,0,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1940,8,14,21,59,59],[1940,8,14,23,59,59],
          '1939093022:00:00','1939100100:00:00','1940081421:59:59','1940081423:59:59' ],
     ],
   1940 =>
     [
        [ [1940,8,14,22,0,0],[1940,8,15,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1941,7,16,20,59,59],[1941,7,16,23,59,59],
          '1940081422:00:00','1940081501:00:00','1941071620:59:59','1941071623:59:59' ],
     ],
   1941 =>
     [
        [ [1941,7,16,21,0,0],[1941,7,16,23,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1942,11,2,0,59,59],[1942,11,2,2,59,59],
          '1941071621:00:00','1941071623:00:00','1942110200:59:59','1942110202:59:59' ],
     ],
   1942 =>
     [
        [ [1942,11,2,1,0,0],[1942,11,2,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1943,3,29,0,59,59],[1943,3,29,1,59,59],
          '1942110201:00:00','1942110202:00:00','1943032900:59:59','1943032901:59:59' ],
     ],
   1943 =>
     [
        [ [1943,3,29,1,0,0],[1943,3,29,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1943,10,4,0,59,59],[1943,10,4,2,59,59],
          '1943032901:00:00','1943032903:00:00','1943100400:59:59','1943100402:59:59' ],
        [ [1943,10,4,1,0,0],[1943,10,4,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1944,4,3,0,59,59],[1944,4,3,1,59,59],
          '1943100401:00:00','1943100402:00:00','1944040300:59:59','1944040301:59:59' ],
     ],
   1944 =>
     [
        [ [1944,4,3,1,0,0],[1944,4,3,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1944,8,23,21,59,59],[1944,8,23,23,59,59],
          '1944040301:00:00','1944040303:00:00','1944082321:59:59','1944082323:59:59' ],
        [ [1944,8,23,22,0,0],[1944,8,24,1,0,0],'+03:00:00',[3,0,0],
          'MSK',0,[1981,3,31,20,59,59],[1981,3,31,23,59,59],
          '1944082322:00:00','1944082401:00:00','1981033120:59:59','1981033123:59:59' ],
     ],
   1981 =>
     [
        [ [1981,3,31,21,0,0],[1981,4,1,1,0,0],'+04:00:00',[4,0,0],
          'MSD',1,[1981,9,30,19,59,59],[1981,9,30,23,59,59],
          '1981033121:00:00','1981040101:00:00','1981093019:59:59','1981093023:59:59' ],
        [ [1981,9,30,20,0,0],[1981,9,30,23,0,0],'+03:00:00',[3,0,0],
          'MSK',0,[1982,3,31,20,59,59],[1982,3,31,23,59,59],
          '1981093020:00:00','1981093023:00:00','1982033120:59:59','1982033123:59:59' ],
     ],
   1982 =>
     [
        [ [1982,3,31,21,0,0],[1982,4,1,1,0,0],'+04:00:00',[4,0,0],
          'MSD',1,[1982,9,30,19,59,59],[1982,9,30,23,59,59],
          '1982033121:00:00','1982040101:00:00','1982093019:59:59','1982093023:59:59' ],
        [ [1982,9,30,20,0,0],[1982,9,30,23,0,0],'+03:00:00',[3,0,0],
          'MSK',0,[1983,3,31,20,59,59],[1983,3,31,23,59,59],
          '1982093020:00:00','1982093023:00:00','1983033120:59:59','1983033123:59:59' ],
     ],
   1983 =>
     [
        [ [1983,3,31,21,0,0],[1983,4,1,1,0,0],'+04:00:00',[4,0,0],
          'MSD',1,[1983,9,30,19,59,59],[1983,9,30,23,59,59],
          '1983033121:00:00','1983040101:00:00','1983093019:59:59','1983093023:59:59' ],
        [ [1983,9,30,20,0,0],[1983,9,30,23,0,0],'+03:00:00',[3,0,0],
          'MSK',0,[1984,3,31,20,59,59],[1984,3,31,23,59,59],
          '1983093020:00:00','1983093023:00:00','1984033120:59:59','1984033123:59:59' ],
     ],
   1984 =>
     [
        [ [1984,3,31,21,0,0],[1984,4,1,1,0,0],'+04:00:00',[4,0,0],
          'MSD',1,[1984,9,29,22,59,59],[1984,9,30,2,59,59],
          '1984033121:00:00','1984040101:00:00','1984092922:59:59','1984093002:59:59' ],
        [ [1984,9,29,23,0,0],[1984,9,30,2,0,0],'+03:00:00',[3,0,0],
          'MSK',0,[1985,3,30,22,59,59],[1985,3,31,1,59,59],
          '1984092923:00:00','1984093002:00:00','1985033022:59:59','1985033101:59:59' ],
     ],
   1985 =>
     [
        [ [1985,3,30,23,0,0],[1985,3,31,3,0,0],'+04:00:00',[4,0,0],
          'MSD',1,[1985,9,28,22,59,59],[1985,9,29,2,59,59],
          '1985033023:00:00','1985033103:00:00','1985092822:59:59','1985092902:59:59' ],
        [ [1985,9,28,23,0,0],[1985,9,29,2,0,0],'+03:00:00',[3,0,0],
          'MSK',0,[1986,3,29,22,59,59],[1986,3,30,1,59,59],
          '1985092823:00:00','1985092902:00:00','1986032922:59:59','1986033001:59:59' ],
     ],
   1986 =>
     [
        [ [1986,3,29,23,0,0],[1986,3,30,3,0,0],'+04:00:00',[4,0,0],
          'MSD',1,[1986,9,27,22,59,59],[1986,9,28,2,59,59],
          '1986032923:00:00','1986033003:00:00','1986092722:59:59','1986092802:59:59' ],
        [ [1986,9,27,23,0,0],[1986,9,28,2,0,0],'+03:00:00',[3,0,0],
          'MSK',0,[1987,3,28,22,59,59],[1987,3,29,1,59,59],
          '1986092723:00:00','1986092802:00:00','1987032822:59:59','1987032901:59:59' ],
     ],
   1987 =>
     [
        [ [1987,3,28,23,0,0],[1987,3,29,3,0,0],'+04:00:00',[4,0,0],
          'MSD',1,[1987,9,26,22,59,59],[1987,9,27,2,59,59],
          '1987032823:00:00','1987032903:00:00','1987092622:59:59','1987092702:59:59' ],
        [ [1987,9,26,23,0,0],[1987,9,27,2,0,0],'+03:00:00',[3,0,0],
          'MSK',0,[1988,3,26,22,59,59],[1988,3,27,1,59,59],
          '1987092623:00:00','1987092702:00:00','1988032622:59:59','1988032701:59:59' ],
     ],
   1988 =>
     [
        [ [1988,3,26,23,0,0],[1988,3,27,3,0,0],'+04:00:00',[4,0,0],
          'MSD',1,[1988,9,24,22,59,59],[1988,9,25,2,59,59],
          '1988032623:00:00','1988032703:00:00','1988092422:59:59','1988092502:59:59' ],
        [ [1988,9,24,23,0,0],[1988,9,25,2,0,0],'+03:00:00',[3,0,0],
          'MSK',0,[1989,3,25,22,59,59],[1989,3,26,1,59,59],
          '1988092423:00:00','1988092502:00:00','1989032522:59:59','1989032601:59:59' ],
     ],
   1989 =>
     [
        [ [1989,3,25,23,0,0],[1989,3,26,3,0,0],'+04:00:00',[4,0,0],
          'MSD',1,[1989,9,23,22,59,59],[1989,9,24,2,59,59],
          '1989032523:00:00','1989032603:00:00','1989092322:59:59','1989092402:59:59' ],
        [ [1989,9,23,23,0,0],[1989,9,24,2,0,0],'+03:00:00',[3,0,0],
          'MSK',0,[1990,3,24,22,59,59],[1990,3,25,1,59,59],
          '1989092323:00:00','1989092402:00:00','1990032422:59:59','1990032501:59:59' ],
     ],
   1990 =>
     [
        [ [1990,3,24,23,0,0],[1990,3,25,3,0,0],'+04:00:00',[4,0,0],
          'MSD',1,[1990,5,5,21,59,59],[1990,5,6,1,59,59],
          '1990032423:00:00','1990032503:00:00','1990050521:59:59','1990050601:59:59' ],
        [ [1990,5,5,22,0,0],[1990,5,6,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1990,9,29,23,59,59],[1990,9,30,2,59,59],
          '1990050522:00:00','1990050601:00:00','1990092923:59:59','1990093002:59:59' ],
        [ [1990,9,30,0,0,0],[1990,9,30,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1991,3,30,23,59,59],[1991,3,31,1,59,59],
          '1990093000:00:00','1990093002:00:00','1991033023:59:59','1991033101:59:59' ],
     ],
   1991 =>
     [
        [ [1991,3,31,0,0,0],[1991,3,31,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1991,9,28,23,59,59],[1991,9,29,2,59,59],
          '1991033100:00:00','1991033103:00:00','1991092823:59:59','1991092902:59:59' ],
        [ [1991,9,29,0,0,0],[1991,9,29,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1992,3,28,21,59,59],[1992,3,28,23,59,59],
          '1991092900:00:00','1991092902:00:00','1992032821:59:59','1992032823:59:59' ],
     ],
   1992 =>
     [
        [ [1992,3,28,22,0,0],[1992,3,29,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1992,9,26,20,59,59],[1992,9,26,23,59,59],
          '1992032822:00:00','1992032901:00:00','1992092620:59:59','1992092623:59:59' ],
        [ [1992,9,26,21,0,0],[1992,9,26,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1993,3,27,21,59,59],[1993,3,27,23,59,59],
          '1992092621:00:00','1992092623:00:00','1993032721:59:59','1993032723:59:59' ],
     ],
   1993 =>
     [
        [ [1993,3,27,22,0,0],[1993,3,28,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1993,9,25,20,59,59],[1993,9,25,23,59,59],
          '1993032722:00:00','1993032801:00:00','1993092520:59:59','1993092523:59:59' ],
        [ [1993,9,25,21,0,0],[1993,9,25,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1994,3,26,21,59,59],[1994,3,26,23,59,59],
          '1993092521:00:00','1993092523:00:00','1994032621:59:59','1994032623:59:59' ],
     ],
   1994 =>
     [
        [ [1994,3,26,22,0,0],[1994,3,27,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1994,9,24,20,59,59],[1994,9,24,23,59,59],
          '1994032622:00:00','1994032701:00:00','1994092420:59:59','1994092423:59:59' ],
        [ [1994,9,24,21,0,0],[1994,9,24,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1995,3,25,21,59,59],[1995,3,25,23,59,59],
          '1994092421:00:00','1994092423:00:00','1995032521:59:59','1995032523:59:59' ],
     ],
   1995 =>
     [
        [ [1995,3,25,22,0,0],[1995,3,26,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1995,9,23,20,59,59],[1995,9,23,23,59,59],
          '1995032522:00:00','1995032601:00:00','1995092320:59:59','1995092323:59:59' ],
        [ [1995,9,23,21,0,0],[1995,9,23,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1996,3,30,21,59,59],[1996,3,30,23,59,59],
          '1995092321:00:00','1995092323:00:00','1996033021:59:59','1996033023:59:59' ],
     ],
   1996 =>
     [
        [ [1996,3,30,22,0,0],[1996,3,31,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1996,10,26,20,59,59],[1996,10,26,23,59,59],
          '1996033022:00:00','1996033101:00:00','1996102620:59:59','1996102623:59:59' ],
        [ [1996,10,26,21,0,0],[1996,10,26,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1997,3,29,23,59,59],[1997,3,30,1,59,59],
          '1996102621:00:00','1996102623:00:00','1997032923:59:59','1997033001:59:59' ],
     ],
   1997 =>
     [
        [ [1997,3,30,0,0,0],[1997,3,30,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1997,10,25,23,59,59],[1997,10,26,2,59,59],
          '1997033000:00:00','1997033003:00:00','1997102523:59:59','1997102602:59:59' ],
        [ [1997,10,26,0,0,0],[1997,10,26,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1998,3,28,23,59,59],[1998,3,29,1,59,59],
          '1997102600:00:00','1997102602:00:00','1998032823:59:59','1998032901:59:59' ],
     ],
   1998 =>
     [
        [ [1998,3,29,0,0,0],[1998,3,29,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1998,10,24,23,59,59],[1998,10,25,2,59,59],
          '1998032900:00:00','1998032903:00:00','1998102423:59:59','1998102502:59:59' ],
        [ [1998,10,25,0,0,0],[1998,10,25,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1999,3,27,23,59,59],[1999,3,28,1,59,59],
          '1998102500:00:00','1998102502:00:00','1999032723:59:59','1999032801:59:59' ],
     ],
   1999 =>
     [
        [ [1999,3,28,0,0,0],[1999,3,28,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1999,10,30,23,59,59],[1999,10,31,2,59,59],
          '1999032800:00:00','1999032803:00:00','1999103023:59:59','1999103102:59:59' ],
        [ [1999,10,31,0,0,0],[1999,10,31,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2000,3,25,23,59,59],[2000,3,26,1,59,59],
          '1999103100:00:00','1999103102:00:00','2000032523:59:59','2000032601:59:59' ],
     ],
   2000 =>
     [
        [ [2000,3,26,0,0,0],[2000,3,26,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2000,10,28,23,59,59],[2000,10,29,2,59,59],
          '2000032600:00:00','2000032603:00:00','2000102823:59:59','2000102902:59:59' ],
        [ [2000,10,29,0,0,0],[2000,10,29,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2001,3,24,23,59,59],[2001,3,25,1,59,59],
          '2000102900:00:00','2000102902:00:00','2001032423:59:59','2001032501:59:59' ],
     ],
   2001 =>
     [
        [ [2001,3,25,0,0,0],[2001,3,25,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2001,10,27,23,59,59],[2001,10,28,2,59,59],
          '2001032500:00:00','2001032503:00:00','2001102723:59:59','2001102802:59:59' ],
        [ [2001,10,28,0,0,0],[2001,10,28,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2002,3,30,23,59,59],[2002,3,31,1,59,59],
          '2001102800:00:00','2001102802:00:00','2002033023:59:59','2002033101:59:59' ],
     ],
   2002 =>
     [
        [ [2002,3,31,0,0,0],[2002,3,31,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2002,10,26,23,59,59],[2002,10,27,2,59,59],
          '2002033100:00:00','2002033103:00:00','2002102623:59:59','2002102702:59:59' ],
        [ [2002,10,27,0,0,0],[2002,10,27,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2003,3,29,23,59,59],[2003,3,30,1,59,59],
          '2002102700:00:00','2002102702:00:00','2003032923:59:59','2003033001:59:59' ],
     ],
   2003 =>
     [
        [ [2003,3,30,0,0,0],[2003,3,30,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2003,10,25,23,59,59],[2003,10,26,2,59,59],
          '2003033000:00:00','2003033003:00:00','2003102523:59:59','2003102602:59:59' ],
        [ [2003,10,26,0,0,0],[2003,10,26,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2004,3,27,23,59,59],[2004,3,28,1,59,59],
          '2003102600:00:00','2003102602:00:00','2004032723:59:59','2004032801:59:59' ],
     ],
   2004 =>
     [
        [ [2004,3,28,0,0,0],[2004,3,28,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2004,10,30,23,59,59],[2004,10,31,2,59,59],
          '2004032800:00:00','2004032803:00:00','2004103023:59:59','2004103102:59:59' ],
        [ [2004,10,31,0,0,0],[2004,10,31,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2005,3,26,23,59,59],[2005,3,27,1,59,59],
          '2004103100:00:00','2004103102:00:00','2005032623:59:59','2005032701:59:59' ],
     ],
   2005 =>
     [
        [ [2005,3,27,0,0,0],[2005,3,27,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2005,10,29,23,59,59],[2005,10,30,2,59,59],
          '2005032700:00:00','2005032703:00:00','2005102923:59:59','2005103002:59:59' ],
        [ [2005,10,30,0,0,0],[2005,10,30,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2006,3,25,23,59,59],[2006,3,26,1,59,59],
          '2005103000:00:00','2005103002:00:00','2006032523:59:59','2006032601:59:59' ],
     ],
   2006 =>
     [
        [ [2006,3,26,0,0,0],[2006,3,26,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2006,10,28,23,59,59],[2006,10,29,2,59,59],
          '2006032600:00:00','2006032603:00:00','2006102823:59:59','2006102902:59:59' ],
        [ [2006,10,29,0,0,0],[2006,10,29,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2007,3,24,23,59,59],[2007,3,25,1,59,59],
          '2006102900:00:00','2006102902:00:00','2007032423:59:59','2007032501:59:59' ],
     ],
   2007 =>
     [
        [ [2007,3,25,0,0,0],[2007,3,25,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2007,10,27,23,59,59],[2007,10,28,2,59,59],
          '2007032500:00:00','2007032503:00:00','2007102723:59:59','2007102802:59:59' ],
        [ [2007,10,28,0,0,0],[2007,10,28,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2008,3,29,23,59,59],[2008,3,30,1,59,59],
          '2007102800:00:00','2007102802:00:00','2008032923:59:59','2008033001:59:59' ],
     ],
   2008 =>
     [
        [ [2008,3,30,0,0,0],[2008,3,30,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2008,10,25,23,59,59],[2008,10,26,2,59,59],
          '2008033000:00:00','2008033003:00:00','2008102523:59:59','2008102602:59:59' ],
        [ [2008,10,26,0,0,0],[2008,10,26,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2009,3,28,23,59,59],[2009,3,29,1,59,59],
          '2008102600:00:00','2008102602:00:00','2009032823:59:59','2009032901:59:59' ],
     ],
   2009 =>
     [
        [ [2009,3,29,0,0,0],[2009,3,29,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2009,10,24,23,59,59],[2009,10,25,2,59,59],
          '2009032900:00:00','2009032903:00:00','2009102423:59:59','2009102502:59:59' ],
        [ [2009,10,25,0,0,0],[2009,10,25,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2010,3,27,23,59,59],[2010,3,28,1,59,59],
          '2009102500:00:00','2009102502:00:00','2010032723:59:59','2010032801:59:59' ],
     ],
   2010 =>
     [
        [ [2010,3,28,0,0,0],[2010,3,28,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2010,10,30,23,59,59],[2010,10,31,2,59,59],
          '2010032800:00:00','2010032803:00:00','2010103023:59:59','2010103102:59:59' ],
        [ [2010,10,31,0,0,0],[2010,10,31,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2011,3,26,23,59,59],[2011,3,27,1,59,59],
          '2010103100:00:00','2010103102:00:00','2011032623:59:59','2011032701:59:59' ],
     ],
   2011 =>
     [
        [ [2011,3,27,0,0,0],[2011,3,27,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2011,10,29,23,59,59],[2011,10,30,2,59,59],
          '2011032700:00:00','2011032703:00:00','2011102923:59:59','2011103002:59:59' ],
        [ [2011,10,30,0,0,0],[2011,10,30,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2012,3,24,23,59,59],[2012,3,25,1,59,59],
          '2011103000:00:00','2011103002:00:00','2012032423:59:59','2012032501:59:59' ],
     ],
   2012 =>
     [
        [ [2012,3,25,0,0,0],[2012,3,25,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2012,10,27,23,59,59],[2012,10,28,2,59,59],
          '2012032500:00:00','2012032503:00:00','2012102723:59:59','2012102802:59:59' ],
        [ [2012,10,28,0,0,0],[2012,10,28,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2013,3,30,23,59,59],[2013,3,31,1,59,59],
          '2012102800:00:00','2012102802:00:00','2013033023:59:59','2013033101:59:59' ],
     ],
   2013 =>
     [
        [ [2013,3,31,0,0,0],[2013,3,31,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2013,10,26,23,59,59],[2013,10,27,2,59,59],
          '2013033100:00:00','2013033103:00:00','2013102623:59:59','2013102702:59:59' ],
        [ [2013,10,27,0,0,0],[2013,10,27,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2014,3,29,23,59,59],[2014,3,30,1,59,59],
          '2013102700:00:00','2013102702:00:00','2014032923:59:59','2014033001:59:59' ],
     ],
   2014 =>
     [
        [ [2014,3,30,0,0,0],[2014,3,30,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2014,10,25,23,59,59],[2014,10,26,2,59,59],
          '2014033000:00:00','2014033003:00:00','2014102523:59:59','2014102602:59:59' ],
        [ [2014,10,26,0,0,0],[2014,10,26,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2015,3,28,23,59,59],[2015,3,29,1,59,59],
          '2014102600:00:00','2014102602:00:00','2015032823:59:59','2015032901:59:59' ],
     ],
   2015 =>
     [
        [ [2015,3,29,0,0,0],[2015,3,29,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2015,10,24,23,59,59],[2015,10,25,2,59,59],
          '2015032900:00:00','2015032903:00:00','2015102423:59:59','2015102502:59:59' ],
        [ [2015,10,25,0,0,0],[2015,10,25,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2016,3,26,23,59,59],[2016,3,27,1,59,59],
          '2015102500:00:00','2015102502:00:00','2016032623:59:59','2016032701:59:59' ],
     ],
   2016 =>
     [
        [ [2016,3,27,0,0,0],[2016,3,27,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2016,10,29,23,59,59],[2016,10,30,2,59,59],
          '2016032700:00:00','2016032703:00:00','2016102923:59:59','2016103002:59:59' ],
        [ [2016,10,30,0,0,0],[2016,10,30,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2017,3,25,23,59,59],[2017,3,26,1,59,59],
          '2016103000:00:00','2016103002:00:00','2017032523:59:59','2017032601:59:59' ],
     ],
   2017 =>
     [
        [ [2017,3,26,0,0,0],[2017,3,26,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2017,10,28,23,59,59],[2017,10,29,2,59,59],
          '2017032600:00:00','2017032603:00:00','2017102823:59:59','2017102902:59:59' ],
        [ [2017,10,29,0,0,0],[2017,10,29,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2018,3,24,23,59,59],[2018,3,25,1,59,59],
          '2017102900:00:00','2017102902:00:00','2018032423:59:59','2018032501:59:59' ],
     ],
   2018 =>
     [
        [ [2018,3,25,0,0,0],[2018,3,25,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2018,10,27,23,59,59],[2018,10,28,2,59,59],
          '2018032500:00:00','2018032503:00:00','2018102723:59:59','2018102802:59:59' ],
        [ [2018,10,28,0,0,0],[2018,10,28,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2019,3,30,23,59,59],[2019,3,31,1,59,59],
          '2018102800:00:00','2018102802:00:00','2019033023:59:59','2019033101:59:59' ],
     ],
   2019 =>
     [
        [ [2019,3,31,0,0,0],[2019,3,31,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2019,10,26,23,59,59],[2019,10,27,2,59,59],
          '2019033100:00:00','2019033103:00:00','2019102623:59:59','2019102702:59:59' ],
        [ [2019,10,27,0,0,0],[2019,10,27,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2020,3,28,23,59,59],[2020,3,29,1,59,59],
          '2019102700:00:00','2019102702:00:00','2020032823:59:59','2020032901:59:59' ],
     ],
   2020 =>
     [
        [ [2020,3,29,0,0,0],[2020,3,29,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2020,10,24,23,59,59],[2020,10,25,2,59,59],
          '2020032900:00:00','2020032903:00:00','2020102423:59:59','2020102502:59:59' ],
        [ [2020,10,25,0,0,0],[2020,10,25,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2021,3,27,23,59,59],[2021,3,28,1,59,59],
          '2020102500:00:00','2020102502:00:00','2021032723:59:59','2021032801:59:59' ],
     ],
   2021 =>
     [
        [ [2021,3,28,0,0,0],[2021,3,28,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2021,10,30,23,59,59],[2021,10,31,2,59,59],
          '2021032800:00:00','2021032803:00:00','2021103023:59:59','2021103102:59:59' ],
        [ [2021,10,31,0,0,0],[2021,10,31,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2022,3,26,23,59,59],[2022,3,27,1,59,59],
          '2021103100:00:00','2021103102:00:00','2022032623:59:59','2022032701:59:59' ],
     ],
   2022 =>
     [
        [ [2022,3,27,0,0,0],[2022,3,27,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2022,10,29,23,59,59],[2022,10,30,2,59,59],
          '2022032700:00:00','2022032703:00:00','2022102923:59:59','2022103002:59:59' ],
        [ [2022,10,30,0,0,0],[2022,10,30,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2023,3,25,23,59,59],[2023,3,26,1,59,59],
          '2022103000:00:00','2022103002:00:00','2023032523:59:59','2023032601:59:59' ],
     ],
   2023 =>
     [
        [ [2023,3,26,0,0,0],[2023,3,26,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2023,10,28,23,59,59],[2023,10,29,2,59,59],
          '2023032600:00:00','2023032603:00:00','2023102823:59:59','2023102902:59:59' ],
        [ [2023,10,29,0,0,0],[2023,10,29,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2024,3,30,23,59,59],[2024,3,31,1,59,59],
          '2023102900:00:00','2023102902:00:00','2024033023:59:59','2024033101:59:59' ],
     ],
   2024 =>
     [
        [ [2024,3,31,0,0,0],[2024,3,31,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2024,10,26,23,59,59],[2024,10,27,2,59,59],
          '2024033100:00:00','2024033103:00:00','2024102623:59:59','2024102702:59:59' ],
        [ [2024,10,27,0,0,0],[2024,10,27,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2025,3,29,23,59,59],[2025,3,30,1,59,59],
          '2024102700:00:00','2024102702:00:00','2025032923:59:59','2025033001:59:59' ],
     ],
   2025 =>
     [
        [ [2025,3,30,0,0,0],[2025,3,30,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2025,10,25,23,59,59],[2025,10,26,2,59,59],
          '2025033000:00:00','2025033003:00:00','2025102523:59:59','2025102602:59:59' ],
        [ [2025,10,26,0,0,0],[2025,10,26,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2026,3,28,23,59,59],[2026,3,29,1,59,59],
          '2025102600:00:00','2025102602:00:00','2026032823:59:59','2026032901:59:59' ],
     ],
   2026 =>
     [
        [ [2026,3,29,0,0,0],[2026,3,29,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2026,10,24,23,59,59],[2026,10,25,2,59,59],
          '2026032900:00:00','2026032903:00:00','2026102423:59:59','2026102502:59:59' ],
        [ [2026,10,25,0,0,0],[2026,10,25,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2027,3,27,23,59,59],[2027,3,28,1,59,59],
          '2026102500:00:00','2026102502:00:00','2027032723:59:59','2027032801:59:59' ],
     ],
   2027 =>
     [
        [ [2027,3,28,0,0,0],[2027,3,28,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2027,10,30,23,59,59],[2027,10,31,2,59,59],
          '2027032800:00:00','2027032803:00:00','2027103023:59:59','2027103102:59:59' ],
        [ [2027,10,31,0,0,0],[2027,10,31,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2028,3,25,23,59,59],[2028,3,26,1,59,59],
          '2027103100:00:00','2027103102:00:00','2028032523:59:59','2028032601:59:59' ],
     ],
   2028 =>
     [
        [ [2028,3,26,0,0,0],[2028,3,26,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2028,10,28,23,59,59],[2028,10,29,2,59,59],
          '2028032600:00:00','2028032603:00:00','2028102823:59:59','2028102902:59:59' ],
        [ [2028,10,29,0,0,0],[2028,10,29,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2029,3,24,23,59,59],[2029,3,25,1,59,59],
          '2028102900:00:00','2028102902:00:00','2029032423:59:59','2029032501:59:59' ],
     ],
   2029 =>
     [
        [ [2029,3,25,0,0,0],[2029,3,25,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2029,10,27,23,59,59],[2029,10,28,2,59,59],
          '2029032500:00:00','2029032503:00:00','2029102723:59:59','2029102802:59:59' ],
        [ [2029,10,28,0,0,0],[2029,10,28,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2030,3,30,23,59,59],[2030,3,31,1,59,59],
          '2029102800:00:00','2029102802:00:00','2030033023:59:59','2030033101:59:59' ],
     ],
   2030 =>
     [
        [ [2030,3,31,0,0,0],[2030,3,31,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2030,10,26,23,59,59],[2030,10,27,2,59,59],
          '2030033100:00:00','2030033103:00:00','2030102623:59:59','2030102702:59:59' ],
        [ [2030,10,27,0,0,0],[2030,10,27,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2031,3,29,23,59,59],[2031,3,30,1,59,59],
          '2030102700:00:00','2030102702:00:00','2031032923:59:59','2031033001:59:59' ],
     ],
   2031 =>
     [
        [ [2031,3,30,0,0,0],[2031,3,30,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2031,10,25,23,59,59],[2031,10,26,2,59,59],
          '2031033000:00:00','2031033003:00:00','2031102523:59:59','2031102602:59:59' ],
        [ [2031,10,26,0,0,0],[2031,10,26,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2032,3,27,23,59,59],[2032,3,28,1,59,59],
          '2031102600:00:00','2031102602:00:00','2032032723:59:59','2032032801:59:59' ],
     ],
   2032 =>
     [
        [ [2032,3,28,0,0,0],[2032,3,28,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2032,10,30,23,59,59],[2032,10,31,2,59,59],
          '2032032800:00:00','2032032803:00:00','2032103023:59:59','2032103102:59:59' ],
        [ [2032,10,31,0,0,0],[2032,10,31,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2033,3,26,23,59,59],[2033,3,27,1,59,59],
          '2032103100:00:00','2032103102:00:00','2033032623:59:59','2033032701:59:59' ],
     ],
   2033 =>
     [
        [ [2033,3,27,0,0,0],[2033,3,27,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2033,10,29,23,59,59],[2033,10,30,2,59,59],
          '2033032700:00:00','2033032703:00:00','2033102923:59:59','2033103002:59:59' ],
        [ [2033,10,30,0,0,0],[2033,10,30,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2034,3,25,23,59,59],[2034,3,26,1,59,59],
          '2033103000:00:00','2033103002:00:00','2034032523:59:59','2034032601:59:59' ],
     ],
   2034 =>
     [
        [ [2034,3,26,0,0,0],[2034,3,26,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2034,10,28,23,59,59],[2034,10,29,2,59,59],
          '2034032600:00:00','2034032603:00:00','2034102823:59:59','2034102902:59:59' ],
        [ [2034,10,29,0,0,0],[2034,10,29,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2035,3,24,23,59,59],[2035,3,25,1,59,59],
          '2034102900:00:00','2034102902:00:00','2035032423:59:59','2035032501:59:59' ],
     ],
   2035 =>
     [
        [ [2035,3,25,0,0,0],[2035,3,25,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2035,10,27,23,59,59],[2035,10,28,2,59,59],
          '2035032500:00:00','2035032503:00:00','2035102723:59:59','2035102802:59:59' ],
        [ [2035,10,28,0,0,0],[2035,10,28,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2036,3,29,23,59,59],[2036,3,30,1,59,59],
          '2035102800:00:00','2035102802:00:00','2036032923:59:59','2036033001:59:59' ],
     ],
   2036 =>
     [
        [ [2036,3,30,0,0,0],[2036,3,30,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2036,10,25,23,59,59],[2036,10,26,2,59,59],
          '2036033000:00:00','2036033003:00:00','2036102523:59:59','2036102602:59:59' ],
        [ [2036,10,26,0,0,0],[2036,10,26,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2037,3,28,23,59,59],[2037,3,29,1,59,59],
          '2036102600:00:00','2036102602:00:00','2037032823:59:59','2037032901:59:59' ],
     ],
   2037 =>
     [
        [ [2037,3,29,0,0,0],[2037,3,29,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2037,10,24,23,59,59],[2037,10,25,2,59,59],
          '2037032900:00:00','2037032903:00:00','2037102423:59:59','2037102502:59:59' ],
        [ [2037,10,25,0,0,0],[2037,10,25,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2038,3,27,23,59,59],[2038,3,28,1,59,59],
          '2037102500:00:00','2037102502:00:00','2038032723:59:59','2038032801:59:59' ],
     ],
   2038 =>
     [
        [ [2038,3,28,0,0,0],[2038,3,28,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2038,10,30,23,59,59],[2038,10,31,2,59,59],
          '2038032800:00:00','2038032803:00:00','2038103023:59:59','2038103102:59:59' ],
        [ [2038,10,31,0,0,0],[2038,10,31,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2039,3,26,23,59,59],[2039,3,27,1,59,59],
          '2038103100:00:00','2038103102:00:00','2039032623:59:59','2039032701:59:59' ],
     ],
   2039 =>
     [
        [ [2039,3,27,0,0,0],[2039,3,27,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2039,10,29,23,59,59],[2039,10,30,2,59,59],
          '2039032700:00:00','2039032703:00:00','2039102923:59:59','2039103002:59:59' ],
        [ [2039,10,30,0,0,0],[2039,10,30,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2040,3,24,23,59,59],[2040,3,25,1,59,59],
          '2039103000:00:00','2039103002:00:00','2040032423:59:59','2040032501:59:59' ],
     ],
   2040 =>
     [
        [ [2040,3,25,0,0,0],[2040,3,25,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2040,10,27,23,59,59],[2040,10,28,2,59,59],
          '2040032500:00:00','2040032503:00:00','2040102723:59:59','2040102802:59:59' ],
        [ [2040,10,28,0,0,0],[2040,10,28,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2041,3,30,23,59,59],[2041,3,31,1,59,59],
          '2040102800:00:00','2040102802:00:00','2041033023:59:59','2041033101:59:59' ],
     ],
   2041 =>
     [
        [ [2041,3,31,0,0,0],[2041,3,31,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2041,10,26,23,59,59],[2041,10,27,2,59,59],
          '2041033100:00:00','2041033103:00:00','2041102623:59:59','2041102702:59:59' ],
        [ [2041,10,27,0,0,0],[2041,10,27,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2042,3,29,23,59,59],[2042,3,30,1,59,59],
          '2041102700:00:00','2041102702:00:00','2042032923:59:59','2042033001:59:59' ],
     ],
   2042 =>
     [
        [ [2042,3,30,0,0,0],[2042,3,30,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2042,10,25,23,59,59],[2042,10,26,2,59,59],
          '2042033000:00:00','2042033003:00:00','2042102523:59:59','2042102602:59:59' ],
        [ [2042,10,26,0,0,0],[2042,10,26,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2043,3,28,23,59,59],[2043,3,29,1,59,59],
          '2042102600:00:00','2042102602:00:00','2043032823:59:59','2043032901:59:59' ],
     ],
   2043 =>
     [
        [ [2043,3,29,0,0,0],[2043,3,29,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2043,10,24,23,59,59],[2043,10,25,2,59,59],
          '2043032900:00:00','2043032903:00:00','2043102423:59:59','2043102502:59:59' ],
        [ [2043,10,25,0,0,0],[2043,10,25,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2044,3,26,23,59,59],[2044,3,27,1,59,59],
          '2043102500:00:00','2043102502:00:00','2044032623:59:59','2044032701:59:59' ],
     ],
   2044 =>
     [
        [ [2044,3,27,0,0,0],[2044,3,27,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2044,10,29,23,59,59],[2044,10,30,2,59,59],
          '2044032700:00:00','2044032703:00:00','2044102923:59:59','2044103002:59:59' ],
        [ [2044,10,30,0,0,0],[2044,10,30,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2045,3,25,23,59,59],[2045,3,26,1,59,59],
          '2044103000:00:00','2044103002:00:00','2045032523:59:59','2045032601:59:59' ],
     ],
   2045 =>
     [
        [ [2045,3,26,0,0,0],[2045,3,26,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2045,10,28,23,59,59],[2045,10,29,2,59,59],
          '2045032600:00:00','2045032603:00:00','2045102823:59:59','2045102902:59:59' ],
        [ [2045,10,29,0,0,0],[2045,10,29,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2046,3,24,23,59,59],[2046,3,25,1,59,59],
          '2045102900:00:00','2045102902:00:00','2046032423:59:59','2046032501:59:59' ],
     ],
   2046 =>
     [
        [ [2046,3,25,0,0,0],[2046,3,25,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2046,10,27,23,59,59],[2046,10,28,2,59,59],
          '2046032500:00:00','2046032503:00:00','2046102723:59:59','2046102802:59:59' ],
        [ [2046,10,28,0,0,0],[2046,10,28,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2047,3,30,23,59,59],[2047,3,31,1,59,59],
          '2046102800:00:00','2046102802:00:00','2047033023:59:59','2047033101:59:59' ],
     ],
   2047 =>
     [
        [ [2047,3,31,0,0,0],[2047,3,31,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2047,10,26,23,59,59],[2047,10,27,2,59,59],
          '2047033100:00:00','2047033103:00:00','2047102623:59:59','2047102702:59:59' ],
        [ [2047,10,27,0,0,0],[2047,10,27,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2048,3,28,23,59,59],[2048,3,29,1,59,59],
          '2047102700:00:00','2047102702:00:00','2048032823:59:59','2048032901:59:59' ],
     ],
   2048 =>
     [
        [ [2048,3,29,0,0,0],[2048,3,29,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2048,10,24,23,59,59],[2048,10,25,2,59,59],
          '2048032900:00:00','2048032903:00:00','2048102423:59:59','2048102502:59:59' ],
        [ [2048,10,25,0,0,0],[2048,10,25,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2049,3,27,23,59,59],[2049,3,28,1,59,59],
          '2048102500:00:00','2048102502:00:00','2049032723:59:59','2049032801:59:59' ],
     ],
   2049 =>
     [
        [ [2049,3,28,0,0,0],[2049,3,28,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2049,10,30,23,59,59],[2049,10,31,2,59,59],
          '2049032800:00:00','2049032803:00:00','2049103023:59:59','2049103102:59:59' ],
        [ [2049,10,31,0,0,0],[2049,10,31,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2050,3,26,23,59,59],[2050,3,27,1,59,59],
          '2049103100:00:00','2049103102:00:00','2050032623:59:59','2050032701:59:59' ],
     ],
   2050 =>
     [
        [ [2050,3,27,0,0,0],[2050,3,27,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2050,10,29,23,59,59],[2050,10,30,2,59,59],
          '2050032700:00:00','2050032703:00:00','2050102923:59:59','2050103002:59:59' ],
        [ [2050,10,30,0,0,0],[2050,10,30,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2051,3,25,23,59,59],[2051,3,26,1,59,59],
          '2050103000:00:00','2050103002:00:00','2051032523:59:59','2051032601:59:59' ],
     ],
   2051 =>
     [
        [ [2051,3,26,0,0,0],[2051,3,26,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2051,10,28,23,59,59],[2051,10,29,2,59,59],
          '2051032600:00:00','2051032603:00:00','2051102823:59:59','2051102902:59:59' ],
        [ [2051,10,29,0,0,0],[2051,10,29,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2052,3,30,23,59,59],[2052,3,31,1,59,59],
          '2051102900:00:00','2051102902:00:00','2052033023:59:59','2052033101:59:59' ],
     ],
   2052 =>
     [
        [ [2052,3,31,0,0,0],[2052,3,31,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2052,10,26,23,59,59],[2052,10,27,2,59,59],
          '2052033100:00:00','2052033103:00:00','2052102623:59:59','2052102702:59:59' ],
        [ [2052,10,27,0,0,0],[2052,10,27,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2053,3,29,23,59,59],[2053,3,30,1,59,59],
          '2052102700:00:00','2052102702:00:00','2053032923:59:59','2053033001:59:59' ],
     ],
   2053 =>
     [
        [ [2053,3,30,0,0,0],[2053,3,30,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2053,10,25,23,59,59],[2053,10,26,2,59,59],
          '2053033000:00:00','2053033003:00:00','2053102523:59:59','2053102602:59:59' ],
        [ [2053,10,26,0,0,0],[2053,10,26,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2054,3,28,23,59,59],[2054,3,29,1,59,59],
          '2053102600:00:00','2053102602:00:00','2054032823:59:59','2054032901:59:59' ],
     ],
   2054 =>
     [
        [ [2054,3,29,0,0,0],[2054,3,29,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2054,10,24,23,59,59],[2054,10,25,2,59,59],
          '2054032900:00:00','2054032903:00:00','2054102423:59:59','2054102502:59:59' ],
        [ [2054,10,25,0,0,0],[2054,10,25,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2055,3,27,23,59,59],[2055,3,28,1,59,59],
          '2054102500:00:00','2054102502:00:00','2055032723:59:59','2055032801:59:59' ],
     ],
   2055 =>
     [
        [ [2055,3,28,0,0,0],[2055,3,28,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2055,10,30,23,59,59],[2055,10,31,2,59,59],
          '2055032800:00:00','2055032803:00:00','2055103023:59:59','2055103102:59:59' ],
        [ [2055,10,31,0,0,0],[2055,10,31,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2056,3,25,23,59,59],[2056,3,26,1,59,59],
          '2055103100:00:00','2055103102:00:00','2056032523:59:59','2056032601:59:59' ],
     ],
   2056 =>
     [
        [ [2056,3,26,0,0,0],[2056,3,26,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2056,10,28,23,59,59],[2056,10,29,2,59,59],
          '2056032600:00:00','2056032603:00:00','2056102823:59:59','2056102902:59:59' ],
        [ [2056,10,29,0,0,0],[2056,10,29,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2057,3,24,23,59,59],[2057,3,25,1,59,59],
          '2056102900:00:00','2056102902:00:00','2057032423:59:59','2057032501:59:59' ],
     ],
   2057 =>
     [
        [ [2057,3,25,0,0,0],[2057,3,25,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2057,10,27,23,59,59],[2057,10,28,2,59,59],
          '2057032500:00:00','2057032503:00:00','2057102723:59:59','2057102802:59:59' ],
        [ [2057,10,28,0,0,0],[2057,10,28,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2058,3,30,23,59,59],[2058,3,31,1,59,59],
          '2057102800:00:00','2057102802:00:00','2058033023:59:59','2058033101:59:59' ],
     ],
   2058 =>
     [
        [ [2058,3,31,0,0,0],[2058,3,31,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2058,10,26,23,59,59],[2058,10,27,2,59,59],
          '2058033100:00:00','2058033103:00:00','2058102623:59:59','2058102702:59:59' ],
        [ [2058,10,27,0,0,0],[2058,10,27,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2059,3,29,23,59,59],[2059,3,30,1,59,59],
          '2058102700:00:00','2058102702:00:00','2059032923:59:59','2059033001:59:59' ],
     ],
   2059 =>
     [
        [ [2059,3,30,0,0,0],[2059,3,30,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2059,10,25,23,59,59],[2059,10,26,2,59,59],
          '2059033000:00:00','2059033003:00:00','2059102523:59:59','2059102602:59:59' ],
        [ [2059,10,26,0,0,0],[2059,10,26,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2060,3,27,23,59,59],[2060,3,28,1,59,59],
          '2059102600:00:00','2059102602:00:00','2060032723:59:59','2060032801:59:59' ],
     ],
   2060 =>
     [
        [ [2060,3,28,0,0,0],[2060,3,28,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2060,10,30,23,59,59],[2060,10,31,2,59,59],
          '2060032800:00:00','2060032803:00:00','2060103023:59:59','2060103102:59:59' ],
        [ [2060,10,31,0,0,0],[2060,10,31,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2061,3,26,23,59,59],[2061,3,27,1,59,59],
          '2060103100:00:00','2060103102:00:00','2061032623:59:59','2061032701:59:59' ],
     ],
   2061 =>
     [
        [ [2061,3,27,0,0,0],[2061,3,27,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2061,10,29,23,59,59],[2061,10,30,2,59,59],
          '2061032700:00:00','2061032703:00:00','2061102923:59:59','2061103002:59:59' ],
        [ [2061,10,30,0,0,0],[2061,10,30,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2062,3,25,23,59,59],[2062,3,26,1,59,59],
          '2061103000:00:00','2061103002:00:00','2062032523:59:59','2062032601:59:59' ],
     ],
   2062 =>
     [
        [ [2062,3,26,0,0,0],[2062,3,26,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2062,10,28,23,59,59],[2062,10,29,2,59,59],
          '2062032600:00:00','2062032603:00:00','2062102823:59:59','2062102902:59:59' ],
        [ [2062,10,29,0,0,0],[2062,10,29,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2063,3,24,23,59,59],[2063,3,25,1,59,59],
          '2062102900:00:00','2062102902:00:00','2063032423:59:59','2063032501:59:59' ],
     ],
   2063 =>
     [
        [ [2063,3,25,0,0,0],[2063,3,25,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2063,10,27,23,59,59],[2063,10,28,2,59,59],
          '2063032500:00:00','2063032503:00:00','2063102723:59:59','2063102802:59:59' ],
        [ [2063,10,28,0,0,0],[2063,10,28,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2064,3,29,23,59,59],[2064,3,30,1,59,59],
          '2063102800:00:00','2063102802:00:00','2064032923:59:59','2064033001:59:59' ],
     ],
   2064 =>
     [
        [ [2064,3,30,0,0,0],[2064,3,30,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2064,10,25,23,59,59],[2064,10,26,2,59,59],
          '2064033000:00:00','2064033003:00:00','2064102523:59:59','2064102602:59:59' ],
        [ [2064,10,26,0,0,0],[2064,10,26,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2065,3,28,23,59,59],[2065,3,29,1,59,59],
          '2064102600:00:00','2064102602:00:00','2065032823:59:59','2065032901:59:59' ],
     ],
   2065 =>
     [
        [ [2065,3,29,0,0,0],[2065,3,29,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2065,10,24,23,59,59],[2065,10,25,2,59,59],
          '2065032900:00:00','2065032903:00:00','2065102423:59:59','2065102502:59:59' ],
        [ [2065,10,25,0,0,0],[2065,10,25,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2066,3,27,23,59,59],[2066,3,28,1,59,59],
          '2065102500:00:00','2065102502:00:00','2066032723:59:59','2066032801:59:59' ],
     ],
   2066 =>
     [
        [ [2066,3,28,0,0,0],[2066,3,28,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2066,10,30,23,59,59],[2066,10,31,2,59,59],
          '2066032800:00:00','2066032803:00:00','2066103023:59:59','2066103102:59:59' ],
        [ [2066,10,31,0,0,0],[2066,10,31,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2067,3,26,23,59,59],[2067,3,27,1,59,59],
          '2066103100:00:00','2066103102:00:00','2067032623:59:59','2067032701:59:59' ],
     ],
   2067 =>
     [
        [ [2067,3,27,0,0,0],[2067,3,27,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2067,10,29,23,59,59],[2067,10,30,2,59,59],
          '2067032700:00:00','2067032703:00:00','2067102923:59:59','2067103002:59:59' ],
        [ [2067,10,30,0,0,0],[2067,10,30,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2068,3,24,23,59,59],[2068,3,25,1,59,59],
          '2067103000:00:00','2067103002:00:00','2068032423:59:59','2068032501:59:59' ],
     ],
   2068 =>
     [
        [ [2068,3,25,0,0,0],[2068,3,25,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2068,10,27,23,59,59],[2068,10,28,2,59,59],
          '2068032500:00:00','2068032503:00:00','2068102723:59:59','2068102802:59:59' ],
        [ [2068,10,28,0,0,0],[2068,10,28,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2069,3,30,23,59,59],[2069,3,31,1,59,59],
          '2068102800:00:00','2068102802:00:00','2069033023:59:59','2069033101:59:59' ],
     ],
);

%LastRule      = (
   'zone'   => {
                'dstoff' => '+03:00:00',
                'stdoff' => '+02:00:00',
               },
   'rules'  => {
                '03' => {
                         'flag'    => 'last',
                         'dow'     => '7',
                         'num'     => '0',
                         'type'    => 'w',
                         'time'    => '02:00:00',
                         'isdst'   => '1',
                         'abb'     => 'EEST',
                        },
                '10' => {
                         'flag'    => 'last',
                         'dow'     => '7',
                         'num'     => '0',
                         'type'    => 'w',
                         'time'    => '03:00:00',
                         'isdst'   => '0',
                         'abb'     => 'EET',
                        },
               },
);

1;
