#!/usr/bin/perl

package eBay::API::XML::DataType::NameValueListType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. NameValueListType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::NameValueListType

=head1 DESCRIPTION

A name and corresponding value (a name/value pair).



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::NameValueListType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::ItemSpecificSourceCodeType;


my @gaProperties = ( [ 'Name', 'xs:string', '', '', '' ]
	, [ 'Source', 'ns:ItemSpecificSourceCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ItemSpecificSourceCodeType', '' ]
	, [ 'Value', 'xs:string', '1', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setName()

A name in a name/value pair.<br>
<br>
<span class="future">In the AddItem family of calls, this can be any name that the seller
wants to use. However, to help buyers find items more easily, it is
a good idea to try to use a recommended name when possible
(see GetCategorySpecifics or GetItemRecommendations).
You cannot specify the same name twice within the same listing.<br>
<br>
In the GetCategorySpecifics and GetItemRecommendations response,
this is a recommended (popular) name to use for items in the
specified category (e.g., "Brand" might be recommended,
not "Manufacturer").</span> <br>
<br>
In the GetSearchResults response, this is an attribute name that
was used in a listing. Specifically:
If SearchRequest was used to perform a "Product Finder" search,
this contains the name of one attribute (i.e, the name of one
Item Specifics field).
If IncludeCondition was true in the request, this returns the
condition attribute name (e.g., "Item Condition").<br>
<br>
In the GetSearchResultsExpress response, this is an
attribute name that is defined for a catalog product.
Only returned when ProductDetails is set to Fine.<br>
<br>
In the GetProducts response, this is an attribute
name that is defined for a catalog product.

  Calls: AddItem
         AddLiveAuctionItem
         RelistItem
         ReviseItem
         ReviseLiveAuctionItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setName {
  my $self = shift;
  $self->{'Name'} = shift
}

=head2 getName()

  Calls: GetCategorySpecifics
         GetItemRecommendations
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription,
							ItemReturnAttributes, ReturnAll

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
           GranularityLevel: Coarse


  Calls: GetProducts
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getName {
  my $self = shift;
  return $self->{'Name'};
}


=head2 setSource()

The origin of this Item Specific. Only returned if the source is not
custom Item Specifics.<br>
<br>
This information is intended for future use, for applications that also
read data from Item.AttributeSetArray.

#    Argument: 'ns:ItemSpecificSourceCodeType'

=cut

sub setSource {
  my $self = shift;
  $self->{'Source'} = shift
}

=head2 getSource()

#    Returns: 'ns:ItemSpecificSourceCodeType'

=cut

sub getSource {
  my $self = shift;
  return $self->{'Source'};
}


=head2 setValue()

A value associated with the name.<br>
<br>
<span class="future">In the GetCategorySpecifics and GetItemRecommendations response,
the most highly recommended values are returned first. For these calls,
Value is only returned when recommended values are available.<br>
<br>
In the AddItem family of calls, you can only specify one value per
Item Specific. (If you specify multiple values, eBay only stores the
first one.) </span> <br>
<br>
In the GetSearchResults response, if SearchRequest was used to perform
a "Product Finder" search, this contains the
value of one attribute.
If IncludeCondition was true in the request, this returns the
condition attribute value (e.g., "New").<br>
<br>
In the GetSearchResultsExpress response, this is only returned when
ProductDetails is set to Fine.

  Calls: AddItem
         AddLiveAuctionItem
         RelistItem
         ReviseItem
         ReviseLiveAuctionItem
         VerifyAddItem
  RequiredInput: No
  MaxLength: 50 (see GeteBayDetails)

#    Argument: reference to an array  
                      of 'xs:string'

=cut

sub setValue {
  my $self = shift;
  $self->{'Value'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getValue()

  Calls: GetItemRecommendations
  Returned: Conditionally
  MaxLength: 50 (see GeteBayDetails)

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription,
							ItemReturnAttributes, ReturnAll
  MaxLength: 50 (see GeteBayDetails)

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
           GranularityLevel: Coarse


  Calls: GetProducts
  Returned: Conditionally

#    Returns: reference to an array  
                      of 'xs:string'

=cut

sub getValue {
  my $self = shift;
  return $self->_getDataTypeArray('Value');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
