/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Block;
import adobe.abc.Handler;
import adobe.abc.Method;

public class Edge
implements Comparable<Edge> {
    public Block from;
    public Block to;
    int label;
    int id;
    Handler handler;
    boolean is_backwards_branch = false;

    Edge(Method m, Block f, int i) {
        this.from = f;
        this.label = i;
        this.id = m.edgeId++;
    }

    public Edge(Method m, Block f, int i, Block t) {
        this(m, f, i);
        this.to = t;
    }

    Edge(Method m, Block f, int i, Handler h) {
        this(m, f, i);
        this.handler = h;
    }

    public boolean isBackedge() {
        return this.from.postorder < this.to.postorder;
    }

    public int hashCode() {
        return this.label ^ this.to.hashCode() ^ (this.from != null ? this.from.hashCode() : 0);
    }

    public boolean equals(Object o) {
        return o instanceof Edge && ((Edge)o).from == this.from && ((Edge)o).to == this.to && ((Edge)o).label == this.label;
    }

    public String toString() {
        return (this.isThrowEdge() ? this.handler.toString() + " " : "") + (this.from != null ? this.label + ":" + this.from : "") + "->" + this.to;
    }

    @Override
    public int compareTo(Edge e) {
        int d = this.label - e.label;
        if (d != 0) {
            return d;
        }
        if (this.from != null && e.from == null) {
            return 1;
        }
        if (this.from == null && e.from != null) {
            return -1;
        }
        if (this.from != null && (d = this.from.compareTo(e.from)) != 0) {
            return d;
        }
        return this.to.compareTo(e.to);
    }

    public boolean isThrowEdge() {
        return this.handler != null;
    }

    public int getLabel() {
        return this.label;
    }
}

