﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System.Collections.Generic;
using Cake.Core.IO;

namespace Cake.Common.Tools.DotNet.Format
{
    /// <summary>
    /// Contains settings used by <see cref="DotNetFormatter" />.
    /// </summary>
    public class DotNetFormatSettings : DotNetSettings
    {
        /// <summary>
        /// Gets or sets a space-separated list of diagnostic IDs to use as a filter when fixing code style or third-party issues.
        /// </summary>
        public ICollection<string> Diagnostics { get; set; } = new List<string>();

        /// <summary>
        /// Gets or sets the minimum severity of diagnostics to fix.
        /// </summary>
        public DotNetFormatSeverity? Severity { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether to not do implicit NuGet package restore.
        /// This makes build faster, but requires restore to be done before build is executed.
        /// </summary>
        public bool NoRestore { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether to verify that no formatting changes would be performed.
        /// Terminates with a non zero exit code if any files would have been formatted.
        /// </summary>
        public bool VerifyNoChanges { get; set; }

        /// <summary>
        /// Gets or sets a space-separated list of relative file or folder paths to include in formatting.
        /// All files in the solution or project are formatted if empty.
        /// </summary>
        public ICollection<string> Include { get; set; } = new List<string>();

        /// <summary>
        /// Gets or sets a space-separated list of relative file or folder paths to exclude from formatting. The default is none.
        /// </summary>
        public ICollection<string> Exclude { get; set; } = new List<string>();

        /// <summary>
        /// Gets or sets a value indicating whether to format files generated by the SDK.
        /// </summary>
        public bool IncludeGenerated { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether to log all project or solution load information to a binary log file.
        /// </summary>
        public FilePath BinaryLog { get; set; }

        /// <summary>
        /// Gets or sets a path to a JSON report.
        /// </summary>
        public FilePath Report { get; set; }
    }
}
