// @generated by Thrift for thrift/compiler/test/fixtures/sink/src/module.thrift
// This file is probably not the place you want to edit!

//! Mock definitions for `module`.
//!
//! Client mocks. For every service, a struct TheService that implements
//! client::TheService.
//!
//! As an example of the generated API, for the following thrift service in
//! example.thrift:
//!
//! ```thrift
//! service MyService {
//!     FunctionResponse myFunction(
//!         1: FunctionRequest request,
//!     ) throws {
//!         1: StorageException s,
//!         2: NotFoundException n,
//!     ),
//!
//!     // other functions
//! }
//! ```
//!
//! we would end up with this mock object in an `example_mocks` crate:
//!
//! ```
//! # const _: &str = stringify! {
//! impl example_clients::MyService for MyService<'mock> {...}
//!
//! pub struct MyService<'mock> {
//!     pub myFunction: myFunction<'mock>,
//!     // ...
//! }
//!
//! impl myFunction<'mock> {
//!     // directly return the given success response
//!     pub fn ret(&self, value: FunctionResponse);
//!
//!     // invoke closure to compute success response
//!     pub fn mock(
//!         &self,
//!         mock: impl FnMut(FunctionRequest) -> FunctionResponse + Send + Sync + 'mock,
//!     );
//!
//!     // invoke closure to compute response
//!     pub fn mock_result(
//!         &self,
//!         mock: impl FnMut(FunctionRequest) -> Result<FunctionResponse, example_services::errors::MyFunctionExn> + Send + Sync + 'mock,
//!     );
//!
//!     // return one of the function's declared exceptions
//!     pub fn throw<E>(&self, exception: E)
//!     where
//!         E: Clone + Into<example_services::errors::MyFunctionExn> + Send + Sync + 'mock;
//! }
//! # };
//! ```
//!
//! The intended usage from a test would be:
//!
//! ```
//! # const _: &str = stringify! {
//! use std::sync::Arc;
//! use example_clients::MyService;
//!
//! #[tokio::test]
//! async fn test_my_client() {
//!     let mock = Arc::new(example_mocks::new::<dyn MyService>());
//!
//!     // directly return a success response
//!     let resp = FunctionResponse {...};
//!     mock.myFunction.ret(resp);
//!
//!     // or give a closure to compute the success response
//!     mock.myFunction.mock(|request| FunctionResponse {...});
//!
//!     // or throw one of the function's exceptions
//!     mock.myFunction.throw(StorageException::ItFailed);
//!
//!     // or compute a Result (useful if your exceptions aren't Clone)
//!     mock.myFunction.mock_result(|request| Err(...));
//!
//!     let out = do_the_thing(mock).await.unwrap();
//!     assert!(out.what_i_expected());
//! }
//!
//! async fn do_the_thing(
//!     client: Arc<dyn MyService + Send + Sync + 'static>,
//! ) -> Out {...}
//! # };
//! ```

#![recursion_limit = "100000000"]
#![allow(non_camel_case_types, non_snake_case, non_upper_case_globals, unused_crate_dependencies, unused_imports, clippy::all)]

pub(crate) use :: as types;
pub(crate) use :: as client;
pub(crate) use ::::errors;

pub fn new<'mock, Client>() -> Client::Mock<'mock>
where
    Client: ?::std::marker::Sized + DynClient,
{
    Client::mock()
}

pub trait DynClient {
    type Mock<'mock>;
    fn mock<'mock>() -> Self::Mock<'mock>;
}

pub struct SinkService<'mock> {
    pub method: r#impl::sink_service::method<'mock>,
    pub methodAndReponse: r#impl::sink_service::methodAndReponse<'mock>,
    pub methodThrow: r#impl::sink_service::methodThrow<'mock>,
    pub methodSinkThrow: r#impl::sink_service::methodSinkThrow<'mock>,
    pub methodFinalThrow: r#impl::sink_service::methodFinalThrow<'mock>,
    pub methodBothThrow: r#impl::sink_service::methodBothThrow<'mock>,
    pub methodFast: r#impl::sink_service::methodFast<'mock>,
    _marker: ::std::marker::PhantomData<&'mock ()>,
}

impl crate::DynClient for dyn ::::SinkService {
    type Mock<'mock> = SinkService<'mock>;
    fn mock<'mock>() -> Self::Mock<'mock> {
        SinkService {
            method: r#impl::sink_service::method::unimplemented(),
            methodAndReponse: r#impl::sink_service::methodAndReponse::unimplemented(),
            methodThrow: r#impl::sink_service::methodThrow::unimplemented(),
            methodSinkThrow: r#impl::sink_service::methodSinkThrow::unimplemented(),
            methodFinalThrow: r#impl::sink_service::methodFinalThrow::unimplemented(),
            methodBothThrow: r#impl::sink_service::methodBothThrow::unimplemented(),
            methodFast: r#impl::sink_service::methodFast::unimplemented(),
            _marker: ::std::marker::PhantomData,
        }
    }
}

impl<'mock> ::::SinkService for SinkService<'mock> {
    fn method(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodSinkFinalError,
>, crate::errors::sink_service::MethodError>> {
        let mut closure = self.method.closure.lock().unwrap();
        let closure: &mut dyn ::std::ops::FnMut() -> _ = &mut **closure;
        ::std::boxed::Box::pin(::futures::future::ready(closure()))
    }
    fn methodAndReponse(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::fbthrift::SinkResult<
    crate::types::InitialResponse,
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodAndReponseSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodAndReponseSinkFinalError,
>, crate::errors::sink_service::MethodAndReponseError>> {
        let mut closure = self.methodAndReponse.closure.lock().unwrap();
        let closure: &mut dyn ::std::ops::FnMut() -> _ = &mut **closure;
        ::std::boxed::Box::pin(::futures::future::ready(closure()))
    }
    fn methodThrow(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodThrowSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodThrowSinkFinalError,
>, crate::errors::sink_service::MethodThrowError>> {
        let mut closure = self.methodThrow.closure.lock().unwrap();
        let closure: &mut dyn ::std::ops::FnMut() -> _ = &mut **closure;
        ::std::boxed::Box::pin(::futures::future::ready(closure()))
    }
    fn methodSinkThrow(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodSinkThrowSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodSinkThrowSinkFinalError,
>, crate::errors::sink_service::MethodSinkThrowError>> {
        let mut closure = self.methodSinkThrow.closure.lock().unwrap();
        let closure: &mut dyn ::std::ops::FnMut() -> _ = &mut **closure;
        ::std::boxed::Box::pin(::futures::future::ready(closure()))
    }
    fn methodFinalThrow(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodFinalThrowSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodFinalThrowSinkFinalError,
>, crate::errors::sink_service::MethodFinalThrowError>> {
        let mut closure = self.methodFinalThrow.closure.lock().unwrap();
        let closure: &mut dyn ::std::ops::FnMut() -> _ = &mut **closure;
        ::std::boxed::Box::pin(::futures::future::ready(closure()))
    }
    fn methodBothThrow(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodBothThrowSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodBothThrowSinkFinalError,
>, crate::errors::sink_service::MethodBothThrowError>> {
        let mut closure = self.methodBothThrow.closure.lock().unwrap();
        let closure: &mut dyn ::std::ops::FnMut() -> _ = &mut **closure;
        ::std::boxed::Box::pin(::futures::future::ready(closure()))
    }
    fn methodFast(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodFastSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodFastSinkFinalError,
>, crate::errors::sink_service::MethodFastError>> {
        let mut closure = self.methodFast.closure.lock().unwrap();
        let closure: &mut dyn ::std::ops::FnMut() -> _ = &mut **closure;
        ::std::boxed::Box::pin(::futures::future::ready(closure()))
    }
}

impl<'mock, T> ::::SinkServiceExt<T> for SinkService<'mock>
where
    T: ::fbthrift::Transport,
{    fn method_with_rpc_opts(
        &self,
        _rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodSinkFinalError,
>, crate::errors::sink_service::MethodError>> {
        <Self as ::::SinkService>::method(
            self,
        )
    }
    fn methodAndReponse_with_rpc_opts(
        &self,
        _rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::fbthrift::SinkResult<
    crate::types::InitialResponse,
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodAndReponseSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodAndReponseSinkFinalError,
>, crate::errors::sink_service::MethodAndReponseError>> {
        <Self as ::::SinkService>::methodAndReponse(
            self,
        )
    }
    fn methodThrow_with_rpc_opts(
        &self,
        _rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodThrowSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodThrowSinkFinalError,
>, crate::errors::sink_service::MethodThrowError>> {
        <Self as ::::SinkService>::methodThrow(
            self,
        )
    }
    fn methodSinkThrow_with_rpc_opts(
        &self,
        _rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodSinkThrowSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodSinkThrowSinkFinalError,
>, crate::errors::sink_service::MethodSinkThrowError>> {
        <Self as ::::SinkService>::methodSinkThrow(
            self,
        )
    }
    fn methodFinalThrow_with_rpc_opts(
        &self,
        _rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodFinalThrowSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodFinalThrowSinkFinalError,
>, crate::errors::sink_service::MethodFinalThrowError>> {
        <Self as ::::SinkService>::methodFinalThrow(
            self,
        )
    }
    fn methodBothThrow_with_rpc_opts(
        &self,
        _rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodBothThrowSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodBothThrowSinkFinalError,
>, crate::errors::sink_service::MethodBothThrowError>> {
        <Self as ::::SinkService>::methodBothThrow(
            self,
        )
    }
    fn methodFast_with_rpc_opts(
        &self,
        _rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodFastSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodFastSinkFinalError,
>, crate::errors::sink_service::MethodFastError>> {
        <Self as ::::SinkService>::methodFast(
            self,
        )
    }

    fn transport(&self) -> &T {
        ::fbthrift::help::GetTransport::transport(self)
    }
}

impl<'mock, T> ::fbthrift::help::GetTransport<T> for SinkService<'mock>
where
    T: ::fbthrift::Transport,
{
    fn transport(&self) -> &T {
        unimplemented!("SinkServiceExt::transport is not implemented for mock client")
    }
}

pub mod r#impl {
    pub mod sink_service {

        pub struct method<'mock> {
            pub(crate) closure: ::std::sync::Mutex<::std::boxed::Box<
                dyn ::std::ops::FnMut() -> ::std::result::Result<
                    ::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodSinkFinalError,
>,
                    ::::errors::sink_service::MethodError,
                > + ::std::marker::Send + ::std::marker::Sync + 'mock,
            >>,
        }

        #[allow(clippy::redundant_closure)]
        impl<'mock> method<'mock> {
            pub(crate) fn unimplemented() -> Self {
                Self {
                    closure: ::std::sync::Mutex::new(::std::boxed::Box::new(|| panic!(
                        "{}::{} is not mocked",
                        "SinkService",
                        "method",
                    ))),
                }
            }

            pub fn ret(&self, _value: ::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodSinkFinalError,
>) {
                unimplemented!("Mocking sinks is not yet implemented, as value isn't cloneable")
            }

            pub fn mock(&self, mut mock: impl ::std::ops::FnMut() -> ::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodSinkFinalError,
> + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || ::std::result::Result::Ok(mock()));
            }

            pub fn mock_result(&self, mut mock: impl ::std::ops::FnMut() -> ::std::result::Result<::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodSinkFinalError,
>, ::::errors::sink_service::MethodError> + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || mock());
            }

            pub fn throw<E>(&self, exception: E)
            where
                E: ::std::convert::Into<::::errors::sink_service::MethodError>,
                E: ::std::clone::Clone + ::std::marker::Send + ::std::marker::Sync + 'mock,
            {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || ::std::result::Result::Err(exception.clone().into()));
            }
        }

        pub struct methodAndReponse<'mock> {
            pub(crate) closure: ::std::sync::Mutex<::std::boxed::Box<
                dyn ::std::ops::FnMut() -> ::std::result::Result<
                    ::fbthrift::SinkResult<
    crate::types::InitialResponse,
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodAndReponseSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodAndReponseSinkFinalError,
>,
                    ::::errors::sink_service::MethodAndReponseError,
                > + ::std::marker::Send + ::std::marker::Sync + 'mock,
            >>,
        }

        #[allow(clippy::redundant_closure)]
        impl<'mock> methodAndReponse<'mock> {
            pub(crate) fn unimplemented() -> Self {
                Self {
                    closure: ::std::sync::Mutex::new(::std::boxed::Box::new(|| panic!(
                        "{}::{} is not mocked",
                        "SinkService",
                        "methodAndReponse",
                    ))),
                }
            }

            pub fn ret(&self, _value: ::fbthrift::SinkResult<
    crate::types::InitialResponse,
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodAndReponseSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodAndReponseSinkFinalError,
>) {
                unimplemented!("Mocking sinks is not yet implemented, as value isn't cloneable")
            }

            pub fn mock(&self, mut mock: impl ::std::ops::FnMut() -> ::fbthrift::SinkResult<
    crate::types::InitialResponse,
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodAndReponseSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodAndReponseSinkFinalError,
> + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || ::std::result::Result::Ok(mock()));
            }

            pub fn mock_result(&self, mut mock: impl ::std::ops::FnMut() -> ::std::result::Result<::fbthrift::SinkResult<
    crate::types::InitialResponse,
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodAndReponseSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodAndReponseSinkFinalError,
>, ::::errors::sink_service::MethodAndReponseError> + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || mock());
            }

            pub fn throw<E>(&self, exception: E)
            where
                E: ::std::convert::Into<::::errors::sink_service::MethodAndReponseError>,
                E: ::std::clone::Clone + ::std::marker::Send + ::std::marker::Sync + 'mock,
            {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || ::std::result::Result::Err(exception.clone().into()));
            }
        }

        pub struct methodThrow<'mock> {
            pub(crate) closure: ::std::sync::Mutex<::std::boxed::Box<
                dyn ::std::ops::FnMut() -> ::std::result::Result<
                    ::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodThrowSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodThrowSinkFinalError,
>,
                    ::::errors::sink_service::MethodThrowError,
                > + ::std::marker::Send + ::std::marker::Sync + 'mock,
            >>,
        }

        #[allow(clippy::redundant_closure)]
        impl<'mock> methodThrow<'mock> {
            pub(crate) fn unimplemented() -> Self {
                Self {
                    closure: ::std::sync::Mutex::new(::std::boxed::Box::new(|| panic!(
                        "{}::{} is not mocked",
                        "SinkService",
                        "methodThrow",
                    ))),
                }
            }

            pub fn ret(&self, _value: ::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodThrowSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodThrowSinkFinalError,
>) {
                unimplemented!("Mocking sinks is not yet implemented, as value isn't cloneable")
            }

            pub fn mock(&self, mut mock: impl ::std::ops::FnMut() -> ::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodThrowSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodThrowSinkFinalError,
> + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || ::std::result::Result::Ok(mock()));
            }

            pub fn mock_result(&self, mut mock: impl ::std::ops::FnMut() -> ::std::result::Result<::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodThrowSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodThrowSinkFinalError,
>, ::::errors::sink_service::MethodThrowError> + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || mock());
            }

            pub fn throw<E>(&self, exception: E)
            where
                E: ::std::convert::Into<::::errors::sink_service::MethodThrowError>,
                E: ::std::clone::Clone + ::std::marker::Send + ::std::marker::Sync + 'mock,
            {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || ::std::result::Result::Err(exception.clone().into()));
            }
        }

        pub struct methodSinkThrow<'mock> {
            pub(crate) closure: ::std::sync::Mutex<::std::boxed::Box<
                dyn ::std::ops::FnMut() -> ::std::result::Result<
                    ::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodSinkThrowSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodSinkThrowSinkFinalError,
>,
                    ::::errors::sink_service::MethodSinkThrowError,
                > + ::std::marker::Send + ::std::marker::Sync + 'mock,
            >>,
        }

        #[allow(clippy::redundant_closure)]
        impl<'mock> methodSinkThrow<'mock> {
            pub(crate) fn unimplemented() -> Self {
                Self {
                    closure: ::std::sync::Mutex::new(::std::boxed::Box::new(|| panic!(
                        "{}::{} is not mocked",
                        "SinkService",
                        "methodSinkThrow",
                    ))),
                }
            }

            pub fn ret(&self, _value: ::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodSinkThrowSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodSinkThrowSinkFinalError,
>) {
                unimplemented!("Mocking sinks is not yet implemented, as value isn't cloneable")
            }

            pub fn mock(&self, mut mock: impl ::std::ops::FnMut() -> ::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodSinkThrowSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodSinkThrowSinkFinalError,
> + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || ::std::result::Result::Ok(mock()));
            }

            pub fn mock_result(&self, mut mock: impl ::std::ops::FnMut() -> ::std::result::Result<::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodSinkThrowSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodSinkThrowSinkFinalError,
>, ::::errors::sink_service::MethodSinkThrowError> + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || mock());
            }

            pub fn throw<E>(&self, exception: E)
            where
                E: ::std::convert::Into<::::errors::sink_service::MethodSinkThrowError>,
                E: ::std::clone::Clone + ::std::marker::Send + ::std::marker::Sync + 'mock,
            {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || ::std::result::Result::Err(exception.clone().into()));
            }
        }

        pub struct methodFinalThrow<'mock> {
            pub(crate) closure: ::std::sync::Mutex<::std::boxed::Box<
                dyn ::std::ops::FnMut() -> ::std::result::Result<
                    ::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodFinalThrowSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodFinalThrowSinkFinalError,
>,
                    ::::errors::sink_service::MethodFinalThrowError,
                > + ::std::marker::Send + ::std::marker::Sync + 'mock,
            >>,
        }

        #[allow(clippy::redundant_closure)]
        impl<'mock> methodFinalThrow<'mock> {
            pub(crate) fn unimplemented() -> Self {
                Self {
                    closure: ::std::sync::Mutex::new(::std::boxed::Box::new(|| panic!(
                        "{}::{} is not mocked",
                        "SinkService",
                        "methodFinalThrow",
                    ))),
                }
            }

            pub fn ret(&self, _value: ::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodFinalThrowSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodFinalThrowSinkFinalError,
>) {
                unimplemented!("Mocking sinks is not yet implemented, as value isn't cloneable")
            }

            pub fn mock(&self, mut mock: impl ::std::ops::FnMut() -> ::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodFinalThrowSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodFinalThrowSinkFinalError,
> + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || ::std::result::Result::Ok(mock()));
            }

            pub fn mock_result(&self, mut mock: impl ::std::ops::FnMut() -> ::std::result::Result<::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodFinalThrowSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodFinalThrowSinkFinalError,
>, ::::errors::sink_service::MethodFinalThrowError> + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || mock());
            }

            pub fn throw<E>(&self, exception: E)
            where
                E: ::std::convert::Into<::::errors::sink_service::MethodFinalThrowError>,
                E: ::std::clone::Clone + ::std::marker::Send + ::std::marker::Sync + 'mock,
            {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || ::std::result::Result::Err(exception.clone().into()));
            }
        }

        pub struct methodBothThrow<'mock> {
            pub(crate) closure: ::std::sync::Mutex<::std::boxed::Box<
                dyn ::std::ops::FnMut() -> ::std::result::Result<
                    ::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodBothThrowSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodBothThrowSinkFinalError,
>,
                    ::::errors::sink_service::MethodBothThrowError,
                > + ::std::marker::Send + ::std::marker::Sync + 'mock,
            >>,
        }

        #[allow(clippy::redundant_closure)]
        impl<'mock> methodBothThrow<'mock> {
            pub(crate) fn unimplemented() -> Self {
                Self {
                    closure: ::std::sync::Mutex::new(::std::boxed::Box::new(|| panic!(
                        "{}::{} is not mocked",
                        "SinkService",
                        "methodBothThrow",
                    ))),
                }
            }

            pub fn ret(&self, _value: ::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodBothThrowSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodBothThrowSinkFinalError,
>) {
                unimplemented!("Mocking sinks is not yet implemented, as value isn't cloneable")
            }

            pub fn mock(&self, mut mock: impl ::std::ops::FnMut() -> ::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodBothThrowSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodBothThrowSinkFinalError,
> + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || ::std::result::Result::Ok(mock()));
            }

            pub fn mock_result(&self, mut mock: impl ::std::ops::FnMut() -> ::std::result::Result<::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodBothThrowSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodBothThrowSinkFinalError,
>, ::::errors::sink_service::MethodBothThrowError> + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || mock());
            }

            pub fn throw<E>(&self, exception: E)
            where
                E: ::std::convert::Into<::::errors::sink_service::MethodBothThrowError>,
                E: ::std::clone::Clone + ::std::marker::Send + ::std::marker::Sync + 'mock,
            {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || ::std::result::Result::Err(exception.clone().into()));
            }
        }

        pub struct methodFast<'mock> {
            pub(crate) closure: ::std::sync::Mutex<::std::boxed::Box<
                dyn ::std::ops::FnMut() -> ::std::result::Result<
                    ::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodFastSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodFastSinkFinalError,
>,
                    ::::errors::sink_service::MethodFastError,
                > + ::std::marker::Send + ::std::marker::Sync + 'mock,
            >>,
        }

        #[allow(clippy::redundant_closure)]
        impl<'mock> methodFast<'mock> {
            pub(crate) fn unimplemented() -> Self {
                Self {
                    closure: ::std::sync::Mutex::new(::std::boxed::Box::new(|| panic!(
                        "{}::{} is not mocked",
                        "SinkService",
                        "methodFast",
                    ))),
                }
            }

            pub fn ret(&self, _value: ::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodFastSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodFastSinkFinalError,
>) {
                unimplemented!("Mocking sinks is not yet implemented, as value isn't cloneable")
            }

            pub fn mock(&self, mut mock: impl ::std::ops::FnMut() -> ::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodFastSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodFastSinkFinalError,
> + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || ::std::result::Result::Ok(mock()));
            }

            pub fn mock_result(&self, mut mock: impl ::std::ops::FnMut() -> ::std::result::Result<::fbthrift::SinkResult<
    (),
    crate::types::SinkPayload,
    crate::errors::sink_service::MethodFastSinkError,
    crate::types::FinalResponse,
    crate::errors::sink_service::MethodFastSinkFinalError,
>, ::::errors::sink_service::MethodFastError> + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || mock());
            }

            pub fn throw<E>(&self, exception: E)
            where
                E: ::std::convert::Into<::::errors::sink_service::MethodFastError>,
                E: ::std::clone::Clone + ::std::marker::Send + ::std::marker::Sync + 'mock,
            {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || ::std::result::Result::Err(exception.clone().into()));
            }
        }
    }
}
