/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.text.lookup.DateStringLookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DateStringLookupTest {
    @Test
    public void testBadFormat() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateStringLookup.INSTANCE.lookup("this-is-a-bad-format-dontcha-know"));
    }

    @Test
    public void testDefault() throws ParseException {
        String formatted = DateStringLookup.INSTANCE.lookup(null);
        DateFormat.getInstance().parse(formatted);
    }

    @Test
    public void testFormat() {
        String format = "yyyy-MM-dd";
        String value = DateStringLookup.INSTANCE.lookup("yyyy-MM-dd");
        Assertions.assertNotNull((Object)value, (String)"No Date");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String today = simpleDateFormat.format(new Date());
        Assertions.assertEquals((Object)value, (Object)today);
    }

    @Test
    public void testToString() {
        Assertions.assertFalse((boolean)DateStringLookup.INSTANCE.toString().isEmpty());
    }
}

