/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DataGridBundle;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatResolver;
import com.intellij.database.csv.CsvFormatResolverCore;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.CsvFormatParser;
import com.intellij.database.datagrid.CsvParserResult;
import com.intellij.database.settings.CsvSettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChoosePasteFormatAction
extends ActionGroup
implements DumbAware {
    private static final String PASTE_FORMAT_KEY = "database.data.paste.format";

    public ChoosePasteFormatAction() {
        this.setPopup(true);
    }

    public ChoosePasteFormatAction(@NotNull @NlsActions.ActionText String name) {
        if (name == null) {
            ChoosePasteFormatAction.$$$reportNull$$$0(0);
        }
        super(name, true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ChoosePasteFormatAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ChoosePasteFormatAction.$$$reportNull$$$0(2);
        }
        e.getPresentation().setEnabledAndVisible(!CsvSettings.getSettings().getCsvFormats().isEmpty());
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        AnAction showFormatsAction = ActionManager.getInstance().getAction("Console.TableResult.Copy.Csv.Settings.ForImport");
        AnAction[] anActionArray = ContainerUtil.skipNulls((Collection)ContainerUtil.concat((List[])new List[]{Arrays.asList(new AnAction[]{new PasteTypeAction(PasteType.AUTO, DataGridBundle.message((String)"action.Console.TableResult.PasteFormat.detect", (Object[])new Object[0])), new PasteTypeAction(PasteType.SINGLE_VALUE, DataGridBundle.message((String)"action.Console.TableResult.PasteFormat.single.value", (Object[])new Object[0])), new Separator()}), ContainerUtil.map((Collection)CsvSettings.getSettings().getCsvFormats(), f -> new FormatAction((CsvFormat)f)), Arrays.asList(new Separator(), showFormatsAction)})).toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            ChoosePasteFormatAction.$$$reportNull$$$0(3);
        }
        return anActionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ChoosePasteFormatAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ChoosePasteFormatAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }

    private static class PasteTypeAction
    extends ToggleAction
    implements DumbAware {
        protected final PasteType myType;

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                PasteTypeAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        PasteTypeAction(@NotNull PasteType type, @NlsActions.ActionText @NotNull String name) {
            if (type == null) {
                PasteTypeAction.$$$reportNull$$$0(1);
            }
            if (name == null) {
                PasteTypeAction.$$$reportNull$$$0(2);
            }
            super(name);
            this.myType = type;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                PasteTypeAction.$$$reportNull$$$0(3);
            }
            return PasteType.get() == this.myType;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                PasteTypeAction.$$$reportNull$$$0(4);
            }
            if (state) {
                this.myType.save(this.getFormat());
            }
        }

        @Nullable
        CsvFormat getFormat() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChoosePasteFormatAction$PasteTypeAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChoosePasteFormatAction$PasteTypeAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    public static enum PasteType {
        AUTO{

            @Override
            @NotNull
            public String getValueToSave(@Nullable CsvFormat format) {
                return PasteType.AUTO_PREFIX;
            }

            @Override
            public boolean isCurrent(@NotNull String value) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                return value.equals(PasteType.AUTO_PREFIX);
            }

            @Override
            @NotNull
            public Parser getParser() {
                return new FormatParser(this){

                    @Override
                    @Nullable
                    CsvFormat getFormat(@NotNull Project project, @NotNull String text) {
                        if (project == null) {
                            PasteType.1.$$$reportNull$$$0(0);
                        }
                        if (text == null) {
                            PasteType.1.$$$reportNull$$$0(1);
                        }
                        return CsvFormatResolver.getFormat(project, (VirtualFile)new LightVirtualFile("dummy", (CharSequence)text), false, null);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "project";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "text";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/database/run/actions/ChoosePasteFormatAction$PasteType$1$1";
                        objectArray[2] = "getFormat";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }

            @Override
            @Nullable
            public CsvFormat getFormat() {
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/actions/ChoosePasteFormatAction$PasteType$1", "isCurrent"));
            }
        }
        ,
        SINGLE_VALUE{

            @Override
            @NotNull
            public String getValueToSave(@Nullable CsvFormat format) {
                return PasteType.SINGLE_PREFIX;
            }

            @Override
            public boolean isCurrent(@NotNull String value) {
                if (value == null) {
                    2.$$$reportNull$$$0(0);
                }
                return value.equals(PasteType.SINGLE_PREFIX);
            }

            @Override
            @NotNull
            public Parser getParser() {
                SingleValueParser singleValueParser = SingleValueParser.INSTANCE;
                if (singleValueParser == null) {
                    2.$$$reportNull$$$0(1);
                }
                return singleValueParser;
            }

            @Override
            @Nullable
            public CsvFormat getFormat() {
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/actions/ChoosePasteFormatAction$PasteType$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/actions/ChoosePasteFormatAction$PasteType$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getParser";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isCurrent";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }
        ,
        FORMAT{

            @Override
            @NotNull
            public String getValueToSave(@Nullable CsvFormat format) {
                String string = PasteType.FORMAT_PREFIX + Objects.requireNonNull(format).id;
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public boolean isCurrent(@NotNull String value) {
                if (value == null) {
                    3.$$$reportNull$$$0(1);
                }
                return value.startsWith(PasteType.FORMAT_PREFIX);
            }

            @Override
            @NotNull
            public Parser getParser() {
                final CsvFormat format = CsvFormatResolverCore.simplifyFormat((CsvFormat)this.getFormat());
                return format == null ? SingleValueParser.INSTANCE : new FormatParser(this){

                    @Override
                    CsvFormat getFormat(@NotNull Project project, @NotNull String text) {
                        if (project == null) {
                            PasteType.1.$$$reportNull$$$0(0);
                        }
                        if (text == null) {
                            PasteType.1.$$$reportNull$$$0(1);
                        }
                        return format;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "project";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "text";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/database/run/actions/ChoosePasteFormatAction$PasteType$3$1";
                        objectArray[2] = "getFormat";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }

            @Override
            @Nullable
            public CsvFormat getFormat() {
                String value = PropertiesComponent.getInstance().getValue(ChoosePasteFormatAction.PASTE_FORMAT_KEY);
                String id = value == null || value.length() <= PasteType.FORMAT_PREFIX.length() ? null : value.substring(PasteType.FORMAT_PREFIX.length());
                List formats = CsvSettings.getSettings().getCsvFormats();
                return id == null ? null : (CsvFormat)ContainerUtil.find((Iterable)formats, f -> f.id.equals(id));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/actions/ChoosePasteFormatAction$PasteType$3";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValueToSave";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/actions/ChoosePasteFormatAction$PasteType$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isCurrent";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        };

        private static final String FORMAT_PREFIX = "format:";
        private static final String AUTO_PREFIX = "auto";
        private static final String SINGLE_PREFIX = "single";

        public void save(@Nullable CsvFormat format) {
            PropertiesComponent.getInstance().setValue(ChoosePasteFormatAction.PASTE_FORMAT_KEY, this.getValueToSave(format));
        }

        @NotNull
        public abstract Parser getParser();

        @NotNull
        public abstract String getValueToSave(@Nullable CsvFormat var1);

        @Nullable
        public abstract CsvFormat getFormat();

        public abstract boolean isCurrent(@NotNull String var1);

        @NotNull
        public static PasteType get() {
            String value = PropertiesComponent.getInstance().getValue(ChoosePasteFormatAction.PASTE_FORMAT_KEY);
            if (value != null) {
                for (PasteType type : PasteType.values()) {
                    if (!type.isCurrent(value)) continue;
                    PasteType pasteType = type;
                    if (pasteType == null) {
                        PasteType.$$$reportNull$$$0(0);
                    }
                    return pasteType;
                }
            }
            PasteType pasteType = AUTO;
            if (pasteType == null) {
                PasteType.$$$reportNull$$$0(1);
            }
            return pasteType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ChoosePasteFormatAction$PasteType", "get"));
        }
    }

    private static class FormatAction
    extends PasteTypeAction {
        private final CsvFormat myFormat;

        FormatAction(@NotNull CsvFormat format) {
            if (format == null) {
                FormatAction.$$$reportNull$$$0(0);
            }
            super(PasteType.FORMAT, format.name);
            this.myFormat = format;
        }

        @Override
        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                FormatAction.$$$reportNull$$$0(1);
            }
            CsvFormat format = this.myType.getFormat();
            return super.isSelected(e) && StringUtil.equals((CharSequence)this.myFormat.id, (CharSequence)(format == null ? null : format.id));
        }

        @Override
        @Nullable
        CsvFormat getFormat() {
            return this.myFormat;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/ChoosePasteFormatAction$FormatAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class FormatParser
    implements Parser {
        private FormatParser() {
        }

        @Override
        @NotNull
        public Pair<List<String[]>, CsvFormat> parse(@NotNull Project project, @NotNull String value) {
            CsvFormat format;
            CsvParserResult result;
            if (project == null) {
                FormatParser.$$$reportNull$$$0(0);
            }
            if (value == null) {
                FormatParser.$$$reportNull$$$0(1);
            }
            CsvParserResult csvParserResult = result = (format = this.getFormat(project, value)) == null ? null : new CsvFormatParser(format).parse((CharSequence)value);
            if (result == null) {
                Pair<List<String[]>, CsvFormat> pair = SingleValueParser.INSTANCE.parse(project, value);
                if (pair == null) {
                    FormatParser.$$$reportNull$$$0(2);
                }
                return pair;
            }
            List values = ContainerUtil.map((Collection)CsvDocumentDataHookUp.rowsFrom((CsvFormat)result.getFormat(), (CharSequence)result.getSequence(), (List)result.getRecords(), (boolean)result.getFormat().rowNumbers), row -> ContainerUtil.map((Iterable)row, o -> o == null ? null : o.toString()).toArray(ArrayUtilRt.EMPTY_STRING_ARRAY));
            return new Pair((Object)values, (Object)format);
        }

        @Nullable
        abstract CsvFormat getFormat(@NotNull Project var1, @NotNull String var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChoosePasteFormatAction$FormatParser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChoosePasteFormatAction$FormatParser";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "parse";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class SingleValueParser
    implements Parser {
        static final SingleValueParser INSTANCE = new SingleValueParser();

        private SingleValueParser() {
        }

        @Override
        @NotNull
        public Pair<List<String[]>, CsvFormat> parse(@NotNull Project project, @NotNull String value) {
            if (project == null) {
                SingleValueParser.$$$reportNull$$$0(0);
            }
            if (value == null) {
                SingleValueParser.$$$reportNull$$$0(1);
            }
            return new Pair(Collections.singletonList(new String[]{value}), null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/ChoosePasteFormatAction$SingleValueParser";
            objectArray[2] = "parse";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Parser {
        @NotNull
        public Pair<List<String[]>, CsvFormat> parse(@NotNull Project var1, @NotNull String var2);
    }
}

