/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.config.hints;

import com.intellij.microservices.jvm.config.MicroservicesConfigBundle;
import com.intellij.microservices.jvm.config.hints.HintReferenceBase;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BooleanHintReference
extends HintReferenceBase {
    private final String[] myValues;

    public BooleanHintReference(@NotNull PsiElement element, TextRange rangeInElement, String ... aliases) {
        if (element == null) {
            BooleanHintReference.$$$reportNull$$$0(0);
        }
        super(element, rangeInElement);
        this.myValues = ArrayUtil.mergeArrays((String[])new String[]{"false", "true"}, (String[])aliases);
        Arrays.sort(this.myValues);
    }

    @Override
    public TextAttributesKey getTextAttributesKey() {
        return DefaultLanguageHighlighterColors.KEYWORD;
    }

    @Override
    @Nullable
    protected PsiElement doResolve() {
        return Arrays.binarySearch(this.myValues, this.getValue().trim()) > -1 ? this.myElement : null;
    }

    @Override
    public Object @NotNull [] getHintVariants() {
        if (this.myValues == null) {
            BooleanHintReference.$$$reportNull$$$0(1);
        }
        return this.myValues;
    }

    @Override
    @NotNull
    public String getUnresolvedMessagePattern() {
        if (this.myValues.length > 5) {
            String string = super.getUnresolvedMessagePattern();
            if (string == null) {
                BooleanHintReference.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = MicroservicesConfigBundle.partialMessage("config.unresolved.static.value", 1, StringUtil.join((String[])this.myValues, (String)"|"));
        if (string == null) {
            BooleanHintReference.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/microservices/jvm/config/hints/BooleanHintReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/microservices/jvm/config/hints/BooleanHintReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHintVariants";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

