/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.convertcontentstoattribute;

import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.xrp.base.XRPUsageInfo;
import com.sixrr.xrp.psi.XMLMutationUtils;
import com.sixrr.xrp.utils.XMLRefactoringUtil;

class ConvertContentsToAttribute
extends XRPUsageInfo {
    private final XmlTag tag;
    private final String attributeName;
    private final boolean trim;

    ConvertContentsToAttribute(XmlTag tag, String attributeName, boolean trim) {
        super((PsiElement)tag);
        this.tag = tag;
        this.attributeName = attributeName;
        this.trim = trim;
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        String xmlTagBody = XMLMutationUtils.calculateContentsString(this.tag);
        if (this.trim) {
            xmlTagBody = xmlTagBody.trim();
        }
        String escapedContents = XMLRefactoringUtil.XMLEscape(xmlTagBody);
        if (!XMLMutationUtils.tagHasContents(this.tag)) {
            String startString = this.tag.getText();
            String newTag = String.valueOf(startString.subSequence(0, startString.length() - 2)) + " " + this.attributeName + " = \"\"/>";
            XMLMutationUtils.replaceTag(this.tag, newTag);
        } else {
            String startString = XMLMutationUtils.calculateStartTagString(this.tag);
            String newTag = String.valueOf(startString.subSequence(0, startString.length() - 1)) + " " + this.attributeName + " = \"" + escapedContents + "\"/>";
            XMLMutationUtils.replaceTag(this.tag, newTag);
        }
    }
}

