/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.node_modules;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesLibraryDirectory;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

class NodeModulesLibrariesSnapshot {
    private static final Logger LOG = Logger.getInstance(NodeModulesLibrariesSnapshot.class);
    private final List<NodeModulesLibraryDirectory> myLibraryDirs;
    private final @Unmodifiable Map<VirtualFile, NodeModulesLibraryDirectory> myMap;
    private final Map<VirtualFile, NodeModulesLibraryDirectory> myRootMap;

    NodeModulesLibrariesSnapshot(@NotNull NodeModulesDirectoryManager directoryManager, @NotNull Set<VirtualFile> nodeModulesDirs, @NotNull Set<VirtualFile> packageJsonFiles) {
        if (directoryManager == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(0);
        }
        if (nodeModulesDirs == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(1);
        }
        if (packageJsonFiles == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(2);
        }
        ArrayList workspaces = new ArrayList(nodeModulesDirs.size());
        Project project = directoryManager.getProject();
        ReadAction.run(() -> {
            VirtualFile rootDir;
            NotNullLazyValue contentRoots = NotNullLazyValue.createValue(() -> ContainerUtil.newHashSet((Object[])ProjectRootManager.getInstance((Project)project).getContentRoots()));
            HashMap<VirtualFile, Workspace> workspaceMap = new HashMap<VirtualFile, Workspace>(nodeModulesDirs.size());
            for (VirtualFile nodeModulesDir : nodeModulesDirs) {
                rootDir = nodeModulesDir.getParent();
                if (nodeModulesDir.isValid() && rootDir != null) {
                    String name = NodeModulesLibrariesSnapshot.buildLibraryName(project, nodeModulesDir, (NotNullLazyValue<Set<VirtualFile>>)contentRoots);
                    NodeModulesLibraryDirectory libraryDir = new NodeModulesLibraryDirectory(directoryManager, nodeModulesDir, name);
                    Workspace workspace = new Workspace(project, rootDir, libraryDir);
                    workspaces.add(workspace);
                    workspaceMap.put(workspace.myRoot, workspace);
                    continue;
                }
                LOG.warn("Filtering out invalid library node_modules: " + nodeModulesDir.getPath());
            }
            for (VirtualFile packageJson : packageJsonFiles) {
                if (!packageJson.isValid() || (rootDir = packageJson.getParent()) == null || workspaceMap.containsKey(rootDir)) continue;
                workspaces.add(new Workspace(project, rootDir, null));
            }
            Collections.sort(workspaces);
            for (int i = 0; i < workspaces.size(); ++i) {
                Workspace child;
                Workspace root = (Workspace)workspaces.get(i);
                if (root.myDirectory == null) continue;
                for (int j = i + 1; j < workspaces.size() && root.isAncestorOf(child = (Workspace)workspaces.get(j)); ++j) {
                    if (child.myDirectory != null) {
                        root.myDirectory.addDescendant(child.myDirectory);
                    }
                    if (!root.matchesChildWorkspace(child)) continue;
                    if (child.myDirectory != null) {
                        child.myDirectory.setWorkspaceRoot(root.myDirectory);
                        continue;
                    }
                    root.myDirectory.addChildWorkspace(child.myRoot);
                }
            }
        });
        this.myLibraryDirs = workspaces.stream().map(workspace -> workspace.myDirectory).filter(Objects::nonNull).collect(Collectors.toList());
        this.myMap = ContainerUtil.newMapFromValues(this.myLibraryDirs.iterator(), dir -> dir.getNodeModulesDir());
        this.myRootMap = ContainerUtil.map2MapNotNull(this.myLibraryDirs, dir -> {
            VirtualFile nodeModulesDir = dir.getNodeModulesDir();
            VirtualFile requireScopeRoot = nodeModulesDir.getParent();
            return requireScopeRoot == null ? null : Pair.create((Object)requireScopeRoot, (Object)dir);
        });
    }

    @Nullable
    NodeModulesLibraryDirectory findUpLibraryDirectory(@NotNull VirtualFile contextFile) {
        if (contextFile == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(3);
        }
        return JSProjectUtil.traverseUpAndFindFirst(contextFile, f -> this.myRootMap.get(f));
    }

    @NotNull
    public List<NodeModulesLibraryDirectory> getLibraryDirs() {
        List<NodeModulesLibraryDirectory> list = this.myLibraryDirs;
        if (list == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public String findLibraryName(@NotNull VirtualFile nodeModulesDir) {
        NodeModulesLibraryDirectory directory;
        if (nodeModulesDir == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(5);
        }
        return (directory = this.myMap.get(nodeModulesDir)) != null ? directory.getLibraryName() : null;
    }

    @Nullable
    public NodeModulesLibraryDirectory findLibraryDir(@NotNull VirtualFile nodeModulesDir) {
        if (nodeModulesDir == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(6);
        }
        return this.myMap.get(nodeModulesDir);
    }

    public void onPackageJsonFileChanged(@NotNull VirtualFile packageJson) {
        NodeModulesLibraryDirectory d;
        NodeModulesLibraryDirectory directory;
        VirtualFile nodeModulesDir;
        if (packageJson == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(7);
        }
        if ((nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(packageJson)) != null && (directory = this.myMap.get(nodeModulesDir)) != null) {
            directory.invalidateRoots();
        }
        if ((d = this.findNodeModulesDirectoryByTopLevelDependentFile(packageJson)) != null) {
            d.invalidateRoots();
        }
    }

    @Nullable
    NodeModulesLibraryDirectory findNodeModulesDirectoryByTopLevelDependentFile(@NotNull VirtualFile file) {
        VirtualFile dir;
        if (file == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(8);
        }
        VirtualFile virtualFile = dir = file.isDirectory() ? file : file.getParent();
        for (int steps = 3; steps > 0 && dir != null; dir = dir.getParent(), --steps) {
            NodeModulesLibraryDirectory directory = this.myMap.get(dir);
            if (directory == null) continue;
            return directory;
        }
        return null;
    }

    @NotNull
    private static String buildLibraryName(@NotNull Project project, @NotNull VirtualFile nodeModulesDir, @NotNull NotNullLazyValue<Set<VirtualFile>> contentRoots) {
        String relativePath;
        VirtualFile baseDir;
        if (project == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(9);
        }
        if (nodeModulesDir == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(10);
        }
        if (contentRoots == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(11);
        }
        if ((baseDir = project.getBaseDir()) != null && (relativePath = NodeModulesLibrariesSnapshot.buildRelativeName(nodeModulesDir, baseDir, false)) != null) {
            String string = relativePath;
            if (string == null) {
                NodeModulesLibrariesSnapshot.$$$reportNull$$$0(12);
            }
            return string;
        }
        VirtualFile contentRoot = NodeModulesLibrariesSnapshot.findContentRoot(nodeModulesDir, (Set)contentRoots.getValue());
        if (contentRoot != null) {
            String relativePath2 = NodeModulesLibrariesSnapshot.buildRelativeName(nodeModulesDir, contentRoot, false);
            if (relativePath2 != null) {
                String string = relativePath2;
                if (string == null) {
                    NodeModulesLibrariesSnapshot.$$$reportNull$$$0(13);
                }
                return string;
            }
            LOG.error("Failed to buildRelativeName(" + nodeModulesDir.getPath() + ", " + contentRoot.getPath() + ")");
        }
        LOG.warn("Cannot generate library name for " + nodeModulesDir.getPath());
        String path2 = NodeModulesLibrariesSnapshot.buildRelativeName(nodeModulesDir, nodeModulesDir, true);
        if (path2 != null) {
            String string = path2;
            if (string == null) {
                NodeModulesLibrariesSnapshot.$$$reportNull$$$0(14);
            }
            return string;
        }
        LOG.error("Failed to build relative name to itself: " + nodeModulesDir.getPath());
        return "unknown_node_modules";
    }

    @Nullable
    private static String buildRelativeName(@NotNull VirtualFile nodeModulesDir, @NotNull VirtualFile root, boolean prependEllipses) {
        String relativePath;
        if (nodeModulesDir == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(15);
        }
        if (root == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(16);
        }
        if (nodeModulesDir.equals(root)) {
            VirtualFile parentRoot = root.getParent();
            if (parentRoot == null) {
                return nodeModulesDir.getPath();
            }
            root = parentRoot;
        }
        if ((relativePath = VfsUtilCore.getRelativePath((VirtualFile)nodeModulesDir, (VirtualFile)root, (char)'/')) != null) {
            StringBuilder pathBuilder = new StringBuilder(root.getNameSequence());
            pathBuilder.append('/').append(relativePath);
            if (prependEllipses) {
                pathBuilder.insert(0, ".../");
            }
            return pathBuilder.toString();
        }
        return null;
    }

    @Nullable
    private static VirtualFile findContentRoot(@NotNull VirtualFile file, @NotNull Set<VirtualFile> contentRoots) {
        VirtualFile f;
        if (file == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(17);
        }
        if (contentRoots == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(18);
        }
        for (f = file; f != null && !contentRoots.contains(f); f = f.getParent()) {
        }
        return f;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModulesDirs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFiles";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/node_modules/NodeModulesLibrariesSnapshot";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModulesDir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoots";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/node_modules/NodeModulesLibrariesSnapshot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryDirs";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "buildLibraryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findUpLibraryDirectory";
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryDir";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onPackageJsonFileChanged";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findNodeModulesDirectoryByTopLevelDependentFile";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildLibraryName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "buildRelativeName";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findContentRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 12, 13, 14 -> new IllegalStateException(string);
        };
    }

    private static class Workspace
    implements Comparable<Workspace> {
        @Nullable
        private final NodeModulesLibraryDirectory myDirectory;
        private final VirtualFile myRoot;
        private final String myRootPath;
        private final Project myProject;
        @Nullable
        private List<PathMatcher> myWorkspaceMatchers;

        Workspace(@NotNull Project project, @NotNull VirtualFile root, @Nullable NodeModulesLibraryDirectory directory) {
            if (project == null) {
                Workspace.$$$reportNull$$$0(0);
            }
            if (root == null) {
                Workspace.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myRoot = root;
            this.myRootPath = this.myRoot.getPath();
            this.myDirectory = directory;
        }

        @NotNull
        private List<PathMatcher> getWorkspaceMatchers() {
            List workspaceMatchers = this.myWorkspaceMatchers;
            if (workspaceMatchers == null) {
                List<String> workspaces = this.parseWorkspaces();
                this.myWorkspaceMatchers = workspaceMatchers = ContainerUtil.map(workspaces, workspace -> FileSystems.getDefault().getPathMatcher("glob:" + StringUtil.trimStart((String)workspace, (String)"./")));
            }
            List list = workspaceMatchers;
            if (list == null) {
                Workspace.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Nullable
        private PackageJsonData getPackageJsonData() {
            VirtualFile packageJson;
            VirtualFile virtualFile = packageJson = this.myRoot != null ? PackageJsonUtil.findChildPackageJsonFile(this.myRoot) : null;
            if (packageJson == null) {
                return null;
            }
            return PackageJsonData.getOrCreateWithPreferredProject(this.myProject, packageJson);
        }

        private boolean isAncestorOf(@NotNull Workspace child) {
            if (child == null) {
                Workspace.$$$reportNull$$$0(3);
            }
            return child.myRootPath.startsWith(this.myRootPath) && child.myRootPath.length() > this.myRootPath.length() && child.myRootPath.charAt(this.myRootPath.length()) == '/';
        }

        private boolean matchesChildWorkspace(@NotNull Workspace child) {
            List<PathMatcher> matchers;
            if (child == null) {
                Workspace.$$$reportNull$$$0(4);
            }
            if ((matchers = this.getWorkspaceMatchers()).isEmpty()) {
                return false;
            }
            String relativePath = child.myRootPath.substring(this.myRootPath.length() + 1);
            Path path2 = Paths.get(relativePath, new String[0]);
            for (PathMatcher matcher : matchers) {
                if (!matcher.matches(path2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int compareTo(@NotNull Workspace w) {
            if (w == null) {
                Workspace.$$$reportNull$$$0(5);
            }
            return this.myRootPath.compareTo(w.myRootPath);
        }

        @NotNull
        private List<String> parseWorkspaces() {
            VirtualFile pnpmWorkspaceYamlFile = this.myRoot.findChild("pnpm-workspace.yaml");
            if (pnpmWorkspaceYamlFile != null && pnpmWorkspaceYamlFile.isValid() && !pnpmWorkspaceYamlFile.isDirectory()) {
                return Workspace.parsePnpmWorkspaceYaml(pnpmWorkspaceYamlFile);
            }
            PackageJsonData data2 = this.getPackageJsonData();
            List list = data2 != null ? ContainerUtil.notNullize(data2.getWorkspaces()) : Collections.emptyList();
            if (list == null) {
                Workspace.$$$reportNull$$$0(6);
            }
            return list;
        }

        @NotNull
        private static List<String> parsePnpmWorkspaceYaml(@NotNull VirtualFile pnpmWorkspaceYamlFile) {
            List list;
            if (pnpmWorkspaceYamlFile == null) {
                Workspace.$$$reportNull$$$0(7);
            }
            try {
                String text = VfsUtilCore.loadText((VirtualFile)pnpmWorkspaceYamlFile);
                ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
                Map value = (Map)mapper.readValue(text, Map.class);
                List result2 = (List)ObjectUtils.tryCast(value.get("packages"), List.class);
                list = ContainerUtil.filterIsInstance((Collection)Objects.requireNonNullElse(result2, List.of()), String.class);
            }
            catch (Exception e) {
                LOG.warn("Failed to parse pnpm workspace yaml file", (Throwable)e);
                List<String> list2 = List.of();
                if (list2 == null) {
                    Workspace.$$$reportNull$$$0(9);
                }
                return list2;
            }
            if (list == null) {
                Workspace.$$$reportNull$$$0(8);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 6, 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 2: 
                case 6: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/library/node_modules/NodeModulesLibrariesSnapshot$Workspace";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "w";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pnpmWorkspaceYamlFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/library/node_modules/NodeModulesLibrariesSnapshot$Workspace";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWorkspaceMatchers";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseWorkspaces";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parsePnpmWorkspaceYaml";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 6: 
                case 8: 
                case 9: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAncestorOf";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "matchesChildWorkspace";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "parsePnpmWorkspaceYaml";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 6, 8, 9 -> new IllegalStateException(string);
            };
        }
    }
}

