/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.mongodb.json.editor;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.mongodb.json.MongoDBJsonElementTypes;
import com.intellij.persistence.mongodb.json.editor.MongoDBJsonTypedHandlerKt;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonFile;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonProperty;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0012\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/persistence/mongodb/json/editor/MongoDBJsonTypedHandler;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "<init>", "()V", "myWhitespaceAdded", "", "charTyped", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "c", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "removeRedundantWhitespaceIfAfterColon", "", "addWhiteSpaceAfterColonIfNeeded", "intellij.javaee.persistence.impl"})
public final class MongoDBJsonTypedHandler
extends TypedHandlerDelegate {
    private boolean myWhitespaceAdded;

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file instanceof MongoDBJsonFile) {
            MongoDBJsonTypedHandlerKt.processMongoPairedBracesComma(c, editor, file);
            this.addWhiteSpaceAfterColonIfNeeded(c, editor, file);
            this.removeRedundantWhitespaceIfAfterColon(c, editor, file);
            MongoDBJsonTypedHandlerKt.access$handleMoveOutsideQuotes(c, editor, file);
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private final void removeRedundantWhitespaceIfAfterColon(char c, Editor editor, PsiFile file) {
        if (!this.myWhitespaceAdded || c != ' ') {
            if (c != ':') {
                this.myWhitespaceAdded = false;
            }
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
        PsiElement element = file.findElementAt(offset);
        if (element instanceof PsiWhiteSpace) {
            editor.getDocument().deleteString(offset - 1, offset);
        }
        this.myWhitespaceAdded = false;
    }

    private final void addWhiteSpaceAfterColonIfNeeded(char c, Editor editor, PsiFile file) {
        boolean bl;
        if (c != ':') {
            if (c != ' ') {
                this.myWhitespaceAdded = false;
            }
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.skipWhitespacesBackward((PsiElement)file.findElementAt(offset)), MongoDBJsonProperty.class, (boolean)false);
        if (element == null) {
            this.myWhitespaceAdded = false;
            return;
        }
        IElementType[] iElementTypeArray = new IElementType[]{MongoDBJsonElementTypes.COLON};
        ASTNode[] aSTNodeArray = element.getNode().getChildren(TokenSet.create((IElementType[])iElementTypeArray));
        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"getChildren(...)");
        ASTNode[] children = aSTNodeArray;
        if (children.length == 0) {
            this.myWhitespaceAdded = false;
            return;
        }
        ASTNode colon = children[0];
        ASTNode next = colon.getTreeNext();
        String string = next.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text = string;
        if (((CharSequence)text).length() == 0 || !StringsKt.isBlank((CharSequence)text) || StringUtil.isLineBreak((char)text.charAt(0))) {
            int insOffset = colon.getStartOffset() + 1;
            editor.getDocument().insertString(insOffset, (CharSequence)" ");
            editor.getCaretModel().moveToOffset(insOffset + 1);
            bl = true;
        } else {
            bl = false;
        }
        this.myWhitespaceAdded = bl;
    }
}

