/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.velocity.StubVtlTypeSystem;
import com.intellij.velocity.psi.VtlExpression;
import com.intellij.velocity.psi.VtlImplicitVariable;
import com.intellij.velocity.psi.VtlLiteralExpressionType;
import com.intellij.velocity.psi.VtlVariableType;
import com.intellij.velocity.psi.files.VtlFile;
import com.intellij.velocity.psi.reference.VtlReferenceExpression;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface VtlTypeSystem {
    public static final ExtensionPointName<VtlTypeSystem> EP_NAME = ExtensionPointName.create((String)"com.intellij.velocity.typeSystem");
    public static final VtlTypeSystem STUB_TYPE_SYSTEM = new StubVtlTypeSystem();

    @NotNull
    public VtlReferenceExpression createReferenceElement(@NotNull ASTNode var1);

    @NotNull
    public VtlVariableType createTypeFromSignature(@NotNull Project var1, @Nullable PsiElement var2, @NotNull String var3);

    @NotNull
    public VtlVariableType booleanType();

    @NotNull
    public VtlVariableType intType();

    @NotNull
    public VtlVariableType doubleType();

    @NotNull
    public VtlVariableType longType();

    @Nullable
    public VtlVariableType getBoxedType(@Nullable VtlVariableType var1, @NotNull PsiElement var2);

    public boolean areTypesConvertible(@NotNull VtlVariableType var1, @NotNull VtlVariableType var2);

    @NotNull
    public String getPresentableText(@NotNull VtlVariableType var1);

    @Nullable
    public VtlVariableType extractTypeFromIterable(@Nullable VtlExpression var1);

    @NotNull
    public VtlVariableType createTypeByFQClassName(@NotNull Project var1, @NotNull String var2, @NotNull GlobalSearchScope var3);

    @Nullable
    public VtlVariableType createImplicitVariableType(@NotNull Project var1, @NotNull String var2, @NotNull GlobalSearchScope var3);

    @NotNull
    public Collection<String> inferVariableType(@NotNull VtlImplicitVariable var1);

    public boolean isNumericType(@NotNull VtlVariableType var1);

    @NotNull
    public VtlVariableType unboxAndBalanceTypes(@NotNull VtlVariableType var1, @NotNull VtlVariableType var2);

    public boolean isConvertibleFrom(@NotNull VtlVariableType var1, @NotNull VtlVariableType var2);

    @Nullable
    public VtlVariableType inferIndexQualifierType(VtlVariableType var1);

    @NotNull
    public LiteralTextEscaper<VtlLiteralExpressionType.VtlStringLiteral> createLiteralEscaper(@NotNull VtlLiteralExpressionType.VtlStringLiteral var1);

    public void processImplicitVarsProvider(@NotNull VtlFile var1, @NotNull Map<String, VtlImplicitVariable> var2);

    public static VtlTypeSystem getTypeSystem() {
        Iterator typeSystems = EP_NAME.getExtensionList().iterator();
        if (typeSystems.hasNext()) {
            return (VtlTypeSystem)typeSystems.next();
        }
        return STUB_TYPE_SYSTEM;
    }
}

