/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.javaee.web.el.impl;

import com.intellij.javaee.el.ELCallExpression;
import com.intellij.javaee.el.ELElementProcessor;
import com.intellij.javaee.el.ELExpressionHolder;
import com.intellij.javaee.el.ElMethodSignatureFilter;
import com.intellij.javaee.el.psi.ELVariable;
import com.intellij.javaee.el.util.ELResolveUtil;
import com.intellij.javaee.el.util.ElComponentTypeUtil;
import com.intellij.javaee.el.util.PropertyAccessorMethodSignatureFilter;
import com.intellij.javaee.model.psi.JavaeeImplicitVariable;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.javaee.web.WebCommonClassNames;
import com.intellij.jsp.JspManager;
import com.intellij.jsp.impl.ExtendedTEI;
import com.intellij.jsp.impl.FunctionDescriptor;
import com.intellij.jsp.impl.JspElementDescriptorEx;
import com.intellij.jsp.javaee.web.JspImplUtil;
import com.intellij.jsp.javaee.web.JspImplicitVariableImpl;
import com.intellij.jsp.javaee.web.JspManagerImpl;
import com.intellij.jsp.javaee.web.el.impl.JspElVariablesProvider;
import com.intellij.jsp.javaee.web.el.impl.TagImplicitVariable;
import com.intellij.jsp.javaee.web.el.impl.references.FunctionELReference;
import com.intellij.jsp.util.JspUtil;
import com.intellij.lang.jsp.JspVersion;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.NotNullFunction;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.xml.XmlElementDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.VariableInfo;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JspELResolveUtil {
    @NonNls
    public static final String VALUE_ATTRIBUTE_NAME = "value";
    @NonNls
    static final String FOR_TOKENS_TAG_NAME = "forTokens";
    @NonNls
    static final String FOR_EACH_TAG_NAME = "forEach";
    @NonNls
    static final String ITEMS_ATTR_NAME = "items";
    @NonNls
    static final String VALUE_ATTR_NAME = "value";
    private static final Key<CachedValue<List<JavaeeImplicitVariable>>> EL_VARS_MAP = Key.create((String)"el vars");
    private static final Key<CachedValue<List<JavaeeImplicitVariable>>> EL_TEI_VARS_MAP = Key.create((String)"el vars");
    @NonNls
    private static final String VAR_STATUS_ATTR_NAME = "varStatus";
    private static final ThreadLocal<Set<PsiFile>> VISITED = ThreadLocal.withInitial(HashSet::new);
    private static final UserDataCache<CachedValue<List<JavaeeImplicitVariable>>, XmlTag, Object> ourCachedTeiVarsCache = new UserDataCache<CachedValue<List<JavaeeImplicitVariable>>, XmlTag, Object>(){

        protected CachedValue<List<JavaeeImplicitVariable>> compute(XmlTag tag, Object p) {
            return CachedValuesManager.getManager((Project)tag.getProject()).createCachedValue(() -> {
                VariableInfo[] variableInfos;
                SmartList resultVars = null;
                XmlElementDescriptor descriptor = tag.getDescriptor();
                PsiFile psiFile = tag.getContainingFile().getOriginalFile();
                VirtualFile file = psiFile.getVirtualFile();
                TagExtraInfo extraInfo = descriptor instanceof JspElementDescriptorEx && file != null ? ((JspElementDescriptorEx)descriptor).getExtraInfo(ProjectRootManager.getInstance((Project)psiFile.getProject()).getFileIndex().getModuleForFile(file)) : null;
                VariableInfo[] variableInfoArray = variableInfos = extraInfo != null ? extraInfo.getVariableInfo(JspImplUtil.getTagData(tag)) : null;
                if (variableInfos != null && variableInfos.length > 0) {
                    resultVars = new SmartList();
                    for (VariableInfo info : variableInfos) {
                        if (info == null) continue;
                        PsiElement identifierForVariable = null;
                        if (extraInfo instanceof ExtendedTEI) {
                            identifierForVariable = ((ExtendedTEI)extraInfo).getIdentifierForVariable(info, tag);
                        }
                        String className = info.getClassName() != null ? info.getClassName() : "java.lang.Object";
                        PsiType type = PsiImplUtil.buildTypeFromTypeString((String)className, (PsiElement)tag, (PsiFile)psiFile);
                        resultVars.add(new JspImplicitVariableImpl((PsiElement)psiFile, info.getVarName(), type, (PsiElement)(identifierForVariable != null ? identifierForVariable : tag), info.getScope() == 1 ? "AT_BEGIN" : (info.getScope() == 2 ? "AT_END" : null)));
                    }
                }
                return new CachedValueProvider.Result((Object)resultVars, new Object[]{descriptor != null ? descriptor.getDependencies() : ArrayUtilRt.EMPTY_OBJECT_ARRAY, psiFile, JspManagerImpl.getInstance(psiFile.getProject()).getRootsModificationTracker(), PsiModificationTracker.MODIFICATION_COUNT});
            }, false);
        }
    };
    private static final UserDataCache<CachedValue<List<JavaeeImplicitVariable>>, XmlTag, NotNullFunction<? super XmlTag, String>> ourCachedELVarsCache = new UserDataCache<CachedValue<List<JavaeeImplicitVariable>>, XmlTag, NotNullFunction<? super XmlTag, String>>(){

        protected CachedValue<List<JavaeeImplicitVariable>> compute(XmlTag tag, NotNullFunction<? super XmlTag, String> defaultVarTypeProvider) {
            return CachedValuesManager.getManager((Project)tag.getProject()).createCachedValue(() -> {
                List<JavaeeImplicitVariable> resultVars = (List<JavaeeImplicitVariable>)((CachedValue)ourCachedTeiVarsCache.get(EL_TEI_VARS_MAP, (UserDataHolder)tag, null)).getValue();
                if (resultVars == null) {
                    resultVars = JspELResolveUtil.computeTagVariables(tag, defaultVarTypeProvider);
                }
                Object[] deps = new Object[]{tag.getContainingFile(), PsiModificationTracker.MODIFICATION_COUNT};
                return new CachedValueProvider.Result(resultVars, deps);
            }, false);
        }
    };
    private static final UserDataCache<CachedValue<Map<String, JavaeeImplicitVariable>>, PsiFile, VariableInfoData> ourCachedPredefinedVarsCache = new UserDataCache<CachedValue<Map<String, JavaeeImplicitVariable>>, PsiFile, VariableInfoData>(){

        protected CachedValue<Map<String, JavaeeImplicitVariable>> compute(PsiFile file, VariableInfoData data) {
            return CachedValuesManager.getManager((Project)file.getProject()).createCachedValue(() -> {
                HashMap<String, JspImplicitVariableImpl> predefinedVars = new HashMap<String, JspImplicitVariableImpl>(data.myVars.size());
                Project project = file.getProject();
                PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)project);
                for (VariableInfoBean variableInfoBean : data.myVars) {
                    JspImplicitVariableImpl var = new JspImplicitVariableImpl((PsiElement)file, variableInfoBean.getName(), (PsiType)(variableInfoBean.isMapValue() ? JspELResolveUtil.createTypedMapType((PsiElement)file, "java.lang.String", variableInfoBean.getType()) : elementFactory.createTypeByFQClassName(variableInfoBean.getType(), allScope)), null);
                    predefinedVars.put(var.getName(), var);
                }
                if (file instanceof JspFile) {
                    ArrayList tagFileVars = new ArrayList();
                    JspImplUtil.addSharedImplicitVars((PsiElement)file, (JspFile)file, tagFileVars, JavaeeType.discover((PsiElement)file, (JavaeeClass)WebCommonClassNames.HTTP_SESSION));
                    JspElVariablesProvider.collectVariablesFromFile((JspFile)file, tagFileVars);
                    for (JspImplicitVariableImpl var : tagFileVars) {
                        predefinedVars.put(var.getName(), var);
                    }
                }
                Object[] deps = new Object[]{file, PsiModificationTracker.MODIFICATION_COUNT};
                return CachedValueProvider.Result.create(predefinedVars, (Object[])deps);
            }, false);
        }
    };

    private JspELResolveUtil() {
    }

    @Nullable
    public static List<JavaeeImplicitVariable> createOrGetVariables(XmlTag element, NotNullFunction<? super XmlTag, String> defaultVarTypeProvider) {
        return (List)((CachedValue)ourCachedELVarsCache.get(EL_VARS_MAP, (UserDataHolder)element, defaultVarTypeProvider)).getValue();
    }

    private static List<JavaeeImplicitVariable> computeTagVariables(XmlTag tag, NotNullFunction<? super XmlTag, String> defaultVarTypeProvider) {
        SmartList resultVars = new SmartList();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)tag.getProject());
        JspElVariablesProvider.addVarsFromComments(tag, (List<? super JavaeeImplicitVariable>)resultVars);
        XmlAttribute attribute = tag.getAttribute("var");
        if (attribute != null && attribute.getValue() != null) {
            @NonNls String localName = tag.getLocalName();
            String range = localName.equals(FOR_EACH_TAG_NAME) || localName.equals(FOR_TOKENS_TAG_NAME) ? "NESTED" : "AT_BEGIN";
            TagImplicitVariable variable = new TagImplicitVariable(tag, attribute, range, defaultVarTypeProvider);
            resultVars.add(variable);
        }
        if ((attribute = tag.getAttribute(VAR_STATUS_ATTR_NAME)) != null && attribute.getValue() != null) {
            resultVars.add(new JspImplicitVariableImpl((PsiElement)tag, attribute.getValue(), (PsiType)facade.getElementFactory().createTypeByFQClassName("javax.servlet.jsp.jstl.core.LoopTagStatus"), (PsiElement)attribute.getValueElement(), "NESTED"));
        }
        return resultVars;
    }

    public static PsiType createTypedMapType(@NotNull PsiElement context, @NotNull String keyClass, @NotNull String valueClass) {
        PsiClass mapKeyClass;
        PsiClass valuePsiClass;
        PsiClassType mapValueType;
        if (context == null) {
            JspELResolveUtil.$$$reportNull$$$0(0);
        }
        if (keyClass == null) {
            JspELResolveUtil.$$$reportNull$$$0(1);
        }
        if (valueClass == null) {
            JspELResolveUtil.$$$reportNull$$$0(2);
        }
        GlobalSearchScope scope = ElComponentTypeUtil.getElementDependenciesScope((PsiElement)context);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)context.getProject());
        PsiClass mapClass = facade.findClass("java.util.Map", scope);
        PsiElementFactory elementFactory = facade.getElementFactory();
        if (mapClass == null) {
            return elementFactory.createTypeByFQClassName("java.util.Map");
        }
        int arrIndex = valueClass.indexOf("[]");
        if (arrIndex != -1) {
            valueClass = valueClass.substring(0, arrIndex);
        }
        PsiClassType psiClassType = mapValueType = (valuePsiClass = facade.findClass(valueClass, scope)) != null ? elementFactory.createType(valuePsiClass) : elementFactory.createTypeByFQClassName(valueClass);
        if (arrIndex != -1) {
            mapValueType = new PsiArrayType((PsiType)mapValueType);
        }
        PsiClassType keyType = (mapKeyClass = facade.findClass(keyClass, scope)) != null ? elementFactory.createType(mapKeyClass) : elementFactory.createTypeByFQClassName(keyClass);
        PsiSubstitutor rawSubstitutor = elementFactory.createRawSubstitutor((PsiTypeParameterListOwner)mapClass);
        PsiSubstitutor psiSubstitutor = rawSubstitutor.putAll(mapClass, new PsiType[]{keyType, mapValueType});
        return elementFactory.createType(mapClass, psiSubstitutor);
    }

    @Nullable
    public static FunctionDescriptor getFunctionDescriptor(ELCallExpression functionExpr) {
        if (functionExpr != null) {
            ELVariable method = functionExpr.getMethod();
            if (method == null) {
                return null;
            }
            PsiElement element = method.getReferences()[0].resolve();
            if (element instanceof XmlTag) {
                return FunctionELReference.getFunctionDescriptor((XmlTag)element);
            }
        }
        return null;
    }

    public static Map<String, JavaeeImplicitVariable> createOrGetPredefinedVariablesMapImpl(PsiFile file, VariableInfoData data) {
        return (Map)((CachedValue)ourCachedPredefinedVarsCache.get(data.cachingKey, (UserDataHolder)file, (Object)data)).getValue();
    }

    public static boolean iterateClassProperties(PsiClass psiClass, ELElementProcessor processor, boolean readable) {
        return ELResolveUtil.iterateClassProperties((PsiClass)psiClass, (ELElementProcessor)processor, (ElMethodSignatureFilter)new PropertyAccessorMethodSignatureFilter(readable));
    }

    private static boolean isNewJsp(PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return true;
        }
        return JspManager.getInstance((Project)element.getProject()).getJspVersion((PsiFileSystemItem)containingFile).betterThan(JspVersion.JSP_2_1);
    }

    public static XmlTag getParentTagToStartResolving(PsiElement element, ELExpressionHolder expressionHolder) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false);
        if (tag != null && expressionHolder.getParent() instanceof XmlAttributeValue) {
            tag = tag.getParentTag();
        }
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean walkFromContext(@Nullable XmlTag tag, ELElementProcessor processor, NotNullFunction<? super XmlTag, String> defaultVarTypeProvider, PsiElement expressionHolder) {
        PsiFile psiFile;
        String attrName;
        XmlTag nearestTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)expressionHolder, XmlTag.class);
        MyXmlTagProcessor tagProcessor = null;
        XmlTag prevContextTag = expressionHolder.getParent() == tag ? (XmlTag)PsiTreeUtil.getPrevSiblingOfType((PsiElement)expressionHolder, XmlTag.class) : (XmlTag)PsiTreeUtil.getPrevSiblingOfType((PsiElement)nearestTag, XmlTag.class);
        int childIndexOffset = 0;
        if (expressionHolder.getParent() instanceof XmlAttributeValue && nearestTag != null && nearestTag.isEmpty() && nearestTag.getAttributeValue("var") != null && !"value".equals(attrName = ((XmlAttribute)expressionHolder.getParent().getParent()).getName()) && !ITEMS_ATTR_NAME.equals(attrName)) {
            tagProcessor = new MyXmlTagProcessor(defaultVarTypeProvider, processor);
            nearestTag.accept((PsiElementVisitor)tagProcessor);
            if (tagProcessor.result) {
                return false;
            }
        }
        XmlTag contextTag = tag;
        while (contextTag != null) {
            int indexOfPrevContextInParent = -1;
            XmlTag[] subTags = contextTag.getSubTags();
            if (prevContextTag != null) {
                for (XmlTag subTag : subTags) {
                    ++indexOfPrevContextInParent;
                    if (subTag != prevContextTag) {
                        continue;
                    }
                    break;
                }
            } else {
                indexOfPrevContextInParent = subTags.length;
            }
            if (indexOfPrevContextInParent < subTags.length) {
                if (tagProcessor == null) {
                    tagProcessor = new MyXmlTagProcessor(defaultVarTypeProvider, processor);
                }
                for (int i = indexOfPrevContextInParent - childIndexOffset; i >= 0; --i) {
                    subTags[i].accept((PsiElementVisitor)tagProcessor);
                    if (!tagProcessor.result) continue;
                    return false;
                }
            }
            childIndexOffset = 1;
            if (JspELResolveUtil.doEval(contextTag, defaultVarTypeProvider, processor, true)) {
                return false;
            }
            prevContextTag = contextTag;
            contextTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)contextTag, XmlTag.class);
        }
        PsiFile psiFile2 = psiFile = tag != null ? tag.getContainingFile() : expressionHolder.getContainingFile();
        if (psiFile instanceof JspFile && psiFile == expressionHolder.getContainingFile()) {
            if (VISITED.get().add(psiFile)) {
                if (tagProcessor == null) {
                    tagProcessor = new MyXmlTagProcessor(defaultVarTypeProvider, processor);
                }
                try {
                    JspUtil.visitAllIncludedFilesRecursively((JspFile)psiFile, false, tagProcessor);
                }
                finally {
                    VISITED.get().remove(psiFile);
                }
                if (tagProcessor.result) {
                    return false;
                }
            } else {
                ELResolveUtil.LOG.error("Recursion occurred", new Throwable());
            }
        }
        return true;
    }

    private static boolean doEval(XmlTag contextTag, NotNullFunction<? super XmlTag, String> defaultVarTypeProvider, ELElementProcessor processor, boolean insideOut) {
        List<JavaeeImplicitVariable> variables = JspELResolveUtil.createOrGetVariables(contextTag, defaultVarTypeProvider);
        if (variables != null) {
            boolean processedParent = false;
            for (JavaeeImplicitVariable variable : variables) {
                int declarationRange = variable.getDeclarationRange();
                if ((!insideOut || (declarationRange & 1) == 0) && (insideOut || (declarationRange & 2) == 0)) continue;
                PsiElement declarationScope = variable.getDeclarationScope();
                if (declarationScope instanceof XmlTag && processor.getNameHint() != null && ((XmlTag)declarationScope).getValue().getTextRange().getLength() == 0 && !processedParent) {
                    processedParent = true;
                    PsiElement parent = declarationScope.getParent();
                    if (parent instanceof XmlTag && JspELResolveUtil.doEval((XmlTag)parent, defaultVarTypeProvider, processor, true)) {
                        return true;
                    }
                }
                if (processor.processVariable((PsiVariable)variable)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "keyClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "valueClass";
                break;
            }
        }
        objectArray[1] = "com/intellij/jsp/javaee/web/el/impl/JspELResolveUtil";
        objectArray[2] = "createTypedMapType";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class VariableInfoData {
        final Key<CachedValue<Map<String, JavaeeImplicitVariable>>> cachingKey;
        private final List<VariableInfoBean> myVars = new ArrayList<VariableInfoBean>();

        public VariableInfoData(Key<CachedValue<Map<String, JavaeeImplicitVariable>>> _cachingKey) {
            this.cachingKey = _cachingKey;
        }

        public void add(String name, String type) {
            this.add(name, type, false);
        }

        public void add(String name, String type, boolean mapValue) {
            this.myVars.add(new VariableInfoBean(name, type, mapValue));
        }
    }

    private static class MyXmlTagProcessor
    extends XmlRecursiveElementVisitor
    implements Processor<JspFile> {
        private final NotNullFunction<? super XmlTag, String> myDefaultVarTypeProvider;
        private final ELElementProcessor myProcessor;
        boolean result;

        MyXmlTagProcessor(NotNullFunction<? super XmlTag, String> defaultVarTypeProvider, ELElementProcessor processor) {
            this.myDefaultVarTypeProvider = defaultVarTypeProvider;
            this.myProcessor = processor;
        }

        public void visitXmlTag(@NotNull XmlTag tag) {
            if (tag == null) {
                MyXmlTagProcessor.$$$reportNull$$$0(0);
            }
            if (!JspELResolveUtil.doEval(tag, this.myDefaultVarTypeProvider, this.myProcessor, false)) {
                for (XmlTag subTag : tag.getSubTags()) {
                    subTag.accept((PsiElementVisitor)this);
                    if (!this.result) {
                        continue;
                    }
                    break;
                }
            } else {
                this.result = true;
            }
        }

        public boolean process(JspFile jspFile) {
            if (!this.result) {
                this.visitFile((PsiFile)jspFile);
            }
            return !this.result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/jsp/javaee/web/el/impl/JspELResolveUtil$MyXmlTagProcessor", "visitXmlTag"));
        }
    }

    public static final class VariableInfoBean {
        private final String name;
        private final String type;
        private final boolean mapValue;

        private VariableInfoBean(String name, String type) {
            this(name, type, false);
        }

        private VariableInfoBean(String name, String type, boolean mapValue) {
            this.name = name;
            this.type = type;
            this.mapValue = mapValue;
        }

        public static VariableInfoBean create(String name, String type) {
            return new VariableInfoBean(name, type);
        }

        public static VariableInfoBean create(String name, String type, boolean mapvalue) {
            return new VariableInfoBean(name, type, mapvalue);
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean isMapValue() {
            return this.mapValue;
        }
    }
}

