/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.re;

import com.intellij.jpa.jpb.model.config.JpaPluginProjectConfig;
import com.intellij.jpa.jpb.model.config.ProjectState;
import com.intellij.jpa.jpb.model.orm.jpa.JpaOrmFramework;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.util.PsiUtil;
import com.intellij.re.ReverseCustomNamingService;
import com.intellij.re.orm.OrmReInfoProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0004\b\u0016\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ$\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0015\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J$\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000eH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/intellij/re/ReverseEngineeringHelper;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "childScope", "name", "", "generateJavaIdentifier", "initialSqlIdentifier", "identifierType", "Lcom/intellij/re/ReverseEngineeringHelper$IdentifierType;", "ormFramework", "Lcom/intellij/jpa/jpb/model/orm/model/OrmFramework;", "processSqlIdentifier", "sqlIdentifier", "excludeDbIdentifierPrefixes", "excludeDbIdentifierSuffixes", "parseExcludePrefixes", "", "prefixes", "IdentifierType", "Companion", "intellij.javaee.reverseEngineering"})
@SourceDebugExtension(value={"SMAP\nReverseEngineeringHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReverseEngineeringHelper.kt\ncom/intellij/re/ReverseEngineeringHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,179:1\n739#2,9:180\n1563#2:214\n1634#2,2:215\n1636#2:240\n37#3,2:189\n106#4:191\n78#4,22:192\n106#4:217\n78#4,22:218\n*S KotlinDebug\n*F\n+ 1 ReverseEngineeringHelper.kt\ncom/intellij/re/ReverseEngineeringHelper\n*L\n64#1:180,9\n136#1:214\n136#1:215,2\n136#1:240\n64#1:189,2\n90#1:191\n90#1:192,22\n136#1:217\n136#1:218,22\n*E\n"})
public class ReverseEngineeringHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private static final String GENERATED_SUFFIX = "underscore";

    public ReverseEngineeringHelper(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    @NotNull
    public final CoroutineScope childScope(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return CoroutineScopeKt.childScope$default((CoroutineScope)this.coroutineScope, (String)name, null, (boolean)false, (int)6, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String generateJavaIdentifier(@Nullable String initialSqlIdentifier, @NotNull IdentifierType identifierType, @NotNull OrmFramework ormFramework) {
        Object reverseCustomNamingService;
        Intrinsics.checkNotNullParameter((Object)((Object)identifierType), (String)"identifierType");
        Intrinsics.checkNotNullParameter((Object)ormFramework, (String)"ormFramework");
        String sqlIdentifier = initialSqlIdentifier;
        sqlIdentifier = this.processSqlIdentifier(sqlIdentifier, identifierType);
        if (StringUtils.isBlank((CharSequence)sqlIdentifier)) {
            return sqlIdentifier;
        }
        boolean mapReferencesToBasicType = JpaPluginProjectConfig.Companion.getInstance((Project)this.project).getState().mapReferencesToBasicType;
        if (identifierType == IdentifierType.ASSOCIATION_FIELD && !mapReferencesToBasicType) {
            int identifierLength = sqlIdentifier.length();
            String string = sqlIdentifier;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            if (StringsKt.endsWith$default((String)string2, (String)"_ID", (boolean)false, (int)2, null)) {
                sqlIdentifier = StringsKt.take((String)sqlIdentifier, (int)(identifierLength - 3));
            } else if (StringsKt.endsWith$default((String)sqlIdentifier, (String)"Id", (boolean)false, (int)2, null) && identifierLength >= 3 && Character.isLowerCase(sqlIdentifier.charAt(identifierLength - 3))) {
                sqlIdentifier = StringsKt.take((String)sqlIdentifier, (int)(identifierLength - 2));
            }
        }
        ProjectState projectState = JpaPluginProjectConfig.Companion.getInstance(this.project).getState();
        if (projectState.reEnableCustomNamingAlgorithm.booleanValue()) {
            reverseCustomNamingService = ReverseCustomNamingService.Companion.getInstance(this.project);
            if (identifierType == IdentifierType.CLASS) {
                return ((ReverseCustomNamingService)reverseCustomNamingService).toEntityName(sqlIdentifier);
            }
            if (identifierType == IdentifierType.FIELD) {
                return ((ReverseCustomNamingService)reverseCustomNamingService).toAttributeName(sqlIdentifier);
            }
        }
        reverseCustomNamingService = sqlIdentifier;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string = ((String)reverseCustomNamingService).toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        if (Intrinsics.areEqual((Object)sqlIdentifier, (Object)string)) {
            reverseCustomNamingService = sqlIdentifier;
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
            String string3 = ((String)reverseCustomNamingService).toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            sqlIdentifier = string3;
        }
        StringBuilder sb = new StringBuilder();
        if (StringsKt.contains$default((CharSequence)sqlIdentifier, (CharSequence)"_", (boolean)false, (int)2, null)) {
            void $this$toTypedArray$iv;
            List list;
            Collection $this$dropLastWhile$iv;
            Object object = sqlIdentifier;
            Regex regex = new Regex("[_]");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            for (String s : thisCollection$iv.toArray(new String[0])) {
                String string4;
                if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                StringBuilder stringBuilder = sb.append(Character.toUpperCase(s.charAt(0)));
                Intrinsics.checkNotNullExpressionValue((Object)s.substring(1), (String)"substring(...)");
                Locale locale3 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"getDefault(...)");
                String string5 = string4.toLowerCase(locale3);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                stringBuilder.append(string5);
            }
        } else {
            sb.append(sqlIdentifier);
        }
        if (((CharSequence)sb).length() == 0) {
            Logger.getInstance(ReverseEngineeringHelper.class).warn("Generated identifier name is empty. Column name is \"" + sqlIdentifier + "\"");
            Object randomPart = RandomStringUtils.insecure().next(4);
            char c = Character.toUpperCase(((String)randomPart).charAt(0));
            String string6 = randomPart;
            Intrinsics.checkNotNull((Object)string6);
            int n = 1;
            String string7 = string6.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
            randomPart = c + string7;
            sb.append(GENERATED_SUFFIX + (String)randomPart);
        }
        if (identifierType == IdentifierType.CLASS) {
            OrmReInfoProvider ormReInfoProvider = OrmReInfoProvider.Companion.getForFramework(ormFramework);
            String string8 = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toString(...)");
            return ormReInfoProvider.generateClassName(this.project, string8);
        }
        String javaName = Character.toLowerCase(sb.charAt(0)) + sb.substring(1);
        return Companion.convertToJavaIdentifier(this.project, javaName, identifierType);
    }

    public static /* synthetic */ String generateJavaIdentifier$default(ReverseEngineeringHelper reverseEngineeringHelper, String string, IdentifierType identifierType, OrmFramework ormFramework, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generateJavaIdentifier");
        }
        if ((n & 4) != 0) {
            ormFramework = (OrmFramework)JpaOrmFramework.INSTANCE;
        }
        return reverseEngineeringHelper.generateJavaIdentifier(string, identifierType, ormFramework);
    }

    private final String processSqlIdentifier(String sqlIdentifier, IdentifierType identifierType) {
        String string;
        String sqlIdentifier2;
        block7: {
            block6: {
                sqlIdentifier2 = sqlIdentifier;
                string = sqlIdentifier2;
                if (string == null) break block6;
                String $this$trim$iv = string;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if ((string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()) != null) break block7;
            }
            string = "";
        }
        sqlIdentifier2 = string;
        ProjectState projectState = JpaPluginProjectConfig.Companion.getInstance(this.project).getState();
        return identifierType == IdentifierType.CLASS ? this.processSqlIdentifier(sqlIdentifier2, projectState.reExcludeTablePrefixes, projectState.reExcludeTableSuffixes) : this.processSqlIdentifier(sqlIdentifier2, projectState.reExcludeColumnPrefixes, projectState.reExcludeColumnSuffixes);
    }

    private final String processSqlIdentifier(String sqlIdentifier, String excludeDbIdentifierPrefixes, String excludeDbIdentifierSuffixes) {
        Collection<String> excludePrefixes = this.parseExcludePrefixes(excludeDbIdentifierPrefixes);
        String result = sqlIdentifier;
        for (String excludePrefix : excludePrefixes) {
            if (!StringUtil.startsWithIgnoreCase((String)result, (String)excludePrefix)) continue;
            String string = result.substring(excludePrefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String identifierWithoutPrefix = string;
            String identifierWithoutUnderscores = StringsKt.replace$default((String)identifierWithoutPrefix, (String)"_", (String)"", (boolean)false, (int)4, null);
            result = StringUtil.isEmpty((String)identifierWithoutPrefix) || StringUtil.isEmpty((String)identifierWithoutUnderscores) ? result : identifierWithoutPrefix;
            break;
        }
        Collection<String> excludeSuffixes = this.parseExcludePrefixes(excludeDbIdentifierSuffixes);
        for (String excludeSuffix : excludeSuffixes) {
            if (!StringUtil.endsWithIgnoreCase((String)result, (String)excludeSuffix)) continue;
            String string = result.substring(0, result.length() - excludeSuffix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String identifierWithoutSuffix = string;
            String identifierWithoutUnderscores = StringsKt.replace$default((String)identifierWithoutSuffix, (String)"_", (String)"", (boolean)false, (int)4, null);
            result = StringUtil.isEmpty((String)identifierWithoutSuffix) || StringUtil.isEmpty((String)identifierWithoutUnderscores) ? result : identifierWithoutSuffix;
            break;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<String> parseExcludePrefixes(String prefixes) {
        void $this$mapTo$iv$iv;
        if (StringUtil.isEmpty((String)prefixes)) {
            return SetsKt.emptySet();
        }
        String string = prefixes;
        Intrinsics.checkNotNull((Object)string);
        List list = StringUtil.split((String)string, (String)",", (boolean)true, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"split(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void obj;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void $this$trim$iv = obj;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl2 = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            collection.add(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ$\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\rH\u0007J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/re/ReverseEngineeringHelper$Companion;", "", "<init>", "()V", "GENERATED_SUFFIX", "", "getInstance", "Lcom/intellij/re/ReverseEngineeringHelper;", "project", "Lcom/intellij/openapi/project/Project;", "convertToJavaIdentifier", "value", "identifierType", "Lcom/intellij/re/ReverseEngineeringHelper$IdentifierType;", "isCorrectIdentifier", "", "intellij.javaee.reverseEngineering"})
    @SourceDebugExtension(value={"SMAP\nReverseEngineeringHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReverseEngineeringHelper.kt\ncom/intellij/re/ReverseEngineeringHelper$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,179:1\n739#2,9:180\n37#3,2:189\n*S KotlinDebug\n*F\n+ 1 ReverseEngineeringHelper.kt\ncom/intellij/re/ReverseEngineeringHelper$Companion\n*L\n155#1:180,9\n155#1:189,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ReverseEngineeringHelper getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(ReverseEngineeringHelper.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (ReverseEngineeringHelper)object;
        }

        /*
         * WARNING - void declaration
         */
        @Contract(value="_, null, _ -> null")
        @Nullable
        public final String convertToJavaIdentifier(@NotNull Project project, @Nullable String value, @NotNull IdentifierType identifierType) {
            void $this$toTypedArray$iv;
            List list;
            Collection $this$dropLastWhile$iv;
            block13: {
                block12: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)((Object)identifierType), (String)"identifierType");
                    if (StringUtils.isBlank((CharSequence)value)) break block12;
                    String string = value;
                    Intrinsics.checkNotNull((Object)string);
                    if (!this.isCorrectIdentifier(project, string)) break block13;
                }
                return value;
            }
            Object object = value;
            Regex regex = new Regex("[\\W]");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] split = thisCollection$iv.toArray(new String[0]);
            StringBuilder correctName = new StringBuilder();
            int n2 = split.length;
            for (int i = 0; i < n2; ++i) {
                String string;
                String splitWord = split[i];
                if (i == 0) {
                    string = splitWord;
                } else {
                    String string2 = StringUtil.capitalize((String)splitWord);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"capitalize(...)");
                }
                correctName.append(string);
            }
            String string = correctName.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            if (!this.isCorrectIdentifier(project, string)) {
                if (identifierType == IdentifierType.CLASS) {
                    v5 = correctName.append("Model");
                } else {
                    String reservedKeywordSuffix = JpaPluginProjectConfig.Companion.getInstance((Project)project).getState().reReservedKeywordSuffix;
                    v5 = correctName.append(reservedKeywordSuffix);
                }
            }
            return correctName.toString();
        }

        public final boolean isCorrectIdentifier(@NotNull Project project, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            LanguageLevelProjectExtension languageLevel = LanguageLevelProjectExtension.getInstance((Project)project);
            return StringUtil.isJavaIdentifier((String)value) && !PsiUtil.isKeyword((String)value, (LanguageLevel)languageLevel.getLanguageLevel());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/re/ReverseEngineeringHelper$IdentifierType;", "", "<init>", "(Ljava/lang/String;I)V", "CLASS", "FIELD", "ASSOCIATION_FIELD", "intellij.javaee.reverseEngineering"})
    public static final class IdentifierType
    extends Enum<IdentifierType> {
        public static final /* enum */ IdentifierType CLASS = new IdentifierType();
        public static final /* enum */ IdentifierType FIELD = new IdentifierType();
        public static final /* enum */ IdentifierType ASSOCIATION_FIELD = new IdentifierType();
        private static final /* synthetic */ IdentifierType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static IdentifierType[] values() {
            return (IdentifierType[])$VALUES.clone();
        }

        public static IdentifierType valueOf(String value) {
            return Enum.valueOf(IdentifierType.class, value);
        }

        @NotNull
        public static EnumEntries<IdentifierType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = identifierTypeArray = new IdentifierType[]{IdentifierType.CLASS, IdentifierType.FIELD, IdentifierType.ASSOCIATION_FIELD};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

